/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in InboundNatRules.
 */
public class InboundNatRulesInner {
    /** The Retrofit service to perform REST calls. */
    private InboundNatRulesService service;
    /** The service client containing this operation class. */
    private NetworkManagementClientImpl client;

    /**
     * Initializes an instance of InboundNatRulesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public InboundNatRulesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = retrofit.create(InboundNatRulesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for InboundNatRules to be
     * used by Retrofit to perform actually REST calls.
     */
    interface InboundNatRulesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.InboundNatRules list" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/inboundNatRules")
        Observable<Response<ResponseBody>> list(@Path("resourceGroupName") String resourceGroupName, @Path("loadBalancerName") String loadBalancerName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.InboundNatRules delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/inboundNatRules/{inboundNatRuleName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("loadBalancerName") String loadBalancerName, @Path("inboundNatRuleName") String inboundNatRuleName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.InboundNatRules beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/inboundNatRules/{inboundNatRuleName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("loadBalancerName") String loadBalancerName, @Path("inboundNatRuleName") String inboundNatRuleName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.InboundNatRules get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/inboundNatRules/{inboundNatRuleName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("loadBalancerName") String loadBalancerName, @Path("inboundNatRuleName") String inboundNatRuleName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Query("$expand") String expand, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.InboundNatRules createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/inboundNatRules/{inboundNatRuleName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("loadBalancerName") String loadBalancerName, @Path("inboundNatRuleName") String inboundNatRuleName, @Path("subscriptionId") String subscriptionId, @Body InboundNatRuleInner inboundNatRuleParameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.InboundNatRules beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/inboundNatRules/{inboundNatRuleName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("loadBalancerName") String loadBalancerName, @Path("inboundNatRuleName") String inboundNatRuleName, @Path("subscriptionId") String subscriptionId, @Body InboundNatRuleInner inboundNatRuleParameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.InboundNatRules listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets all the inbound nat rules in a load balancer.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;InboundNatRuleInner&gt; object if successful.
     */
    public PagedList<InboundNatRuleInner> list(final String resourceGroupName, final String loadBalancerName) {
        ServiceResponse<Page<InboundNatRuleInner>> response = listSinglePageAsync(resourceGroupName, loadBalancerName).toBlocking().single();
        return new PagedList<InboundNatRuleInner>(response.body()) {
            @Override
            public Page<InboundNatRuleInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the inbound nat rules in a load balancer.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<InboundNatRuleInner>> listAsync(final String resourceGroupName, final String loadBalancerName, final ListOperationCallback<InboundNatRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(resourceGroupName, loadBalancerName),
            new Func1<String, Observable<ServiceResponse<Page<InboundNatRuleInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<InboundNatRuleInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the inbound nat rules in a load balancer.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;InboundNatRuleInner&gt; object
     */
    public Observable<Page<InboundNatRuleInner>> listAsync(final String resourceGroupName, final String loadBalancerName) {
        return listWithServiceResponseAsync(resourceGroupName, loadBalancerName)
            .map(new Func1<ServiceResponse<Page<InboundNatRuleInner>>, Page<InboundNatRuleInner>>() {
                @Override
                public Page<InboundNatRuleInner> call(ServiceResponse<Page<InboundNatRuleInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the inbound nat rules in a load balancer.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;InboundNatRuleInner&gt; object
     */
    public Observable<ServiceResponse<Page<InboundNatRuleInner>>> listWithServiceResponseAsync(final String resourceGroupName, final String loadBalancerName) {
        return listSinglePageAsync(resourceGroupName, loadBalancerName)
            .concatMap(new Func1<ServiceResponse<Page<InboundNatRuleInner>>, Observable<ServiceResponse<Page<InboundNatRuleInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<InboundNatRuleInner>>> call(ServiceResponse<Page<InboundNatRuleInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the inbound nat rules in a load balancer.
     *
    ServiceResponse<PageImpl<InboundNatRuleInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl<InboundNatRuleInner>> * @param loadBalancerName The name of the load balancer.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;InboundNatRuleInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<InboundNatRuleInner>>> listSinglePageAsync(final String resourceGroupName, final String loadBalancerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.list(resourceGroupName, loadBalancerName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<InboundNatRuleInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<InboundNatRuleInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<InboundNatRuleInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<InboundNatRuleInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<InboundNatRuleInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<InboundNatRuleInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<InboundNatRuleInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes the specified load balancer inbound nat rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param inboundNatRuleName The name of the inbound nat rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String loadBalancerName, String inboundNatRuleName) {
        deleteWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName).toBlocking().last().body();
    }

    /**
     * Deletes the specified load balancer inbound nat rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param inboundNatRuleName The name of the inbound nat rule.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName), serviceCallback);
    }

    /**
     * Deletes the specified load balancer inbound nat rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param inboundNatRuleName The name of the inbound nat rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName) {
        return deleteWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified load balancer inbound nat rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param inboundNatRuleName The name of the inbound nat rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (inboundNatRuleName == null) {
            throw new IllegalArgumentException("Parameter inboundNatRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, loadBalancerName, inboundNatRuleName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes the specified load balancer inbound nat rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param inboundNatRuleName The name of the inbound nat rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String loadBalancerName, String inboundNatRuleName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName).toBlocking().single().body();
    }

    /**
     * Deletes the specified load balancer inbound nat rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param inboundNatRuleName The name of the inbound nat rule.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName), serviceCallback);
    }

    /**
     * Deletes the specified load balancer inbound nat rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param inboundNatRuleName The name of the inbound nat rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified load balancer inbound nat rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param inboundNatRuleName The name of the inbound nat rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (inboundNatRuleName == null) {
            throw new IllegalArgumentException("Parameter inboundNatRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.beginDelete(resourceGroupName, loadBalancerName, inboundNatRuleName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the specified load balancer inbound nat rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param inboundNatRuleName The name of the inbound nat rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the InboundNatRuleInner object if successful.
     */
    public InboundNatRuleInner get(String resourceGroupName, String loadBalancerName, String inboundNatRuleName) {
        return getWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName).toBlocking().single().body();
    }

    /**
     * Gets the specified load balancer inbound nat rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param inboundNatRuleName The name of the inbound nat rule.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<InboundNatRuleInner> getAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, final ServiceCallback<InboundNatRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName), serviceCallback);
    }

    /**
     * Gets the specified load balancer inbound nat rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param inboundNatRuleName The name of the inbound nat rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InboundNatRuleInner object
     */
    public Observable<InboundNatRuleInner> getAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName) {
        return getWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName).map(new Func1<ServiceResponse<InboundNatRuleInner>, InboundNatRuleInner>() {
            @Override
            public InboundNatRuleInner call(ServiceResponse<InboundNatRuleInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the specified load balancer inbound nat rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param inboundNatRuleName The name of the inbound nat rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InboundNatRuleInner object
     */
    public Observable<ServiceResponse<InboundNatRuleInner>> getWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (inboundNatRuleName == null) {
            throw new IllegalArgumentException("Parameter inboundNatRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        final String expand = null;
        return service.get(resourceGroupName, loadBalancerName, inboundNatRuleName, this.client.subscriptionId(), apiVersion, expand, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<InboundNatRuleInner>>>() {
                @Override
                public Observable<ServiceResponse<InboundNatRuleInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<InboundNatRuleInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets the specified load balancer inbound nat rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param inboundNatRuleName The name of the inbound nat rule.
     * @param expand Expands referenced resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the InboundNatRuleInner object if successful.
     */
    public InboundNatRuleInner get(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, String expand) {
        return getWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName, expand).toBlocking().single().body();
    }

    /**
     * Gets the specified load balancer inbound nat rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param inboundNatRuleName The name of the inbound nat rule.
     * @param expand Expands referenced resources.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<InboundNatRuleInner> getAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, String expand, final ServiceCallback<InboundNatRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName, expand), serviceCallback);
    }

    /**
     * Gets the specified load balancer inbound nat rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param inboundNatRuleName The name of the inbound nat rule.
     * @param expand Expands referenced resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InboundNatRuleInner object
     */
    public Observable<InboundNatRuleInner> getAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, String expand) {
        return getWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName, expand).map(new Func1<ServiceResponse<InboundNatRuleInner>, InboundNatRuleInner>() {
            @Override
            public InboundNatRuleInner call(ServiceResponse<InboundNatRuleInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the specified load balancer inbound nat rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param inboundNatRuleName The name of the inbound nat rule.
     * @param expand Expands referenced resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InboundNatRuleInner object
     */
    public Observable<ServiceResponse<InboundNatRuleInner>> getWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (inboundNatRuleName == null) {
            throw new IllegalArgumentException("Parameter inboundNatRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.get(resourceGroupName, loadBalancerName, inboundNatRuleName, this.client.subscriptionId(), apiVersion, expand, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<InboundNatRuleInner>>>() {
                @Override
                public Observable<ServiceResponse<InboundNatRuleInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<InboundNatRuleInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<InboundNatRuleInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<InboundNatRuleInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<InboundNatRuleInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates a load balancer inbound nat rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param inboundNatRuleName The name of the inbound nat rule.
     * @param inboundNatRuleParameters Parameters supplied to the create or update inbound nat rule operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the InboundNatRuleInner object if successful.
     */
    public InboundNatRuleInner createOrUpdate(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, InboundNatRuleInner inboundNatRuleParameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName, inboundNatRuleParameters).toBlocking().last().body();
    }

    /**
     * Creates or updates a load balancer inbound nat rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param inboundNatRuleName The name of the inbound nat rule.
     * @param inboundNatRuleParameters Parameters supplied to the create or update inbound nat rule operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<InboundNatRuleInner> createOrUpdateAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, InboundNatRuleInner inboundNatRuleParameters, final ServiceCallback<InboundNatRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName, inboundNatRuleParameters), serviceCallback);
    }

    /**
     * Creates or updates a load balancer inbound nat rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param inboundNatRuleName The name of the inbound nat rule.
     * @param inboundNatRuleParameters Parameters supplied to the create or update inbound nat rule operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<InboundNatRuleInner> createOrUpdateAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, InboundNatRuleInner inboundNatRuleParameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName, inboundNatRuleParameters).map(new Func1<ServiceResponse<InboundNatRuleInner>, InboundNatRuleInner>() {
            @Override
            public InboundNatRuleInner call(ServiceResponse<InboundNatRuleInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a load balancer inbound nat rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param inboundNatRuleName The name of the inbound nat rule.
     * @param inboundNatRuleParameters Parameters supplied to the create or update inbound nat rule operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<InboundNatRuleInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, InboundNatRuleInner inboundNatRuleParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (inboundNatRuleName == null) {
            throw new IllegalArgumentException("Parameter inboundNatRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (inboundNatRuleParameters == null) {
            throw new IllegalArgumentException("Parameter inboundNatRuleParameters is required and cannot be null.");
        }
        Validator.validate(inboundNatRuleParameters);
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, loadBalancerName, inboundNatRuleName, this.client.subscriptionId(), inboundNatRuleParameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<InboundNatRuleInner>() { }.getType());
    }

    /**
     * Creates or updates a load balancer inbound nat rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param inboundNatRuleName The name of the inbound nat rule.
     * @param inboundNatRuleParameters Parameters supplied to the create or update inbound nat rule operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the InboundNatRuleInner object if successful.
     */
    public InboundNatRuleInner beginCreateOrUpdate(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, InboundNatRuleInner inboundNatRuleParameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName, inboundNatRuleParameters).toBlocking().single().body();
    }

    /**
     * Creates or updates a load balancer inbound nat rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param inboundNatRuleName The name of the inbound nat rule.
     * @param inboundNatRuleParameters Parameters supplied to the create or update inbound nat rule operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<InboundNatRuleInner> beginCreateOrUpdateAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, InboundNatRuleInner inboundNatRuleParameters, final ServiceCallback<InboundNatRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName, inboundNatRuleParameters), serviceCallback);
    }

    /**
     * Creates or updates a load balancer inbound nat rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param inboundNatRuleName The name of the inbound nat rule.
     * @param inboundNatRuleParameters Parameters supplied to the create or update inbound nat rule operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InboundNatRuleInner object
     */
    public Observable<InboundNatRuleInner> beginCreateOrUpdateAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, InboundNatRuleInner inboundNatRuleParameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, loadBalancerName, inboundNatRuleName, inboundNatRuleParameters).map(new Func1<ServiceResponse<InboundNatRuleInner>, InboundNatRuleInner>() {
            @Override
            public InboundNatRuleInner call(ServiceResponse<InboundNatRuleInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a load balancer inbound nat rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param loadBalancerName The name of the load balancer.
     * @param inboundNatRuleName The name of the inbound nat rule.
     * @param inboundNatRuleParameters Parameters supplied to the create or update inbound nat rule operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InboundNatRuleInner object
     */
    public Observable<ServiceResponse<InboundNatRuleInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, String inboundNatRuleName, InboundNatRuleInner inboundNatRuleParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (inboundNatRuleName == null) {
            throw new IllegalArgumentException("Parameter inboundNatRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (inboundNatRuleParameters == null) {
            throw new IllegalArgumentException("Parameter inboundNatRuleParameters is required and cannot be null.");
        }
        Validator.validate(inboundNatRuleParameters);
        final String apiVersion = "2019-11-01";
        return service.beginCreateOrUpdate(resourceGroupName, loadBalancerName, inboundNatRuleName, this.client.subscriptionId(), inboundNatRuleParameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<InboundNatRuleInner>>>() {
                @Override
                public Observable<ServiceResponse<InboundNatRuleInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<InboundNatRuleInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<InboundNatRuleInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<InboundNatRuleInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<InboundNatRuleInner>() { }.getType())
                .register(201, new TypeToken<InboundNatRuleInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all the inbound nat rules in a load balancer.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;InboundNatRuleInner&gt; object if successful.
     */
    public PagedList<InboundNatRuleInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<InboundNatRuleInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<InboundNatRuleInner>(response.body()) {
            @Override
            public Page<InboundNatRuleInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the inbound nat rules in a load balancer.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<InboundNatRuleInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<InboundNatRuleInner>> serviceFuture, final ListOperationCallback<InboundNatRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<InboundNatRuleInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<InboundNatRuleInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the inbound nat rules in a load balancer.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;InboundNatRuleInner&gt; object
     */
    public Observable<Page<InboundNatRuleInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<InboundNatRuleInner>>, Page<InboundNatRuleInner>>() {
                @Override
                public Page<InboundNatRuleInner> call(ServiceResponse<Page<InboundNatRuleInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the inbound nat rules in a load balancer.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;InboundNatRuleInner&gt; object
     */
    public Observable<ServiceResponse<Page<InboundNatRuleInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<InboundNatRuleInner>>, Observable<ServiceResponse<Page<InboundNatRuleInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<InboundNatRuleInner>>> call(ServiceResponse<Page<InboundNatRuleInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the inbound nat rules in a load balancer.
     *
    ServiceResponse<PageImpl<InboundNatRuleInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;InboundNatRuleInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<InboundNatRuleInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<InboundNatRuleInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<InboundNatRuleInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<InboundNatRuleInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<InboundNatRuleInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<InboundNatRuleInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<InboundNatRuleInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<InboundNatRuleInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
