/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Allow to exclude some variable satisfy the condition for the WAF check.
 */
public class ApplicationGatewayFirewallExclusion {
    /**
     * The variable to be excluded.
     */
    @JsonProperty(value = "matchVariable")
    private String matchVariable;

    /**
     * When matchVariable is a collection, operate on the selector to specify
     * which elements in the collection this exclusion applies to.
     */
    @JsonProperty(value = "selectorMatchOperator")
    private String selectorMatchOperator;

    /**
     * When matchVariable is a collection, operator used to specify which
     * elements in the collection this exclusion applies to.
     */
    @JsonProperty(value = "selector")
    private String selector;

    /**
     * Get the variable to be excluded.
     *
     * @return the matchVariable value
     */
    public String matchVariable() {
        return this.matchVariable;
    }

    /**
     * Set the variable to be excluded.
     *
     * @param matchVariable the matchVariable value to set
     * @return the ApplicationGatewayFirewallExclusion object itself.
     */
    public ApplicationGatewayFirewallExclusion withMatchVariable(String matchVariable) {
        this.matchVariable = matchVariable;
        return this;
    }

    /**
     * Get when matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.
     *
     * @return the selectorMatchOperator value
     */
    public String selectorMatchOperator() {
        return this.selectorMatchOperator;
    }

    /**
     * Set when matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.
     *
     * @param selectorMatchOperator the selectorMatchOperator value to set
     * @return the ApplicationGatewayFirewallExclusion object itself.
     */
    public ApplicationGatewayFirewallExclusion withSelectorMatchOperator(String selectorMatchOperator) {
        this.selectorMatchOperator = selectorMatchOperator;
        return this;
    }

    /**
     * Get when matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to.
     *
     * @return the selector value
     */
    public String selector() {
        return this.selector;
    }

    /**
     * Set when matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to.
     *
     * @param selector the selector value to set
     * @return the ApplicationGatewayFirewallExclusion object itself.
     */
    public ApplicationGatewayFirewallExclusion withSelector(String selector) {
        this.selector = selector;
        return this;
    }

}
