/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.VirtualHubInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class VirtualHubsInner
implements InnerSupportsGet<VirtualHubInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<VirtualHubInner> {
    private VirtualHubsService service;
    private NetworkManagementClientImpl client;

    public VirtualHubsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (VirtualHubsService)retrofit.create(VirtualHubsService.class);
        this.client = client;
    }

    public VirtualHubInner getByResourceGroup(String resourceGroupName, String virtualHubName) {
        return (VirtualHubInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualHubName).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualHubInner> getByResourceGroupAsync(String resourceGroupName, String virtualHubName, ServiceCallback<VirtualHubInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualHubName), serviceCallback);
    }

    public Observable<VirtualHubInner> getByResourceGroupAsync(String resourceGroupName, String virtualHubName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualHubName).map((Func1)new Func1<ServiceResponse<VirtualHubInner>, VirtualHubInner>(){

            public VirtualHubInner call(ServiceResponse<VirtualHubInner> response) {
                return (VirtualHubInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualHubInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String virtualHubName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, virtualHubName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualHubInner>>>(){

            public Observable<ServiceResponse<VirtualHubInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualHubsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualHubInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualHubInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VirtualHubInner createOrUpdate(String resourceGroupName, String virtualHubName, VirtualHubInner virtualHubParameters) {
        return (VirtualHubInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualHubName, virtualHubParameters).toBlocking().last()).body());
    }

    public ServiceFuture<VirtualHubInner> createOrUpdateAsync(String resourceGroupName, String virtualHubName, VirtualHubInner virtualHubParameters, ServiceCallback<VirtualHubInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualHubName, virtualHubParameters), serviceCallback);
    }

    public Observable<VirtualHubInner> createOrUpdateAsync(String resourceGroupName, String virtualHubName, VirtualHubInner virtualHubParameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualHubName, virtualHubParameters).map((Func1)new Func1<ServiceResponse<VirtualHubInner>, VirtualHubInner>(){

            public VirtualHubInner call(ServiceResponse<VirtualHubInner> response) {
                return (VirtualHubInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualHubInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualHubName, VirtualHubInner virtualHubParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        if (virtualHubParameters == null) {
            throw new IllegalArgumentException("Parameter virtualHubParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)virtualHubParameters));
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, virtualHubName, "2019-11-01", virtualHubParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualHubInner>(){}.getType());
    }

    public VirtualHubInner beginCreateOrUpdate(String resourceGroupName, String virtualHubName, VirtualHubInner virtualHubParameters) {
        return (VirtualHubInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualHubName, virtualHubParameters).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualHubInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualHubName, VirtualHubInner virtualHubParameters, ServiceCallback<VirtualHubInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualHubName, virtualHubParameters), serviceCallback);
    }

    public Observable<VirtualHubInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualHubName, VirtualHubInner virtualHubParameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualHubName, virtualHubParameters).map((Func1)new Func1<ServiceResponse<VirtualHubInner>, VirtualHubInner>(){

            public VirtualHubInner call(ServiceResponse<VirtualHubInner> response) {
                return (VirtualHubInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualHubInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualHubName, VirtualHubInner virtualHubParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        if (virtualHubParameters == null) {
            throw new IllegalArgumentException("Parameter virtualHubParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)virtualHubParameters));
        String apiVersion = "2019-11-01";
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, virtualHubName, "2019-11-01", virtualHubParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualHubInner>>>(){

            public Observable<ServiceResponse<VirtualHubInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualHubsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualHubInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualHubInner>(){}.getType()).register(201, new TypeToken<VirtualHubInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VirtualHubInner updateTags(String resourceGroupName, String virtualHubName) {
        return (VirtualHubInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, virtualHubName).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualHubInner> updateTagsAsync(String resourceGroupName, String virtualHubName, ServiceCallback<VirtualHubInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, virtualHubName), serviceCallback);
    }

    public Observable<VirtualHubInner> updateTagsAsync(String resourceGroupName, String virtualHubName) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, virtualHubName).map((Func1)new Func1<ServiceResponse<VirtualHubInner>, VirtualHubInner>(){

            public VirtualHubInner call(ServiceResponse<VirtualHubInner> response) {
                return (VirtualHubInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualHubInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String virtualHubName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Object tags = null;
        TagsObject virtualHubParameters = new TagsObject();
        virtualHubParameters.withTags(null);
        return this.service.updateTags(this.client.subscriptionId(), resourceGroupName, virtualHubName, "2019-11-01", this.client.acceptLanguage(), virtualHubParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualHubInner>>>(){

            public Observable<ServiceResponse<VirtualHubInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualHubsInner.this.updateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public VirtualHubInner updateTags(String resourceGroupName, String virtualHubName, Map<String, String> tags) {
        return (VirtualHubInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, virtualHubName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualHubInner> updateTagsAsync(String resourceGroupName, String virtualHubName, Map<String, String> tags, ServiceCallback<VirtualHubInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, virtualHubName, tags), serviceCallback);
    }

    public Observable<VirtualHubInner> updateTagsAsync(String resourceGroupName, String virtualHubName, Map<String, String> tags) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, virtualHubName, tags).map((Func1)new Func1<ServiceResponse<VirtualHubInner>, VirtualHubInner>(){

            public VirtualHubInner call(ServiceResponse<VirtualHubInner> response) {
                return (VirtualHubInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualHubInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String virtualHubName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2019-11-01";
        TagsObject virtualHubParameters = new TagsObject();
        virtualHubParameters.withTags(tags);
        return this.service.updateTags(this.client.subscriptionId(), resourceGroupName, virtualHubName, "2019-11-01", this.client.acceptLanguage(), virtualHubParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualHubInner>>>(){

            public Observable<ServiceResponse<VirtualHubInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualHubsInner.this.updateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualHubInner> updateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualHubInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String virtualHubName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, virtualHubName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String virtualHubName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, virtualHubName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String virtualHubName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, virtualHubName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String virtualHubName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, virtualHubName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String virtualHubName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualHubName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String virtualHubName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualHubName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String virtualHubName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualHubName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String virtualHubName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, virtualHubName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualHubsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualHubInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<VirtualHubInner>((Page)response.body()){

            public Page<VirtualHubInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualHubsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualHubInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<VirtualHubInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualHubInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualHubInner>>> call(String nextPageLink) {
                return VirtualHubsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualHubInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<VirtualHubInner>>, Page<VirtualHubInner>>(){

            public Page<VirtualHubInner> call(ServiceResponse<Page<VirtualHubInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualHubInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualHubInner>>, Observable<ServiceResponse<Page<VirtualHubInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualHubInner>>> call(ServiceResponse<Page<VirtualHubInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualHubsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualHubInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualHubInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualHubInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualHubsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualHubInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualHubInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualHubInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<VirtualHubInner>((Page)response.body()){

            public Page<VirtualHubInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualHubsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualHubInner>> listAsync(ListOperationCallback<VirtualHubInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualHubInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualHubInner>>> call(String nextPageLink) {
                return VirtualHubsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualHubInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<VirtualHubInner>>, Page<VirtualHubInner>>(){

            public Page<VirtualHubInner> call(ServiceResponse<Page<VirtualHubInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualHubInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<VirtualHubInner>>, Observable<ServiceResponse<Page<VirtualHubInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualHubInner>>> call(ServiceResponse<Page<VirtualHubInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualHubsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualHubInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualHubInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualHubInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualHubsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualHubInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualHubInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualHubInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualHubInner>((Page)response.body()){

            public Page<VirtualHubInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualHubsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualHubInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<VirtualHubInner>> serviceFuture, ListOperationCallback<VirtualHubInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualHubInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualHubInner>>> call(String nextPageLink) {
                return VirtualHubsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualHubInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VirtualHubInner>>, Page<VirtualHubInner>>(){

            public Page<VirtualHubInner> call(ServiceResponse<Page<VirtualHubInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualHubInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualHubInner>>, Observable<ServiceResponse<Page<VirtualHubInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualHubInner>>> call(ServiceResponse<Page<VirtualHubInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualHubsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualHubInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualHubInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualHubInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualHubsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualHubInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualHubInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualHubInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualHubInner>((Page)response.body()){

            public Page<VirtualHubInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualHubsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualHubInner>> listNextAsync(String nextPageLink, ServiceFuture<List<VirtualHubInner>> serviceFuture, ListOperationCallback<VirtualHubInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualHubInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualHubInner>>> call(String nextPageLink) {
                return VirtualHubsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualHubInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VirtualHubInner>>, Page<VirtualHubInner>>(){

            public Page<VirtualHubInner> call(ServiceResponse<Page<VirtualHubInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualHubInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualHubInner>>, Observable<ServiceResponse<Page<VirtualHubInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualHubInner>>> call(ServiceResponse<Page<VirtualHubInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualHubsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualHubInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualHubInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualHubInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualHubsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualHubInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualHubInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface VirtualHubsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubs getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualHubName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubs createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualHubName") String var3, @Query(value="api-version") String var4, @Body VirtualHubInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubs beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualHubName") String var3, @Query(value="api-version") String var4, @Body VirtualHubInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubs updateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}")
        public Observable<Response<ResponseBody>> updateTags(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualHubName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubs delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualHubName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubs beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualHubName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubs listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubs list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/virtualHubs")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubs listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubs listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

