/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.network.IPVersion;
import com.microsoft.azure.management.network.IpTag;
import com.microsoft.azure.management.network.ProvisioningState;
import com.microsoft.azure.management.network.PublicIPPrefix;
import com.microsoft.azure.management.network.PublicIPPrefixSku;
import com.microsoft.azure.management.network.ReferencedPublicIpAddress;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.PublicIPPrefixInner;
import com.microsoft.azure.management.network.implementation.PublicIPPrefixesInner;
import com.microsoft.azure.management.network.model.AppliableWithTags;
import com.microsoft.azure.management.resources.fluentcore.arm.AvailabilityZoneId;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import rx.Observable;
import rx.functions.Func1;

class PublicIPPrefixImpl
extends GroupableResourceImpl<PublicIPPrefix, PublicIPPrefixInner, PublicIPPrefixImpl, NetworkManager>
implements PublicIPPrefix,
PublicIPPrefix.Definition,
PublicIPPrefix.Update,
AppliableWithTags<PublicIPPrefix> {
    PublicIPPrefixImpl(String name, PublicIPPrefixInner inner, NetworkManager manager) {
        super(name, (Resource)inner, (ManagerBase)manager);
    }

    public Observable<PublicIPPrefix> createResourceAsync() {
        PublicIPPrefixesInner client = ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).publicIPPrefixes();
        return client.createOrUpdateAsync(this.resourceGroupName(), this.name(), (PublicIPPrefixInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public Observable<PublicIPPrefix> updateResourceAsync() {
        PublicIPPrefixesInner client = ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).publicIPPrefixes();
        return client.createOrUpdateAsync(this.resourceGroupName(), this.name(), (PublicIPPrefixInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<PublicIPPrefixInner> getInnerAsync() {
        PublicIPPrefixesInner client = ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).publicIPPrefixes();
        return client.getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public PublicIPPrefixImpl updateTags() {
        return this;
    }

    @Override
    public PublicIPPrefix applyTags() {
        return (PublicIPPrefix)this.applyTagsAsync().toBlocking().last();
    }

    @Override
    public Observable<PublicIPPrefix> applyTagsAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).publicIPPrefixes().updateTagsAsync(this.resourceGroupName(), this.name(), ((PublicIPPrefixInner)((Object)this.inner())).getTags()).flatMap((Func1)new Func1<PublicIPPrefixInner, Observable<PublicIPPrefix>>(){

            public Observable<PublicIPPrefix> call(PublicIPPrefixInner inner) {
                PublicIPPrefixImpl.this.setInner((Object)inner);
                return Observable.just((Object)PublicIPPrefixImpl.this);
            }
        });
    }

    @Override
    public ServiceFuture<PublicIPPrefix> applyTagsAsync(ServiceCallback<PublicIPPrefix> callback) {
        return ServiceFuture.fromBody(this.applyTagsAsync(), callback);
    }

    public boolean isInCreateMode() {
        return ((PublicIPPrefixInner)((Object)this.inner())).id() == null;
    }

    @Override
    public String ipPrefix() {
        return ((PublicIPPrefixInner)((Object)this.inner())).ipPrefix();
    }

    @Override
    public List<IpTag> ipTags() {
        return Collections.unmodifiableList(((PublicIPPrefixInner)((Object)this.inner())).ipTags() == null ? new ArrayList() : ((PublicIPPrefixInner)((Object)this.inner())).ipTags());
    }

    @Override
    public SubResource loadBalancerFrontendIpConfiguration() {
        return ((PublicIPPrefixInner)((Object)this.inner())).loadBalancerFrontendIpConfiguration();
    }

    @Override
    public Integer prefixLength() {
        return ((PublicIPPrefixInner)((Object)this.inner())).prefixLength();
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((PublicIPPrefixInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public List<ReferencedPublicIpAddress> publicIPAddresses() {
        return Collections.unmodifiableList(((PublicIPPrefixInner)((Object)this.inner())).publicIPAddresses() == null ? new ArrayList() : ((PublicIPPrefixInner)((Object)this.inner())).publicIPAddresses());
    }

    @Override
    public IPVersion publicIPAddressVersion() {
        return ((PublicIPPrefixInner)((Object)this.inner())).publicIPAddressVersion();
    }

    @Override
    public String resourceGuid() {
        return ((PublicIPPrefixInner)((Object)this.inner())).resourceGuid();
    }

    @Override
    public PublicIPPrefixSku sku() {
        return ((PublicIPPrefixInner)((Object)this.inner())).sku();
    }

    @Override
    public Set<AvailabilityZoneId> availabilityZones() {
        HashSet<AvailabilityZoneId> zones = new HashSet<AvailabilityZoneId>();
        if (((PublicIPPrefixInner)((Object)this.inner())).zones() != null) {
            for (String zone : ((PublicIPPrefixInner)((Object)this.inner())).zones()) {
                zones.add(AvailabilityZoneId.fromString((String)zone));
            }
        }
        return Collections.unmodifiableSet(zones);
    }

    @Override
    public PublicIPPrefixImpl withIpTags(List<IpTag> ipTags) {
        ((PublicIPPrefixInner)((Object)this.inner())).withIpTags(ipTags);
        return this;
    }

    @Override
    public PublicIPPrefixImpl withPrefixLength(Integer prefixLength) {
        ((PublicIPPrefixInner)((Object)this.inner())).withPrefixLength(prefixLength);
        return this;
    }

    @Override
    public PublicIPPrefixImpl withPublicIPAddressVersion(IPVersion publicIPAddressVersion) {
        ((PublicIPPrefixInner)((Object)this.inner())).withPublicIPAddressVersion(publicIPAddressVersion);
        return this;
    }

    @Override
    public PublicIPPrefixImpl withSku(PublicIPPrefixSku sku) {
        ((PublicIPPrefixInner)((Object)this.inner())).withSku(sku);
        return this;
    }

    @Override
    public PublicIPPrefixImpl withAvailabilityZone(AvailabilityZoneId zoneId) {
        if (((PublicIPPrefixInner)((Object)this.inner())).zones() == null) {
            ((PublicIPPrefixInner)((Object)this.inner())).withZones(new ArrayList<String>());
        }
        ((PublicIPPrefixInner)((Object)this.inner())).zones().add(zoneId.toString());
        return this;
    }
}

