/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.io.BaseEncoding;
import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ApplicationGateway;
import com.microsoft.azure.management.network.ApplicationGatewayAuthenticationCertificate;
import com.microsoft.azure.management.network.ApplicationGatewayBackendHttpConfiguration;
import com.microsoft.azure.management.network.ApplicationGatewayBackendHttpSettings;
import com.microsoft.azure.management.network.ApplicationGatewayConnectionDraining;
import com.microsoft.azure.management.network.ApplicationGatewayCookieBasedAffinity;
import com.microsoft.azure.management.network.ApplicationGatewayProbe;
import com.microsoft.azure.management.network.ApplicationGatewayProtocol;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@LangDefinition
class ApplicationGatewayBackendHttpConfigurationImpl
extends ChildResourceImpl<ApplicationGatewayBackendHttpSettings, ApplicationGatewayImpl, ApplicationGateway>
implements ApplicationGatewayBackendHttpConfiguration,
ApplicationGatewayBackendHttpConfiguration.Definition<ApplicationGateway.DefinitionStages.WithCreate>,
ApplicationGatewayBackendHttpConfiguration.UpdateDefinition<ApplicationGateway.Update>,
ApplicationGatewayBackendHttpConfiguration.Update {
    ApplicationGatewayBackendHttpConfigurationImpl(ApplicationGatewayBackendHttpSettings inner, ApplicationGatewayImpl parent) {
        super((Object)inner, (Object)parent);
    }

    @Override
    public Map<String, ApplicationGatewayAuthenticationCertificate> authenticationCertificates() {
        TreeMap<String, ApplicationGatewayAuthenticationCertificate> certs = new TreeMap<String, ApplicationGatewayAuthenticationCertificate>();
        if (((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).authenticationCertificates() == null) {
            return Collections.unmodifiableMap(certs);
        }
        for (SubResource ref : ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).authenticationCertificates()) {
            ApplicationGatewayAuthenticationCertificate cert = ((ApplicationGatewayImpl)this.parent()).authenticationCertificates().get(ResourceUtils.nameFromResourceId((String)ref.id()));
            if (cert == null) continue;
            certs.put(cert.name(), cert);
        }
        return Collections.unmodifiableMap(certs);
    }

    public String name() {
        return ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).name();
    }

    @Override
    public ApplicationGatewayProbe probe() {
        if (((ApplicationGatewayImpl)this.parent()).probes() != null && ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).probe() != null) {
            return ((ApplicationGatewayImpl)this.parent()).probes().get(ResourceUtils.nameFromResourceId((String)((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).probe().id()));
        }
        return null;
    }

    @Override
    public String hostHeader() {
        return ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).hostName();
    }

    @Override
    public boolean isHostHeaderFromBackend() {
        return Utils.toPrimitiveBoolean((Boolean)((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).pickHostNameFromBackendAddress());
    }

    @Override
    public boolean isProbeEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).probeEnabled());
    }

    @Override
    public int connectionDrainingTimeoutInSeconds() {
        if (((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).connectionDraining() == null) {
            return 0;
        }
        if (!((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).connectionDraining().enabled()) {
            return 0;
        }
        return ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).connectionDraining().drainTimeoutInSec();
    }

    @Override
    public String affinityCookieName() {
        return ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).affinityCookieName();
    }

    @Override
    public String path() {
        return ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).path();
    }

    @Override
    public int port() {
        return Utils.toPrimitiveInt((Integer)((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).port());
    }

    @Override
    public ApplicationGatewayProtocol protocol() {
        return ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).protocol();
    }

    @Override
    public boolean cookieBasedAffinity() {
        return ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).cookieBasedAffinity().equals((Object)ApplicationGatewayCookieBasedAffinity.ENABLED);
    }

    @Override
    public int requestTimeout() {
        return Utils.toPrimitiveInt((Integer)((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).requestTimeout());
    }

    public ApplicationGatewayImpl attach() {
        ((ApplicationGatewayImpl)this.parent()).withBackendHttpConfiguration(this);
        return (ApplicationGatewayImpl)this.parent();
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withPort(int port) {
        ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).withPort(port);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withCookieBasedAffinity() {
        ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).withCookieBasedAffinity(ApplicationGatewayCookieBasedAffinity.ENABLED);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withoutCookieBasedAffinity() {
        ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).withCookieBasedAffinity(ApplicationGatewayCookieBasedAffinity.DISABLED);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withProtocol(ApplicationGatewayProtocol protocol) {
        ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).withProtocol(protocol);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withRequestTimeout(int seconds) {
        ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).withRequestTimeout(seconds);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withProbe(String name) {
        if (name == null) {
            return this.withoutProbe();
        }
        SubResource probeRef = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/probes/" + name);
        ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).withProbe(probeRef);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withoutProbe() {
        ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).withProbe(null);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withHostHeaderFromBackend() {
        ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).withPickHostNameFromBackendAddress(true).withHostName(null);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withHostHeader(String hostHeader) {
        ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).withHostName(hostHeader).withPickHostNameFromBackendAddress(false);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withoutHostHeader() {
        ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).withHostName(null).withPickHostNameFromBackendAddress(false);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withConnectionDrainingTimeoutInSeconds(int seconds) {
        if (((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).connectionDraining() == null) {
            ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).withConnectionDraining(new ApplicationGatewayConnectionDraining());
        }
        if (seconds > 0) {
            ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).connectionDraining().withDrainTimeoutInSec(seconds).withEnabled(true);
        }
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withoutConnectionDraining() {
        ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).withConnectionDraining(null);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withAffinityCookieName(String name) {
        ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).withAffinityCookieName(name);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withPath(String path) {
        if (path != null) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
        }
        ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).withPath(path);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withAuthenticationCertificate(String name) {
        if (name == null) {
            return this;
        }
        SubResource certRef = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/authenticationCertificates/" + name);
        List<SubResource> refs = ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).authenticationCertificates();
        if (refs == null) {
            refs = new ArrayList<SubResource>();
            ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).withAuthenticationCertificates(refs);
        }
        for (SubResource ref : refs) {
            if (!ref.id().equalsIgnoreCase(certRef.id())) continue;
            return this;
        }
        refs.add(certRef);
        return this.withHttps();
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withAuthenticationCertificateFromBytes(byte[] derData) {
        if (derData == null) {
            return this;
        }
        String encoded = new String(BaseEncoding.base64().encode(derData));
        return this.withAuthenticationCertificateFromBase64(encoded);
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withAuthenticationCertificateFromBase64(String base64Data) {
        if (base64Data == null) {
            return this;
        }
        String certName = null;
        for (ApplicationGatewayAuthenticationCertificate cert : ((ApplicationGatewayImpl)this.parent()).authenticationCertificates().values()) {
            if (!cert.data().contentEquals(base64Data)) continue;
            certName = cert.name();
            break;
        }
        if (certName == null) {
            certName = SdkContext.randomResourceName((String)"cert", (int)20);
            ((ApplicationGatewayImpl)this.parent()).defineAuthenticationCertificate(certName).fromBase64(base64Data).attach();
        }
        return this.withAuthenticationCertificate(certName).withHttps();
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withAuthenticationCertificateFromFile(File certificateFile) throws IOException {
        if (certificateFile == null) {
            return this;
        }
        byte[] content = Files.readAllBytes(certificateFile.toPath());
        return this.withAuthenticationCertificateFromBytes(content);
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withoutAuthenticationCertificate(String name) {
        if (name == null) {
            return this;
        }
        for (SubResource ref : ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).authenticationCertificates()) {
            if (!ResourceUtils.nameFromResourceId((String)ref.id()).equalsIgnoreCase(name)) continue;
            ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).authenticationCertificates().remove(ref);
            break;
        }
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withHttps() {
        return this.withProtocol(ApplicationGatewayProtocol.HTTPS);
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withHttp() {
        return this.withoutAuthenticationCertificates().withProtocol(ApplicationGatewayProtocol.HTTP);
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withoutAuthenticationCertificates() {
        ((ApplicationGatewayBackendHttpSettings)((Object)this.inner())).withAuthenticationCertificates(null);
        return this;
    }
}

