/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ApplicationGateway;
import com.microsoft.azure.management.network.ApplicationGatewayBackendHealth;
import com.microsoft.azure.management.network.ApplicationGatewayBackendHealthHttpSettings;
import com.microsoft.azure.management.network.ApplicationGatewayBackendHealthServer;
import com.microsoft.azure.management.network.ApplicationGatewayBackendHttpConfiguration;
import com.microsoft.azure.management.network.ApplicationGatewayBackendHttpConfigurationHealth;
import com.microsoft.azure.management.network.ApplicationGatewayBackendServerHealth;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayBackendHealthImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayBackendServerHealthImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

@LangDefinition
public class ApplicationGatewayBackendHttpConfigurationHealthImpl
implements ApplicationGatewayBackendHttpConfigurationHealth {
    private final ApplicationGatewayBackendHealthHttpSettings inner;
    private final ApplicationGatewayBackendHealthImpl backendHealth;
    private final Map<String, ApplicationGatewayBackendServerHealth> serverHealths = new TreeMap<String, ApplicationGatewayBackendServerHealth>();

    ApplicationGatewayBackendHttpConfigurationHealthImpl(ApplicationGatewayBackendHealthHttpSettings inner, ApplicationGatewayBackendHealthImpl backendHealth) {
        this.inner = inner;
        this.backendHealth = backendHealth;
        if (inner.servers() != null) {
            for (ApplicationGatewayBackendHealthServer serverHealthInner : this.inner().servers()) {
                ApplicationGatewayBackendServerHealthImpl serverHealth = new ApplicationGatewayBackendServerHealthImpl(serverHealthInner, this);
                this.serverHealths.put(serverHealth.ipAddress(), serverHealth);
            }
        }
    }

    public ApplicationGatewayBackendHealthHttpSettings inner() {
        return this.inner;
    }

    public String name() {
        if (this.inner.backendHttpSettings() != null) {
            return ResourceUtils.nameFromResourceId((String)this.inner.backendHttpSettings().id());
        }
        return null;
    }

    @Override
    public ApplicationGatewayBackendHttpConfiguration backendHttpConfiguration() {
        if (this.inner.backendHttpSettings() == null) {
            return null;
        }
        String name = ResourceUtils.nameFromResourceId((String)this.inner.backendHttpSettings().id());
        return ((ApplicationGateway)this.parent().parent()).backendHttpConfigurations().get(name);
    }

    public ApplicationGatewayBackendHealth parent() {
        return this.backendHealth;
    }

    @Override
    public Map<String, ApplicationGatewayBackendServerHealth> serverHealths() {
        return Collections.unmodifiableMap(this.serverHealths);
    }
}

