/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in VpnServerConfigurations.
 */
public class VpnServerConfigurationsInner implements InnerSupportsGet<VpnServerConfigurationInner>, InnerSupportsDelete<Void>, InnerSupportsListing<VpnServerConfigurationInner> {
    /** The Retrofit service to perform REST calls. */
    private VpnServerConfigurationsService service;
    /** The service client containing this operation class. */
    private NetworkManagementClientImpl client;

    /**
     * Initializes an instance of VpnServerConfigurationsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public VpnServerConfigurationsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = retrofit.create(VpnServerConfigurationsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for VpnServerConfigurations to be
     * used by Retrofit to perform actually REST calls.
     */
    interface VpnServerConfigurationsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnServerConfigurations getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnServerConfigurations/{vpnServerConfigurationName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("vpnServerConfigurationName") String vpnServerConfigurationName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnServerConfigurations createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnServerConfigurations/{vpnServerConfigurationName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("vpnServerConfigurationName") String vpnServerConfigurationName, @Query("api-version") String apiVersion, @Body VpnServerConfigurationInner vpnServerConfigurationParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnServerConfigurations beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnServerConfigurations/{vpnServerConfigurationName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("vpnServerConfigurationName") String vpnServerConfigurationName, @Query("api-version") String apiVersion, @Body VpnServerConfigurationInner vpnServerConfigurationParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnServerConfigurations updateTags" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnServerConfigurations/{vpnServerConfigurationName}")
        Observable<Response<ResponseBody>> updateTags(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("vpnServerConfigurationName") String vpnServerConfigurationName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body TagsObject vpnServerConfigurationParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnServerConfigurations delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnServerConfigurations/{vpnServerConfigurationName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("vpnServerConfigurationName") String vpnServerConfigurationName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnServerConfigurations beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnServerConfigurations/{vpnServerConfigurationName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("vpnServerConfigurationName") String vpnServerConfigurationName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnServerConfigurations listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnServerConfigurations")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnServerConfigurations list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Network/vpnServerConfigurations")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnServerConfigurations listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnServerConfigurations listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Retrieves the details of a VpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VpnServerConfigurationInner object if successful.
     */
    public VpnServerConfigurationInner getByResourceGroup(String resourceGroupName, String vpnServerConfigurationName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName).toBlocking().single().body();
    }

    /**
     * Retrieves the details of a VpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being retrieved.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VpnServerConfigurationInner> getByResourceGroupAsync(String resourceGroupName, String vpnServerConfigurationName, final ServiceCallback<VpnServerConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName), serviceCallback);
    }

    /**
     * Retrieves the details of a VpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VpnServerConfigurationInner object
     */
    public Observable<VpnServerConfigurationInner> getByResourceGroupAsync(String resourceGroupName, String vpnServerConfigurationName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName).map(new Func1<ServiceResponse<VpnServerConfigurationInner>, VpnServerConfigurationInner>() {
            @Override
            public VpnServerConfigurationInner call(ServiceResponse<VpnServerConfigurationInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the details of a VpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VpnServerConfigurationInner object
     */
    public Observable<ServiceResponse<VpnServerConfigurationInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String vpnServerConfigurationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnServerConfigurationName == null) {
            throw new IllegalArgumentException("Parameter vpnServerConfigurationName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, vpnServerConfigurationName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnServerConfigurationInner>>>() {
                @Override
                public Observable<ServiceResponse<VpnServerConfigurationInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VpnServerConfigurationInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VpnServerConfigurationInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VpnServerConfigurationInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VpnServerConfigurationInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a VpnServerConfiguration resource if it doesn't exist else updates the existing VpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being created or updated.
     * @param vpnServerConfigurationParameters Parameters supplied to create or update VpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VpnServerConfigurationInner object if successful.
     */
    public VpnServerConfigurationInner createOrUpdate(String resourceGroupName, String vpnServerConfigurationName, VpnServerConfigurationInner vpnServerConfigurationParameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName, vpnServerConfigurationParameters).toBlocking().last().body();
    }

    /**
     * Creates a VpnServerConfiguration resource if it doesn't exist else updates the existing VpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being created or updated.
     * @param vpnServerConfigurationParameters Parameters supplied to create or update VpnServerConfiguration.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VpnServerConfigurationInner> createOrUpdateAsync(String resourceGroupName, String vpnServerConfigurationName, VpnServerConfigurationInner vpnServerConfigurationParameters, final ServiceCallback<VpnServerConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName, vpnServerConfigurationParameters), serviceCallback);
    }

    /**
     * Creates a VpnServerConfiguration resource if it doesn't exist else updates the existing VpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being created or updated.
     * @param vpnServerConfigurationParameters Parameters supplied to create or update VpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<VpnServerConfigurationInner> createOrUpdateAsync(String resourceGroupName, String vpnServerConfigurationName, VpnServerConfigurationInner vpnServerConfigurationParameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName, vpnServerConfigurationParameters).map(new Func1<ServiceResponse<VpnServerConfigurationInner>, VpnServerConfigurationInner>() {
            @Override
            public VpnServerConfigurationInner call(ServiceResponse<VpnServerConfigurationInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a VpnServerConfiguration resource if it doesn't exist else updates the existing VpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being created or updated.
     * @param vpnServerConfigurationParameters Parameters supplied to create or update VpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<VpnServerConfigurationInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String vpnServerConfigurationName, VpnServerConfigurationInner vpnServerConfigurationParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnServerConfigurationName == null) {
            throw new IllegalArgumentException("Parameter vpnServerConfigurationName is required and cannot be null.");
        }
        if (vpnServerConfigurationParameters == null) {
            throw new IllegalArgumentException("Parameter vpnServerConfigurationParameters is required and cannot be null.");
        }
        Validator.validate(vpnServerConfigurationParameters);
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, vpnServerConfigurationName, apiVersion, vpnServerConfigurationParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VpnServerConfigurationInner>() { }.getType());
    }

    /**
     * Creates a VpnServerConfiguration resource if it doesn't exist else updates the existing VpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being created or updated.
     * @param vpnServerConfigurationParameters Parameters supplied to create or update VpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VpnServerConfigurationInner object if successful.
     */
    public VpnServerConfigurationInner beginCreateOrUpdate(String resourceGroupName, String vpnServerConfigurationName, VpnServerConfigurationInner vpnServerConfigurationParameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName, vpnServerConfigurationParameters).toBlocking().single().body();
    }

    /**
     * Creates a VpnServerConfiguration resource if it doesn't exist else updates the existing VpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being created or updated.
     * @param vpnServerConfigurationParameters Parameters supplied to create or update VpnServerConfiguration.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VpnServerConfigurationInner> beginCreateOrUpdateAsync(String resourceGroupName, String vpnServerConfigurationName, VpnServerConfigurationInner vpnServerConfigurationParameters, final ServiceCallback<VpnServerConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName, vpnServerConfigurationParameters), serviceCallback);
    }

    /**
     * Creates a VpnServerConfiguration resource if it doesn't exist else updates the existing VpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being created or updated.
     * @param vpnServerConfigurationParameters Parameters supplied to create or update VpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VpnServerConfigurationInner object
     */
    public Observable<VpnServerConfigurationInner> beginCreateOrUpdateAsync(String resourceGroupName, String vpnServerConfigurationName, VpnServerConfigurationInner vpnServerConfigurationParameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName, vpnServerConfigurationParameters).map(new Func1<ServiceResponse<VpnServerConfigurationInner>, VpnServerConfigurationInner>() {
            @Override
            public VpnServerConfigurationInner call(ServiceResponse<VpnServerConfigurationInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a VpnServerConfiguration resource if it doesn't exist else updates the existing VpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being created or updated.
     * @param vpnServerConfigurationParameters Parameters supplied to create or update VpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VpnServerConfigurationInner object
     */
    public Observable<ServiceResponse<VpnServerConfigurationInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String vpnServerConfigurationName, VpnServerConfigurationInner vpnServerConfigurationParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnServerConfigurationName == null) {
            throw new IllegalArgumentException("Parameter vpnServerConfigurationName is required and cannot be null.");
        }
        if (vpnServerConfigurationParameters == null) {
            throw new IllegalArgumentException("Parameter vpnServerConfigurationParameters is required and cannot be null.");
        }
        Validator.validate(vpnServerConfigurationParameters);
        final String apiVersion = "2019-11-01";
        return service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, vpnServerConfigurationName, apiVersion, vpnServerConfigurationParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnServerConfigurationInner>>>() {
                @Override
                public Observable<ServiceResponse<VpnServerConfigurationInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VpnServerConfigurationInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VpnServerConfigurationInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VpnServerConfigurationInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VpnServerConfigurationInner>() { }.getType())
                .register(201, new TypeToken<VpnServerConfigurationInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates VpnServerConfiguration tags.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VpnServerConfigurationInner object if successful.
     */
    public VpnServerConfigurationInner updateTags(String resourceGroupName, String vpnServerConfigurationName) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName).toBlocking().single().body();
    }

    /**
     * Updates VpnServerConfiguration tags.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being updated.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VpnServerConfigurationInner> updateTagsAsync(String resourceGroupName, String vpnServerConfigurationName, final ServiceCallback<VpnServerConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateTagsWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName), serviceCallback);
    }

    /**
     * Updates VpnServerConfiguration tags.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VpnServerConfigurationInner object
     */
    public Observable<VpnServerConfigurationInner> updateTagsAsync(String resourceGroupName, String vpnServerConfigurationName) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName).map(new Func1<ServiceResponse<VpnServerConfigurationInner>, VpnServerConfigurationInner>() {
            @Override
            public VpnServerConfigurationInner call(ServiceResponse<VpnServerConfigurationInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates VpnServerConfiguration tags.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VpnServerConfigurationInner object
     */
    public Observable<ServiceResponse<VpnServerConfigurationInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String vpnServerConfigurationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnServerConfigurationName == null) {
            throw new IllegalArgumentException("Parameter vpnServerConfigurationName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        final Map<String, String> tags = null;
        TagsObject vpnServerConfigurationParameters = new TagsObject();
        vpnServerConfigurationParameters.withTags(null);
        return service.updateTags(this.client.subscriptionId(), resourceGroupName, vpnServerConfigurationName, apiVersion, this.client.acceptLanguage(), vpnServerConfigurationParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnServerConfigurationInner>>>() {
                @Override
                public Observable<ServiceResponse<VpnServerConfigurationInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VpnServerConfigurationInner> clientResponse = updateTagsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates VpnServerConfiguration tags.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being updated.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VpnServerConfigurationInner object if successful.
     */
    public VpnServerConfigurationInner updateTags(String resourceGroupName, String vpnServerConfigurationName, Map<String, String> tags) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName, tags).toBlocking().single().body();
    }

    /**
     * Updates VpnServerConfiguration tags.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being updated.
     * @param tags Resource tags.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VpnServerConfigurationInner> updateTagsAsync(String resourceGroupName, String vpnServerConfigurationName, Map<String, String> tags, final ServiceCallback<VpnServerConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateTagsWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName, tags), serviceCallback);
    }

    /**
     * Updates VpnServerConfiguration tags.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being updated.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VpnServerConfigurationInner object
     */
    public Observable<VpnServerConfigurationInner> updateTagsAsync(String resourceGroupName, String vpnServerConfigurationName, Map<String, String> tags) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName, tags).map(new Func1<ServiceResponse<VpnServerConfigurationInner>, VpnServerConfigurationInner>() {
            @Override
            public VpnServerConfigurationInner call(ServiceResponse<VpnServerConfigurationInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates VpnServerConfiguration tags.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being updated.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VpnServerConfigurationInner object
     */
    public Observable<ServiceResponse<VpnServerConfigurationInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String vpnServerConfigurationName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnServerConfigurationName == null) {
            throw new IllegalArgumentException("Parameter vpnServerConfigurationName is required and cannot be null.");
        }
        Validator.validate(tags);
        final String apiVersion = "2019-11-01";
        TagsObject vpnServerConfigurationParameters = new TagsObject();
        vpnServerConfigurationParameters.withTags(tags);
        return service.updateTags(this.client.subscriptionId(), resourceGroupName, vpnServerConfigurationName, apiVersion, this.client.acceptLanguage(), vpnServerConfigurationParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnServerConfigurationInner>>>() {
                @Override
                public Observable<ServiceResponse<VpnServerConfigurationInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VpnServerConfigurationInner> clientResponse = updateTagsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VpnServerConfigurationInner> updateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VpnServerConfigurationInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VpnServerConfigurationInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a VpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String vpnServerConfigurationName) {
        deleteWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName).toBlocking().last().body();
    }

    /**
     * Deletes a VpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being deleted.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String vpnServerConfigurationName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName), serviceCallback);
    }

    /**
     * Deletes a VpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String vpnServerConfigurationName) {
        return deleteWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a VpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String vpnServerConfigurationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnServerConfigurationName == null) {
            throw new IllegalArgumentException("Parameter vpnServerConfigurationName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.delete(this.client.subscriptionId(), resourceGroupName, vpnServerConfigurationName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a VpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String vpnServerConfigurationName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName).toBlocking().single().body();
    }

    /**
     * Deletes a VpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being deleted.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String vpnServerConfigurationName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName), serviceCallback);
    }

    /**
     * Deletes a VpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String vpnServerConfigurationName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a VpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration being deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String vpnServerConfigurationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnServerConfigurationName == null) {
            throw new IllegalArgumentException("Parameter vpnServerConfigurationName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.beginDelete(this.client.subscriptionId(), resourceGroupName, vpnServerConfigurationName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the vpnServerConfigurations in a resource group.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VpnServerConfigurationInner&gt; object if successful.
     */
    public PagedList<VpnServerConfigurationInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<VpnServerConfigurationInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<VpnServerConfigurationInner>(response.body()) {
            @Override
            public Page<VpnServerConfigurationInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the vpnServerConfigurations in a resource group.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VpnServerConfigurationInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<VpnServerConfigurationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<VpnServerConfigurationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the vpnServerConfigurations in a resource group.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VpnServerConfigurationInner&gt; object
     */
    public Observable<Page<VpnServerConfigurationInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<VpnServerConfigurationInner>>, Page<VpnServerConfigurationInner>>() {
                @Override
                public Page<VpnServerConfigurationInner> call(ServiceResponse<Page<VpnServerConfigurationInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the vpnServerConfigurations in a resource group.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VpnServerConfigurationInner&gt; object
     */
    public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<VpnServerConfigurationInner>>, Observable<ServiceResponse<Page<VpnServerConfigurationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> call(ServiceResponse<Page<VpnServerConfigurationInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the vpnServerConfigurations in a resource group.
     *
    ServiceResponse<PageImpl<VpnServerConfigurationInner>> * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VpnServerConfigurationInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnServerConfigurationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VpnServerConfigurationInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VpnServerConfigurationInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VpnServerConfigurationInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VpnServerConfigurationInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VpnServerConfigurationInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the VpnServerConfigurations in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VpnServerConfigurationInner&gt; object if successful.
     */
    public PagedList<VpnServerConfigurationInner> list() {
        ServiceResponse<Page<VpnServerConfigurationInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<VpnServerConfigurationInner>(response.body()) {
            @Override
            public Page<VpnServerConfigurationInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the VpnServerConfigurations in a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VpnServerConfigurationInner>> listAsync(final ListOperationCallback<VpnServerConfigurationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<VpnServerConfigurationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the VpnServerConfigurations in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VpnServerConfigurationInner&gt; object
     */
    public Observable<Page<VpnServerConfigurationInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<VpnServerConfigurationInner>>, Page<VpnServerConfigurationInner>>() {
                @Override
                public Page<VpnServerConfigurationInner> call(ServiceResponse<Page<VpnServerConfigurationInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the VpnServerConfigurations in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VpnServerConfigurationInner&gt; object
     */
    public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<VpnServerConfigurationInner>>, Observable<ServiceResponse<Page<VpnServerConfigurationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> call(ServiceResponse<Page<VpnServerConfigurationInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the VpnServerConfigurations in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VpnServerConfigurationInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnServerConfigurationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VpnServerConfigurationInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VpnServerConfigurationInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VpnServerConfigurationInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VpnServerConfigurationInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VpnServerConfigurationInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the vpnServerConfigurations in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VpnServerConfigurationInner&gt; object if successful.
     */
    public PagedList<VpnServerConfigurationInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<VpnServerConfigurationInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VpnServerConfigurationInner>(response.body()) {
            @Override
            public Page<VpnServerConfigurationInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the vpnServerConfigurations in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VpnServerConfigurationInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<VpnServerConfigurationInner>> serviceFuture, final ListOperationCallback<VpnServerConfigurationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<VpnServerConfigurationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the vpnServerConfigurations in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VpnServerConfigurationInner&gt; object
     */
    public Observable<Page<VpnServerConfigurationInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<VpnServerConfigurationInner>>, Page<VpnServerConfigurationInner>>() {
                @Override
                public Page<VpnServerConfigurationInner> call(ServiceResponse<Page<VpnServerConfigurationInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the vpnServerConfigurations in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VpnServerConfigurationInner&gt; object
     */
    public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<VpnServerConfigurationInner>>, Observable<ServiceResponse<Page<VpnServerConfigurationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> call(ServiceResponse<Page<VpnServerConfigurationInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the vpnServerConfigurations in a resource group.
     *
    ServiceResponse<PageImpl<VpnServerConfigurationInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VpnServerConfigurationInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnServerConfigurationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VpnServerConfigurationInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VpnServerConfigurationInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VpnServerConfigurationInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VpnServerConfigurationInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VpnServerConfigurationInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the VpnServerConfigurations in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VpnServerConfigurationInner&gt; object if successful.
     */
    public PagedList<VpnServerConfigurationInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<VpnServerConfigurationInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VpnServerConfigurationInner>(response.body()) {
            @Override
            public Page<VpnServerConfigurationInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the VpnServerConfigurations in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VpnServerConfigurationInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<VpnServerConfigurationInner>> serviceFuture, final ListOperationCallback<VpnServerConfigurationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<VpnServerConfigurationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the VpnServerConfigurations in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VpnServerConfigurationInner&gt; object
     */
    public Observable<Page<VpnServerConfigurationInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<VpnServerConfigurationInner>>, Page<VpnServerConfigurationInner>>() {
                @Override
                public Page<VpnServerConfigurationInner> call(ServiceResponse<Page<VpnServerConfigurationInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the VpnServerConfigurations in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VpnServerConfigurationInner&gt; object
     */
    public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<VpnServerConfigurationInner>>, Observable<ServiceResponse<Page<VpnServerConfigurationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> call(ServiceResponse<Page<VpnServerConfigurationInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the VpnServerConfigurations in a subscription.
     *
    ServiceResponse<PageImpl<VpnServerConfigurationInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VpnServerConfigurationInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnServerConfigurationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VpnServerConfigurationInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VpnServerConfigurationInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VpnServerConfigurationInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VpnServerConfigurationInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VpnServerConfigurationInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
