/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in VirtualHubRouteTableV2s.
 */
public class VirtualHubRouteTableV2sInner {
    /** The Retrofit service to perform REST calls. */
    private VirtualHubRouteTableV2sService service;
    /** The service client containing this operation class. */
    private NetworkManagementClientImpl client;

    /**
     * Initializes an instance of VirtualHubRouteTableV2sInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public VirtualHubRouteTableV2sInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = retrofit.create(VirtualHubRouteTableV2sService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for VirtualHubRouteTableV2s to be
     * used by Retrofit to perform actually REST calls.
     */
    interface VirtualHubRouteTableV2sService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubRouteTableV2s get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routeTables/{routeTableName}")
        Observable<Response<ResponseBody>> get(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("virtualHubName") String virtualHubName, @Path("routeTableName") String routeTableName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubRouteTableV2s createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routeTables/{routeTableName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("virtualHubName") String virtualHubName, @Path("routeTableName") String routeTableName, @Query("api-version") String apiVersion, @Body VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubRouteTableV2s beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routeTables/{routeTableName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("virtualHubName") String virtualHubName, @Path("routeTableName") String routeTableName, @Query("api-version") String apiVersion, @Body VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubRouteTableV2s delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routeTables/{routeTableName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("virtualHubName") String virtualHubName, @Path("routeTableName") String routeTableName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubRouteTableV2s beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routeTables/{routeTableName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("virtualHubName") String virtualHubName, @Path("routeTableName") String routeTableName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubRouteTableV2s list" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routeTables")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("virtualHubName") String virtualHubName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubRouteTableV2s listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Retrieves the details of a VirtualHubRouteTableV2.
     *
     * @param resourceGroupName The resource group name of the VirtualHubRouteTableV2.
     * @param virtualHubName The name of the VirtualHub.
     * @param routeTableName The name of the VirtualHubRouteTableV2.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualHubRouteTableV2Inner object if successful.
     */
    public VirtualHubRouteTableV2Inner get(String resourceGroupName, String virtualHubName, String routeTableName) {
        return getWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName).toBlocking().single().body();
    }

    /**
     * Retrieves the details of a VirtualHubRouteTableV2.
     *
     * @param resourceGroupName The resource group name of the VirtualHubRouteTableV2.
     * @param virtualHubName The name of the VirtualHub.
     * @param routeTableName The name of the VirtualHubRouteTableV2.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualHubRouteTableV2Inner> getAsync(String resourceGroupName, String virtualHubName, String routeTableName, final ServiceCallback<VirtualHubRouteTableV2Inner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName), serviceCallback);
    }

    /**
     * Retrieves the details of a VirtualHubRouteTableV2.
     *
     * @param resourceGroupName The resource group name of the VirtualHubRouteTableV2.
     * @param virtualHubName The name of the VirtualHub.
     * @param routeTableName The name of the VirtualHubRouteTableV2.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualHubRouteTableV2Inner object
     */
    public Observable<VirtualHubRouteTableV2Inner> getAsync(String resourceGroupName, String virtualHubName, String routeTableName) {
        return getWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName).map(new Func1<ServiceResponse<VirtualHubRouteTableV2Inner>, VirtualHubRouteTableV2Inner>() {
            @Override
            public VirtualHubRouteTableV2Inner call(ServiceResponse<VirtualHubRouteTableV2Inner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the details of a VirtualHubRouteTableV2.
     *
     * @param resourceGroupName The resource group name of the VirtualHubRouteTableV2.
     * @param virtualHubName The name of the VirtualHub.
     * @param routeTableName The name of the VirtualHubRouteTableV2.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualHubRouteTableV2Inner object
     */
    public Observable<ServiceResponse<VirtualHubRouteTableV2Inner>> getWithServiceResponseAsync(String resourceGroupName, String virtualHubName, String routeTableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        if (routeTableName == null) {
            throw new IllegalArgumentException("Parameter routeTableName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.get(this.client.subscriptionId(), resourceGroupName, virtualHubName, routeTableName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualHubRouteTableV2Inner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualHubRouteTableV2Inner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualHubRouteTableV2Inner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualHubRouteTableV2Inner> getDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VirtualHubRouteTableV2Inner, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VirtualHubRouteTableV2Inner>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Creates a VirtualHubRouteTableV2 resource if it doesn't exist else updates the existing VirtualHubRouteTableV2.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param routeTableName The name of the VirtualHubRouteTableV2.
     * @param virtualHubRouteTableV2Parameters Parameters supplied to create or update VirtualHubRouteTableV2.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualHubRouteTableV2Inner object if successful.
     */
    public VirtualHubRouteTableV2Inner createOrUpdate(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName, virtualHubRouteTableV2Parameters).toBlocking().last().body();
    }

    /**
     * Creates a VirtualHubRouteTableV2 resource if it doesn't exist else updates the existing VirtualHubRouteTableV2.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param routeTableName The name of the VirtualHubRouteTableV2.
     * @param virtualHubRouteTableV2Parameters Parameters supplied to create or update VirtualHubRouteTableV2.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualHubRouteTableV2Inner> createOrUpdateAsync(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters, final ServiceCallback<VirtualHubRouteTableV2Inner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName, virtualHubRouteTableV2Parameters), serviceCallback);
    }

    /**
     * Creates a VirtualHubRouteTableV2 resource if it doesn't exist else updates the existing VirtualHubRouteTableV2.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param routeTableName The name of the VirtualHubRouteTableV2.
     * @param virtualHubRouteTableV2Parameters Parameters supplied to create or update VirtualHubRouteTableV2.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<VirtualHubRouteTableV2Inner> createOrUpdateAsync(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName, virtualHubRouteTableV2Parameters).map(new Func1<ServiceResponse<VirtualHubRouteTableV2Inner>, VirtualHubRouteTableV2Inner>() {
            @Override
            public VirtualHubRouteTableV2Inner call(ServiceResponse<VirtualHubRouteTableV2Inner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a VirtualHubRouteTableV2 resource if it doesn't exist else updates the existing VirtualHubRouteTableV2.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param routeTableName The name of the VirtualHubRouteTableV2.
     * @param virtualHubRouteTableV2Parameters Parameters supplied to create or update VirtualHubRouteTableV2.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<VirtualHubRouteTableV2Inner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        if (routeTableName == null) {
            throw new IllegalArgumentException("Parameter routeTableName is required and cannot be null.");
        }
        if (virtualHubRouteTableV2Parameters == null) {
            throw new IllegalArgumentException("Parameter virtualHubRouteTableV2Parameters is required and cannot be null.");
        }
        Validator.validate(virtualHubRouteTableV2Parameters);
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, virtualHubName, routeTableName, apiVersion, virtualHubRouteTableV2Parameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualHubRouteTableV2Inner>() { }.getType());
    }

    /**
     * Creates a VirtualHubRouteTableV2 resource if it doesn't exist else updates the existing VirtualHubRouteTableV2.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param routeTableName The name of the VirtualHubRouteTableV2.
     * @param virtualHubRouteTableV2Parameters Parameters supplied to create or update VirtualHubRouteTableV2.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualHubRouteTableV2Inner object if successful.
     */
    public VirtualHubRouteTableV2Inner beginCreateOrUpdate(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName, virtualHubRouteTableV2Parameters).toBlocking().single().body();
    }

    /**
     * Creates a VirtualHubRouteTableV2 resource if it doesn't exist else updates the existing VirtualHubRouteTableV2.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param routeTableName The name of the VirtualHubRouteTableV2.
     * @param virtualHubRouteTableV2Parameters Parameters supplied to create or update VirtualHubRouteTableV2.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualHubRouteTableV2Inner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters, final ServiceCallback<VirtualHubRouteTableV2Inner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName, virtualHubRouteTableV2Parameters), serviceCallback);
    }

    /**
     * Creates a VirtualHubRouteTableV2 resource if it doesn't exist else updates the existing VirtualHubRouteTableV2.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param routeTableName The name of the VirtualHubRouteTableV2.
     * @param virtualHubRouteTableV2Parameters Parameters supplied to create or update VirtualHubRouteTableV2.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualHubRouteTableV2Inner object
     */
    public Observable<VirtualHubRouteTableV2Inner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName, virtualHubRouteTableV2Parameters).map(new Func1<ServiceResponse<VirtualHubRouteTableV2Inner>, VirtualHubRouteTableV2Inner>() {
            @Override
            public VirtualHubRouteTableV2Inner call(ServiceResponse<VirtualHubRouteTableV2Inner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a VirtualHubRouteTableV2 resource if it doesn't exist else updates the existing VirtualHubRouteTableV2.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param routeTableName The name of the VirtualHubRouteTableV2.
     * @param virtualHubRouteTableV2Parameters Parameters supplied to create or update VirtualHubRouteTableV2.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualHubRouteTableV2Inner object
     */
    public Observable<ServiceResponse<VirtualHubRouteTableV2Inner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        if (routeTableName == null) {
            throw new IllegalArgumentException("Parameter routeTableName is required and cannot be null.");
        }
        if (virtualHubRouteTableV2Parameters == null) {
            throw new IllegalArgumentException("Parameter virtualHubRouteTableV2Parameters is required and cannot be null.");
        }
        Validator.validate(virtualHubRouteTableV2Parameters);
        final String apiVersion = "2019-11-01";
        return service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, virtualHubName, routeTableName, apiVersion, virtualHubRouteTableV2Parameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualHubRouteTableV2Inner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualHubRouteTableV2Inner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualHubRouteTableV2Inner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualHubRouteTableV2Inner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VirtualHubRouteTableV2Inner, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VirtualHubRouteTableV2Inner>() { }.getType())
                .register(201, new TypeToken<VirtualHubRouteTableV2Inner>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Deletes a VirtualHubRouteTableV2.
     *
     * @param resourceGroupName The resource group name of the VirtualHubRouteTableV2.
     * @param virtualHubName The name of the VirtualHub.
     * @param routeTableName The name of the VirtualHubRouteTableV2.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String virtualHubName, String routeTableName) {
        deleteWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName).toBlocking().last().body();
    }

    /**
     * Deletes a VirtualHubRouteTableV2.
     *
     * @param resourceGroupName The resource group name of the VirtualHubRouteTableV2.
     * @param virtualHubName The name of the VirtualHub.
     * @param routeTableName The name of the VirtualHubRouteTableV2.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String virtualHubName, String routeTableName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName), serviceCallback);
    }

    /**
     * Deletes a VirtualHubRouteTableV2.
     *
     * @param resourceGroupName The resource group name of the VirtualHubRouteTableV2.
     * @param virtualHubName The name of the VirtualHub.
     * @param routeTableName The name of the VirtualHubRouteTableV2.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String virtualHubName, String routeTableName) {
        return deleteWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a VirtualHubRouteTableV2.
     *
     * @param resourceGroupName The resource group name of the VirtualHubRouteTableV2.
     * @param virtualHubName The name of the VirtualHub.
     * @param routeTableName The name of the VirtualHubRouteTableV2.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String virtualHubName, String routeTableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        if (routeTableName == null) {
            throw new IllegalArgumentException("Parameter routeTableName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.delete(this.client.subscriptionId(), resourceGroupName, virtualHubName, routeTableName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a VirtualHubRouteTableV2.
     *
     * @param resourceGroupName The resource group name of the VirtualHubRouteTableV2.
     * @param virtualHubName The name of the VirtualHub.
     * @param routeTableName The name of the VirtualHubRouteTableV2.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String virtualHubName, String routeTableName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName).toBlocking().single().body();
    }

    /**
     * Deletes a VirtualHubRouteTableV2.
     *
     * @param resourceGroupName The resource group name of the VirtualHubRouteTableV2.
     * @param virtualHubName The name of the VirtualHub.
     * @param routeTableName The name of the VirtualHubRouteTableV2.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String virtualHubName, String routeTableName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName), serviceCallback);
    }

    /**
     * Deletes a VirtualHubRouteTableV2.
     *
     * @param resourceGroupName The resource group name of the VirtualHubRouteTableV2.
     * @param virtualHubName The name of the VirtualHub.
     * @param routeTableName The name of the VirtualHubRouteTableV2.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String virtualHubName, String routeTableName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a VirtualHubRouteTableV2.
     *
     * @param resourceGroupName The resource group name of the VirtualHubRouteTableV2.
     * @param virtualHubName The name of the VirtualHub.
     * @param routeTableName The name of the VirtualHubRouteTableV2.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String virtualHubName, String routeTableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        if (routeTableName == null) {
            throw new IllegalArgumentException("Parameter routeTableName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.beginDelete(this.client.subscriptionId(), resourceGroupName, virtualHubName, routeTableName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Retrieves the details of all VirtualHubRouteTableV2s.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualHubRouteTableV2Inner&gt; object if successful.
     */
    public PagedList<VirtualHubRouteTableV2Inner> list(final String resourceGroupName, final String virtualHubName) {
        ServiceResponse<Page<VirtualHubRouteTableV2Inner>> response = listSinglePageAsync(resourceGroupName, virtualHubName).toBlocking().single();
        return new PagedList<VirtualHubRouteTableV2Inner>(response.body()) {
            @Override
            public Page<VirtualHubRouteTableV2Inner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the details of all VirtualHubRouteTableV2s.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualHubRouteTableV2Inner>> listAsync(final String resourceGroupName, final String virtualHubName, final ListOperationCallback<VirtualHubRouteTableV2Inner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(resourceGroupName, virtualHubName),
            new Func1<String, Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the details of all VirtualHubRouteTableV2s.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualHubRouteTableV2Inner&gt; object
     */
    public Observable<Page<VirtualHubRouteTableV2Inner>> listAsync(final String resourceGroupName, final String virtualHubName) {
        return listWithServiceResponseAsync(resourceGroupName, virtualHubName)
            .map(new Func1<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>, Page<VirtualHubRouteTableV2Inner>>() {
                @Override
                public Page<VirtualHubRouteTableV2Inner> call(ServiceResponse<Page<VirtualHubRouteTableV2Inner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the details of all VirtualHubRouteTableV2s.
     *
     * @param resourceGroupName The resource group name of the VirtualHub.
     * @param virtualHubName The name of the VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualHubRouteTableV2Inner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>> listWithServiceResponseAsync(final String resourceGroupName, final String virtualHubName) {
        return listSinglePageAsync(resourceGroupName, virtualHubName)
            .concatMap(new Func1<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>, Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>> call(ServiceResponse<Page<VirtualHubRouteTableV2Inner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the details of all VirtualHubRouteTableV2s.
     *
    ServiceResponse<PageImpl<VirtualHubRouteTableV2Inner>> * @param resourceGroupName The resource group name of the VirtualHub.
    ServiceResponse<PageImpl<VirtualHubRouteTableV2Inner>> * @param virtualHubName The name of the VirtualHub.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualHubRouteTableV2Inner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>> listSinglePageAsync(final String resourceGroupName, final String virtualHubName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.list(this.client.subscriptionId(), resourceGroupName, virtualHubName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VirtualHubRouteTableV2Inner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualHubRouteTableV2Inner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VirtualHubRouteTableV2Inner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VirtualHubRouteTableV2Inner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VirtualHubRouteTableV2Inner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves the details of all VirtualHubRouteTableV2s.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualHubRouteTableV2Inner&gt; object if successful.
     */
    public PagedList<VirtualHubRouteTableV2Inner> listNext(final String nextPageLink) {
        ServiceResponse<Page<VirtualHubRouteTableV2Inner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualHubRouteTableV2Inner>(response.body()) {
            @Override
            public Page<VirtualHubRouteTableV2Inner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Retrieves the details of all VirtualHubRouteTableV2s.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualHubRouteTableV2Inner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<VirtualHubRouteTableV2Inner>> serviceFuture, final ListOperationCallback<VirtualHubRouteTableV2Inner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Retrieves the details of all VirtualHubRouteTableV2s.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualHubRouteTableV2Inner&gt; object
     */
    public Observable<Page<VirtualHubRouteTableV2Inner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>, Page<VirtualHubRouteTableV2Inner>>() {
                @Override
                public Page<VirtualHubRouteTableV2Inner> call(ServiceResponse<Page<VirtualHubRouteTableV2Inner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Retrieves the details of all VirtualHubRouteTableV2s.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualHubRouteTableV2Inner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>, Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>> call(ServiceResponse<Page<VirtualHubRouteTableV2Inner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Retrieves the details of all VirtualHubRouteTableV2s.
     *
    ServiceResponse<PageImpl<VirtualHubRouteTableV2Inner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualHubRouteTableV2Inner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VirtualHubRouteTableV2Inner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualHubRouteTableV2Inner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VirtualHubRouteTableV2Inner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VirtualHubRouteTableV2Inner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VirtualHubRouteTableV2Inner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
