/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in ServiceEndpointPolicyDefinitions.
 */
public class ServiceEndpointPolicyDefinitionsInner {
    /** The Retrofit service to perform REST calls. */
    private ServiceEndpointPolicyDefinitionsService service;
    /** The service client containing this operation class. */
    private NetworkManagementClientImpl client;

    /**
     * Initializes an instance of ServiceEndpointPolicyDefinitionsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ServiceEndpointPolicyDefinitionsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = retrofit.create(ServiceEndpointPolicyDefinitionsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for ServiceEndpointPolicyDefinitions to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ServiceEndpointPolicyDefinitionsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicyDefinitions delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}/serviceEndpointPolicyDefinitions/{serviceEndpointPolicyDefinitionName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("serviceEndpointPolicyName") String serviceEndpointPolicyName, @Path("serviceEndpointPolicyDefinitionName") String serviceEndpointPolicyDefinitionName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicyDefinitions beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}/serviceEndpointPolicyDefinitions/{serviceEndpointPolicyDefinitionName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("serviceEndpointPolicyName") String serviceEndpointPolicyName, @Path("serviceEndpointPolicyDefinitionName") String serviceEndpointPolicyDefinitionName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicyDefinitions get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}/serviceEndpointPolicyDefinitions/{serviceEndpointPolicyDefinitionName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("serviceEndpointPolicyName") String serviceEndpointPolicyName, @Path("serviceEndpointPolicyDefinitionName") String serviceEndpointPolicyDefinitionName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicyDefinitions createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}/serviceEndpointPolicyDefinitions/{serviceEndpointPolicyDefinitionName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("serviceEndpointPolicyName") String serviceEndpointPolicyName, @Path("serviceEndpointPolicyDefinitionName") String serviceEndpointPolicyDefinitionName, @Path("subscriptionId") String subscriptionId, @Body ServiceEndpointPolicyDefinitionInner serviceEndpointPolicyDefinitions, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicyDefinitions beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}/serviceEndpointPolicyDefinitions/{serviceEndpointPolicyDefinitionName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("serviceEndpointPolicyName") String serviceEndpointPolicyName, @Path("serviceEndpointPolicyDefinitionName") String serviceEndpointPolicyDefinitionName, @Path("subscriptionId") String subscriptionId, @Body ServiceEndpointPolicyDefinitionInner serviceEndpointPolicyDefinitions, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicyDefinitions listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}/serviceEndpointPolicyDefinitions")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("serviceEndpointPolicyName") String serviceEndpointPolicyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicyDefinitions listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Deletes the specified ServiceEndpoint policy definitions.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the Service Endpoint Policy.
     * @param serviceEndpointPolicyDefinitionName The name of the service endpoint policy definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName) {
        deleteWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName).toBlocking().last().body();
    }

    /**
     * Deletes the specified ServiceEndpoint policy definitions.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the Service Endpoint Policy.
     * @param serviceEndpointPolicyDefinitionName The name of the service endpoint policy definition.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName), serviceCallback);
    }

    /**
     * Deletes the specified ServiceEndpoint policy definitions.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the Service Endpoint Policy.
     * @param serviceEndpointPolicyDefinitionName The name of the service endpoint policy definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName) {
        return deleteWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified ServiceEndpoint policy definitions.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the Service Endpoint Policy.
     * @param serviceEndpointPolicyDefinitionName The name of the service endpoint policy definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (serviceEndpointPolicyDefinitionName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyDefinitionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes the specified ServiceEndpoint policy definitions.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the Service Endpoint Policy.
     * @param serviceEndpointPolicyDefinitionName The name of the service endpoint policy definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName).toBlocking().single().body();
    }

    /**
     * Deletes the specified ServiceEndpoint policy definitions.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the Service Endpoint Policy.
     * @param serviceEndpointPolicyDefinitionName The name of the service endpoint policy definition.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName), serviceCallback);
    }

    /**
     * Deletes the specified ServiceEndpoint policy definitions.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the Service Endpoint Policy.
     * @param serviceEndpointPolicyDefinitionName The name of the service endpoint policy definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified ServiceEndpoint policy definitions.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the Service Endpoint Policy.
     * @param serviceEndpointPolicyDefinitionName The name of the service endpoint policy definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (serviceEndpointPolicyDefinitionName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyDefinitionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.beginDelete(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get the specified service endpoint policy definitions from service endpoint policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy name.
     * @param serviceEndpointPolicyDefinitionName The name of the service endpoint policy definition name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ServiceEndpointPolicyDefinitionInner object if successful.
     */
    public ServiceEndpointPolicyDefinitionInner get(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName) {
        return getWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName).toBlocking().single().body();
    }

    /**
     * Get the specified service endpoint policy definitions from service endpoint policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy name.
     * @param serviceEndpointPolicyDefinitionName The name of the service endpoint policy definition name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ServiceEndpointPolicyDefinitionInner> getAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName, final ServiceCallback<ServiceEndpointPolicyDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName), serviceCallback);
    }

    /**
     * Get the specified service endpoint policy definitions from service endpoint policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy name.
     * @param serviceEndpointPolicyDefinitionName The name of the service endpoint policy definition name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServiceEndpointPolicyDefinitionInner object
     */
    public Observable<ServiceEndpointPolicyDefinitionInner> getAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName) {
        return getWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName).map(new Func1<ServiceResponse<ServiceEndpointPolicyDefinitionInner>, ServiceEndpointPolicyDefinitionInner>() {
            @Override
            public ServiceEndpointPolicyDefinitionInner call(ServiceResponse<ServiceEndpointPolicyDefinitionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get the specified service endpoint policy definitions from service endpoint policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy name.
     * @param serviceEndpointPolicyDefinitionName The name of the service endpoint policy definition name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServiceEndpointPolicyDefinitionInner object
     */
    public Observable<ServiceResponse<ServiceEndpointPolicyDefinitionInner>> getWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (serviceEndpointPolicyDefinitionName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyDefinitionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.get(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServiceEndpointPolicyDefinitionInner>>>() {
                @Override
                public Observable<ServiceResponse<ServiceEndpointPolicyDefinitionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ServiceEndpointPolicyDefinitionInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ServiceEndpointPolicyDefinitionInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ServiceEndpointPolicyDefinitionInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ServiceEndpointPolicyDefinitionInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates a service endpoint policy definition in the specified service endpoint policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param serviceEndpointPolicyDefinitionName The name of the service endpoint policy definition name.
     * @param serviceEndpointPolicyDefinitions Parameters supplied to the create or update service endpoint policy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ServiceEndpointPolicyDefinitionInner object if successful.
     */
    public ServiceEndpointPolicyDefinitionInner createOrUpdate(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName, ServiceEndpointPolicyDefinitionInner serviceEndpointPolicyDefinitions) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName, serviceEndpointPolicyDefinitions).toBlocking().last().body();
    }

    /**
     * Creates or updates a service endpoint policy definition in the specified service endpoint policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param serviceEndpointPolicyDefinitionName The name of the service endpoint policy definition name.
     * @param serviceEndpointPolicyDefinitions Parameters supplied to the create or update service endpoint policy operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ServiceEndpointPolicyDefinitionInner> createOrUpdateAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName, ServiceEndpointPolicyDefinitionInner serviceEndpointPolicyDefinitions, final ServiceCallback<ServiceEndpointPolicyDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName, serviceEndpointPolicyDefinitions), serviceCallback);
    }

    /**
     * Creates or updates a service endpoint policy definition in the specified service endpoint policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param serviceEndpointPolicyDefinitionName The name of the service endpoint policy definition name.
     * @param serviceEndpointPolicyDefinitions Parameters supplied to the create or update service endpoint policy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceEndpointPolicyDefinitionInner> createOrUpdateAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName, ServiceEndpointPolicyDefinitionInner serviceEndpointPolicyDefinitions) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName, serviceEndpointPolicyDefinitions).map(new Func1<ServiceResponse<ServiceEndpointPolicyDefinitionInner>, ServiceEndpointPolicyDefinitionInner>() {
            @Override
            public ServiceEndpointPolicyDefinitionInner call(ServiceResponse<ServiceEndpointPolicyDefinitionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a service endpoint policy definition in the specified service endpoint policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param serviceEndpointPolicyDefinitionName The name of the service endpoint policy definition name.
     * @param serviceEndpointPolicyDefinitions Parameters supplied to the create or update service endpoint policy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ServiceEndpointPolicyDefinitionInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName, ServiceEndpointPolicyDefinitionInner serviceEndpointPolicyDefinitions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (serviceEndpointPolicyDefinitionName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyDefinitionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (serviceEndpointPolicyDefinitions == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyDefinitions is required and cannot be null.");
        }
        Validator.validate(serviceEndpointPolicyDefinitions);
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName, this.client.subscriptionId(), serviceEndpointPolicyDefinitions, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ServiceEndpointPolicyDefinitionInner>() { }.getType());
    }

    /**
     * Creates or updates a service endpoint policy definition in the specified service endpoint policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param serviceEndpointPolicyDefinitionName The name of the service endpoint policy definition name.
     * @param serviceEndpointPolicyDefinitions Parameters supplied to the create or update service endpoint policy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ServiceEndpointPolicyDefinitionInner object if successful.
     */
    public ServiceEndpointPolicyDefinitionInner beginCreateOrUpdate(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName, ServiceEndpointPolicyDefinitionInner serviceEndpointPolicyDefinitions) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName, serviceEndpointPolicyDefinitions).toBlocking().single().body();
    }

    /**
     * Creates or updates a service endpoint policy definition in the specified service endpoint policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param serviceEndpointPolicyDefinitionName The name of the service endpoint policy definition name.
     * @param serviceEndpointPolicyDefinitions Parameters supplied to the create or update service endpoint policy operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ServiceEndpointPolicyDefinitionInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName, ServiceEndpointPolicyDefinitionInner serviceEndpointPolicyDefinitions, final ServiceCallback<ServiceEndpointPolicyDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName, serviceEndpointPolicyDefinitions), serviceCallback);
    }

    /**
     * Creates or updates a service endpoint policy definition in the specified service endpoint policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param serviceEndpointPolicyDefinitionName The name of the service endpoint policy definition name.
     * @param serviceEndpointPolicyDefinitions Parameters supplied to the create or update service endpoint policy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServiceEndpointPolicyDefinitionInner object
     */
    public Observable<ServiceEndpointPolicyDefinitionInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName, ServiceEndpointPolicyDefinitionInner serviceEndpointPolicyDefinitions) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName, serviceEndpointPolicyDefinitions).map(new Func1<ServiceResponse<ServiceEndpointPolicyDefinitionInner>, ServiceEndpointPolicyDefinitionInner>() {
            @Override
            public ServiceEndpointPolicyDefinitionInner call(ServiceResponse<ServiceEndpointPolicyDefinitionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a service endpoint policy definition in the specified service endpoint policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy.
     * @param serviceEndpointPolicyDefinitionName The name of the service endpoint policy definition name.
     * @param serviceEndpointPolicyDefinitions Parameters supplied to the create or update service endpoint policy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServiceEndpointPolicyDefinitionInner object
     */
    public Observable<ServiceResponse<ServiceEndpointPolicyDefinitionInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName, ServiceEndpointPolicyDefinitionInner serviceEndpointPolicyDefinitions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (serviceEndpointPolicyDefinitionName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyDefinitionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (serviceEndpointPolicyDefinitions == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyDefinitions is required and cannot be null.");
        }
        Validator.validate(serviceEndpointPolicyDefinitions);
        final String apiVersion = "2019-11-01";
        return service.beginCreateOrUpdate(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName, this.client.subscriptionId(), serviceEndpointPolicyDefinitions, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServiceEndpointPolicyDefinitionInner>>>() {
                @Override
                public Observable<ServiceResponse<ServiceEndpointPolicyDefinitionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ServiceEndpointPolicyDefinitionInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ServiceEndpointPolicyDefinitionInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ServiceEndpointPolicyDefinitionInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ServiceEndpointPolicyDefinitionInner>() { }.getType())
                .register(201, new TypeToken<ServiceEndpointPolicyDefinitionInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all service endpoint policy definitions in a service end point policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ServiceEndpointPolicyDefinitionInner&gt; object if successful.
     */
    public PagedList<ServiceEndpointPolicyDefinitionInner> listByResourceGroup(final String resourceGroupName, final String serviceEndpointPolicyName) {
        ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName, serviceEndpointPolicyName).toBlocking().single();
        return new PagedList<ServiceEndpointPolicyDefinitionInner>(response.body()) {
            @Override
            public Page<ServiceEndpointPolicyDefinitionInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all service endpoint policy definitions in a service end point policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ServiceEndpointPolicyDefinitionInner>> listByResourceGroupAsync(final String resourceGroupName, final String serviceEndpointPolicyName, final ListOperationCallback<ServiceEndpointPolicyDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName, serviceEndpointPolicyName),
            new Func1<String, Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all service endpoint policy definitions in a service end point policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ServiceEndpointPolicyDefinitionInner&gt; object
     */
    public Observable<Page<ServiceEndpointPolicyDefinitionInner>> listByResourceGroupAsync(final String resourceGroupName, final String serviceEndpointPolicyName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName)
            .map(new Func1<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>, Page<ServiceEndpointPolicyDefinitionInner>>() {
                @Override
                public Page<ServiceEndpointPolicyDefinitionInner> call(ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all service endpoint policy definitions in a service end point policy.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceEndpointPolicyName The name of the service endpoint policy name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ServiceEndpointPolicyDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName, final String serviceEndpointPolicyName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName, serviceEndpointPolicyName)
            .concatMap(new Func1<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>, Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>> call(ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all service endpoint policy definitions in a service end point policy.
     *
    ServiceResponse<PageImpl<ServiceEndpointPolicyDefinitionInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl<ServiceEndpointPolicyDefinitionInner>> * @param serviceEndpointPolicyName The name of the service endpoint policy name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ServiceEndpointPolicyDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName, final String serviceEndpointPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.listByResourceGroup(resourceGroupName, serviceEndpointPolicyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ServiceEndpointPolicyDefinitionInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ServiceEndpointPolicyDefinitionInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ServiceEndpointPolicyDefinitionInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ServiceEndpointPolicyDefinitionInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all service endpoint policy definitions in a service end point policy.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ServiceEndpointPolicyDefinitionInner&gt; object if successful.
     */
    public PagedList<ServiceEndpointPolicyDefinitionInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ServiceEndpointPolicyDefinitionInner>(response.body()) {
            @Override
            public Page<ServiceEndpointPolicyDefinitionInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all service endpoint policy definitions in a service end point policy.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ServiceEndpointPolicyDefinitionInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<ServiceEndpointPolicyDefinitionInner>> serviceFuture, final ListOperationCallback<ServiceEndpointPolicyDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all service endpoint policy definitions in a service end point policy.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ServiceEndpointPolicyDefinitionInner&gt; object
     */
    public Observable<Page<ServiceEndpointPolicyDefinitionInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>, Page<ServiceEndpointPolicyDefinitionInner>>() {
                @Override
                public Page<ServiceEndpointPolicyDefinitionInner> call(ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all service endpoint policy definitions in a service end point policy.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ServiceEndpointPolicyDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>, Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>> call(ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all service endpoint policy definitions in a service end point policy.
     *
    ServiceResponse<PageImpl<ServiceEndpointPolicyDefinitionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ServiceEndpointPolicyDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ServiceEndpointPolicyDefinitionInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ServiceEndpointPolicyDefinitionInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ServiceEndpointPolicyDefinitionInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ServiceEndpointPolicyDefinitionInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
