/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.network.CheckPrivateLinkServiceVisibilityRequest;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in PrivateLinkServices.
 */
public class PrivateLinkServicesInner implements InnerSupportsGet<PrivateLinkServiceInner>, InnerSupportsDelete<Void>, InnerSupportsListing<PrivateLinkServiceInner> {
    /** The Retrofit service to perform REST calls. */
    private PrivateLinkServicesService service;
    /** The service client containing this operation class. */
    private NetworkManagementClientImpl client;

    /**
     * Initializes an instance of PrivateLinkServicesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public PrivateLinkServicesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = retrofit.create(PrivateLinkServicesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for PrivateLinkServices to be
     * used by Retrofit to perform actually REST calls.
     */
    interface PrivateLinkServicesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices/{serviceName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("serviceName") String serviceName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices/{serviceName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("serviceName") String serviceName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices/{serviceName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("serviceName") String serviceName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Query("$expand") String expand, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices/{serviceName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("serviceName") String serviceName, @Path("subscriptionId") String subscriptionId, @Body PrivateLinkServiceInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices/{serviceName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("serviceName") String serviceName, @Path("subscriptionId") String subscriptionId, @Body PrivateLinkServiceInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Network/privateLinkServices")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices getPrivateEndpointConnection" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices/{serviceName}/privateEndpointConnections/{peConnectionName}")
        Observable<Response<ResponseBody>> getPrivateEndpointConnection(@Path("resourceGroupName") String resourceGroupName, @Path("serviceName") String serviceName, @Path("peConnectionName") String peConnectionName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Query("$expand") String expand, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices updatePrivateEndpointConnection" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices/{serviceName}/privateEndpointConnections/{peConnectionName}")
        Observable<Response<ResponseBody>> updatePrivateEndpointConnection(@Path("resourceGroupName") String resourceGroupName, @Path("serviceName") String serviceName, @Path("peConnectionName") String peConnectionName, @Path("subscriptionId") String subscriptionId, @Body PrivateEndpointConnectionInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices deletePrivateEndpointConnection" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices/{serviceName}/privateEndpointConnections/{peConnectionName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deletePrivateEndpointConnection(@Path("resourceGroupName") String resourceGroupName, @Path("serviceName") String serviceName, @Path("peConnectionName") String peConnectionName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices beginDeletePrivateEndpointConnection" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices/{serviceName}/privateEndpointConnections/{peConnectionName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDeletePrivateEndpointConnection(@Path("resourceGroupName") String resourceGroupName, @Path("serviceName") String serviceName, @Path("peConnectionName") String peConnectionName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices listPrivateEndpointConnections" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices/{serviceName}/privateEndpointConnections")
        Observable<Response<ResponseBody>> listPrivateEndpointConnections(@Path("resourceGroupName") String resourceGroupName, @Path("serviceName") String serviceName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices checkPrivateLinkServiceVisibility" })
        @POST("subscriptions/{subscriptionId}/providers/Microsoft.Network/locations/{location}/checkPrivateLinkServiceVisibility")
        Observable<Response<ResponseBody>> checkPrivateLinkServiceVisibility(@Path("location") String location, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body CheckPrivateLinkServiceVisibilityRequest parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices checkPrivateLinkServiceVisibilityByResourceGroup" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/locations/{location}/checkPrivateLinkServiceVisibility")
        Observable<Response<ResponseBody>> checkPrivateLinkServiceVisibilityByResourceGroup(@Path("location") String location, @Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body CheckPrivateLinkServiceVisibilityRequest parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices listAutoApprovedPrivateLinkServices" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Network/locations/{location}/autoApprovedPrivateLinkServices")
        Observable<Response<ResponseBody>> listAutoApprovedPrivateLinkServices(@Path("location") String location, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices listAutoApprovedPrivateLinkServicesByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/locations/{location}/autoApprovedPrivateLinkServices")
        Observable<Response<ResponseBody>> listAutoApprovedPrivateLinkServicesByResourceGroup(@Path("location") String location, @Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices listPrivateEndpointConnectionsNext" })
        @GET
        Observable<Response<ResponseBody>> listPrivateEndpointConnectionsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices listAutoApprovedPrivateLinkServicesNext" })
        @GET
        Observable<Response<ResponseBody>> listAutoApprovedPrivateLinkServicesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices listAutoApprovedPrivateLinkServicesByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listAutoApprovedPrivateLinkServicesByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Deletes the specified private link service.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String serviceName) {
        deleteWithServiceResponseAsync(resourceGroupName, serviceName).toBlocking().last().body();
    }

    /**
     * Deletes the specified private link service.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serviceName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, serviceName), serviceCallback);
    }

    /**
     * Deletes the specified private link service.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String serviceName) {
        return deleteWithServiceResponseAsync(resourceGroupName, serviceName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified private link service.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serviceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Parameter serviceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, serviceName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes the specified private link service.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String serviceName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, serviceName).toBlocking().single().body();
    }

    /**
     * Deletes the specified private link service.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String serviceName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, serviceName), serviceCallback);
    }

    /**
     * Deletes the specified private link service.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String serviceName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, serviceName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified private link service.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String serviceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Parameter serviceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.beginDelete(resourceGroupName, serviceName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Gets the specified private link service by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PrivateLinkServiceInner object if successful.
     */
    public PrivateLinkServiceInner getByResourceGroup(String resourceGroupName, String serviceName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceName).toBlocking().single().body();
    }

    /**
     * Gets the specified private link service by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PrivateLinkServiceInner> getByResourceGroupAsync(String resourceGroupName, String serviceName, final ServiceCallback<PrivateLinkServiceInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceName), serviceCallback);
    }

    /**
     * Gets the specified private link service by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateLinkServiceInner object
     */
    public Observable<PrivateLinkServiceInner> getByResourceGroupAsync(String resourceGroupName, String serviceName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceName).map(new Func1<ServiceResponse<PrivateLinkServiceInner>, PrivateLinkServiceInner>() {
            @Override
            public PrivateLinkServiceInner call(ServiceResponse<PrivateLinkServiceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the specified private link service by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateLinkServiceInner object
     */
    public Observable<ServiceResponse<PrivateLinkServiceInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String serviceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Parameter serviceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        final String expand = null;
        return service.getByResourceGroup(resourceGroupName, serviceName, this.client.subscriptionId(), apiVersion, expand, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateLinkServiceInner>>>() {
                @Override
                public Observable<ServiceResponse<PrivateLinkServiceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PrivateLinkServiceInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets the specified private link service by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param expand Expands referenced resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PrivateLinkServiceInner object if successful.
     */
    public PrivateLinkServiceInner getByResourceGroup(String resourceGroupName, String serviceName, String expand) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceName, expand).toBlocking().single().body();
    }

    /**
     * Gets the specified private link service by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param expand Expands referenced resources.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PrivateLinkServiceInner> getByResourceGroupAsync(String resourceGroupName, String serviceName, String expand, final ServiceCallback<PrivateLinkServiceInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceName, expand), serviceCallback);
    }

    /**
     * Gets the specified private link service by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param expand Expands referenced resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateLinkServiceInner object
     */
    public Observable<PrivateLinkServiceInner> getByResourceGroupAsync(String resourceGroupName, String serviceName, String expand) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceName, expand).map(new Func1<ServiceResponse<PrivateLinkServiceInner>, PrivateLinkServiceInner>() {
            @Override
            public PrivateLinkServiceInner call(ServiceResponse<PrivateLinkServiceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the specified private link service by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param expand Expands referenced resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateLinkServiceInner object
     */
    public Observable<ServiceResponse<PrivateLinkServiceInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String serviceName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Parameter serviceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.getByResourceGroup(resourceGroupName, serviceName, this.client.subscriptionId(), apiVersion, expand, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateLinkServiceInner>>>() {
                @Override
                public Observable<ServiceResponse<PrivateLinkServiceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PrivateLinkServiceInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PrivateLinkServiceInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PrivateLinkServiceInner, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PrivateLinkServiceInner>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Creates or updates an private link service in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param parameters Parameters supplied to the create or update private link service operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PrivateLinkServiceInner object if successful.
     */
    public PrivateLinkServiceInner createOrUpdate(String resourceGroupName, String serviceName, PrivateLinkServiceInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, serviceName, parameters).toBlocking().last().body();
    }

    /**
     * Creates or updates an private link service in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param parameters Parameters supplied to the create or update private link service operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PrivateLinkServiceInner> createOrUpdateAsync(String resourceGroupName, String serviceName, PrivateLinkServiceInner parameters, final ServiceCallback<PrivateLinkServiceInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, serviceName, parameters), serviceCallback);
    }

    /**
     * Creates or updates an private link service in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param parameters Parameters supplied to the create or update private link service operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<PrivateLinkServiceInner> createOrUpdateAsync(String resourceGroupName, String serviceName, PrivateLinkServiceInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, serviceName, parameters).map(new Func1<ServiceResponse<PrivateLinkServiceInner>, PrivateLinkServiceInner>() {
            @Override
            public PrivateLinkServiceInner call(ServiceResponse<PrivateLinkServiceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates an private link service in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param parameters Parameters supplied to the create or update private link service operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<PrivateLinkServiceInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serviceName, PrivateLinkServiceInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Parameter serviceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, serviceName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<PrivateLinkServiceInner>() { }.getType());
    }

    /**
     * Creates or updates an private link service in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param parameters Parameters supplied to the create or update private link service operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PrivateLinkServiceInner object if successful.
     */
    public PrivateLinkServiceInner beginCreateOrUpdate(String resourceGroupName, String serviceName, PrivateLinkServiceInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serviceName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates an private link service in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param parameters Parameters supplied to the create or update private link service operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PrivateLinkServiceInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, PrivateLinkServiceInner parameters, final ServiceCallback<PrivateLinkServiceInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serviceName, parameters), serviceCallback);
    }

    /**
     * Creates or updates an private link service in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param parameters Parameters supplied to the create or update private link service operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateLinkServiceInner object
     */
    public Observable<PrivateLinkServiceInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, PrivateLinkServiceInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serviceName, parameters).map(new Func1<ServiceResponse<PrivateLinkServiceInner>, PrivateLinkServiceInner>() {
            @Override
            public PrivateLinkServiceInner call(ServiceResponse<PrivateLinkServiceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates an private link service in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param parameters Parameters supplied to the create or update private link service operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateLinkServiceInner object
     */
    public Observable<ServiceResponse<PrivateLinkServiceInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serviceName, PrivateLinkServiceInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Parameter serviceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-11-01";
        return service.beginCreateOrUpdate(resourceGroupName, serviceName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateLinkServiceInner>>>() {
                @Override
                public Observable<ServiceResponse<PrivateLinkServiceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PrivateLinkServiceInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PrivateLinkServiceInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PrivateLinkServiceInner, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PrivateLinkServiceInner>() { }.getType())
                .register(201, new TypeToken<PrivateLinkServiceInner>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Gets all private link services in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PrivateLinkServiceInner&gt; object if successful.
     */
    public PagedList<PrivateLinkServiceInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<PrivateLinkServiceInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<PrivateLinkServiceInner>(response.body()) {
            @Override
            public Page<PrivateLinkServiceInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all private link services in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PrivateLinkServiceInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<PrivateLinkServiceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<PrivateLinkServiceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all private link services in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateLinkServiceInner&gt; object
     */
    public Observable<Page<PrivateLinkServiceInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<PrivateLinkServiceInner>>, Page<PrivateLinkServiceInner>>() {
                @Override
                public Page<PrivateLinkServiceInner> call(ServiceResponse<Page<PrivateLinkServiceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all private link services in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateLinkServiceInner&gt; object
     */
    public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<PrivateLinkServiceInner>>, Observable<ServiceResponse<Page<PrivateLinkServiceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> call(ServiceResponse<Page<PrivateLinkServiceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all private link services in a resource group.
     *
    ServiceResponse<PageImpl<PrivateLinkServiceInner>> * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PrivateLinkServiceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateLinkServiceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PrivateLinkServiceInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PrivateLinkServiceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PrivateLinkServiceInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<PrivateLinkServiceInner>, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<PrivateLinkServiceInner>>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Gets all private link service in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PrivateLinkServiceInner&gt; object if successful.
     */
    public PagedList<PrivateLinkServiceInner> list() {
        ServiceResponse<Page<PrivateLinkServiceInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<PrivateLinkServiceInner>(response.body()) {
            @Override
            public Page<PrivateLinkServiceInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all private link service in a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PrivateLinkServiceInner>> listAsync(final ListOperationCallback<PrivateLinkServiceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<PrivateLinkServiceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all private link service in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateLinkServiceInner&gt; object
     */
    public Observable<Page<PrivateLinkServiceInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<PrivateLinkServiceInner>>, Page<PrivateLinkServiceInner>>() {
                @Override
                public Page<PrivateLinkServiceInner> call(ServiceResponse<Page<PrivateLinkServiceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all private link service in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateLinkServiceInner&gt; object
     */
    public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<PrivateLinkServiceInner>>, Observable<ServiceResponse<Page<PrivateLinkServiceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> call(ServiceResponse<Page<PrivateLinkServiceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all private link service in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PrivateLinkServiceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateLinkServiceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PrivateLinkServiceInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PrivateLinkServiceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PrivateLinkServiceInner>> listDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<PrivateLinkServiceInner>, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<PrivateLinkServiceInner>>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Get the specific private end point connection by specific private link service in the resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param peConnectionName The name of the private end point connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PrivateEndpointConnectionInner object if successful.
     */
    public PrivateEndpointConnectionInner getPrivateEndpointConnection(String resourceGroupName, String serviceName, String peConnectionName) {
        return getPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName).toBlocking().single().body();
    }

    /**
     * Get the specific private end point connection by specific private link service in the resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param peConnectionName The name of the private end point connection.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PrivateEndpointConnectionInner> getPrivateEndpointConnectionAsync(String resourceGroupName, String serviceName, String peConnectionName, final ServiceCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(getPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName), serviceCallback);
    }

    /**
     * Get the specific private end point connection by specific private link service in the resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param peConnectionName The name of the private end point connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateEndpointConnectionInner object
     */
    public Observable<PrivateEndpointConnectionInner> getPrivateEndpointConnectionAsync(String resourceGroupName, String serviceName, String peConnectionName) {
        return getPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName).map(new Func1<ServiceResponse<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner>() {
            @Override
            public PrivateEndpointConnectionInner call(ServiceResponse<PrivateEndpointConnectionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get the specific private end point connection by specific private link service in the resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param peConnectionName The name of the private end point connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateEndpointConnectionInner object
     */
    public Observable<ServiceResponse<PrivateEndpointConnectionInner>> getPrivateEndpointConnectionWithServiceResponseAsync(String resourceGroupName, String serviceName, String peConnectionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Parameter serviceName is required and cannot be null.");
        }
        if (peConnectionName == null) {
            throw new IllegalArgumentException("Parameter peConnectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        final String expand = null;
        return service.getPrivateEndpointConnection(resourceGroupName, serviceName, peConnectionName, this.client.subscriptionId(), apiVersion, expand, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateEndpointConnectionInner>>>() {
                @Override
                public Observable<ServiceResponse<PrivateEndpointConnectionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PrivateEndpointConnectionInner> clientResponse = getPrivateEndpointConnectionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Get the specific private end point connection by specific private link service in the resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param peConnectionName The name of the private end point connection.
     * @param expand Expands referenced resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PrivateEndpointConnectionInner object if successful.
     */
    public PrivateEndpointConnectionInner getPrivateEndpointConnection(String resourceGroupName, String serviceName, String peConnectionName, String expand) {
        return getPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName, expand).toBlocking().single().body();
    }

    /**
     * Get the specific private end point connection by specific private link service in the resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param peConnectionName The name of the private end point connection.
     * @param expand Expands referenced resources.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PrivateEndpointConnectionInner> getPrivateEndpointConnectionAsync(String resourceGroupName, String serviceName, String peConnectionName, String expand, final ServiceCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(getPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName, expand), serviceCallback);
    }

    /**
     * Get the specific private end point connection by specific private link service in the resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param peConnectionName The name of the private end point connection.
     * @param expand Expands referenced resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateEndpointConnectionInner object
     */
    public Observable<PrivateEndpointConnectionInner> getPrivateEndpointConnectionAsync(String resourceGroupName, String serviceName, String peConnectionName, String expand) {
        return getPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName, expand).map(new Func1<ServiceResponse<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner>() {
            @Override
            public PrivateEndpointConnectionInner call(ServiceResponse<PrivateEndpointConnectionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get the specific private end point connection by specific private link service in the resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param peConnectionName The name of the private end point connection.
     * @param expand Expands referenced resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateEndpointConnectionInner object
     */
    public Observable<ServiceResponse<PrivateEndpointConnectionInner>> getPrivateEndpointConnectionWithServiceResponseAsync(String resourceGroupName, String serviceName, String peConnectionName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Parameter serviceName is required and cannot be null.");
        }
        if (peConnectionName == null) {
            throw new IllegalArgumentException("Parameter peConnectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.getPrivateEndpointConnection(resourceGroupName, serviceName, peConnectionName, this.client.subscriptionId(), apiVersion, expand, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateEndpointConnectionInner>>>() {
                @Override
                public Observable<ServiceResponse<PrivateEndpointConnectionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PrivateEndpointConnectionInner> clientResponse = getPrivateEndpointConnectionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PrivateEndpointConnectionInner> getPrivateEndpointConnectionDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PrivateEndpointConnectionInner, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PrivateEndpointConnectionInner>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Approve or reject private end point connection for a private link service in a subscription.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param peConnectionName The name of the private end point connection.
     * @param parameters Parameters supplied to approve or reject the private end point connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PrivateEndpointConnectionInner object if successful.
     */
    public PrivateEndpointConnectionInner updatePrivateEndpointConnection(String resourceGroupName, String serviceName, String peConnectionName, PrivateEndpointConnectionInner parameters) {
        return updatePrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName, parameters).toBlocking().single().body();
    }

    /**
     * Approve or reject private end point connection for a private link service in a subscription.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param peConnectionName The name of the private end point connection.
     * @param parameters Parameters supplied to approve or reject the private end point connection.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PrivateEndpointConnectionInner> updatePrivateEndpointConnectionAsync(String resourceGroupName, String serviceName, String peConnectionName, PrivateEndpointConnectionInner parameters, final ServiceCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(updatePrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName, parameters), serviceCallback);
    }

    /**
     * Approve or reject private end point connection for a private link service in a subscription.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param peConnectionName The name of the private end point connection.
     * @param parameters Parameters supplied to approve or reject the private end point connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateEndpointConnectionInner object
     */
    public Observable<PrivateEndpointConnectionInner> updatePrivateEndpointConnectionAsync(String resourceGroupName, String serviceName, String peConnectionName, PrivateEndpointConnectionInner parameters) {
        return updatePrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName, parameters).map(new Func1<ServiceResponse<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner>() {
            @Override
            public PrivateEndpointConnectionInner call(ServiceResponse<PrivateEndpointConnectionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Approve or reject private end point connection for a private link service in a subscription.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param peConnectionName The name of the private end point connection.
     * @param parameters Parameters supplied to approve or reject the private end point connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateEndpointConnectionInner object
     */
    public Observable<ServiceResponse<PrivateEndpointConnectionInner>> updatePrivateEndpointConnectionWithServiceResponseAsync(String resourceGroupName, String serviceName, String peConnectionName, PrivateEndpointConnectionInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Parameter serviceName is required and cannot be null.");
        }
        if (peConnectionName == null) {
            throw new IllegalArgumentException("Parameter peConnectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-11-01";
        return service.updatePrivateEndpointConnection(resourceGroupName, serviceName, peConnectionName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateEndpointConnectionInner>>>() {
                @Override
                public Observable<ServiceResponse<PrivateEndpointConnectionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PrivateEndpointConnectionInner> clientResponse = updatePrivateEndpointConnectionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PrivateEndpointConnectionInner> updatePrivateEndpointConnectionDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PrivateEndpointConnectionInner, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PrivateEndpointConnectionInner>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Delete private end point connection for a private link service in a subscription.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param peConnectionName The name of the private end point connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deletePrivateEndpointConnection(String resourceGroupName, String serviceName, String peConnectionName) {
        deletePrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName).toBlocking().last().body();
    }

    /**
     * Delete private end point connection for a private link service in a subscription.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param peConnectionName The name of the private end point connection.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deletePrivateEndpointConnectionAsync(String resourceGroupName, String serviceName, String peConnectionName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deletePrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName), serviceCallback);
    }

    /**
     * Delete private end point connection for a private link service in a subscription.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param peConnectionName The name of the private end point connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deletePrivateEndpointConnectionAsync(String resourceGroupName, String serviceName, String peConnectionName) {
        return deletePrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete private end point connection for a private link service in a subscription.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param peConnectionName The name of the private end point connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deletePrivateEndpointConnectionWithServiceResponseAsync(String resourceGroupName, String serviceName, String peConnectionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Parameter serviceName is required and cannot be null.");
        }
        if (peConnectionName == null) {
            throw new IllegalArgumentException("Parameter peConnectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.deletePrivateEndpointConnection(resourceGroupName, serviceName, peConnectionName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Delete private end point connection for a private link service in a subscription.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param peConnectionName The name of the private end point connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDeletePrivateEndpointConnection(String resourceGroupName, String serviceName, String peConnectionName) {
        beginDeletePrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName).toBlocking().single().body();
    }

    /**
     * Delete private end point connection for a private link service in a subscription.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param peConnectionName The name of the private end point connection.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeletePrivateEndpointConnectionAsync(String resourceGroupName, String serviceName, String peConnectionName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeletePrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName), serviceCallback);
    }

    /**
     * Delete private end point connection for a private link service in a subscription.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param peConnectionName The name of the private end point connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeletePrivateEndpointConnectionAsync(String resourceGroupName, String serviceName, String peConnectionName) {
        return beginDeletePrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete private end point connection for a private link service in a subscription.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param peConnectionName The name of the private end point connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeletePrivateEndpointConnectionWithServiceResponseAsync(String resourceGroupName, String serviceName, String peConnectionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Parameter serviceName is required and cannot be null.");
        }
        if (peConnectionName == null) {
            throw new IllegalArgumentException("Parameter peConnectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.beginDeletePrivateEndpointConnection(resourceGroupName, serviceName, peConnectionName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeletePrivateEndpointConnectionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeletePrivateEndpointConnectionDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Gets all private end point connections for a specific private link service.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PrivateEndpointConnectionInner&gt; object if successful.
     */
    public PagedList<PrivateEndpointConnectionInner> listPrivateEndpointConnections(final String resourceGroupName, final String serviceName) {
        ServiceResponse<Page<PrivateEndpointConnectionInner>> response = listPrivateEndpointConnectionsSinglePageAsync(resourceGroupName, serviceName).toBlocking().single();
        return new PagedList<PrivateEndpointConnectionInner>(response.body()) {
            @Override
            public Page<PrivateEndpointConnectionInner> nextPage(String nextPageLink) {
                return listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all private end point connections for a specific private link service.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsAsync(final String resourceGroupName, final String serviceName, final ListOperationCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listPrivateEndpointConnectionsSinglePageAsync(resourceGroupName, serviceName),
            new Func1<String, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(String nextPageLink) {
                    return listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all private end point connections for a specific private link service.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateEndpointConnectionInner&gt; object
     */
    public Observable<Page<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsAsync(final String resourceGroupName, final String serviceName) {
        return listPrivateEndpointConnectionsWithServiceResponseAsync(resourceGroupName, serviceName)
            .map(new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Page<PrivateEndpointConnectionInner>>() {
                @Override
                public Page<PrivateEndpointConnectionInner> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all private end point connections for a specific private link service.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceName The name of the private link service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateEndpointConnectionInner&gt; object
     */
    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listPrivateEndpointConnectionsWithServiceResponseAsync(final String resourceGroupName, final String serviceName) {
        return listPrivateEndpointConnectionsSinglePageAsync(resourceGroupName, serviceName)
            .concatMap(new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listPrivateEndpointConnectionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all private end point connections for a specific private link service.
     *
    ServiceResponse<PageImpl<PrivateEndpointConnectionInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl<PrivateEndpointConnectionInner>> * @param serviceName The name of the private link service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PrivateEndpointConnectionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listPrivateEndpointConnectionsSinglePageAsync(final String resourceGroupName, final String serviceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Parameter serviceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.listPrivateEndpointConnections(resourceGroupName, serviceName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PrivateEndpointConnectionInner>> result = listPrivateEndpointConnectionsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PrivateEndpointConnectionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<PrivateEndpointConnectionInner>, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<PrivateEndpointConnectionInner>>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Checks whether the subscription is visible to private link service.
     *
     * @param location The location of the domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PrivateLinkServiceVisibilityInner object if successful.
     */
    public PrivateLinkServiceVisibilityInner checkPrivateLinkServiceVisibility(String location) {
        return checkPrivateLinkServiceVisibilityWithServiceResponseAsync(location).toBlocking().single().body();
    }

    /**
     * Checks whether the subscription is visible to private link service.
     *
     * @param location The location of the domain name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PrivateLinkServiceVisibilityInner> checkPrivateLinkServiceVisibilityAsync(String location, final ServiceCallback<PrivateLinkServiceVisibilityInner> serviceCallback) {
        return ServiceFuture.fromResponse(checkPrivateLinkServiceVisibilityWithServiceResponseAsync(location), serviceCallback);
    }

    /**
     * Checks whether the subscription is visible to private link service.
     *
     * @param location The location of the domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateLinkServiceVisibilityInner object
     */
    public Observable<PrivateLinkServiceVisibilityInner> checkPrivateLinkServiceVisibilityAsync(String location) {
        return checkPrivateLinkServiceVisibilityWithServiceResponseAsync(location).map(new Func1<ServiceResponse<PrivateLinkServiceVisibilityInner>, PrivateLinkServiceVisibilityInner>() {
            @Override
            public PrivateLinkServiceVisibilityInner call(ServiceResponse<PrivateLinkServiceVisibilityInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Checks whether the subscription is visible to private link service.
     *
     * @param location The location of the domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateLinkServiceVisibilityInner object
     */
    public Observable<ServiceResponse<PrivateLinkServiceVisibilityInner>> checkPrivateLinkServiceVisibilityWithServiceResponseAsync(String location) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        final String privateLinkServiceAlias = null;
        CheckPrivateLinkServiceVisibilityRequest parameters = new CheckPrivateLinkServiceVisibilityRequest();
        parameters.withPrivateLinkServiceAlias(null);
        return service.checkPrivateLinkServiceVisibility(location, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateLinkServiceVisibilityInner>>>() {
                @Override
                public Observable<ServiceResponse<PrivateLinkServiceVisibilityInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PrivateLinkServiceVisibilityInner> clientResponse = checkPrivateLinkServiceVisibilityDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Checks whether the subscription is visible to private link service.
     *
     * @param location The location of the domain name.
     * @param privateLinkServiceAlias The alias of the private link service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PrivateLinkServiceVisibilityInner object if successful.
     */
    public PrivateLinkServiceVisibilityInner checkPrivateLinkServiceVisibility(String location, String privateLinkServiceAlias) {
        return checkPrivateLinkServiceVisibilityWithServiceResponseAsync(location, privateLinkServiceAlias).toBlocking().single().body();
    }

    /**
     * Checks whether the subscription is visible to private link service.
     *
     * @param location The location of the domain name.
     * @param privateLinkServiceAlias The alias of the private link service.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PrivateLinkServiceVisibilityInner> checkPrivateLinkServiceVisibilityAsync(String location, String privateLinkServiceAlias, final ServiceCallback<PrivateLinkServiceVisibilityInner> serviceCallback) {
        return ServiceFuture.fromResponse(checkPrivateLinkServiceVisibilityWithServiceResponseAsync(location, privateLinkServiceAlias), serviceCallback);
    }

    /**
     * Checks whether the subscription is visible to private link service.
     *
     * @param location The location of the domain name.
     * @param privateLinkServiceAlias The alias of the private link service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateLinkServiceVisibilityInner object
     */
    public Observable<PrivateLinkServiceVisibilityInner> checkPrivateLinkServiceVisibilityAsync(String location, String privateLinkServiceAlias) {
        return checkPrivateLinkServiceVisibilityWithServiceResponseAsync(location, privateLinkServiceAlias).map(new Func1<ServiceResponse<PrivateLinkServiceVisibilityInner>, PrivateLinkServiceVisibilityInner>() {
            @Override
            public PrivateLinkServiceVisibilityInner call(ServiceResponse<PrivateLinkServiceVisibilityInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Checks whether the subscription is visible to private link service.
     *
     * @param location The location of the domain name.
     * @param privateLinkServiceAlias The alias of the private link service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateLinkServiceVisibilityInner object
     */
    public Observable<ServiceResponse<PrivateLinkServiceVisibilityInner>> checkPrivateLinkServiceVisibilityWithServiceResponseAsync(String location, String privateLinkServiceAlias) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        CheckPrivateLinkServiceVisibilityRequest parameters = new CheckPrivateLinkServiceVisibilityRequest();
        parameters.withPrivateLinkServiceAlias(privateLinkServiceAlias);
        return service.checkPrivateLinkServiceVisibility(location, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateLinkServiceVisibilityInner>>>() {
                @Override
                public Observable<ServiceResponse<PrivateLinkServiceVisibilityInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PrivateLinkServiceVisibilityInner> clientResponse = checkPrivateLinkServiceVisibilityDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PrivateLinkServiceVisibilityInner> checkPrivateLinkServiceVisibilityDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PrivateLinkServiceVisibilityInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PrivateLinkServiceVisibilityInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Checks whether the subscription is visible to private link service in the specified resource group.
     *
     * @param location The location of the domain name.
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PrivateLinkServiceVisibilityInner object if successful.
     */
    public PrivateLinkServiceVisibilityInner checkPrivateLinkServiceVisibilityByResourceGroup(String location, String resourceGroupName) {
        return checkPrivateLinkServiceVisibilityByResourceGroupWithServiceResponseAsync(location, resourceGroupName).toBlocking().single().body();
    }

    /**
     * Checks whether the subscription is visible to private link service in the specified resource group.
     *
     * @param location The location of the domain name.
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PrivateLinkServiceVisibilityInner> checkPrivateLinkServiceVisibilityByResourceGroupAsync(String location, String resourceGroupName, final ServiceCallback<PrivateLinkServiceVisibilityInner> serviceCallback) {
        return ServiceFuture.fromResponse(checkPrivateLinkServiceVisibilityByResourceGroupWithServiceResponseAsync(location, resourceGroupName), serviceCallback);
    }

    /**
     * Checks whether the subscription is visible to private link service in the specified resource group.
     *
     * @param location The location of the domain name.
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateLinkServiceVisibilityInner object
     */
    public Observable<PrivateLinkServiceVisibilityInner> checkPrivateLinkServiceVisibilityByResourceGroupAsync(String location, String resourceGroupName) {
        return checkPrivateLinkServiceVisibilityByResourceGroupWithServiceResponseAsync(location, resourceGroupName).map(new Func1<ServiceResponse<PrivateLinkServiceVisibilityInner>, PrivateLinkServiceVisibilityInner>() {
            @Override
            public PrivateLinkServiceVisibilityInner call(ServiceResponse<PrivateLinkServiceVisibilityInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Checks whether the subscription is visible to private link service in the specified resource group.
     *
     * @param location The location of the domain name.
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateLinkServiceVisibilityInner object
     */
    public Observable<ServiceResponse<PrivateLinkServiceVisibilityInner>> checkPrivateLinkServiceVisibilityByResourceGroupWithServiceResponseAsync(String location, String resourceGroupName) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        final String privateLinkServiceAlias = null;
        CheckPrivateLinkServiceVisibilityRequest parameters = new CheckPrivateLinkServiceVisibilityRequest();
        parameters.withPrivateLinkServiceAlias(null);
        return service.checkPrivateLinkServiceVisibilityByResourceGroup(location, resourceGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateLinkServiceVisibilityInner>>>() {
                @Override
                public Observable<ServiceResponse<PrivateLinkServiceVisibilityInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PrivateLinkServiceVisibilityInner> clientResponse = checkPrivateLinkServiceVisibilityByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Checks whether the subscription is visible to private link service in the specified resource group.
     *
     * @param location The location of the domain name.
     * @param resourceGroupName The name of the resource group.
     * @param privateLinkServiceAlias The alias of the private link service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PrivateLinkServiceVisibilityInner object if successful.
     */
    public PrivateLinkServiceVisibilityInner checkPrivateLinkServiceVisibilityByResourceGroup(String location, String resourceGroupName, String privateLinkServiceAlias) {
        return checkPrivateLinkServiceVisibilityByResourceGroupWithServiceResponseAsync(location, resourceGroupName, privateLinkServiceAlias).toBlocking().single().body();
    }

    /**
     * Checks whether the subscription is visible to private link service in the specified resource group.
     *
     * @param location The location of the domain name.
     * @param resourceGroupName The name of the resource group.
     * @param privateLinkServiceAlias The alias of the private link service.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PrivateLinkServiceVisibilityInner> checkPrivateLinkServiceVisibilityByResourceGroupAsync(String location, String resourceGroupName, String privateLinkServiceAlias, final ServiceCallback<PrivateLinkServiceVisibilityInner> serviceCallback) {
        return ServiceFuture.fromResponse(checkPrivateLinkServiceVisibilityByResourceGroupWithServiceResponseAsync(location, resourceGroupName, privateLinkServiceAlias), serviceCallback);
    }

    /**
     * Checks whether the subscription is visible to private link service in the specified resource group.
     *
     * @param location The location of the domain name.
     * @param resourceGroupName The name of the resource group.
     * @param privateLinkServiceAlias The alias of the private link service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateLinkServiceVisibilityInner object
     */
    public Observable<PrivateLinkServiceVisibilityInner> checkPrivateLinkServiceVisibilityByResourceGroupAsync(String location, String resourceGroupName, String privateLinkServiceAlias) {
        return checkPrivateLinkServiceVisibilityByResourceGroupWithServiceResponseAsync(location, resourceGroupName, privateLinkServiceAlias).map(new Func1<ServiceResponse<PrivateLinkServiceVisibilityInner>, PrivateLinkServiceVisibilityInner>() {
            @Override
            public PrivateLinkServiceVisibilityInner call(ServiceResponse<PrivateLinkServiceVisibilityInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Checks whether the subscription is visible to private link service in the specified resource group.
     *
     * @param location The location of the domain name.
     * @param resourceGroupName The name of the resource group.
     * @param privateLinkServiceAlias The alias of the private link service.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateLinkServiceVisibilityInner object
     */
    public Observable<ServiceResponse<PrivateLinkServiceVisibilityInner>> checkPrivateLinkServiceVisibilityByResourceGroupWithServiceResponseAsync(String location, String resourceGroupName, String privateLinkServiceAlias) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        CheckPrivateLinkServiceVisibilityRequest parameters = new CheckPrivateLinkServiceVisibilityRequest();
        parameters.withPrivateLinkServiceAlias(privateLinkServiceAlias);
        return service.checkPrivateLinkServiceVisibilityByResourceGroup(location, resourceGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateLinkServiceVisibilityInner>>>() {
                @Override
                public Observable<ServiceResponse<PrivateLinkServiceVisibilityInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PrivateLinkServiceVisibilityInner> clientResponse = checkPrivateLinkServiceVisibilityByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PrivateLinkServiceVisibilityInner> checkPrivateLinkServiceVisibilityByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PrivateLinkServiceVisibilityInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PrivateLinkServiceVisibilityInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Returns all of the private link service ids that can be linked to a Private Endpoint with auto approved in this subscription in this region.
     *
     * @param location The location of the domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AutoApprovedPrivateLinkServiceInner&gt; object if successful.
     */
    public PagedList<AutoApprovedPrivateLinkServiceInner> listAutoApprovedPrivateLinkServices(final String location) {
        ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>> response = listAutoApprovedPrivateLinkServicesSinglePageAsync(location).toBlocking().single();
        return new PagedList<AutoApprovedPrivateLinkServiceInner>(response.body()) {
            @Override
            public Page<AutoApprovedPrivateLinkServiceInner> nextPage(String nextPageLink) {
                return listAutoApprovedPrivateLinkServicesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Returns all of the private link service ids that can be linked to a Private Endpoint with auto approved in this subscription in this region.
     *
     * @param location The location of the domain name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AutoApprovedPrivateLinkServiceInner>> listAutoApprovedPrivateLinkServicesAsync(final String location, final ListOperationCallback<AutoApprovedPrivateLinkServiceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAutoApprovedPrivateLinkServicesSinglePageAsync(location),
            new Func1<String, Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> call(String nextPageLink) {
                    return listAutoApprovedPrivateLinkServicesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Returns all of the private link service ids that can be linked to a Private Endpoint with auto approved in this subscription in this region.
     *
     * @param location The location of the domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AutoApprovedPrivateLinkServiceInner&gt; object
     */
    public Observable<Page<AutoApprovedPrivateLinkServiceInner>> listAutoApprovedPrivateLinkServicesAsync(final String location) {
        return listAutoApprovedPrivateLinkServicesWithServiceResponseAsync(location)
            .map(new Func1<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>, Page<AutoApprovedPrivateLinkServiceInner>>() {
                @Override
                public Page<AutoApprovedPrivateLinkServiceInner> call(ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Returns all of the private link service ids that can be linked to a Private Endpoint with auto approved in this subscription in this region.
     *
     * @param location The location of the domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AutoApprovedPrivateLinkServiceInner&gt; object
     */
    public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> listAutoApprovedPrivateLinkServicesWithServiceResponseAsync(final String location) {
        return listAutoApprovedPrivateLinkServicesSinglePageAsync(location)
            .concatMap(new Func1<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>, Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> call(ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAutoApprovedPrivateLinkServicesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Returns all of the private link service ids that can be linked to a Private Endpoint with auto approved in this subscription in this region.
     *
    ServiceResponse<PageImpl<AutoApprovedPrivateLinkServiceInner>> * @param location The location of the domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AutoApprovedPrivateLinkServiceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> listAutoApprovedPrivateLinkServicesSinglePageAsync(final String location) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.listAutoApprovedPrivateLinkServices(location, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AutoApprovedPrivateLinkServiceInner>> result = listAutoApprovedPrivateLinkServicesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AutoApprovedPrivateLinkServiceInner>> listAutoApprovedPrivateLinkServicesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AutoApprovedPrivateLinkServiceInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AutoApprovedPrivateLinkServiceInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Returns all of the private link service ids that can be linked to a Private Endpoint with auto approved in this subscription in this region.
     *
     * @param location The location of the domain name.
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AutoApprovedPrivateLinkServiceInner&gt; object if successful.
     */
    public PagedList<AutoApprovedPrivateLinkServiceInner> listAutoApprovedPrivateLinkServicesByResourceGroup(final String location, final String resourceGroupName) {
        ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>> response = listAutoApprovedPrivateLinkServicesByResourceGroupSinglePageAsync(location, resourceGroupName).toBlocking().single();
        return new PagedList<AutoApprovedPrivateLinkServiceInner>(response.body()) {
            @Override
            public Page<AutoApprovedPrivateLinkServiceInner> nextPage(String nextPageLink) {
                return listAutoApprovedPrivateLinkServicesByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Returns all of the private link service ids that can be linked to a Private Endpoint with auto approved in this subscription in this region.
     *
     * @param location The location of the domain name.
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AutoApprovedPrivateLinkServiceInner>> listAutoApprovedPrivateLinkServicesByResourceGroupAsync(final String location, final String resourceGroupName, final ListOperationCallback<AutoApprovedPrivateLinkServiceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAutoApprovedPrivateLinkServicesByResourceGroupSinglePageAsync(location, resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> call(String nextPageLink) {
                    return listAutoApprovedPrivateLinkServicesByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Returns all of the private link service ids that can be linked to a Private Endpoint with auto approved in this subscription in this region.
     *
     * @param location The location of the domain name.
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AutoApprovedPrivateLinkServiceInner&gt; object
     */
    public Observable<Page<AutoApprovedPrivateLinkServiceInner>> listAutoApprovedPrivateLinkServicesByResourceGroupAsync(final String location, final String resourceGroupName) {
        return listAutoApprovedPrivateLinkServicesByResourceGroupWithServiceResponseAsync(location, resourceGroupName)
            .map(new Func1<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>, Page<AutoApprovedPrivateLinkServiceInner>>() {
                @Override
                public Page<AutoApprovedPrivateLinkServiceInner> call(ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Returns all of the private link service ids that can be linked to a Private Endpoint with auto approved in this subscription in this region.
     *
     * @param location The location of the domain name.
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AutoApprovedPrivateLinkServiceInner&gt; object
     */
    public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> listAutoApprovedPrivateLinkServicesByResourceGroupWithServiceResponseAsync(final String location, final String resourceGroupName) {
        return listAutoApprovedPrivateLinkServicesByResourceGroupSinglePageAsync(location, resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>, Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> call(ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAutoApprovedPrivateLinkServicesByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Returns all of the private link service ids that can be linked to a Private Endpoint with auto approved in this subscription in this region.
     *
    ServiceResponse<PageImpl<AutoApprovedPrivateLinkServiceInner>> * @param location The location of the domain name.
    ServiceResponse<PageImpl<AutoApprovedPrivateLinkServiceInner>> * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AutoApprovedPrivateLinkServiceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> listAutoApprovedPrivateLinkServicesByResourceGroupSinglePageAsync(final String location, final String resourceGroupName) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.listAutoApprovedPrivateLinkServicesByResourceGroup(location, resourceGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AutoApprovedPrivateLinkServiceInner>> result = listAutoApprovedPrivateLinkServicesByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AutoApprovedPrivateLinkServiceInner>> listAutoApprovedPrivateLinkServicesByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AutoApprovedPrivateLinkServiceInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AutoApprovedPrivateLinkServiceInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all private link services in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PrivateLinkServiceInner&gt; object if successful.
     */
    public PagedList<PrivateLinkServiceInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<PrivateLinkServiceInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PrivateLinkServiceInner>(response.body()) {
            @Override
            public Page<PrivateLinkServiceInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all private link services in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PrivateLinkServiceInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<PrivateLinkServiceInner>> serviceFuture, final ListOperationCallback<PrivateLinkServiceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<PrivateLinkServiceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all private link services in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateLinkServiceInner&gt; object
     */
    public Observable<Page<PrivateLinkServiceInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<PrivateLinkServiceInner>>, Page<PrivateLinkServiceInner>>() {
                @Override
                public Page<PrivateLinkServiceInner> call(ServiceResponse<Page<PrivateLinkServiceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all private link services in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateLinkServiceInner&gt; object
     */
    public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<PrivateLinkServiceInner>>, Observable<ServiceResponse<Page<PrivateLinkServiceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> call(ServiceResponse<Page<PrivateLinkServiceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all private link services in a resource group.
     *
    ServiceResponse<PageImpl<PrivateLinkServiceInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PrivateLinkServiceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateLinkServiceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PrivateLinkServiceInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PrivateLinkServiceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PrivateLinkServiceInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<PrivateLinkServiceInner>, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<PrivateLinkServiceInner>>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Gets all private link service in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PrivateLinkServiceInner&gt; object if successful.
     */
    public PagedList<PrivateLinkServiceInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<PrivateLinkServiceInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PrivateLinkServiceInner>(response.body()) {
            @Override
            public Page<PrivateLinkServiceInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all private link service in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PrivateLinkServiceInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<PrivateLinkServiceInner>> serviceFuture, final ListOperationCallback<PrivateLinkServiceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<PrivateLinkServiceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all private link service in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateLinkServiceInner&gt; object
     */
    public Observable<Page<PrivateLinkServiceInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<PrivateLinkServiceInner>>, Page<PrivateLinkServiceInner>>() {
                @Override
                public Page<PrivateLinkServiceInner> call(ServiceResponse<Page<PrivateLinkServiceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all private link service in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateLinkServiceInner&gt; object
     */
    public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<PrivateLinkServiceInner>>, Observable<ServiceResponse<Page<PrivateLinkServiceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> call(ServiceResponse<Page<PrivateLinkServiceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all private link service in a subscription.
     *
    ServiceResponse<PageImpl<PrivateLinkServiceInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PrivateLinkServiceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateLinkServiceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PrivateLinkServiceInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PrivateLinkServiceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PrivateLinkServiceInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<PrivateLinkServiceInner>, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<PrivateLinkServiceInner>>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Gets all private end point connections for a specific private link service.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PrivateEndpointConnectionInner&gt; object if successful.
     */
    public PagedList<PrivateEndpointConnectionInner> listPrivateEndpointConnectionsNext(final String nextPageLink) {
        ServiceResponse<Page<PrivateEndpointConnectionInner>> response = listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PrivateEndpointConnectionInner>(response.body()) {
            @Override
            public Page<PrivateEndpointConnectionInner> nextPage(String nextPageLink) {
                return listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all private end point connections for a specific private link service.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsNextAsync(final String nextPageLink, final ServiceFuture<List<PrivateEndpointConnectionInner>> serviceFuture, final ListOperationCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(String nextPageLink) {
                    return listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all private end point connections for a specific private link service.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateEndpointConnectionInner&gt; object
     */
    public Observable<Page<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsNextAsync(final String nextPageLink) {
        return listPrivateEndpointConnectionsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Page<PrivateEndpointConnectionInner>>() {
                @Override
                public Page<PrivateEndpointConnectionInner> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all private end point connections for a specific private link service.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateEndpointConnectionInner&gt; object
     */
    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listPrivateEndpointConnectionsNextWithServiceResponseAsync(final String nextPageLink) {
        return listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listPrivateEndpointConnectionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all private end point connections for a specific private link service.
     *
    ServiceResponse<PageImpl<PrivateEndpointConnectionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PrivateEndpointConnectionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listPrivateEndpointConnectionsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listPrivateEndpointConnectionsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PrivateEndpointConnectionInner>> result = listPrivateEndpointConnectionsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PrivateEndpointConnectionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<PrivateEndpointConnectionInner>, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<PrivateEndpointConnectionInner>>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Returns all of the private link service ids that can be linked to a Private Endpoint with auto approved in this subscription in this region.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AutoApprovedPrivateLinkServiceInner&gt; object if successful.
     */
    public PagedList<AutoApprovedPrivateLinkServiceInner> listAutoApprovedPrivateLinkServicesNext(final String nextPageLink) {
        ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>> response = listAutoApprovedPrivateLinkServicesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AutoApprovedPrivateLinkServiceInner>(response.body()) {
            @Override
            public Page<AutoApprovedPrivateLinkServiceInner> nextPage(String nextPageLink) {
                return listAutoApprovedPrivateLinkServicesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Returns all of the private link service ids that can be linked to a Private Endpoint with auto approved in this subscription in this region.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AutoApprovedPrivateLinkServiceInner>> listAutoApprovedPrivateLinkServicesNextAsync(final String nextPageLink, final ServiceFuture<List<AutoApprovedPrivateLinkServiceInner>> serviceFuture, final ListOperationCallback<AutoApprovedPrivateLinkServiceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAutoApprovedPrivateLinkServicesNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> call(String nextPageLink) {
                    return listAutoApprovedPrivateLinkServicesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Returns all of the private link service ids that can be linked to a Private Endpoint with auto approved in this subscription in this region.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AutoApprovedPrivateLinkServiceInner&gt; object
     */
    public Observable<Page<AutoApprovedPrivateLinkServiceInner>> listAutoApprovedPrivateLinkServicesNextAsync(final String nextPageLink) {
        return listAutoApprovedPrivateLinkServicesNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>, Page<AutoApprovedPrivateLinkServiceInner>>() {
                @Override
                public Page<AutoApprovedPrivateLinkServiceInner> call(ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Returns all of the private link service ids that can be linked to a Private Endpoint with auto approved in this subscription in this region.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AutoApprovedPrivateLinkServiceInner&gt; object
     */
    public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> listAutoApprovedPrivateLinkServicesNextWithServiceResponseAsync(final String nextPageLink) {
        return listAutoApprovedPrivateLinkServicesNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>, Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> call(ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAutoApprovedPrivateLinkServicesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Returns all of the private link service ids that can be linked to a Private Endpoint with auto approved in this subscription in this region.
     *
    ServiceResponse<PageImpl<AutoApprovedPrivateLinkServiceInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AutoApprovedPrivateLinkServiceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> listAutoApprovedPrivateLinkServicesNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listAutoApprovedPrivateLinkServicesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AutoApprovedPrivateLinkServiceInner>> result = listAutoApprovedPrivateLinkServicesNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AutoApprovedPrivateLinkServiceInner>> listAutoApprovedPrivateLinkServicesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AutoApprovedPrivateLinkServiceInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AutoApprovedPrivateLinkServiceInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Returns all of the private link service ids that can be linked to a Private Endpoint with auto approved in this subscription in this region.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AutoApprovedPrivateLinkServiceInner&gt; object if successful.
     */
    public PagedList<AutoApprovedPrivateLinkServiceInner> listAutoApprovedPrivateLinkServicesByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>> response = listAutoApprovedPrivateLinkServicesByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AutoApprovedPrivateLinkServiceInner>(response.body()) {
            @Override
            public Page<AutoApprovedPrivateLinkServiceInner> nextPage(String nextPageLink) {
                return listAutoApprovedPrivateLinkServicesByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Returns all of the private link service ids that can be linked to a Private Endpoint with auto approved in this subscription in this region.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AutoApprovedPrivateLinkServiceInner>> listAutoApprovedPrivateLinkServicesByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<AutoApprovedPrivateLinkServiceInner>> serviceFuture, final ListOperationCallback<AutoApprovedPrivateLinkServiceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAutoApprovedPrivateLinkServicesByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> call(String nextPageLink) {
                    return listAutoApprovedPrivateLinkServicesByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Returns all of the private link service ids that can be linked to a Private Endpoint with auto approved in this subscription in this region.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AutoApprovedPrivateLinkServiceInner&gt; object
     */
    public Observable<Page<AutoApprovedPrivateLinkServiceInner>> listAutoApprovedPrivateLinkServicesByResourceGroupNextAsync(final String nextPageLink) {
        return listAutoApprovedPrivateLinkServicesByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>, Page<AutoApprovedPrivateLinkServiceInner>>() {
                @Override
                public Page<AutoApprovedPrivateLinkServiceInner> call(ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Returns all of the private link service ids that can be linked to a Private Endpoint with auto approved in this subscription in this region.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AutoApprovedPrivateLinkServiceInner&gt; object
     */
    public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> listAutoApprovedPrivateLinkServicesByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listAutoApprovedPrivateLinkServicesByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>, Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> call(ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAutoApprovedPrivateLinkServicesByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Returns all of the private link service ids that can be linked to a Private Endpoint with auto approved in this subscription in this region.
     *
    ServiceResponse<PageImpl<AutoApprovedPrivateLinkServiceInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AutoApprovedPrivateLinkServiceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> listAutoApprovedPrivateLinkServicesByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listAutoApprovedPrivateLinkServicesByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AutoApprovedPrivateLinkServiceInner>> result = listAutoApprovedPrivateLinkServicesByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AutoApprovedPrivateLinkServiceInner>> listAutoApprovedPrivateLinkServicesByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AutoApprovedPrivateLinkServiceInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AutoApprovedPrivateLinkServiceInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
