/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in ExpressRouteGateways.
 */
public class ExpressRouteGatewaysInner implements InnerSupportsGet<ExpressRouteGatewayInner>, InnerSupportsDelete<Void>, InnerSupportsListing<ExpressRouteGatewayInner> {
    /** The Retrofit service to perform REST calls. */
    private ExpressRouteGatewaysService service;
    /** The service client containing this operation class. */
    private NetworkManagementClientImpl client;

    /**
     * Initializes an instance of ExpressRouteGatewaysInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ExpressRouteGatewaysInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = retrofit.create(ExpressRouteGatewaysService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for ExpressRouteGateways to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ExpressRouteGatewaysService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteGateways list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Network/expressRouteGateways")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteGateways listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteGateways createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways/{expressRouteGatewayName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("expressRouteGatewayName") String expressRouteGatewayName, @Path("subscriptionId") String subscriptionId, @Body ExpressRouteGatewayInner putExpressRouteGatewayParameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteGateways beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways/{expressRouteGatewayName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("expressRouteGatewayName") String expressRouteGatewayName, @Path("subscriptionId") String subscriptionId, @Body ExpressRouteGatewayInner putExpressRouteGatewayParameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteGateways getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways/{expressRouteGatewayName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("expressRouteGatewayName") String expressRouteGatewayName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteGateways delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways/{expressRouteGatewayName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("expressRouteGatewayName") String expressRouteGatewayName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteGateways beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways/{expressRouteGatewayName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("expressRouteGatewayName") String expressRouteGatewayName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists ExpressRoute gateways under a given subscription.
     *
     * @return the PagedList<ExpressRouteGatewayInner> object if successful.
     */
    public PagedList<ExpressRouteGatewayInner> list() {
        PageImpl1<ExpressRouteGatewayInner> page = new PageImpl1<>();
        page.setItems(listWithServiceResponseAsync().toBlocking().single().body());
        page.setNextPageLink(null);
        return new PagedList<ExpressRouteGatewayInner>(page) {
            @Override
            public Page<ExpressRouteGatewayInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    /**
     * Lists ExpressRoute gateways under a given subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ExpressRouteGatewayInner>> listAsync(final ServiceCallback<List<ExpressRouteGatewayInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listWithServiceResponseAsync(), serviceCallback);
    }

    /**
     * Lists ExpressRoute gateways under a given subscription.
     *
     * @return the observable to the List&lt;ExpressRouteGatewayInner&gt; object
     */
    public Observable<Page<ExpressRouteGatewayInner>> listAsync() {
        return listWithServiceResponseAsync().map(new Func1<ServiceResponse<List<ExpressRouteGatewayInner>>, Page<ExpressRouteGatewayInner>>() {
            @Override
            public Page<ExpressRouteGatewayInner> call(ServiceResponse<List<ExpressRouteGatewayInner>> response) {
                PageImpl1<ExpressRouteGatewayInner> page = new PageImpl1<>();
                page.setItems(response.body());
                return page;
            }
        });
    }

    /**
     * Lists ExpressRoute gateways under a given subscription.
     *
     * @return the observable to the List&lt;ExpressRouteGatewayInner&gt; object
     */
    public Observable<ServiceResponse<List<ExpressRouteGatewayInner>>> listWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ExpressRouteGatewayInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<ExpressRouteGatewayInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<ExpressRouteGatewayInner>> result = listDelegate(response);
                        List<ExpressRouteGatewayInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<ExpressRouteGatewayInner>> clientResponse = new ServiceResponse<List<ExpressRouteGatewayInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<ExpressRouteGatewayInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<ExpressRouteGatewayInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<ExpressRouteGatewayInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists ExpressRoute gateways in a given resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @return the PagedList<ExpressRouteGatewayInner> object if successful.
     */
    public PagedList<ExpressRouteGatewayInner> listByResourceGroup(String resourceGroupName) {
        PageImpl1<ExpressRouteGatewayInner> page = new PageImpl1<>();
        page.setItems(listByResourceGroupWithServiceResponseAsync(resourceGroupName).toBlocking().single().body());
        page.setNextPageLink(null);
        return new PagedList<ExpressRouteGatewayInner>(page) {
            @Override
            public Page<ExpressRouteGatewayInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    /**
     * Lists ExpressRoute gateways in a given resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ExpressRouteGatewayInner>> listByResourceGroupAsync(String resourceGroupName, final ServiceCallback<List<ExpressRouteGatewayInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listByResourceGroupWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    /**
     * Lists ExpressRoute gateways in a given resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @return the observable to the List&lt;ExpressRouteGatewayInner&gt; object
     */
    public Observable<Page<ExpressRouteGatewayInner>> listByResourceGroupAsync(String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName).map(new Func1<ServiceResponse<List<ExpressRouteGatewayInner>>, Page<ExpressRouteGatewayInner>>() {
            @Override
            public Page<ExpressRouteGatewayInner> call(ServiceResponse<List<ExpressRouteGatewayInner>> response) {
                PageImpl1<ExpressRouteGatewayInner> page = new PageImpl1<>();
                page.setItems(response.body());
                return page;
            }
        });
    }

    /**
     * Lists ExpressRoute gateways in a given resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @return the observable to the List&lt;ExpressRouteGatewayInner&gt; object
     */
    public Observable<ServiceResponse<List<ExpressRouteGatewayInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ExpressRouteGatewayInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<ExpressRouteGatewayInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<ExpressRouteGatewayInner>> result = listByResourceGroupDelegate(response);
                        List<ExpressRouteGatewayInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<ExpressRouteGatewayInner>> clientResponse = new ServiceResponse<List<ExpressRouteGatewayInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<ExpressRouteGatewayInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<ExpressRouteGatewayInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<ExpressRouteGatewayInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates a ExpressRoute gateway in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRouteGatewayName The name of the ExpressRoute gateway.
     * @param putExpressRouteGatewayParameters Parameters required in an ExpressRoute gateway PUT operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ExpressRouteGatewayInner object if successful.
     */
    public ExpressRouteGatewayInner createOrUpdate(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, putExpressRouteGatewayParameters).toBlocking().last().body();
    }

    /**
     * Creates or updates a ExpressRoute gateway in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRouteGatewayName The name of the ExpressRoute gateway.
     * @param putExpressRouteGatewayParameters Parameters required in an ExpressRoute gateway PUT operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ExpressRouteGatewayInner> createOrUpdateAsync(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters, final ServiceCallback<ExpressRouteGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, putExpressRouteGatewayParameters), serviceCallback);
    }

    /**
     * Creates or updates a ExpressRoute gateway in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRouteGatewayName The name of the ExpressRoute gateway.
     * @param putExpressRouteGatewayParameters Parameters required in an ExpressRoute gateway PUT operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ExpressRouteGatewayInner> createOrUpdateAsync(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, putExpressRouteGatewayParameters).map(new Func1<ServiceResponse<ExpressRouteGatewayInner>, ExpressRouteGatewayInner>() {
            @Override
            public ExpressRouteGatewayInner call(ServiceResponse<ExpressRouteGatewayInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a ExpressRoute gateway in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRouteGatewayName The name of the ExpressRoute gateway.
     * @param putExpressRouteGatewayParameters Parameters required in an ExpressRoute gateway PUT operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ExpressRouteGatewayInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRouteGatewayName == null) {
            throw new IllegalArgumentException("Parameter expressRouteGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (putExpressRouteGatewayParameters == null) {
            throw new IllegalArgumentException("Parameter putExpressRouteGatewayParameters is required and cannot be null.");
        }
        Validator.validate(putExpressRouteGatewayParameters);
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, expressRouteGatewayName, this.client.subscriptionId(), putExpressRouteGatewayParameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ExpressRouteGatewayInner>() { }.getType());
    }

    /**
     * Creates or updates a ExpressRoute gateway in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRouteGatewayName The name of the ExpressRoute gateway.
     * @param putExpressRouteGatewayParameters Parameters required in an ExpressRoute gateway PUT operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ExpressRouteGatewayInner object if successful.
     */
    public ExpressRouteGatewayInner beginCreateOrUpdate(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, putExpressRouteGatewayParameters).toBlocking().single().body();
    }

    /**
     * Creates or updates a ExpressRoute gateway in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRouteGatewayName The name of the ExpressRoute gateway.
     * @param putExpressRouteGatewayParameters Parameters required in an ExpressRoute gateway PUT operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ExpressRouteGatewayInner> beginCreateOrUpdateAsync(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters, final ServiceCallback<ExpressRouteGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, putExpressRouteGatewayParameters), serviceCallback);
    }

    /**
     * Creates or updates a ExpressRoute gateway in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRouteGatewayName The name of the ExpressRoute gateway.
     * @param putExpressRouteGatewayParameters Parameters required in an ExpressRoute gateway PUT operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ExpressRouteGatewayInner object
     */
    public Observable<ExpressRouteGatewayInner> beginCreateOrUpdateAsync(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, putExpressRouteGatewayParameters).map(new Func1<ServiceResponse<ExpressRouteGatewayInner>, ExpressRouteGatewayInner>() {
            @Override
            public ExpressRouteGatewayInner call(ServiceResponse<ExpressRouteGatewayInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a ExpressRoute gateway in a specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRouteGatewayName The name of the ExpressRoute gateway.
     * @param putExpressRouteGatewayParameters Parameters required in an ExpressRoute gateway PUT operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ExpressRouteGatewayInner object
     */
    public Observable<ServiceResponse<ExpressRouteGatewayInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRouteGatewayName == null) {
            throw new IllegalArgumentException("Parameter expressRouteGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (putExpressRouteGatewayParameters == null) {
            throw new IllegalArgumentException("Parameter putExpressRouteGatewayParameters is required and cannot be null.");
        }
        Validator.validate(putExpressRouteGatewayParameters);
        final String apiVersion = "2019-11-01";
        return service.beginCreateOrUpdate(resourceGroupName, expressRouteGatewayName, this.client.subscriptionId(), putExpressRouteGatewayParameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ExpressRouteGatewayInner>>>() {
                @Override
                public Observable<ServiceResponse<ExpressRouteGatewayInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ExpressRouteGatewayInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ExpressRouteGatewayInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ExpressRouteGatewayInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ExpressRouteGatewayInner>() { }.getType())
                .register(201, new TypeToken<ExpressRouteGatewayInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Fetches the details of a ExpressRoute gateway in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRouteGatewayName The name of the ExpressRoute gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ExpressRouteGatewayInner object if successful.
     */
    public ExpressRouteGatewayInner getByResourceGroup(String resourceGroupName, String expressRouteGatewayName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName).toBlocking().single().body();
    }

    /**
     * Fetches the details of a ExpressRoute gateway in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRouteGatewayName The name of the ExpressRoute gateway.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ExpressRouteGatewayInner> getByResourceGroupAsync(String resourceGroupName, String expressRouteGatewayName, final ServiceCallback<ExpressRouteGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName), serviceCallback);
    }

    /**
     * Fetches the details of a ExpressRoute gateway in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRouteGatewayName The name of the ExpressRoute gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ExpressRouteGatewayInner object
     */
    public Observable<ExpressRouteGatewayInner> getByResourceGroupAsync(String resourceGroupName, String expressRouteGatewayName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName).map(new Func1<ServiceResponse<ExpressRouteGatewayInner>, ExpressRouteGatewayInner>() {
            @Override
            public ExpressRouteGatewayInner call(ServiceResponse<ExpressRouteGatewayInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Fetches the details of a ExpressRoute gateway in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRouteGatewayName The name of the ExpressRoute gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ExpressRouteGatewayInner object
     */
    public Observable<ServiceResponse<ExpressRouteGatewayInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String expressRouteGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRouteGatewayName == null) {
            throw new IllegalArgumentException("Parameter expressRouteGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.getByResourceGroup(resourceGroupName, expressRouteGatewayName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ExpressRouteGatewayInner>>>() {
                @Override
                public Observable<ServiceResponse<ExpressRouteGatewayInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ExpressRouteGatewayInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ExpressRouteGatewayInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ExpressRouteGatewayInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ExpressRouteGatewayInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes the specified ExpressRoute gateway in a resource group. An ExpressRoute gateway resource can only be deleted when there are no connection subresources.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRouteGatewayName The name of the ExpressRoute gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String expressRouteGatewayName) {
        deleteWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName).toBlocking().last().body();
    }

    /**
     * Deletes the specified ExpressRoute gateway in a resource group. An ExpressRoute gateway resource can only be deleted when there are no connection subresources.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRouteGatewayName The name of the ExpressRoute gateway.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String expressRouteGatewayName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName), serviceCallback);
    }

    /**
     * Deletes the specified ExpressRoute gateway in a resource group. An ExpressRoute gateway resource can only be deleted when there are no connection subresources.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRouteGatewayName The name of the ExpressRoute gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String expressRouteGatewayName) {
        return deleteWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified ExpressRoute gateway in a resource group. An ExpressRoute gateway resource can only be deleted when there are no connection subresources.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRouteGatewayName The name of the ExpressRoute gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String expressRouteGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRouteGatewayName == null) {
            throw new IllegalArgumentException("Parameter expressRouteGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, expressRouteGatewayName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes the specified ExpressRoute gateway in a resource group. An ExpressRoute gateway resource can only be deleted when there are no connection subresources.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRouteGatewayName The name of the ExpressRoute gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String expressRouteGatewayName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName).toBlocking().single().body();
    }

    /**
     * Deletes the specified ExpressRoute gateway in a resource group. An ExpressRoute gateway resource can only be deleted when there are no connection subresources.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRouteGatewayName The name of the ExpressRoute gateway.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String expressRouteGatewayName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName), serviceCallback);
    }

    /**
     * Deletes the specified ExpressRoute gateway in a resource group. An ExpressRoute gateway resource can only be deleted when there are no connection subresources.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRouteGatewayName The name of the ExpressRoute gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String expressRouteGatewayName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified ExpressRoute gateway in a resource group. An ExpressRoute gateway resource can only be deleted when there are no connection subresources.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRouteGatewayName The name of the ExpressRoute gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String expressRouteGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRouteGatewayName == null) {
            throw new IllegalArgumentException("Parameter expressRouteGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.beginDelete(resourceGroupName, expressRouteGatewayName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
