/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.network.ProvisioningState;
import java.util.List;
import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.network.ProtocolCustomSettingsFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.rest.SkipParentValidation;
import com.microsoft.azure.Resource;

/**
 * A DDoS custom policy in a resource group.
 */
@JsonFlatten
@SkipParentValidation
public class DdosCustomPolicyInner extends Resource {
    /**
     * The resource GUID property of the DDoS custom policy resource. It
     * uniquely identifies the resource, even if the user changes its name or
     * migrate the resource across subscriptions or resource groups.
     */
    @JsonProperty(value = "properties.resourceGuid", access = JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;

    /**
     * The provisioning state of the DDoS custom policy resource. Possible
     * values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'.
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /**
     * The list of public IPs associated with the DDoS custom policy resource.
     * This list is read-only.
     */
    @JsonProperty(value = "properties.publicIPAddresses", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> publicIPAddresses;

    /**
     * The protocol-specific DDoS policy customization parameters.
     */
    @JsonProperty(value = "properties.protocolCustomSettings")
    private List<ProtocolCustomSettingsFormat> protocolCustomSettings;

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /**
     * Resource ID.
     */
    @JsonProperty(value = "id")
    private String id;

    /**
     * Get the resource GUID property of the DDoS custom policy resource. It uniquely identifies the resource, even if the user changes its name or migrate the resource across subscriptions or resource groups.
     *
     * @return the resourceGuid value
     */
    public String resourceGuid() {
        return this.resourceGuid;
    }

    /**
     * Get the provisioning state of the DDoS custom policy resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'.
     *
     * @return the provisioningState value
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the list of public IPs associated with the DDoS custom policy resource. This list is read-only.
     *
     * @return the publicIPAddresses value
     */
    public List<SubResource> publicIPAddresses() {
        return this.publicIPAddresses;
    }

    /**
     * Get the protocol-specific DDoS policy customization parameters.
     *
     * @return the protocolCustomSettings value
     */
    public List<ProtocolCustomSettingsFormat> protocolCustomSettings() {
        return this.protocolCustomSettings;
    }

    /**
     * Set the protocol-specific DDoS policy customization parameters.
     *
     * @param protocolCustomSettings the protocolCustomSettings value to set
     * @return the DdosCustomPolicyInner object itself.
     */
    public DdosCustomPolicyInner withProtocolCustomSettings(List<ProtocolCustomSettingsFormat> protocolCustomSettings) {
        this.protocolCustomSettings = protocolCustomSettings;
        return this;
    }

    /**
     * Get a unique read-only string that changes whenever the resource is updated.
     *
     * @return the etag value
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get resource ID.
     *
     * @return the id value
     */
    public String id() {
        return this.id;
    }

    /**
     * Set resource ID.
     *
     * @param id the id value to set
     * @return the DdosCustomPolicyInner object itself.
     */
    public DdosCustomPolicyInner withId(String id) {
        this.id = id;
        return this;
    }

}
