/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.BastionHostInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class BastionHostsInner
implements InnerSupportsGet<BastionHostInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<BastionHostInner> {
    private BastionHostsService service;
    private NetworkManagementClientImpl client;

    public BastionHostsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (BastionHostsService)retrofit.create(BastionHostsService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String bastionHostName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, bastionHostName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String bastionHostName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, bastionHostName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String bastionHostName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, bastionHostName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String bastionHostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, bastionHostName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String bastionHostName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, bastionHostName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String bastionHostName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, bastionHostName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String bastionHostName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, bastionHostName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String bastionHostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginDelete(resourceGroupName, bastionHostName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BastionHostsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BastionHostInner getByResourceGroup(String resourceGroupName, String bastionHostName) {
        return (BastionHostInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, bastionHostName).toBlocking().single()).body());
    }

    public ServiceFuture<BastionHostInner> getByResourceGroupAsync(String resourceGroupName, String bastionHostName, ServiceCallback<BastionHostInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, bastionHostName), serviceCallback);
    }

    public Observable<BastionHostInner> getByResourceGroupAsync(String resourceGroupName, String bastionHostName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, bastionHostName).map((Func1)new Func1<ServiceResponse<BastionHostInner>, BastionHostInner>(){

            public BastionHostInner call(ServiceResponse<BastionHostInner> response) {
                return (BastionHostInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<BastionHostInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String bastionHostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.getByResourceGroup(resourceGroupName, bastionHostName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BastionHostInner>>>(){

            public Observable<ServiceResponse<BastionHostInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BastionHostsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BastionHostInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BastionHostInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BastionHostInner createOrUpdate(String resourceGroupName, String bastionHostName, BastionHostInner parameters) {
        return (BastionHostInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, bastionHostName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<BastionHostInner> createOrUpdateAsync(String resourceGroupName, String bastionHostName, BastionHostInner parameters, ServiceCallback<BastionHostInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, bastionHostName, parameters), serviceCallback);
    }

    public Observable<BastionHostInner> createOrUpdateAsync(String resourceGroupName, String bastionHostName, BastionHostInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, bastionHostName, parameters).map((Func1)new Func1<ServiceResponse<BastionHostInner>, BastionHostInner>(){

            public BastionHostInner call(ServiceResponse<BastionHostInner> response) {
                return (BastionHostInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<BastionHostInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String bastionHostName, BastionHostInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, bastionHostName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<BastionHostInner>(){}.getType());
    }

    public BastionHostInner beginCreateOrUpdate(String resourceGroupName, String bastionHostName, BastionHostInner parameters) {
        return (BastionHostInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, bastionHostName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<BastionHostInner> beginCreateOrUpdateAsync(String resourceGroupName, String bastionHostName, BastionHostInner parameters, ServiceCallback<BastionHostInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, bastionHostName, parameters), serviceCallback);
    }

    public Observable<BastionHostInner> beginCreateOrUpdateAsync(String resourceGroupName, String bastionHostName, BastionHostInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, bastionHostName, parameters).map((Func1)new Func1<ServiceResponse<BastionHostInner>, BastionHostInner>(){

            public BastionHostInner call(ServiceResponse<BastionHostInner> response) {
                return (BastionHostInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<BastionHostInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String bastionHostName, BastionHostInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (bastionHostName == null) {
            throw new IllegalArgumentException("Parameter bastionHostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, bastionHostName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BastionHostInner>>>(){

            public Observable<ServiceResponse<BastionHostInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BastionHostsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BastionHostInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BastionHostInner>(){}.getType()).register(201, new TypeToken<BastionHostInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BastionHostInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<BastionHostInner>((Page)response.body()){

            public Page<BastionHostInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)BastionHostsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BastionHostInner>> listAsync(ListOperationCallback<BastionHostInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<BastionHostInner>>>>(){

            public Observable<ServiceResponse<Page<BastionHostInner>>> call(String nextPageLink) {
                return BastionHostsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BastionHostInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<BastionHostInner>>, Page<BastionHostInner>>(){

            public Page<BastionHostInner> call(ServiceResponse<Page<BastionHostInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionHostInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<BastionHostInner>>, Observable<ServiceResponse<Page<BastionHostInner>>>>(){

            public Observable<ServiceResponse<Page<BastionHostInner>>> call(ServiceResponse<Page<BastionHostInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(BastionHostsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionHostInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionHostInner>>>>(){

            public Observable<ServiceResponse<Page<BastionHostInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = BastionHostsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BastionHostInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<BastionHostInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BastionHostInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<BastionHostInner>((Page)response.body()){

            public Page<BastionHostInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)BastionHostsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BastionHostInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<BastionHostInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<BastionHostInner>>>>(){

            public Observable<ServiceResponse<Page<BastionHostInner>>> call(String nextPageLink) {
                return BastionHostsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BastionHostInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<BastionHostInner>>, Page<BastionHostInner>>(){

            public Page<BastionHostInner> call(ServiceResponse<Page<BastionHostInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionHostInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<BastionHostInner>>, Observable<ServiceResponse<Page<BastionHostInner>>>>(){

            public Observable<ServiceResponse<Page<BastionHostInner>>> call(ServiceResponse<Page<BastionHostInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(BastionHostsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionHostInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionHostInner>>>>(){

            public Observable<ServiceResponse<Page<BastionHostInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = BastionHostsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BastionHostInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<BastionHostInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BastionHostInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BastionHostInner>((Page)response.body()){

            public Page<BastionHostInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)BastionHostsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BastionHostInner>> listNextAsync(String nextPageLink, ServiceFuture<List<BastionHostInner>> serviceFuture, ListOperationCallback<BastionHostInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<BastionHostInner>>>>(){

            public Observable<ServiceResponse<Page<BastionHostInner>>> call(String nextPageLink) {
                return BastionHostsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BastionHostInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<BastionHostInner>>, Page<BastionHostInner>>(){

            public Page<BastionHostInner> call(ServiceResponse<Page<BastionHostInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionHostInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<BastionHostInner>>, Observable<ServiceResponse<Page<BastionHostInner>>>>(){

            public Observable<ServiceResponse<Page<BastionHostInner>>> call(ServiceResponse<Page<BastionHostInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(BastionHostsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionHostInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionHostInner>>>>(){

            public Observable<ServiceResponse<Page<BastionHostInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = BastionHostsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BastionHostInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<BastionHostInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BastionHostInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BastionHostInner>((Page)response.body()){

            public Page<BastionHostInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)BastionHostsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BastionHostInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<BastionHostInner>> serviceFuture, ListOperationCallback<BastionHostInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<BastionHostInner>>>>(){

            public Observable<ServiceResponse<Page<BastionHostInner>>> call(String nextPageLink) {
                return BastionHostsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BastionHostInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<BastionHostInner>>, Page<BastionHostInner>>(){

            public Page<BastionHostInner> call(ServiceResponse<Page<BastionHostInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionHostInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<BastionHostInner>>, Observable<ServiceResponse<Page<BastionHostInner>>>>(){

            public Observable<ServiceResponse<Page<BastionHostInner>>> call(ServiceResponse<Page<BastionHostInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(BastionHostsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BastionHostInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BastionHostInner>>>>(){

            public Observable<ServiceResponse<Page<BastionHostInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = BastionHostsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BastionHostInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<BastionHostInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface BastionHostsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.BastionHosts delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="bastionHostName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.BastionHosts beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="bastionHostName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.BastionHosts getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="bastionHostName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.BastionHosts createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="bastionHostName") String var2, @Path(value="subscriptionId") String var3, @Body BastionHostInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.BastionHosts beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="bastionHostName") String var2, @Path(value="subscriptionId") String var3, @Body BastionHostInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.BastionHosts list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/bastionHosts")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.BastionHosts listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.BastionHosts listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.BastionHosts listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

