/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ApplicationGateway;
import com.microsoft.azure.management.network.ApplicationGatewayIPConfiguration;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.Subnet;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayIPConfigurationInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;

@LangDefinition
class ApplicationGatewayIPConfigurationImpl
extends ChildResourceImpl<ApplicationGatewayIPConfigurationInner, ApplicationGatewayImpl, ApplicationGateway>
implements ApplicationGatewayIPConfiguration,
ApplicationGatewayIPConfiguration.Definition<ApplicationGateway.DefinitionStages.WithCreate>,
ApplicationGatewayIPConfiguration.UpdateDefinition<ApplicationGateway.Update>,
ApplicationGatewayIPConfiguration.Update {
    ApplicationGatewayIPConfigurationImpl(ApplicationGatewayIPConfigurationInner inner, ApplicationGatewayImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String name() {
        return ((ApplicationGatewayIPConfigurationInner)((Object)this.inner())).name();
    }

    @Override
    public ApplicationGatewayIPConfigurationImpl withExistingSubnet(Subnet subnet) {
        return this.withExistingSubnet(((Network)subnet.parent()).id(), subnet.name());
    }

    @Override
    public ApplicationGatewayIPConfigurationImpl withExistingSubnet(Network network, String subnetName) {
        return this.withExistingSubnet(network.id(), subnetName);
    }

    public ApplicationGatewayIPConfigurationImpl withExistingSubnet(String networkId, String subnetName) {
        SubResource subnetRef = new SubResource().withId(networkId + "/subnets/" + subnetName);
        ((ApplicationGatewayIPConfigurationInner)((Object)this.inner())).withSubnet(subnetRef);
        return this;
    }

    public ApplicationGatewayImpl attach() {
        return ((ApplicationGatewayImpl)this.parent()).withConfig(this);
    }

    @Override
    public String networkId() {
        SubResource subnetRef = ((ApplicationGatewayIPConfigurationInner)((Object)this.inner())).subnet();
        if (subnetRef != null) {
            return ResourceUtils.parentResourceIdFromResourceId((String)subnetRef.id());
        }
        return null;
    }

    @Override
    public String subnetName() {
        SubResource subnetRef = ((ApplicationGatewayIPConfigurationInner)((Object)this.inner())).subnet();
        if (subnetRef != null) {
            return ResourceUtils.nameFromResourceId((String)subnetRef.id());
        }
        return null;
    }

    @Override
    public Subnet getSubnet() {
        return ((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager()).getAssociatedSubnet(((ApplicationGatewayIPConfigurationInner)((Object)this.inner())).subnet());
    }
}

