/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in VirtualWANs.
 */
public class VirtualWANsInner implements InnerSupportsGet<VirtualWANInner>, InnerSupportsDelete<Void>, InnerSupportsListing<VirtualWANInner> {
    /** The Retrofit service to perform REST calls. */
    private VirtualWANsService service;
    /** The service client containing this operation class. */
    private NetworkManagementClientImpl client;

    /**
     * Initializes an instance of VirtualWANsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public VirtualWANsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = retrofit.create(VirtualWANsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for VirtualWANs to be
     * used by Retrofit to perform actually REST calls.
     */
    interface VirtualWANsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualWANs getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{VirtualWANName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("VirtualWANName") String virtualWANName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualWANs createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{VirtualWANName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("VirtualWANName") String virtualWANName, @Query("api-version") String apiVersion, @Body VirtualWANInner wANParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualWANs beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{VirtualWANName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("VirtualWANName") String virtualWANName, @Query("api-version") String apiVersion, @Body VirtualWANInner wANParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualWANs updateTags" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{VirtualWANName}")
        Observable<Response<ResponseBody>> updateTags(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("VirtualWANName") String virtualWANName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body TagsObject wANParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualWANs beginUpdateTags" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{VirtualWANName}")
        Observable<Response<ResponseBody>> beginUpdateTags(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("VirtualWANName") String virtualWANName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body TagsObject wANParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualWANs delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{VirtualWANName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("VirtualWANName") String virtualWANName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualWANs beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{VirtualWANName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("VirtualWANName") String virtualWANName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualWANs listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualWANs list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Network/virtualWans")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualWANs listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualWANs listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Retrieves the details of a VirtualWAN.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualWANInner object if successful.
     */
    public VirtualWANInner getByResourceGroup(String resourceGroupName, String virtualWANName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualWANName).toBlocking().single().body();
    }

    /**
     * Retrieves the details of a VirtualWAN.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being retrieved.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualWANInner> getByResourceGroupAsync(String resourceGroupName, String virtualWANName, final ServiceCallback<VirtualWANInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualWANName), serviceCallback);
    }

    /**
     * Retrieves the details of a VirtualWAN.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualWANInner object
     */
    public Observable<VirtualWANInner> getByResourceGroupAsync(String resourceGroupName, String virtualWANName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualWANName).map(new Func1<ServiceResponse<VirtualWANInner>, VirtualWANInner>() {
            @Override
            public VirtualWANInner call(ServiceResponse<VirtualWANInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the details of a VirtualWAN.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualWANInner object
     */
    public Observable<ServiceResponse<VirtualWANInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String virtualWANName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01";
        return service.getByResourceGroup(resourceGroupName, virtualWANName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualWANInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualWANInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualWANInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualWANInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VirtualWANInner, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VirtualWANInner>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Creates a VirtualWAN resource if it doesn't exist else updates the existing VirtualWAN.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being created or updated.
     * @param wANParameters Parameters supplied to create or update VirtualWAN.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualWANInner object if successful.
     */
    public VirtualWANInner createOrUpdate(String resourceGroupName, String virtualWANName, VirtualWANInner wANParameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualWANName, wANParameters).toBlocking().last().body();
    }

    /**
     * Creates a VirtualWAN resource if it doesn't exist else updates the existing VirtualWAN.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being created or updated.
     * @param wANParameters Parameters supplied to create or update VirtualWAN.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualWANInner> createOrUpdateAsync(String resourceGroupName, String virtualWANName, VirtualWANInner wANParameters, final ServiceCallback<VirtualWANInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualWANName, wANParameters), serviceCallback);
    }

    /**
     * Creates a VirtualWAN resource if it doesn't exist else updates the existing VirtualWAN.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being created or updated.
     * @param wANParameters Parameters supplied to create or update VirtualWAN.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<VirtualWANInner> createOrUpdateAsync(String resourceGroupName, String virtualWANName, VirtualWANInner wANParameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualWANName, wANParameters).map(new Func1<ServiceResponse<VirtualWANInner>, VirtualWANInner>() {
            @Override
            public VirtualWANInner call(ServiceResponse<VirtualWANInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a VirtualWAN resource if it doesn't exist else updates the existing VirtualWAN.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being created or updated.
     * @param wANParameters Parameters supplied to create or update VirtualWAN.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<VirtualWANInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualWANName, VirtualWANInner wANParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        if (wANParameters == null) {
            throw new IllegalArgumentException("Parameter wANParameters is required and cannot be null.");
        }
        Validator.validate(wANParameters);
        final String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, virtualWANName, apiVersion, wANParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualWANInner>() { }.getType());
    }

    /**
     * Creates a VirtualWAN resource if it doesn't exist else updates the existing VirtualWAN.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being created or updated.
     * @param wANParameters Parameters supplied to create or update VirtualWAN.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualWANInner object if successful.
     */
    public VirtualWANInner beginCreateOrUpdate(String resourceGroupName, String virtualWANName, VirtualWANInner wANParameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualWANName, wANParameters).toBlocking().single().body();
    }

    /**
     * Creates a VirtualWAN resource if it doesn't exist else updates the existing VirtualWAN.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being created or updated.
     * @param wANParameters Parameters supplied to create or update VirtualWAN.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualWANInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualWANName, VirtualWANInner wANParameters, final ServiceCallback<VirtualWANInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualWANName, wANParameters), serviceCallback);
    }

    /**
     * Creates a VirtualWAN resource if it doesn't exist else updates the existing VirtualWAN.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being created or updated.
     * @param wANParameters Parameters supplied to create or update VirtualWAN.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualWANInner object
     */
    public Observable<VirtualWANInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualWANName, VirtualWANInner wANParameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualWANName, wANParameters).map(new Func1<ServiceResponse<VirtualWANInner>, VirtualWANInner>() {
            @Override
            public VirtualWANInner call(ServiceResponse<VirtualWANInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a VirtualWAN resource if it doesn't exist else updates the existing VirtualWAN.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being created or updated.
     * @param wANParameters Parameters supplied to create or update VirtualWAN.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualWANInner object
     */
    public Observable<ServiceResponse<VirtualWANInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualWANName, VirtualWANInner wANParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        if (wANParameters == null) {
            throw new IllegalArgumentException("Parameter wANParameters is required and cannot be null.");
        }
        Validator.validate(wANParameters);
        final String apiVersion = "2018-06-01";
        return service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, virtualWANName, apiVersion, wANParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualWANInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualWANInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualWANInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualWANInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VirtualWANInner, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VirtualWANInner>() { }.getType())
                .register(201, new TypeToken<VirtualWANInner>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Updates a VirtualWAN tags.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualWANInner object if successful.
     */
    public VirtualWANInner updateTags(String resourceGroupName, String virtualWANName) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, virtualWANName).toBlocking().last().body();
    }

    /**
     * Updates a VirtualWAN tags.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being updated.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualWANInner> updateTagsAsync(String resourceGroupName, String virtualWANName, final ServiceCallback<VirtualWANInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateTagsWithServiceResponseAsync(resourceGroupName, virtualWANName), serviceCallback);
    }

    /**
     * Updates a VirtualWAN tags.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<VirtualWANInner> updateTagsAsync(String resourceGroupName, String virtualWANName) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, virtualWANName).map(new Func1<ServiceResponse<VirtualWANInner>, VirtualWANInner>() {
            @Override
            public VirtualWANInner call(ServiceResponse<VirtualWANInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a VirtualWAN tags.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<VirtualWANInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String virtualWANName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01";
        final Map<String, String> tags = null;
        TagsObject wANParameters = new TagsObject();
        wANParameters.withTags(null);
        Observable<Response<ResponseBody>> observable = service.updateTags(this.client.subscriptionId(), resourceGroupName, virtualWANName, apiVersion, this.client.acceptLanguage(), wANParameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualWANInner>() { }.getType());
    }
    /**
     * Updates a VirtualWAN tags.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being updated.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualWANInner object if successful.
     */
    public VirtualWANInner updateTags(String resourceGroupName, String virtualWANName, Map<String, String> tags) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, virtualWANName, tags).toBlocking().last().body();
    }

    /**
     * Updates a VirtualWAN tags.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being updated.
     * @param tags Resource tags.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualWANInner> updateTagsAsync(String resourceGroupName, String virtualWANName, Map<String, String> tags, final ServiceCallback<VirtualWANInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateTagsWithServiceResponseAsync(resourceGroupName, virtualWANName, tags), serviceCallback);
    }

    /**
     * Updates a VirtualWAN tags.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being updated.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<VirtualWANInner> updateTagsAsync(String resourceGroupName, String virtualWANName, Map<String, String> tags) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, virtualWANName, tags).map(new Func1<ServiceResponse<VirtualWANInner>, VirtualWANInner>() {
            @Override
            public VirtualWANInner call(ServiceResponse<VirtualWANInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a VirtualWAN tags.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being updated.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<VirtualWANInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String virtualWANName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        Validator.validate(tags);
        final String apiVersion = "2018-06-01";
        TagsObject wANParameters = new TagsObject();
        wANParameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = service.updateTags(this.client.subscriptionId(), resourceGroupName, virtualWANName, apiVersion, this.client.acceptLanguage(), wANParameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualWANInner>() { }.getType());
    }

    /**
     * Updates a VirtualWAN tags.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualWANInner object if successful.
     */
    public VirtualWANInner beginUpdateTags(String resourceGroupName, String virtualWANName) {
        return beginUpdateTagsWithServiceResponseAsync(resourceGroupName, virtualWANName).toBlocking().single().body();
    }

    /**
     * Updates a VirtualWAN tags.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being updated.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualWANInner> beginUpdateTagsAsync(String resourceGroupName, String virtualWANName, final ServiceCallback<VirtualWANInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateTagsWithServiceResponseAsync(resourceGroupName, virtualWANName), serviceCallback);
    }

    /**
     * Updates a VirtualWAN tags.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualWANInner object
     */
    public Observable<VirtualWANInner> beginUpdateTagsAsync(String resourceGroupName, String virtualWANName) {
        return beginUpdateTagsWithServiceResponseAsync(resourceGroupName, virtualWANName).map(new Func1<ServiceResponse<VirtualWANInner>, VirtualWANInner>() {
            @Override
            public VirtualWANInner call(ServiceResponse<VirtualWANInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a VirtualWAN tags.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualWANInner object
     */
    public Observable<ServiceResponse<VirtualWANInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String virtualWANName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01";
        final Map<String, String> tags = null;
        TagsObject wANParameters = new TagsObject();
        wANParameters.withTags(null);
        return service.beginUpdateTags(this.client.subscriptionId(), resourceGroupName, virtualWANName, apiVersion, this.client.acceptLanguage(), wANParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualWANInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualWANInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualWANInner> clientResponse = beginUpdateTagsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates a VirtualWAN tags.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being updated.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualWANInner object if successful.
     */
    public VirtualWANInner beginUpdateTags(String resourceGroupName, String virtualWANName, Map<String, String> tags) {
        return beginUpdateTagsWithServiceResponseAsync(resourceGroupName, virtualWANName, tags).toBlocking().single().body();
    }

    /**
     * Updates a VirtualWAN tags.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being updated.
     * @param tags Resource tags.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualWANInner> beginUpdateTagsAsync(String resourceGroupName, String virtualWANName, Map<String, String> tags, final ServiceCallback<VirtualWANInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateTagsWithServiceResponseAsync(resourceGroupName, virtualWANName, tags), serviceCallback);
    }

    /**
     * Updates a VirtualWAN tags.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being updated.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualWANInner object
     */
    public Observable<VirtualWANInner> beginUpdateTagsAsync(String resourceGroupName, String virtualWANName, Map<String, String> tags) {
        return beginUpdateTagsWithServiceResponseAsync(resourceGroupName, virtualWANName, tags).map(new Func1<ServiceResponse<VirtualWANInner>, VirtualWANInner>() {
            @Override
            public VirtualWANInner call(ServiceResponse<VirtualWANInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a VirtualWAN tags.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being updated.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualWANInner object
     */
    public Observable<ServiceResponse<VirtualWANInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String virtualWANName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        Validator.validate(tags);
        final String apiVersion = "2018-06-01";
        TagsObject wANParameters = new TagsObject();
        wANParameters.withTags(tags);
        return service.beginUpdateTags(this.client.subscriptionId(), resourceGroupName, virtualWANName, apiVersion, this.client.acceptLanguage(), wANParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualWANInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualWANInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualWANInner> clientResponse = beginUpdateTagsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualWANInner> beginUpdateTagsDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VirtualWANInner, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VirtualWANInner>() { }.getType())
                .register(201, new TypeToken<VirtualWANInner>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Deletes a VirtualWAN.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String virtualWANName) {
        deleteWithServiceResponseAsync(resourceGroupName, virtualWANName).toBlocking().last().body();
    }

    /**
     * Deletes a VirtualWAN.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being deleted.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String virtualWANName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, virtualWANName), serviceCallback);
    }

    /**
     * Deletes a VirtualWAN.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String virtualWANName) {
        return deleteWithServiceResponseAsync(resourceGroupName, virtualWANName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a VirtualWAN.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String virtualWANName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = service.delete(this.client.subscriptionId(), resourceGroupName, virtualWANName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a VirtualWAN.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String virtualWANName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, virtualWANName).toBlocking().single().body();
    }

    /**
     * Deletes a VirtualWAN.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being deleted.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String virtualWANName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, virtualWANName), serviceCallback);
    }

    /**
     * Deletes a VirtualWAN.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String virtualWANName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, virtualWANName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a VirtualWAN.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param virtualWANName The name of the VirtualWAN being deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String virtualWANName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01";
        return service.beginDelete(this.client.subscriptionId(), resourceGroupName, virtualWANName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Lists all the VirtualWANs in a resource group.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualWANInner&gt; object if successful.
     */
    public PagedList<VirtualWANInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<VirtualWANInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<VirtualWANInner>(response.body()) {
            @Override
            public Page<VirtualWANInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the VirtualWANs in a resource group.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualWANInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<VirtualWANInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<VirtualWANInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualWANInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the VirtualWANs in a resource group.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualWANInner&gt; object
     */
    public Observable<Page<VirtualWANInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<VirtualWANInner>>, Page<VirtualWANInner>>() {
                @Override
                public Page<VirtualWANInner> call(ServiceResponse<Page<VirtualWANInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the VirtualWANs in a resource group.
     *
     * @param resourceGroupName The resource group name of the VirtualWan.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualWANInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualWANInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<VirtualWANInner>>, Observable<ServiceResponse<Page<VirtualWANInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualWANInner>>> call(ServiceResponse<Page<VirtualWANInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the VirtualWANs in a resource group.
     *
    ServiceResponse<PageImpl<VirtualWANInner>> * @param resourceGroupName The resource group name of the VirtualWan.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualWANInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualWANInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01";
        return service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualWANInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualWANInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VirtualWANInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualWANInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VirtualWANInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VirtualWANInner>, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VirtualWANInner>>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Lists all the VirtualWANs in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualWANInner&gt; object if successful.
     */
    public PagedList<VirtualWANInner> list() {
        ServiceResponse<Page<VirtualWANInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<VirtualWANInner>(response.body()) {
            @Override
            public Page<VirtualWANInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the VirtualWANs in a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualWANInner>> listAsync(final ListOperationCallback<VirtualWANInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<VirtualWANInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualWANInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the VirtualWANs in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualWANInner&gt; object
     */
    public Observable<Page<VirtualWANInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<VirtualWANInner>>, Page<VirtualWANInner>>() {
                @Override
                public Page<VirtualWANInner> call(ServiceResponse<Page<VirtualWANInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the VirtualWANs in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualWANInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualWANInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<VirtualWANInner>>, Observable<ServiceResponse<Page<VirtualWANInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualWANInner>>> call(ServiceResponse<Page<VirtualWANInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the VirtualWANs in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualWANInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualWANInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualWANInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualWANInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VirtualWANInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualWANInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VirtualWANInner>> listDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VirtualWANInner>, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VirtualWANInner>>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Lists all the VirtualWANs in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualWANInner&gt; object if successful.
     */
    public PagedList<VirtualWANInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<VirtualWANInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualWANInner>(response.body()) {
            @Override
            public Page<VirtualWANInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the VirtualWANs in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualWANInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<VirtualWANInner>> serviceFuture, final ListOperationCallback<VirtualWANInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<VirtualWANInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualWANInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the VirtualWANs in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualWANInner&gt; object
     */
    public Observable<Page<VirtualWANInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<VirtualWANInner>>, Page<VirtualWANInner>>() {
                @Override
                public Page<VirtualWANInner> call(ServiceResponse<Page<VirtualWANInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the VirtualWANs in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualWANInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualWANInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<VirtualWANInner>>, Observable<ServiceResponse<Page<VirtualWANInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualWANInner>>> call(ServiceResponse<Page<VirtualWANInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the VirtualWANs in a resource group.
     *
    ServiceResponse<PageImpl<VirtualWANInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualWANInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualWANInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualWANInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualWANInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VirtualWANInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualWANInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VirtualWANInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VirtualWANInner>, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VirtualWANInner>>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Lists all the VirtualWANs in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualWANInner&gt; object if successful.
     */
    public PagedList<VirtualWANInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<VirtualWANInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualWANInner>(response.body()) {
            @Override
            public Page<VirtualWANInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the VirtualWANs in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualWANInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<VirtualWANInner>> serviceFuture, final ListOperationCallback<VirtualWANInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<VirtualWANInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualWANInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the VirtualWANs in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualWANInner&gt; object
     */
    public Observable<Page<VirtualWANInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<VirtualWANInner>>, Page<VirtualWANInner>>() {
                @Override
                public Page<VirtualWANInner> call(ServiceResponse<Page<VirtualWANInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the VirtualWANs in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualWANInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualWANInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<VirtualWANInner>>, Observable<ServiceResponse<Page<VirtualWANInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualWANInner>>> call(ServiceResponse<Page<VirtualWANInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the VirtualWANs in a subscription.
     *
    ServiceResponse<PageImpl<VirtualWANInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualWANInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualWANInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualWANInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualWANInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VirtualWANInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualWANInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VirtualWANInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VirtualWANInner>, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VirtualWANInner>>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

}
