/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.monitor.AutoscaleNotification;
import com.microsoft.azure.management.monitor.AutoscaleProfile;
import com.microsoft.azure.management.monitor.AutoscaleSetting;
import com.microsoft.azure.management.monitor.EmailNotification;
import com.microsoft.azure.management.monitor.WebhookNotification;
import com.microsoft.azure.management.monitor.implementation.AutoscaleProfileImpl;
import com.microsoft.azure.management.monitor.implementation.AutoscaleProfileInner;
import com.microsoft.azure.management.monitor.implementation.AutoscaleSettingResourceInner;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.azure.management.monitor.implementation.MonitorManager;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rx.Observable;

@LangDefinition
class AutoscaleSettingImpl
extends GroupableResourceImpl<AutoscaleSetting, AutoscaleSettingResourceInner, AutoscaleSettingImpl, MonitorManager>
implements AutoscaleSetting,
AutoscaleSetting.Definition,
AutoscaleSetting.Update {
    AutoscaleSettingImpl(String name, AutoscaleSettingResourceInner innerModel, MonitorManager monitorManager) {
        super(name, (Resource)innerModel, (ManagerBase)monitorManager);
        if (this.isInCreateMode()) {
            ((AutoscaleSettingResourceInner)((Object)this.inner())).withEnabled(true);
        }
        if (((AutoscaleSettingResourceInner)((Object)this.inner())).notifications() == null) {
            ((AutoscaleSettingResourceInner)((Object)this.inner())).withNotifications(new ArrayList<AutoscaleNotification>());
            ((AutoscaleSettingResourceInner)((Object)this.inner())).notifications().add(new AutoscaleNotification());
        }
        if (((AutoscaleSettingResourceInner)((Object)this.inner())).profiles() == null) {
            ((AutoscaleSettingResourceInner)((Object)this.inner())).withProfiles(new ArrayList<AutoscaleProfileInner>());
        }
    }

    @Override
    public String targetResourceId() {
        return ((AutoscaleSettingResourceInner)((Object)this.inner())).targetResourceUri();
    }

    @Override
    public Map<String, AutoscaleProfile> profiles() {
        HashMap<String, AutoscaleProfile> result = new HashMap<String, AutoscaleProfile>();
        for (AutoscaleProfileInner profileInner : ((AutoscaleSettingResourceInner)((Object)this.inner())).profiles()) {
            AutoscaleProfileImpl profileImpl = new AutoscaleProfileImpl(profileInner.name(), profileInner, this);
            result.put(profileImpl.name(), profileImpl);
        }
        return result;
    }

    @Override
    public boolean autoscaleEnabled() {
        return ((AutoscaleSettingResourceInner)((Object)this.inner())).enabled();
    }

    @Override
    public boolean adminEmailNotificationEnabled() {
        if (((AutoscaleSettingResourceInner)((Object)this.inner())).notifications() != null && ((AutoscaleSettingResourceInner)((Object)this.inner())).notifications().get(0) != null && ((AutoscaleSettingResourceInner)((Object)this.inner())).notifications().get(0).email() != null) {
            return ((AutoscaleSettingResourceInner)((Object)this.inner())).notifications().get(0).email().sendToSubscriptionAdministrator();
        }
        return false;
    }

    @Override
    public boolean coAdminEmailNotificationEnabled() {
        if (((AutoscaleSettingResourceInner)((Object)this.inner())).notifications() != null && ((AutoscaleSettingResourceInner)((Object)this.inner())).notifications().get(0) != null && ((AutoscaleSettingResourceInner)((Object)this.inner())).notifications().get(0).email() != null) {
            return ((AutoscaleSettingResourceInner)((Object)this.inner())).notifications().get(0).email().sendToSubscriptionCoAdministrators();
        }
        return false;
    }

    @Override
    public List<String> customEmailsNotification() {
        if (((AutoscaleSettingResourceInner)((Object)this.inner())).notifications() != null && ((AutoscaleSettingResourceInner)((Object)this.inner())).notifications().get(0) != null && ((AutoscaleSettingResourceInner)((Object)this.inner())).notifications().get(0).email() != null && ((AutoscaleSettingResourceInner)((Object)this.inner())).notifications().get(0).email().customEmails() != null) {
            return ((AutoscaleSettingResourceInner)((Object)this.inner())).notifications().get(0).email().customEmails();
        }
        return new ArrayList<String>();
    }

    @Override
    public String webhookNotification() {
        if (((AutoscaleSettingResourceInner)((Object)this.inner())).notifications() != null && ((AutoscaleSettingResourceInner)((Object)this.inner())).notifications().get(0) != null && ((AutoscaleSettingResourceInner)((Object)this.inner())).notifications().get(0).email() != null && ((AutoscaleSettingResourceInner)((Object)this.inner())).notifications().get(0).webhooks() != null && ((AutoscaleSettingResourceInner)((Object)this.inner())).notifications().get(0).webhooks().size() > 0) {
            return ((AutoscaleSettingResourceInner)((Object)this.inner())).notifications().get(0).webhooks().get(0).serviceUri();
        }
        return null;
    }

    @Override
    public AutoscaleProfileImpl defineAutoscaleProfile(String name) {
        return new AutoscaleProfileImpl(name, new AutoscaleProfileInner(), this);
    }

    @Override
    public AutoscaleProfileImpl updateAutoscaleProfile(String name) {
        int idx = this.getProfileIndexByName(name);
        if (idx == -1) {
            throw new IllegalArgumentException("Cannot find autoscale profile with the name '" + name + "'");
        }
        AutoscaleProfileInner innerProfile = ((AutoscaleSettingResourceInner)((Object)this.inner())).profiles().get(idx);
        return new AutoscaleProfileImpl(innerProfile.name(), innerProfile, this);
    }

    @Override
    public AutoscaleSettingImpl withoutAutoscaleProfile(String name) {
        int idx = this.getProfileIndexByName(name);
        if (idx != -1) {
            ((AutoscaleSettingResourceInner)((Object)this.inner())).profiles().remove(idx);
        }
        return this;
    }

    @Override
    public AutoscaleSettingImpl withTargetResource(String targetResourceId) {
        ((AutoscaleSettingResourceInner)((Object)this.inner())).withTargetResourceUri(targetResourceId);
        return this;
    }

    @Override
    public AutoscaleSettingImpl withAdminEmailNotification() {
        AutoscaleNotification notificationInner = this.getNotificationInner();
        notificationInner.email().withSendToSubscriptionAdministrator(true);
        return this;
    }

    @Override
    public AutoscaleSettingImpl withCoAdminEmailNotification() {
        AutoscaleNotification notificationInner = this.getNotificationInner();
        notificationInner.email().withSendToSubscriptionCoAdministrators(true);
        return this;
    }

    @Override
    public AutoscaleSettingImpl withCustomEmailsNotification(String ... customEmailAddresses) {
        AutoscaleNotification notificationInner = this.getNotificationInner();
        notificationInner.email().withCustomEmails(new ArrayList<String>());
        for (String strEmail : customEmailAddresses) {
            notificationInner.email().customEmails().add(strEmail);
        }
        return this;
    }

    @Override
    public AutoscaleSettingImpl withWebhookNotification(String serviceUri) {
        AutoscaleNotification notificationInner = this.getNotificationInner();
        if (notificationInner.webhooks() == null) {
            notificationInner.withWebhooks(new ArrayList<WebhookNotification>());
        }
        if (notificationInner.webhooks().isEmpty()) {
            notificationInner.webhooks().add(new WebhookNotification());
        }
        notificationInner.webhooks().get(0).withServiceUri(serviceUri);
        return this;
    }

    @Override
    public AutoscaleSettingImpl withoutAdminEmailNotification() {
        AutoscaleNotification notificationInner = this.getNotificationInner();
        notificationInner.email().withSendToSubscriptionAdministrator(false);
        return this;
    }

    @Override
    public AutoscaleSettingImpl withoutCoAdminEmailNotification() {
        AutoscaleNotification notificationInner = this.getNotificationInner();
        notificationInner.email().withSendToSubscriptionCoAdministrators(false);
        return this;
    }

    @Override
    public AutoscaleSettingImpl withoutCustomEmailsNotification() {
        AutoscaleNotification notificationInner = this.getNotificationInner();
        notificationInner.email().withCustomEmails(null);
        return this;
    }

    @Override
    public AutoscaleSettingImpl withoutWebhookNotification() {
        AutoscaleNotification notificationInner = this.getNotificationInner();
        notificationInner.withWebhooks(null);
        return this;
    }

    @Override
    public AutoscaleSettingImpl withAutoscaleEnabled() {
        ((AutoscaleSettingResourceInner)((Object)this.inner())).withEnabled(true);
        return this;
    }

    @Override
    public AutoscaleSettingImpl withAutoscaleDisabled() {
        ((AutoscaleSettingResourceInner)((Object)this.inner())).withEnabled(false);
        return this;
    }

    public Observable<AutoscaleSetting> createResourceAsync() {
        return ((MonitorManagementClientImpl)((Object)((MonitorManager)this.manager()).inner())).autoscaleSettings().createOrUpdateAsync(this.resourceGroupName(), this.name(), (AutoscaleSettingResourceInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<AutoscaleSettingResourceInner> getInnerAsync() {
        return ((MonitorManagementClientImpl)((Object)((MonitorManager)this.manager()).inner())).autoscaleSettings().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public AutoscaleSettingImpl addNewAutoscaleProfile(AutoscaleProfileImpl profile) {
        ((AutoscaleSettingResourceInner)((Object)this.inner())).profiles().add((AutoscaleProfileInner)profile.inner());
        return this;
    }

    private int getProfileIndexByName(String name) {
        int idxResult = -1;
        for (int idx = 0; idx < ((AutoscaleSettingResourceInner)((Object)this.inner())).profiles().size(); ++idx) {
            if (!((AutoscaleSettingResourceInner)((Object)this.inner())).profiles().get(idx).name().equalsIgnoreCase(name)) continue;
            idxResult = idx;
            break;
        }
        return idxResult;
    }

    private AutoscaleNotification getNotificationInner() {
        AutoscaleNotification notificationInner = ((AutoscaleSettingResourceInner)((Object)this.inner())).notifications().get(0);
        if (notificationInner.email() == null) {
            notificationInner.withEmail(new EmailNotification());
        }
        return notificationInner;
    }
}

