/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.monitor.ErrorResponseException;
import com.microsoft.azure.management.monitor.LogSearchRuleResourcePatch;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in ScheduledQueryRules.
 */
public class ScheduledQueryRulesInner implements InnerSupportsGet<LogSearchRuleResourceInner>, InnerSupportsDelete<Void>, InnerSupportsListing<LogSearchRuleResourceInner> {
    /** The Retrofit service to perform REST calls. */
    private ScheduledQueryRulesService service;
    /** The service client containing this operation class. */
    private MonitorManagementClientImpl client;

    /**
     * Initializes an instance of ScheduledQueryRulesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ScheduledQueryRulesInner(Retrofit retrofit, MonitorManagementClientImpl client) {
        this.service = retrofit.create(ScheduledQueryRulesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for ScheduledQueryRules to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ScheduledQueryRulesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ScheduledQueryRules createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/scheduledQueryRules/{ruleName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("ruleName") String ruleName, @Query("api-version") String apiVersion, @Body LogSearchRuleResourceInner parameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ScheduledQueryRules getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/scheduledQueryRules/{ruleName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("ruleName") String ruleName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ScheduledQueryRules update" })
        @PATCH("subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/scheduledQueryRules/{ruleName}")
        Observable<Response<ResponseBody>> update(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("ruleName") String ruleName, @Query("api-version") String apiVersion, @Body LogSearchRuleResourcePatch parameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ScheduledQueryRules delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/scheduledQueryRules/{ruleName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("ruleName") String ruleName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ScheduledQueryRules list" })
        @GET("subscriptions/{subscriptionId}/providers/microsoft.insights/scheduledQueryRules")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Query("$filter") String filter, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ScheduledQueryRules listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/scheduledQueryRules")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Query("$filter") String filter, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Creates or updates an log search rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ruleName The name of the rule.
     * @param parameters The parameters of the rule to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the LogSearchRuleResourceInner object if successful.
     */
    public LogSearchRuleResourceInner createOrUpdate(String resourceGroupName, String ruleName, LogSearchRuleResourceInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, ruleName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates an log search rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ruleName The name of the rule.
     * @param parameters The parameters of the rule to create or update.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<LogSearchRuleResourceInner> createOrUpdateAsync(String resourceGroupName, String ruleName, LogSearchRuleResourceInner parameters, final ServiceCallback<LogSearchRuleResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, ruleName, parameters), serviceCallback);
    }

    /**
     * Creates or updates an log search rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ruleName The name of the rule.
     * @param parameters The parameters of the rule to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the LogSearchRuleResourceInner object
     */
    public Observable<LogSearchRuleResourceInner> createOrUpdateAsync(String resourceGroupName, String ruleName, LogSearchRuleResourceInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, ruleName, parameters).map(new Func1<ServiceResponse<LogSearchRuleResourceInner>, LogSearchRuleResourceInner>() {
            @Override
            public LogSearchRuleResourceInner call(ServiceResponse<LogSearchRuleResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates an log search rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ruleName The name of the rule.
     * @param parameters The parameters of the rule to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the LogSearchRuleResourceInner object
     */
    public Observable<ServiceResponse<LogSearchRuleResourceInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String ruleName, LogSearchRuleResourceInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2018-04-16";
        return service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, ruleName, apiVersion, parameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<LogSearchRuleResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<LogSearchRuleResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<LogSearchRuleResourceInner> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<LogSearchRuleResourceInner> createOrUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<LogSearchRuleResourceInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<LogSearchRuleResourceInner>() { }.getType())
                .register(201, new TypeToken<LogSearchRuleResourceInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets an Log Search rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ruleName The name of the rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the LogSearchRuleResourceInner object if successful.
     */
    public LogSearchRuleResourceInner getByResourceGroup(String resourceGroupName, String ruleName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, ruleName).toBlocking().single().body();
    }

    /**
     * Gets an Log Search rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ruleName The name of the rule.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<LogSearchRuleResourceInner> getByResourceGroupAsync(String resourceGroupName, String ruleName, final ServiceCallback<LogSearchRuleResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, ruleName), serviceCallback);
    }

    /**
     * Gets an Log Search rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ruleName The name of the rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the LogSearchRuleResourceInner object
     */
    public Observable<LogSearchRuleResourceInner> getByResourceGroupAsync(String resourceGroupName, String ruleName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, ruleName).map(new Func1<ServiceResponse<LogSearchRuleResourceInner>, LogSearchRuleResourceInner>() {
            @Override
            public LogSearchRuleResourceInner call(ServiceResponse<LogSearchRuleResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets an Log Search rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ruleName The name of the rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the LogSearchRuleResourceInner object
     */
    public Observable<ServiceResponse<LogSearchRuleResourceInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String ruleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-04-16";
        return service.getByResourceGroup(resourceGroupName, ruleName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<LogSearchRuleResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<LogSearchRuleResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<LogSearchRuleResourceInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<LogSearchRuleResourceInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<LogSearchRuleResourceInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<LogSearchRuleResourceInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Update log search Rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ruleName The name of the rule.
     * @param parameters The parameters of the rule to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the LogSearchRuleResourceInner object if successful.
     */
    public LogSearchRuleResourceInner update(String resourceGroupName, String ruleName, LogSearchRuleResourcePatch parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, ruleName, parameters).toBlocking().single().body();
    }

    /**
     * Update log search Rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ruleName The name of the rule.
     * @param parameters The parameters of the rule to update.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<LogSearchRuleResourceInner> updateAsync(String resourceGroupName, String ruleName, LogSearchRuleResourcePatch parameters, final ServiceCallback<LogSearchRuleResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, ruleName, parameters), serviceCallback);
    }

    /**
     * Update log search Rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ruleName The name of the rule.
     * @param parameters The parameters of the rule to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the LogSearchRuleResourceInner object
     */
    public Observable<LogSearchRuleResourceInner> updateAsync(String resourceGroupName, String ruleName, LogSearchRuleResourcePatch parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, ruleName, parameters).map(new Func1<ServiceResponse<LogSearchRuleResourceInner>, LogSearchRuleResourceInner>() {
            @Override
            public LogSearchRuleResourceInner call(ServiceResponse<LogSearchRuleResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update log search Rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ruleName The name of the rule.
     * @param parameters The parameters of the rule to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the LogSearchRuleResourceInner object
     */
    public Observable<ServiceResponse<LogSearchRuleResourceInner>> updateWithServiceResponseAsync(String resourceGroupName, String ruleName, LogSearchRuleResourcePatch parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2018-04-16";
        return service.update(this.client.subscriptionId(), resourceGroupName, ruleName, apiVersion, parameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<LogSearchRuleResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<LogSearchRuleResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<LogSearchRuleResourceInner> clientResponse = updateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<LogSearchRuleResourceInner> updateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<LogSearchRuleResourceInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<LogSearchRuleResourceInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes a Log Search rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ruleName The name of the rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String ruleName) {
        deleteWithServiceResponseAsync(resourceGroupName, ruleName).toBlocking().single().body();
    }

    /**
     * Deletes a Log Search rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ruleName The name of the rule.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String ruleName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, ruleName), serviceCallback);
    }

    /**
     * Deletes a Log Search rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ruleName The name of the rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String ruleName) {
        return deleteWithServiceResponseAsync(resourceGroupName, ruleName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a Log Search rule.
     *
     * @param resourceGroupName The name of the resource group.
     * @param ruleName The name of the rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String ruleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-04-16";
        return service.delete(resourceGroupName, ruleName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * List the Log Search rules within a subscription group.
     *
     * @return the PagedList<LogSearchRuleResourceInner> object if successful.
     */
    public PagedList<LogSearchRuleResourceInner> list() {
        PageImpl1<LogSearchRuleResourceInner> page = new PageImpl1<>();
        page.setItems(listWithServiceResponseAsync().toBlocking().single().body());
        page.setNextPageLink(null);
        return new PagedList<LogSearchRuleResourceInner>(page) {
            @Override
            public Page<LogSearchRuleResourceInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    /**
     * List the Log Search rules within a subscription group.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<LogSearchRuleResourceInner>> listAsync(final ServiceCallback<List<LogSearchRuleResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listWithServiceResponseAsync(), serviceCallback);
    }

    /**
     * List the Log Search rules within a subscription group.
     *
     * @return the observable to the List&lt;LogSearchRuleResourceInner&gt; object
     */
    public Observable<Page<LogSearchRuleResourceInner>> listAsync() {
        return listWithServiceResponseAsync().map(new Func1<ServiceResponse<List<LogSearchRuleResourceInner>>, Page<LogSearchRuleResourceInner>>() {
            @Override
            public Page<LogSearchRuleResourceInner> call(ServiceResponse<List<LogSearchRuleResourceInner>> response) {
                PageImpl1<LogSearchRuleResourceInner> page = new PageImpl1<>();
                page.setItems(response.body());
                return page;
            }
        });
    }

    /**
     * List the Log Search rules within a subscription group.
     *
     * @return the observable to the List&lt;LogSearchRuleResourceInner&gt; object
     */
    public Observable<ServiceResponse<List<LogSearchRuleResourceInner>>> listWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-04-16";
        final String filter = null;
        return service.list(this.client.subscriptionId(), apiVersion, filter, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<LogSearchRuleResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<LogSearchRuleResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<LogSearchRuleResourceInner>> result = listDelegate(response);
                        List<LogSearchRuleResourceInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<LogSearchRuleResourceInner>> clientResponse = new ServiceResponse<List<LogSearchRuleResourceInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * List the Log Search rules within a subscription group.
     *
     * @param filter The filter to apply on the operation. For more information please see https://msdn.microsoft.com/en-us/library/azure/dn931934.aspx
     * @return the PagedList<LogSearchRuleResourceInner> object if successful.
     */
    public PagedList<LogSearchRuleResourceInner> list(String filter) {
        PageImpl1<LogSearchRuleResourceInner> page = new PageImpl1<>();
        page.setItems(listWithServiceResponseAsync(filter).toBlocking().single().body());
        page.setNextPageLink(null);
        return new PagedList<LogSearchRuleResourceInner>(page) {
            @Override
            public Page<LogSearchRuleResourceInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    /**
     * List the Log Search rules within a subscription group.
     *
     * @param filter The filter to apply on the operation. For more information please see https://msdn.microsoft.com/en-us/library/azure/dn931934.aspx
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<LogSearchRuleResourceInner>> listAsync(String filter, final ServiceCallback<List<LogSearchRuleResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listWithServiceResponseAsync(filter), serviceCallback);
    }

    /**
     * List the Log Search rules within a subscription group.
     *
     * @param filter The filter to apply on the operation. For more information please see https://msdn.microsoft.com/en-us/library/azure/dn931934.aspx
     * @return the observable to the List&lt;LogSearchRuleResourceInner&gt; object
     */
    public Observable<Page<LogSearchRuleResourceInner>> listAsync(String filter) {
        return listWithServiceResponseAsync(filter).map(new Func1<ServiceResponse<List<LogSearchRuleResourceInner>>, Page<LogSearchRuleResourceInner>>() {
            @Override
            public Page<LogSearchRuleResourceInner> call(ServiceResponse<List<LogSearchRuleResourceInner>> response) {
                PageImpl1<LogSearchRuleResourceInner> page = new PageImpl1<>();
                page.setItems(response.body());
                return page;
            }
        });
    }

    /**
     * List the Log Search rules within a subscription group.
     *
     * @param filter The filter to apply on the operation. For more information please see https://msdn.microsoft.com/en-us/library/azure/dn931934.aspx
     * @return the observable to the List&lt;LogSearchRuleResourceInner&gt; object
     */
    public Observable<ServiceResponse<List<LogSearchRuleResourceInner>>> listWithServiceResponseAsync(String filter) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-04-16";
        return service.list(this.client.subscriptionId(), apiVersion, filter, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<LogSearchRuleResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<LogSearchRuleResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<LogSearchRuleResourceInner>> result = listDelegate(response);
                        List<LogSearchRuleResourceInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<LogSearchRuleResourceInner>> clientResponse = new ServiceResponse<List<LogSearchRuleResourceInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<LogSearchRuleResourceInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<LogSearchRuleResourceInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<LogSearchRuleResourceInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * List the Log Search rules within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @return the PagedList<LogSearchRuleResourceInner> object if successful.
     */
    public PagedList<LogSearchRuleResourceInner> listByResourceGroup(String resourceGroupName) {
        PageImpl1<LogSearchRuleResourceInner> page = new PageImpl1<>();
        page.setItems(listByResourceGroupWithServiceResponseAsync(resourceGroupName).toBlocking().single().body());
        page.setNextPageLink(null);
        return new PagedList<LogSearchRuleResourceInner>(page) {
            @Override
            public Page<LogSearchRuleResourceInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    /**
     * List the Log Search rules within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<LogSearchRuleResourceInner>> listByResourceGroupAsync(String resourceGroupName, final ServiceCallback<List<LogSearchRuleResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listByResourceGroupWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    /**
     * List the Log Search rules within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @return the observable to the List&lt;LogSearchRuleResourceInner&gt; object
     */
    public Observable<Page<LogSearchRuleResourceInner>> listByResourceGroupAsync(String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName).map(new Func1<ServiceResponse<List<LogSearchRuleResourceInner>>, Page<LogSearchRuleResourceInner>>() {
            @Override
            public Page<LogSearchRuleResourceInner> call(ServiceResponse<List<LogSearchRuleResourceInner>> response) {
                PageImpl1<LogSearchRuleResourceInner> page = new PageImpl1<>();
                page.setItems(response.body());
                return page;
            }
        });
    }

    /**
     * List the Log Search rules within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @return the observable to the List&lt;LogSearchRuleResourceInner&gt; object
     */
    public Observable<ServiceResponse<List<LogSearchRuleResourceInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-04-16";
        final String filter = null;
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), apiVersion, filter, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<LogSearchRuleResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<LogSearchRuleResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<LogSearchRuleResourceInner>> result = listByResourceGroupDelegate(response);
                        List<LogSearchRuleResourceInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<LogSearchRuleResourceInner>> clientResponse = new ServiceResponse<List<LogSearchRuleResourceInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * List the Log Search rules within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param filter The filter to apply on the operation. For more information please see https://msdn.microsoft.com/en-us/library/azure/dn931934.aspx
     * @return the PagedList<LogSearchRuleResourceInner> object if successful.
     */
    public PagedList<LogSearchRuleResourceInner> listByResourceGroup(String resourceGroupName, String filter) {
        PageImpl1<LogSearchRuleResourceInner> page = new PageImpl1<>();
        page.setItems(listByResourceGroupWithServiceResponseAsync(resourceGroupName, filter).toBlocking().single().body());
        page.setNextPageLink(null);
        return new PagedList<LogSearchRuleResourceInner>(page) {
            @Override
            public Page<LogSearchRuleResourceInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    /**
     * List the Log Search rules within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param filter The filter to apply on the operation. For more information please see https://msdn.microsoft.com/en-us/library/azure/dn931934.aspx
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<LogSearchRuleResourceInner>> listByResourceGroupAsync(String resourceGroupName, String filter, final ServiceCallback<List<LogSearchRuleResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listByResourceGroupWithServiceResponseAsync(resourceGroupName, filter), serviceCallback);
    }

    /**
     * List the Log Search rules within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param filter The filter to apply on the operation. For more information please see https://msdn.microsoft.com/en-us/library/azure/dn931934.aspx
     * @return the observable to the List&lt;LogSearchRuleResourceInner&gt; object
     */
    public Observable<Page<LogSearchRuleResourceInner>> listByResourceGroupAsync(String resourceGroupName, String filter) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName, filter).map(new Func1<ServiceResponse<List<LogSearchRuleResourceInner>>, Page<LogSearchRuleResourceInner>>() {
            @Override
            public Page<LogSearchRuleResourceInner> call(ServiceResponse<List<LogSearchRuleResourceInner>> response) {
                PageImpl1<LogSearchRuleResourceInner> page = new PageImpl1<>();
                page.setItems(response.body());
                return page;
            }
        });
    }

    /**
     * List the Log Search rules within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param filter The filter to apply on the operation. For more information please see https://msdn.microsoft.com/en-us/library/azure/dn931934.aspx
     * @return the observable to the List&lt;LogSearchRuleResourceInner&gt; object
     */
    public Observable<ServiceResponse<List<LogSearchRuleResourceInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName, String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-04-16";
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), apiVersion, filter, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<LogSearchRuleResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<LogSearchRuleResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<LogSearchRuleResourceInner>> result = listByResourceGroupDelegate(response);
                        List<LogSearchRuleResourceInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<LogSearchRuleResourceInner>> clientResponse = new ServiceResponse<List<LogSearchRuleResourceInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<LogSearchRuleResourceInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<LogSearchRuleResourceInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<LogSearchRuleResourceInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

}
