/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for BaselineSensitivity.
 */
public final class BaselineSensitivity extends ExpandableStringEnum<BaselineSensitivity> {
    /** Static value Low for BaselineSensitivity. */
    public static final BaselineSensitivity LOW = fromString("Low");

    /** Static value Medium for BaselineSensitivity. */
    public static final BaselineSensitivity MEDIUM = fromString("Medium");

    /** Static value High for BaselineSensitivity. */
    public static final BaselineSensitivity HIGH = fromString("High");

    /**
     * Creates or finds a BaselineSensitivity from its string representation.
     * @param name a name to look for
     * @return the corresponding BaselineSensitivity
     */
    @JsonCreator
    public static BaselineSensitivity fromString(String name) {
        return fromString(name, BaselineSensitivity.class);
    }

    /**
     * @return known BaselineSensitivity values
     */
    public static Collection<BaselineSensitivity> values() {
        return values(BaselineSensitivity.class);
    }
}
