/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonTypeResolver;

/**
 * Specifies the action to send email when the rule condition is evaluated. The
 * discriminator is always RuleEmailAction in this case.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "odata.type")
@JsonTypeName("Microsoft.Azure.Management.Insights.Models.RuleEmailAction")
@JsonTypeResolver(OdataTypeDiscriminatorTypeResolver.class)
public class RuleEmailAction extends RuleAction {
    /**
     * Whether the administrators (service and co-administrators) of the
     * service should be notified when the alert is activated.
     */
    @JsonProperty(value = "sendToServiceOwners")
    private Boolean sendToServiceOwners;

    /**
     * the list of administrator's custom email addresses to notify of the
     * activation of the alert.
     */
    @JsonProperty(value = "customEmails")
    private List<String> customEmails;

    /**
     * Get whether the administrators (service and co-administrators) of the service should be notified when the alert is activated.
     *
     * @return the sendToServiceOwners value
     */
    public Boolean sendToServiceOwners() {
        return this.sendToServiceOwners;
    }

    /**
     * Set whether the administrators (service and co-administrators) of the service should be notified when the alert is activated.
     *
     * @param sendToServiceOwners the sendToServiceOwners value to set
     * @return the RuleEmailAction object itself.
     */
    public RuleEmailAction withSendToServiceOwners(Boolean sendToServiceOwners) {
        this.sendToServiceOwners = sendToServiceOwners;
        return this;
    }

    /**
     * Get the list of administrator's custom email addresses to notify of the activation of the alert.
     *
     * @return the customEmails value
     */
    public List<String> customEmails() {
        return this.customEmails;
    }

    /**
     * Set the list of administrator's custom email addresses to notify of the activation of the alert.
     *
     * @param customEmails the customEmails value to set
     * @return the RuleEmailAction object itself.
     */
    public RuleEmailAction withCustomEmails(List<String> customEmails) {
        this.customEmails = customEmails;
        return this;
    }

}
