/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * An Itsm receiver.
 */
public class ItsmReceiver {
    /**
     * The name of the Itsm receiver. Names must be unique across all receivers
     * within an action group.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /**
     * OMS LA instance identifier.
     */
    @JsonProperty(value = "workspaceId", required = true)
    private String workspaceId;

    /**
     * Unique identification of ITSM connection among multiple defined in above
     * workspace.
     */
    @JsonProperty(value = "connectionId", required = true)
    private String connectionId;

    /**
     * JSON blob for the configurations of the ITSM action.
     * CreateMultipleWorkItems option will be part of this blob as well.
     */
    @JsonProperty(value = "ticketConfiguration", required = true)
    private String ticketConfiguration;

    /**
     * Region in which workspace resides. Supported
     * values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'.
     */
    @JsonProperty(value = "region", required = true)
    private String region;

    /**
     * Get the name of the Itsm receiver. Names must be unique across all receivers within an action group.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name of the Itsm receiver. Names must be unique across all receivers within an action group.
     *
     * @param name the name value to set
     * @return the ItsmReceiver object itself.
     */
    public ItsmReceiver withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get oMS LA instance identifier.
     *
     * @return the workspaceId value
     */
    public String workspaceId() {
        return this.workspaceId;
    }

    /**
     * Set oMS LA instance identifier.
     *
     * @param workspaceId the workspaceId value to set
     * @return the ItsmReceiver object itself.
     */
    public ItsmReceiver withWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    /**
     * Get unique identification of ITSM connection among multiple defined in above workspace.
     *
     * @return the connectionId value
     */
    public String connectionId() {
        return this.connectionId;
    }

    /**
     * Set unique identification of ITSM connection among multiple defined in above workspace.
     *
     * @param connectionId the connectionId value to set
     * @return the ItsmReceiver object itself.
     */
    public ItsmReceiver withConnectionId(String connectionId) {
        this.connectionId = connectionId;
        return this;
    }

    /**
     * Get jSON blob for the configurations of the ITSM action. CreateMultipleWorkItems option will be part of this blob as well.
     *
     * @return the ticketConfiguration value
     */
    public String ticketConfiguration() {
        return this.ticketConfiguration;
    }

    /**
     * Set jSON blob for the configurations of the ITSM action. CreateMultipleWorkItems option will be part of this blob as well.
     *
     * @param ticketConfiguration the ticketConfiguration value to set
     * @return the ItsmReceiver object itself.
     */
    public ItsmReceiver withTicketConfiguration(String ticketConfiguration) {
        this.ticketConfiguration = ticketConfiguration;
        return this;
    }

    /**
     * Get region in which workspace resides. Supported values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'.
     *
     * @return the region value
     */
    public String region() {
        return this.region;
    }

    /**
     * Set region in which workspace resides. Supported values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'.
     *
     * @param region the region value to set
     * @return the ItsmReceiver object itself.
     */
    public ItsmReceiver withRegion(String region) {
        this.region = region;
        return this;
    }

}
