/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The minimum number of violations required within the selected lookback time
 * window required to raise an alert.
 */
public class DynamicThresholdFailingPeriods {
    /**
     * The number of aggregated lookback points. The lookback time window is
     * calculated based on the aggregation granularity (windowSize) and the
     * selected number of aggregated points.
     */
    @JsonProperty(value = "numberOfEvaluationPeriods", required = true)
    private double numberOfEvaluationPeriods;

    /**
     * The number of violations to trigger an alert. Should be smaller or equal
     * to numberOfEvaluationPeriods.
     */
    @JsonProperty(value = "minFailingPeriodsToAlert", required = true)
    private double minFailingPeriodsToAlert;

    /**
     * Get the number of aggregated lookback points. The lookback time window is calculated based on the aggregation granularity (windowSize) and the selected number of aggregated points.
     *
     * @return the numberOfEvaluationPeriods value
     */
    public double numberOfEvaluationPeriods() {
        return this.numberOfEvaluationPeriods;
    }

    /**
     * Set the number of aggregated lookback points. The lookback time window is calculated based on the aggregation granularity (windowSize) and the selected number of aggregated points.
     *
     * @param numberOfEvaluationPeriods the numberOfEvaluationPeriods value to set
     * @return the DynamicThresholdFailingPeriods object itself.
     */
    public DynamicThresholdFailingPeriods withNumberOfEvaluationPeriods(double numberOfEvaluationPeriods) {
        this.numberOfEvaluationPeriods = numberOfEvaluationPeriods;
        return this;
    }

    /**
     * Get the number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods.
     *
     * @return the minFailingPeriodsToAlert value
     */
    public double minFailingPeriodsToAlert() {
        return this.minFailingPeriodsToAlert;
    }

    /**
     * Set the number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods.
     *
     * @param minFailingPeriodsToAlert the minFailingPeriodsToAlert value to set
     * @return the DynamicThresholdFailingPeriods object itself.
     */
    public DynamicThresholdFailingPeriods withMinFailingPeriodsToAlert(double minFailingPeriodsToAlert) {
        this.minFailingPeriodsToAlert = minFailingPeriodsToAlert;
        return this;
    }

}
