/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.monitor.ActivityLogAlertPatchBody;
import com.microsoft.azure.management.monitor.ErrorResponseException;
import com.microsoft.azure.management.monitor.implementation.ActivityLogAlertResourceInner;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.azure.management.monitor.implementation.PageImpl1;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ActivityLogAlertsInner
implements InnerSupportsGet<ActivityLogAlertResourceInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<ActivityLogAlertResourceInner> {
    private ActivityLogAlertsService service;
    private MonitorManagementClientImpl client;

    public ActivityLogAlertsInner(Retrofit retrofit, MonitorManagementClientImpl client) {
        this.service = (ActivityLogAlertsService)retrofit.create(ActivityLogAlertsService.class);
        this.client = client;
    }

    public ActivityLogAlertResourceInner createOrUpdate(String resourceGroupName, String activityLogAlertName, ActivityLogAlertResourceInner activityLogAlert) {
        return (ActivityLogAlertResourceInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, activityLogAlertName, activityLogAlert).toBlocking().single()).body());
    }

    public ServiceFuture<ActivityLogAlertResourceInner> createOrUpdateAsync(String resourceGroupName, String activityLogAlertName, ActivityLogAlertResourceInner activityLogAlert, ServiceCallback<ActivityLogAlertResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, activityLogAlertName, activityLogAlert), serviceCallback);
    }

    public Observable<ActivityLogAlertResourceInner> createOrUpdateAsync(String resourceGroupName, String activityLogAlertName, ActivityLogAlertResourceInner activityLogAlert) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, activityLogAlertName, activityLogAlert).map((Func1)new Func1<ServiceResponse<ActivityLogAlertResourceInner>, ActivityLogAlertResourceInner>(){

            public ActivityLogAlertResourceInner call(ServiceResponse<ActivityLogAlertResourceInner> response) {
                return (ActivityLogAlertResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ActivityLogAlertResourceInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String activityLogAlertName, ActivityLogAlertResourceInner activityLogAlert) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (activityLogAlertName == null) {
            throw new IllegalArgumentException("Parameter activityLogAlertName is required and cannot be null.");
        }
        if (activityLogAlert == null) {
            throw new IllegalArgumentException("Parameter activityLogAlert is required and cannot be null.");
        }
        Validator.validate((Object)((Object)activityLogAlert));
        String apiVersion = "2017-04-01";
        return this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, activityLogAlertName, "2017-04-01", activityLogAlert, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ActivityLogAlertResourceInner>>>(){

            public Observable<ServiceResponse<ActivityLogAlertResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ActivityLogAlertsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ActivityLogAlertResourceInner> createOrUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ActivityLogAlertResourceInner>(){}.getType()).register(201, new TypeToken<ActivityLogAlertResourceInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public ActivityLogAlertResourceInner getByResourceGroup(String resourceGroupName, String activityLogAlertName) {
        return (ActivityLogAlertResourceInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, activityLogAlertName).toBlocking().single()).body());
    }

    public ServiceFuture<ActivityLogAlertResourceInner> getByResourceGroupAsync(String resourceGroupName, String activityLogAlertName, ServiceCallback<ActivityLogAlertResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, activityLogAlertName), serviceCallback);
    }

    public Observable<ActivityLogAlertResourceInner> getByResourceGroupAsync(String resourceGroupName, String activityLogAlertName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, activityLogAlertName).map((Func1)new Func1<ServiceResponse<ActivityLogAlertResourceInner>, ActivityLogAlertResourceInner>(){

            public ActivityLogAlertResourceInner call(ServiceResponse<ActivityLogAlertResourceInner> response) {
                return (ActivityLogAlertResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ActivityLogAlertResourceInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String activityLogAlertName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (activityLogAlertName == null) {
            throw new IllegalArgumentException("Parameter activityLogAlertName is required and cannot be null.");
        }
        String apiVersion = "2017-04-01";
        return this.service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, activityLogAlertName, "2017-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ActivityLogAlertResourceInner>>>(){

            public Observable<ServiceResponse<ActivityLogAlertResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ActivityLogAlertsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ActivityLogAlertResourceInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ActivityLogAlertResourceInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String activityLogAlertName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, activityLogAlertName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String activityLogAlertName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, activityLogAlertName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String activityLogAlertName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, activityLogAlertName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String activityLogAlertName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (activityLogAlertName == null) {
            throw new IllegalArgumentException("Parameter activityLogAlertName is required and cannot be null.");
        }
        String apiVersion = "2017-04-01";
        return this.service.delete(this.client.subscriptionId(), resourceGroupName, activityLogAlertName, "2017-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ActivityLogAlertsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public ActivityLogAlertResourceInner update(String resourceGroupName, String activityLogAlertName, ActivityLogAlertPatchBody activityLogAlertPatch) {
        return (ActivityLogAlertResourceInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, activityLogAlertName, activityLogAlertPatch).toBlocking().single()).body());
    }

    public ServiceFuture<ActivityLogAlertResourceInner> updateAsync(String resourceGroupName, String activityLogAlertName, ActivityLogAlertPatchBody activityLogAlertPatch, ServiceCallback<ActivityLogAlertResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, activityLogAlertName, activityLogAlertPatch), serviceCallback);
    }

    public Observable<ActivityLogAlertResourceInner> updateAsync(String resourceGroupName, String activityLogAlertName, ActivityLogAlertPatchBody activityLogAlertPatch) {
        return this.updateWithServiceResponseAsync(resourceGroupName, activityLogAlertName, activityLogAlertPatch).map((Func1)new Func1<ServiceResponse<ActivityLogAlertResourceInner>, ActivityLogAlertResourceInner>(){

            public ActivityLogAlertResourceInner call(ServiceResponse<ActivityLogAlertResourceInner> response) {
                return (ActivityLogAlertResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ActivityLogAlertResourceInner>> updateWithServiceResponseAsync(String resourceGroupName, String activityLogAlertName, ActivityLogAlertPatchBody activityLogAlertPatch) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (activityLogAlertName == null) {
            throw new IllegalArgumentException("Parameter activityLogAlertName is required and cannot be null.");
        }
        if (activityLogAlertPatch == null) {
            throw new IllegalArgumentException("Parameter activityLogAlertPatch is required and cannot be null.");
        }
        Validator.validate((Object)activityLogAlertPatch);
        String apiVersion = "2017-04-01";
        return this.service.update(this.client.subscriptionId(), resourceGroupName, activityLogAlertName, "2017-04-01", activityLogAlertPatch, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ActivityLogAlertResourceInner>>>(){

            public Observable<ServiceResponse<ActivityLogAlertResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ActivityLogAlertsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ActivityLogAlertResourceInner> updateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ActivityLogAlertResourceInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<ActivityLogAlertResourceInner> list() {
        PageImpl1 page = new PageImpl1();
        page.setItems((List)((ServiceResponse)this.listWithServiceResponseAsync().toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<ActivityLogAlertResourceInner>(page){

            public Page<ActivityLogAlertResourceInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<ActivityLogAlertResourceInner>> listAsync(ServiceCallback<List<ActivityLogAlertResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<Page<ActivityLogAlertResourceInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<ActivityLogAlertResourceInner>>, Page<ActivityLogAlertResourceInner>>(){

            public Page<ActivityLogAlertResourceInner> call(ServiceResponse<List<ActivityLogAlertResourceInner>> response) {
                PageImpl1<ActivityLogAlertResourceInner> page = new PageImpl1<ActivityLogAlertResourceInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<ActivityLogAlertResourceInner>>> listWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-04-01";
        return this.service.list(this.client.subscriptionId(), "2017-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ActivityLogAlertResourceInner>>>>(){

            public Observable<ServiceResponse<List<ActivityLogAlertResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ActivityLogAlertsInner.this.listDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ActivityLogAlertResourceInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ActivityLogAlertResourceInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<ActivityLogAlertResourceInner> listByResourceGroup(String resourceGroupName) {
        PageImpl1 page = new PageImpl1();
        page.setItems((List)((ServiceResponse)this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<ActivityLogAlertResourceInner>(page){

            public Page<ActivityLogAlertResourceInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<ActivityLogAlertResourceInner>> listByResourceGroupAsync(String resourceGroupName, ServiceCallback<List<ActivityLogAlertResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByResourceGroupWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    public Observable<Page<ActivityLogAlertResourceInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<List<ActivityLogAlertResourceInner>>, Page<ActivityLogAlertResourceInner>>(){

            public Page<ActivityLogAlertResourceInner> call(ServiceResponse<List<ActivityLogAlertResourceInner>> response) {
                PageImpl1<ActivityLogAlertResourceInner> page = new PageImpl1<ActivityLogAlertResourceInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<ActivityLogAlertResourceInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        String apiVersion = "2017-04-01";
        return this.service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, "2017-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ActivityLogAlertResourceInner>>>>(){

            public Observable<ServiceResponse<List<ActivityLogAlertResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ActivityLogAlertsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ActivityLogAlertResourceInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ActivityLogAlertResourceInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface ActivityLogAlertsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ActivityLogAlerts createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/activityLogAlerts/{activityLogAlertName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="activityLogAlertName") String var3, @Query(value="api-version") String var4, @Body ActivityLogAlertResourceInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ActivityLogAlerts getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/activityLogAlerts/{activityLogAlertName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="activityLogAlertName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ActivityLogAlerts delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/activityLogAlerts/{activityLogAlertName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="activityLogAlertName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ActivityLogAlerts update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/activityLogAlerts/{activityLogAlertName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="activityLogAlertName") String var3, @Query(value="api-version") String var4, @Body ActivityLogAlertPatchBody var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ActivityLogAlerts list"})
        @GET(value="subscriptions/{subscriptionId}/providers/microsoft.insights/activityLogAlerts")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ActivityLogAlerts listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/activityLogAlerts")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);
    }
}

