/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.monitor.ErrorResponseException;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in MetricNamespaces.
 */
public class MetricNamespacesInner {
    /** The Retrofit service to perform REST calls. */
    private MetricNamespacesService service;
    /** The service client containing this operation class. */
    private MonitorManagementClientImpl client;

    /**
     * Initializes an instance of MetricNamespacesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public MetricNamespacesInner(Retrofit retrofit, MonitorManagementClientImpl client) {
        this.service = retrofit.create(MetricNamespacesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for MetricNamespaces to be
     * used by Retrofit to perform actually REST calls.
     */
    interface MetricNamespacesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.MetricNamespaces list" })
        @GET("{resourceUri}/providers/microsoft.insights/metricNamespaces")
        Observable<Response<ResponseBody>> list(@Path(value = "resourceUri", encoded = true) String resourceUri, @Query("api-version") String apiVersion, @Query("startTime") String startTime, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists the metric namespaces for the resource.
     *
     * @param resourceUri The identifier of the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;MetricNamespaceInner&gt; object if successful.
     */
    public List<MetricNamespaceInner> list(String resourceUri) {
        return listWithServiceResponseAsync(resourceUri).toBlocking().single().body();
    }

    /**
     * Lists the metric namespaces for the resource.
     *
     * @param resourceUri The identifier of the resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<MetricNamespaceInner>> listAsync(String resourceUri, final ServiceCallback<List<MetricNamespaceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listWithServiceResponseAsync(resourceUri), serviceCallback);
    }

    /**
     * Lists the metric namespaces for the resource.
     *
     * @param resourceUri The identifier of the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;MetricNamespaceInner&gt; object
     */
    public Observable<List<MetricNamespaceInner>> listAsync(String resourceUri) {
        return listWithServiceResponseAsync(resourceUri).map(new Func1<ServiceResponse<List<MetricNamespaceInner>>, List<MetricNamespaceInner>>() {
            @Override
            public List<MetricNamespaceInner> call(ServiceResponse<List<MetricNamespaceInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Lists the metric namespaces for the resource.
     *
     * @param resourceUri The identifier of the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;MetricNamespaceInner&gt; object
     */
    public Observable<ServiceResponse<List<MetricNamespaceInner>>> listWithServiceResponseAsync(String resourceUri) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        final String apiVersion = "2017-12-01-preview";
        final String startTime = null;
        return service.list(resourceUri, apiVersion, startTime, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MetricNamespaceInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<MetricNamespaceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<MetricNamespaceInner>> result = listDelegate(response);
                        List<MetricNamespaceInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<MetricNamespaceInner>> clientResponse = new ServiceResponse<List<MetricNamespaceInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Lists the metric namespaces for the resource.
     *
     * @param resourceUri The identifier of the resource.
     * @param startTime The ISO 8601 conform Date start time from which to query for metric namespaces.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;MetricNamespaceInner&gt; object if successful.
     */
    public List<MetricNamespaceInner> list(String resourceUri, String startTime) {
        return listWithServiceResponseAsync(resourceUri, startTime).toBlocking().single().body();
    }

    /**
     * Lists the metric namespaces for the resource.
     *
     * @param resourceUri The identifier of the resource.
     * @param startTime The ISO 8601 conform Date start time from which to query for metric namespaces.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<MetricNamespaceInner>> listAsync(String resourceUri, String startTime, final ServiceCallback<List<MetricNamespaceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listWithServiceResponseAsync(resourceUri, startTime), serviceCallback);
    }

    /**
     * Lists the metric namespaces for the resource.
     *
     * @param resourceUri The identifier of the resource.
     * @param startTime The ISO 8601 conform Date start time from which to query for metric namespaces.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;MetricNamespaceInner&gt; object
     */
    public Observable<List<MetricNamespaceInner>> listAsync(String resourceUri, String startTime) {
        return listWithServiceResponseAsync(resourceUri, startTime).map(new Func1<ServiceResponse<List<MetricNamespaceInner>>, List<MetricNamespaceInner>>() {
            @Override
            public List<MetricNamespaceInner> call(ServiceResponse<List<MetricNamespaceInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Lists the metric namespaces for the resource.
     *
     * @param resourceUri The identifier of the resource.
     * @param startTime The ISO 8601 conform Date start time from which to query for metric namespaces.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;MetricNamespaceInner&gt; object
     */
    public Observable<ServiceResponse<List<MetricNamespaceInner>>> listWithServiceResponseAsync(String resourceUri, String startTime) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        final String apiVersion = "2017-12-01-preview";
        return service.list(resourceUri, apiVersion, startTime, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MetricNamespaceInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<MetricNamespaceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<MetricNamespaceInner>> result = listDelegate(response);
                        List<MetricNamespaceInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<MetricNamespaceInner>> clientResponse = new ServiceResponse<List<MetricNamespaceInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<MetricNamespaceInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<MetricNamespaceInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<MetricNamespaceInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

}
