/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * An SMS receiver.
 */
public class SmsReceiver {
    /**
     * The name of the SMS receiver. Names must be unique across all receivers
     * within an action group.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /**
     * The country code of the SMS receiver.
     */
    @JsonProperty(value = "countryCode", required = true)
    private String countryCode;

    /**
     * The phone number of the SMS receiver.
     */
    @JsonProperty(value = "phoneNumber", required = true)
    private String phoneNumber;

    /**
     * The status of the receiver. Possible values include: 'NotSpecified',
     * 'Enabled', 'Disabled'.
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private ReceiverStatus status;

    /**
     * Get the name of the SMS receiver. Names must be unique across all receivers within an action group.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name of the SMS receiver. Names must be unique across all receivers within an action group.
     *
     * @param name the name value to set
     * @return the SmsReceiver object itself.
     */
    public SmsReceiver withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the country code of the SMS receiver.
     *
     * @return the countryCode value
     */
    public String countryCode() {
        return this.countryCode;
    }

    /**
     * Set the country code of the SMS receiver.
     *
     * @param countryCode the countryCode value to set
     * @return the SmsReceiver object itself.
     */
    public SmsReceiver withCountryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    /**
     * Get the phone number of the SMS receiver.
     *
     * @return the phoneNumber value
     */
    public String phoneNumber() {
        return this.phoneNumber;
    }

    /**
     * Set the phone number of the SMS receiver.
     *
     * @param phoneNumber the phoneNumber value to set
     * @return the SmsReceiver object itself.
     */
    public SmsReceiver withPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    /**
     * Get the status of the receiver. Possible values include: 'NotSpecified', 'Enabled', 'Disabled'.
     *
     * @return the status value
     */
    public ReceiverStatus status() {
        return this.status;
    }

}
