/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A rule metric data source. The discriminator value is always
 * RuleMetricDataSource in this case.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "odata.type")
@JsonTypeName("Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource")
public class RuleMetricDataSource extends RuleDataSource {
    /**
     * the name of the metric that defines what the rule monitors.
     */
    @JsonProperty(value = "metricName")
    private String metricName;

    /**
     * Get the name of the metric that defines what the rule monitors.
     *
     * @return the metricName value
     */
    public String metricName() {
        return this.metricName;
    }

    /**
     * Set the name of the metric that defines what the rule monitors.
     *
     * @param metricName the metricName value to set
     * @return the RuleMetricDataSource object itself.
     */
    public RuleMetricDataSource withMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

}
