/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.keyvault.implementation;

import com.microsoft.azure.CloudException;
import com.microsoft.azure.Resource;
import com.microsoft.azure.keyvault.KeyVaultClient;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryUser;
import com.microsoft.azure.management.graphrbac.ServicePrincipal;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.keyvault.AccessPolicy;
import com.microsoft.azure.management.keyvault.AccessPolicyEntry;
import com.microsoft.azure.management.keyvault.CreateMode;
import com.microsoft.azure.management.keyvault.IPRule;
import com.microsoft.azure.management.keyvault.Keys;
import com.microsoft.azure.management.keyvault.NetworkRuleAction;
import com.microsoft.azure.management.keyvault.NetworkRuleBypassOptions;
import com.microsoft.azure.management.keyvault.NetworkRuleSet;
import com.microsoft.azure.management.keyvault.Secrets;
import com.microsoft.azure.management.keyvault.Sku;
import com.microsoft.azure.management.keyvault.SkuName;
import com.microsoft.azure.management.keyvault.Vault;
import com.microsoft.azure.management.keyvault.VaultCreateOrUpdateParameters;
import com.microsoft.azure.management.keyvault.VaultProperties;
import com.microsoft.azure.management.keyvault.VirtualNetworkRule;
import com.microsoft.azure.management.keyvault.implementation.AccessPolicyImpl;
import com.microsoft.azure.management.keyvault.implementation.KeyVaultManagementClientImpl;
import com.microsoft.azure.management.keyvault.implementation.KeyVaultManager;
import com.microsoft.azure.management.keyvault.implementation.KeysImpl;
import com.microsoft.azure.management.keyvault.implementation.SecretsImpl;
import com.microsoft.azure.management.keyvault.implementation.VaultInner;
import com.microsoft.azure.management.keyvault.implementation.VaultsInner;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.functions.FuncN;

@LangDefinition
class VaultImpl
extends GroupableResourceImpl<Vault, VaultInner, VaultImpl, KeyVaultManager>
implements Vault,
Vault.Definition,
Vault.Update {
    private GraphRbacManager graphRbacManager;
    private List<AccessPolicyImpl> accessPolicies;
    private KeyVaultClient client;
    private Keys keys;
    private Secrets secrets;

    VaultImpl(String key, VaultInner innerObject, KeyVaultManager manager, GraphRbacManager graphRbacManager) {
        super(key, (Resource)innerObject, (ManagerBase)manager);
        this.graphRbacManager = graphRbacManager;
        this.accessPolicies = new ArrayList<AccessPolicyImpl>();
        if (innerObject != null && innerObject.properties() != null && innerObject.properties().accessPolicies() != null) {
            for (AccessPolicyEntry entry : innerObject.properties().accessPolicies()) {
                this.accessPolicies.add(new AccessPolicyImpl(entry, this));
            }
        }
        this.client = new KeyVaultClient(((KeyVaultManagementClientImpl)((Object)manager.inner())).restClient().newBuilder().withBaseUrl("https://{vaultBaseUrl}").build());
    }

    @Override
    public KeyVaultClient client() {
        return this.client;
    }

    @Override
    public Keys keys() {
        if (this.keys == null) {
            this.keys = new KeysImpl(this.client, this);
        }
        return this.keys;
    }

    @Override
    public Secrets secrets() {
        if (this.secrets == null) {
            this.secrets = new SecretsImpl(this.client, this);
        }
        return this.secrets;
    }

    @Override
    public String vaultUri() {
        if (((VaultInner)((Object)this.inner())).properties() == null) {
            return null;
        }
        return ((VaultInner)((Object)this.inner())).properties().vaultUri();
    }

    @Override
    public String tenantId() {
        if (((VaultInner)((Object)this.inner())).properties() == null) {
            return null;
        }
        if (((VaultInner)((Object)this.inner())).properties().tenantId() == null) {
            return null;
        }
        return ((VaultInner)((Object)this.inner())).properties().tenantId().toString();
    }

    @Override
    public Sku sku() {
        if (((VaultInner)((Object)this.inner())).properties() == null) {
            return null;
        }
        return ((VaultInner)((Object)this.inner())).properties().sku();
    }

    @Override
    public List<AccessPolicy> accessPolicies() {
        AccessPolicy[] array = new AccessPolicy[this.accessPolicies.size()];
        return Arrays.asList(this.accessPolicies.toArray(array));
    }

    @Override
    public boolean enabledForDeployment() {
        if (((VaultInner)((Object)this.inner())).properties() == null) {
            return false;
        }
        return Utils.toPrimitiveBoolean((Boolean)((VaultInner)((Object)this.inner())).properties().enabledForDeployment());
    }

    @Override
    public boolean enabledForDiskEncryption() {
        if (((VaultInner)((Object)this.inner())).properties() == null) {
            return false;
        }
        return Utils.toPrimitiveBoolean((Boolean)((VaultInner)((Object)this.inner())).properties().enabledForDiskEncryption());
    }

    @Override
    public boolean enabledForTemplateDeployment() {
        if (((VaultInner)((Object)this.inner())).properties() == null) {
            return false;
        }
        return Utils.toPrimitiveBoolean((Boolean)((VaultInner)((Object)this.inner())).properties().enabledForTemplateDeployment());
    }

    @Override
    public boolean softDeleteEnabled() {
        if (((VaultInner)((Object)this.inner())).properties() == null) {
            return false;
        }
        return Utils.toPrimitiveBoolean((Boolean)((VaultInner)((Object)this.inner())).properties().enableSoftDelete());
    }

    @Override
    public boolean purgeProtectionEnabled() {
        if (((VaultInner)((Object)this.inner())).properties() == null) {
            return false;
        }
        return Utils.toPrimitiveBoolean((Boolean)((VaultInner)((Object)this.inner())).properties().enablePurgeProtection());
    }

    @Override
    public VaultImpl withEmptyAccessPolicy() {
        this.accessPolicies = new ArrayList<AccessPolicyImpl>();
        return this;
    }

    @Override
    public VaultImpl withoutAccessPolicy(String objectId) {
        for (AccessPolicyImpl entry : this.accessPolicies) {
            if (!entry.objectId().equals(objectId)) continue;
            this.accessPolicies.remove(entry);
            break;
        }
        return this;
    }

    @Override
    public VaultImpl withAccessPolicy(AccessPolicy accessPolicy) {
        this.accessPolicies.add((AccessPolicyImpl)accessPolicy);
        return this;
    }

    public AccessPolicyImpl defineAccessPolicy() {
        return new AccessPolicyImpl(new AccessPolicyEntry(), this);
    }

    @Override
    public AccessPolicyImpl updateAccessPolicy(String objectId) {
        for (AccessPolicyImpl entry : this.accessPolicies) {
            if (!entry.objectId().equals(objectId)) continue;
            return entry;
        }
        throw new NoSuchElementException(String.format("Identity %s not found in the access policies.", objectId));
    }

    @Override
    public VaultImpl withDeploymentEnabled() {
        ((VaultInner)((Object)this.inner())).properties().withEnabledForDeployment(true);
        return this;
    }

    @Override
    public VaultImpl withDiskEncryptionEnabled() {
        ((VaultInner)((Object)this.inner())).properties().withEnabledForDiskEncryption(true);
        return this;
    }

    @Override
    public VaultImpl withTemplateDeploymentEnabled() {
        ((VaultInner)((Object)this.inner())).properties().withEnabledForTemplateDeployment(true);
        return this;
    }

    @Override
    public VaultImpl withSoftDeleteEnabled() {
        ((VaultInner)((Object)this.inner())).properties().withEnableSoftDelete(true);
        return this;
    }

    @Override
    public VaultImpl withPurgeProtectionEnabled() {
        ((VaultInner)((Object)this.inner())).properties().withEnablePurgeProtection(true);
        return this;
    }

    @Override
    public VaultImpl withDeploymentDisabled() {
        ((VaultInner)((Object)this.inner())).properties().withEnabledForDeployment(false);
        return this;
    }

    @Override
    public VaultImpl withDiskEncryptionDisabled() {
        ((VaultInner)((Object)this.inner())).properties().withEnabledForDiskEncryption(false);
        return this;
    }

    @Override
    public VaultImpl withTemplateDeploymentDisabled() {
        ((VaultInner)((Object)this.inner())).properties().withEnabledForTemplateDeployment(false);
        return this;
    }

    @Override
    public VaultImpl withSku(SkuName skuName) {
        if (((VaultInner)((Object)this.inner())).properties() == null) {
            ((VaultInner)((Object)this.inner())).withProperties(new VaultProperties());
        }
        ((VaultInner)((Object)this.inner())).properties().withSku(new Sku().withName(skuName));
        return this;
    }

    private Observable<List<AccessPolicy>> populateAccessPolicies() {
        ArrayList<Observable> observables = new ArrayList<Observable>();
        for (final AccessPolicyImpl accessPolicy : this.accessPolicies) {
            if (accessPolicy.objectId() != null) continue;
            if (accessPolicy.userPrincipalName() != null) {
                observables.add(this.graphRbacManager.users().getByNameAsync(accessPolicy.userPrincipalName()).subscribeOn(SdkContext.getRxScheduler()).doOnNext((Action1)new Action1<ActiveDirectoryUser>(){

                    public void call(ActiveDirectoryUser user) {
                        if (user == null) {
                            throw new CloudException(String.format("User principal name %s is not found in tenant %s", accessPolicy.userPrincipalName(), VaultImpl.this.graphRbacManager.tenantId()), null);
                        }
                        accessPolicy.forObjectId(user.id());
                    }
                }));
                continue;
            }
            if (accessPolicy.servicePrincipalName() != null) {
                observables.add(this.graphRbacManager.servicePrincipals().getByNameAsync(accessPolicy.servicePrincipalName()).subscribeOn(SdkContext.getRxScheduler()).doOnNext((Action1)new Action1<ServicePrincipal>(){

                    public void call(ServicePrincipal sp) {
                        if (sp == null) {
                            throw new CloudException(String.format("Service principal name %s is not found in tenant %s", accessPolicy.servicePrincipalName(), VaultImpl.this.graphRbacManager.tenantId()), null);
                        }
                        accessPolicy.forObjectId(sp.id());
                    }
                }));
                continue;
            }
            throw new IllegalArgumentException("Access policy must specify object ID.");
        }
        if (observables.isEmpty()) {
            return Observable.just(this.accessPolicies());
        }
        return Observable.zip(observables, (FuncN)new FuncN<List<AccessPolicy>>(){

            public List<AccessPolicy> call(Object ... args) {
                return VaultImpl.this.accessPolicies();
            }
        });
    }

    public Observable<Vault> createResourceAsync() {
        final VaultsInner client = ((KeyVaultManagementClientImpl)((Object)((KeyVaultManager)this.manager()).inner())).vaults();
        return this.populateAccessPolicies().flatMap((Func1)new Func1<Object, Observable<VaultInner>>(){

            public Observable<VaultInner> call(Object o) {
                VaultCreateOrUpdateParameters parameters = new VaultCreateOrUpdateParameters();
                parameters.withLocation(VaultImpl.this.regionName());
                parameters.withProperties(((VaultInner)((Object)VaultImpl.this.inner())).properties());
                parameters.withTags(((VaultInner)((Object)VaultImpl.this.inner())).getTags());
                parameters.properties().withAccessPolicies(new ArrayList<AccessPolicyEntry>());
                for (AccessPolicy accessPolicy : VaultImpl.this.accessPolicies) {
                    parameters.properties().accessPolicies().add((AccessPolicyEntry)accessPolicy.inner());
                }
                return client.createOrUpdateAsync(VaultImpl.this.resourceGroupName(), VaultImpl.this.name(), parameters);
            }
        }).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<VaultInner> getInnerAsync() {
        return ((KeyVaultManagementClientImpl)((Object)((KeyVaultManager)this.manager()).inner())).vaults().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public CreateMode createMode() {
        return ((VaultInner)((Object)this.inner())).properties().createMode();
    }

    @Override
    public NetworkRuleSet networkRuleSet() {
        return ((VaultInner)((Object)this.inner())).properties().networkAcls();
    }

    @Override
    public VaultImpl withAccessFromAllNetworks() {
        if (((VaultInner)((Object)this.inner())).properties().networkAcls() == null) {
            ((VaultInner)((Object)this.inner())).properties().withNetworkAcls(new NetworkRuleSet());
        }
        ((VaultInner)((Object)this.inner())).properties().networkAcls().withDefaultAction(NetworkRuleAction.ALLOW);
        return this;
    }

    @Override
    public VaultImpl withAccessFromSelectedNetworks() {
        if (((VaultInner)((Object)this.inner())).properties().networkAcls() == null) {
            ((VaultInner)((Object)this.inner())).properties().withNetworkAcls(new NetworkRuleSet());
        }
        ((VaultInner)((Object)this.inner())).properties().networkAcls().withDefaultAction(NetworkRuleAction.DENY);
        return this;
    }

    private VaultImpl withAccessAllowedFromIpAddressOrRange(String ipAddressOrRange) {
        NetworkRuleSet networkRuleSet = ((VaultInner)((Object)this.inner())).properties().networkAcls();
        if (networkRuleSet.ipRules() == null) {
            networkRuleSet.withIpRules(new ArrayList<IPRule>());
        }
        boolean found = false;
        for (IPRule rule : networkRuleSet.ipRules()) {
            if (!rule.value().equalsIgnoreCase(ipAddressOrRange)) continue;
            found = true;
            break;
        }
        if (!found) {
            networkRuleSet.ipRules().add(new IPRule().withValue(ipAddressOrRange));
        }
        return this;
    }

    @Override
    public VaultImpl withAccessFromIpAddress(String ipAddress) {
        return this.withAccessAllowedFromIpAddressOrRange(ipAddress);
    }

    @Override
    public VaultImpl withAccessFromIpAddressRange(String ipAddressCidr) {
        return this.withAccessAllowedFromIpAddressOrRange(ipAddressCidr);
    }

    @Override
    public VaultImpl withAccessFromAzureServices() {
        if (((VaultInner)((Object)this.inner())).properties().networkAcls() == null) {
            ((VaultInner)((Object)this.inner())).properties().withNetworkAcls(new NetworkRuleSet());
        }
        ((VaultInner)((Object)this.inner())).properties().networkAcls().withBypass(NetworkRuleBypassOptions.AZURE_SERVICES);
        return this;
    }

    @Override
    public VaultImpl withBypass(NetworkRuleBypassOptions bypass) {
        if (((VaultInner)((Object)this.inner())).properties().networkAcls() == null) {
            ((VaultInner)((Object)this.inner())).properties().withNetworkAcls(new NetworkRuleSet());
        }
        ((VaultInner)((Object)this.inner())).properties().networkAcls().withBypass(bypass);
        return this;
    }

    @Override
    public VaultImpl withDefaultAction(NetworkRuleAction defaultAction) {
        if (((VaultInner)((Object)this.inner())).properties().networkAcls() == null) {
            ((VaultInner)((Object)this.inner())).properties().withNetworkAcls(new NetworkRuleSet());
        }
        ((VaultInner)((Object)this.inner())).properties().networkAcls().withDefaultAction(defaultAction);
        return this;
    }

    @Override
    public VaultImpl withVirtualNetworkRules(List<VirtualNetworkRule> virtualNetworkRules) {
        if (((VaultInner)((Object)this.inner())).properties().networkAcls() == null) {
            ((VaultInner)((Object)this.inner())).properties().withNetworkAcls(new NetworkRuleSet());
        }
        ((VaultInner)((Object)this.inner())).properties().networkAcls().withVirtualNetworkRules(virtualNetworkRules);
        return this;
    }
}

