/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.keyvault;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The parameters used to check the availability of the vault name.
 */
public class VaultCheckNameAvailabilityParameters {
    /**
     * The vault name.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /**
     * The type of resource, Microsoft.KeyVault/vaults.
     */
    @JsonProperty(value = "type", required = true)
    private String type;

    /**
     * Creates an instance of VaultCheckNameAvailabilityParameters class.
     */
    public VaultCheckNameAvailabilityParameters() {
        type = "Microsoft.KeyVault/vaults";
    }

    /**
     * Get the name value.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name value.
     *
     * @param name the name value to set
     * @return the VaultCheckNameAvailabilityParameters object itself.
     */
    public VaultCheckNameAvailabilityParameters withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type value.
     *
     * @return the type value
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type value.
     *
     * @param type the type value to set
     * @return the VaultCheckNameAvailabilityParameters object itself.
     */
    public VaultCheckNameAvailabilityParameters withType(String type) {
        this.type = type;
        return this;
    }

}
