/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryUser;
import com.microsoft.azure.management.graphrbac.PasswordProfile;
import com.microsoft.azure.management.graphrbac.implementation.DomainInner;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.graphrbac.implementation.UserCreateParametersInner;
import com.microsoft.azure.management.graphrbac.implementation.UserInner;
import com.microsoft.azure.management.graphrbac.implementation.UserUpdateParametersInner;
import com.microsoft.azure.management.resources.fluentcore.arm.CountryIsoCode;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.Graph.RBAC.Fluent")
class ActiveDirectoryUserImpl
extends CreatableUpdatableImpl<ActiveDirectoryUser, UserInner, ActiveDirectoryUserImpl>
implements ActiveDirectoryUser,
ActiveDirectoryUser.Definition,
ActiveDirectoryUser.Update {
    private final GraphRbacManager manager;
    private UserCreateParametersInner createParameters;
    private UserUpdateParametersInner updateParameters;
    private String emailAlias;

    ActiveDirectoryUserImpl(UserInner innerObject, GraphRbacManager manager) {
        super(innerObject.displayName(), (Object)innerObject);
        this.manager = manager;
        this.createParameters = new UserCreateParametersInner().withDisplayName(this.name()).withAccountEnabled(true);
        this.updateParameters = new UserUpdateParametersInner().withDisplayName(this.name());
    }

    public String id() {
        return ((UserInner)this.inner()).objectId();
    }

    @Override
    public String userPrincipalName() {
        return ((UserInner)this.inner()).userPrincipalName();
    }

    public String name() {
        return ((UserInner)this.inner()).displayName();
    }

    @Override
    public String signInName() {
        if (((UserInner)this.inner()).signInNames() != null && !((UserInner)this.inner()).signInNames().isEmpty()) {
            return ((UserInner)this.inner()).signInNames().get(0).value();
        }
        return null;
    }

    @Override
    public String mail() {
        return ((UserInner)this.inner()).mail();
    }

    @Override
    public String mailNickname() {
        return ((UserInner)this.inner()).mailNickname();
    }

    @Override
    public CountryIsoCode usageLocation() {
        return CountryIsoCode.fromString((String)((UserInner)this.inner()).usageLocation());
    }

    public GraphRbacManager manager() {
        return this.manager;
    }

    @Override
    public ActiveDirectoryUserImpl withUserPrincipalName(String userPrincipalName) {
        this.createParameters.withUserPrincipalName(userPrincipalName);
        if (this.isInCreateMode() || this.updateParameters.mailNickname() != null) {
            this.withMailNickname(userPrincipalName.replaceAll("@.+$", ""));
        }
        return this;
    }

    @Override
    public ActiveDirectoryUserImpl withEmailAlias(String emailAlias) {
        this.emailAlias = emailAlias;
        return this;
    }

    @Override
    public ActiveDirectoryUserImpl withPassword(String password) {
        this.createParameters.withPasswordProfile(new PasswordProfile().withPassword(password));
        this.updateParameters.withPasswordProfile(new PasswordProfile().withPassword(password));
        return this;
    }

    protected Observable<UserInner> getInnerAsync() {
        return this.manager.inner().users().getAsync(this.id());
    }

    public boolean isInCreateMode() {
        return this.id() == null;
    }

    public Observable<ActiveDirectoryUser> createResourceAsync() {
        Observable domain = this.emailAlias != null ? this.manager().inner().domains().listAsync().map((Func1)new Func1<List<DomainInner>, ActiveDirectoryUserImpl>(){

            public ActiveDirectoryUserImpl call(List<DomainInner> domainInners) {
                for (DomainInner inner : domainInners) {
                    if (!inner.isVerified().booleanValue() || !inner.isDefault().booleanValue() || ActiveDirectoryUserImpl.this.emailAlias == null) continue;
                    ActiveDirectoryUserImpl.this.withUserPrincipalName(ActiveDirectoryUserImpl.this.emailAlias + "@" + inner.name());
                    break;
                }
                return ActiveDirectoryUserImpl.this;
            }
        }) : Observable.just((Object)this);
        return domain.flatMap((Func1)new Func1<ActiveDirectoryUserImpl, Observable<UserInner>>(){

            public Observable<UserInner> call(ActiveDirectoryUserImpl activeDirectoryUser) {
                return ActiveDirectoryUserImpl.this.manager().inner().users().createAsync(ActiveDirectoryUserImpl.this.createParameters);
            }
        }).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public Observable<ActiveDirectoryUser> updateResourceAsync() {
        return this.manager().inner().users().updateAsync(this.id(), this.updateParameters).flatMap((Func1)new Func1<Void, Observable<ActiveDirectoryUser>>(){

            public Observable<ActiveDirectoryUser> call(Void aVoid) {
                return ActiveDirectoryUserImpl.this.refreshAsync();
            }
        });
    }

    private void withMailNickname(String mailNickname) {
        this.createParameters.withMailNickname(mailNickname);
        this.updateParameters.withMailNickname(mailNickname);
    }

    @Override
    public ActiveDirectoryUserImpl withPromptToChangePasswordOnLogin(boolean promptToChangePasswordOnLogin) {
        this.createParameters.passwordProfile().withForceChangePasswordNextLogin(promptToChangePasswordOnLogin);
        this.updateParameters.passwordProfile().withForceChangePasswordNextLogin(promptToChangePasswordOnLogin);
        return this;
    }

    public String toString() {
        return this.name() + " - " + this.userPrincipalName();
    }

    @Override
    public ActiveDirectoryUserImpl withAccountEnabled(boolean accountEnabled) {
        this.createParameters.withAccountEnabled(accountEnabled);
        this.updateParameters.withAccountEnabled(accountEnabled);
        return this;
    }

    @Override
    public ActiveDirectoryUserImpl withUsageLocation(CountryIsoCode usageLocation) {
        this.createParameters.withUsageLocation(usageLocation.toString());
        this.updateParameters.withUsageLocation(usageLocation.toString());
        return this;
    }
}

