/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.eventhub.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.eventhub.CheckNameAvailabilityParameter;
import com.microsoft.azure.management.eventhub.ErrorResponseException;
import com.microsoft.azure.management.eventhub.implementation.AccessKeysInner;
import com.microsoft.azure.management.eventhub.implementation.ArmDisasterRecoveryInner;
import com.microsoft.azure.management.eventhub.implementation.AuthorizationRuleInner;
import com.microsoft.azure.management.eventhub.implementation.CheckNameAvailabilityResultInner;
import com.microsoft.azure.management.eventhub.implementation.EventHubManagementClientImpl;
import com.microsoft.azure.management.eventhub.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class DisasterRecoveryConfigsInner {
    private DisasterRecoveryConfigsService service;
    private EventHubManagementClientImpl client;

    public DisasterRecoveryConfigsInner(Retrofit retrofit, EventHubManagementClientImpl client) {
        this.service = (DisasterRecoveryConfigsService)retrofit.create(DisasterRecoveryConfigsService.class);
        this.client = client;
    }

    public CheckNameAvailabilityResultInner checkNameAvailability(String resourceGroupName, String namespaceName, String name) {
        return (CheckNameAvailabilityResultInner)((ServiceResponse)this.checkNameAvailabilityWithServiceResponseAsync(resourceGroupName, namespaceName, name).toBlocking().single()).body();
    }

    public ServiceFuture<CheckNameAvailabilityResultInner> checkNameAvailabilityAsync(String resourceGroupName, String namespaceName, String name, ServiceCallback<CheckNameAvailabilityResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkNameAvailabilityWithServiceResponseAsync(resourceGroupName, namespaceName, name), serviceCallback);
    }

    public Observable<CheckNameAvailabilityResultInner> checkNameAvailabilityAsync(String resourceGroupName, String namespaceName, String name) {
        return this.checkNameAvailabilityWithServiceResponseAsync(resourceGroupName, namespaceName, name).map((Func1)new Func1<ServiceResponse<CheckNameAvailabilityResultInner>, CheckNameAvailabilityResultInner>(){

            public CheckNameAvailabilityResultInner call(ServiceResponse<CheckNameAvailabilityResultInner> response) {
                return (CheckNameAvailabilityResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CheckNameAvailabilityResultInner>> checkNameAvailabilityWithServiceResponseAsync(String resourceGroupName, String namespaceName, String name) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        CheckNameAvailabilityParameter parameters = new CheckNameAvailabilityParameter();
        parameters.withName(name);
        return this.service.checkNameAvailability(this.client.subscriptionId(), resourceGroupName, namespaceName, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CheckNameAvailabilityResultInner>>>(){

            public Observable<ServiceResponse<CheckNameAvailabilityResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DisasterRecoveryConfigsInner.this.checkNameAvailabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CheckNameAvailabilityResultInner> checkNameAvailabilityDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CheckNameAvailabilityResultInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<ArmDisasterRecoveryInner> list(String resourceGroupName, String namespaceName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, namespaceName).toBlocking().single();
        return new PagedList<ArmDisasterRecoveryInner>((Page)response.body()){

            public Page<ArmDisasterRecoveryInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DisasterRecoveryConfigsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ArmDisasterRecoveryInner>> listAsync(String resourceGroupName, String namespaceName, ListOperationCallback<ArmDisasterRecoveryInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, namespaceName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ArmDisasterRecoveryInner>>>>(){

            public Observable<ServiceResponse<Page<ArmDisasterRecoveryInner>>> call(String nextPageLink) {
                return DisasterRecoveryConfigsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ArmDisasterRecoveryInner>> listAsync(String resourceGroupName, String namespaceName) {
        return this.listWithServiceResponseAsync(resourceGroupName, namespaceName).map((Func1)new Func1<ServiceResponse<Page<ArmDisasterRecoveryInner>>, Page<ArmDisasterRecoveryInner>>(){

            public Page<ArmDisasterRecoveryInner> call(ServiceResponse<Page<ArmDisasterRecoveryInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ArmDisasterRecoveryInner>>> listWithServiceResponseAsync(String resourceGroupName, String namespaceName) {
        return this.listSinglePageAsync(resourceGroupName, namespaceName).concatMap((Func1)new Func1<ServiceResponse<Page<ArmDisasterRecoveryInner>>, Observable<ServiceResponse<Page<ArmDisasterRecoveryInner>>>>(){

            public Observable<ServiceResponse<Page<ArmDisasterRecoveryInner>>> call(ServiceResponse<Page<ArmDisasterRecoveryInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DisasterRecoveryConfigsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ArmDisasterRecoveryInner>>> listSinglePageAsync(String resourceGroupName, String namespaceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(resourceGroupName, namespaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ArmDisasterRecoveryInner>>>>(){

            public Observable<ServiceResponse<Page<ArmDisasterRecoveryInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DisasterRecoveryConfigsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ArmDisasterRecoveryInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ArmDisasterRecoveryInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public ArmDisasterRecoveryInner createOrUpdate(String resourceGroupName, String namespaceName, String alias, ArmDisasterRecoveryInner parameters) {
        return (ArmDisasterRecoveryInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, alias, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ArmDisasterRecoveryInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String alias, ArmDisasterRecoveryInner parameters, ServiceCallback<ArmDisasterRecoveryInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, alias, parameters), serviceCallback);
    }

    public Observable<ArmDisasterRecoveryInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String alias, ArmDisasterRecoveryInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, alias, parameters).map((Func1)new Func1<ServiceResponse<ArmDisasterRecoveryInner>, ArmDisasterRecoveryInner>(){

            public ArmDisasterRecoveryInner call(ServiceResponse<ArmDisasterRecoveryInner> response) {
                return (ArmDisasterRecoveryInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ArmDisasterRecoveryInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String namespaceName, String alias, ArmDisasterRecoveryInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (alias == null) {
            throw new IllegalArgumentException("Parameter alias is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        return this.service.createOrUpdate(resourceGroupName, namespaceName, alias, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ArmDisasterRecoveryInner>>>(){

            public Observable<ServiceResponse<ArmDisasterRecoveryInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DisasterRecoveryConfigsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ArmDisasterRecoveryInner> createOrUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ArmDisasterRecoveryInner>(){}.getType()).register(201, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String namespaceName, String alias) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, namespaceName, alias).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String namespaceName, String alias, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, namespaceName, alias), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String namespaceName, String alias) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, namespaceName, alias).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String namespaceName, String alias) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (alias == null) {
            throw new IllegalArgumentException("Parameter alias is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, namespaceName, alias, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DisasterRecoveryConfigsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public ArmDisasterRecoveryInner get(String resourceGroupName, String namespaceName, String alias) {
        return (ArmDisasterRecoveryInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, namespaceName, alias).toBlocking().single()).body());
    }

    public ServiceFuture<ArmDisasterRecoveryInner> getAsync(String resourceGroupName, String namespaceName, String alias, ServiceCallback<ArmDisasterRecoveryInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, namespaceName, alias), serviceCallback);
    }

    public Observable<ArmDisasterRecoveryInner> getAsync(String resourceGroupName, String namespaceName, String alias) {
        return this.getWithServiceResponseAsync(resourceGroupName, namespaceName, alias).map((Func1)new Func1<ServiceResponse<ArmDisasterRecoveryInner>, ArmDisasterRecoveryInner>(){

            public ArmDisasterRecoveryInner call(ServiceResponse<ArmDisasterRecoveryInner> response) {
                return (ArmDisasterRecoveryInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ArmDisasterRecoveryInner>> getWithServiceResponseAsync(String resourceGroupName, String namespaceName, String alias) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (alias == null) {
            throw new IllegalArgumentException("Parameter alias is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, namespaceName, alias, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ArmDisasterRecoveryInner>>>(){

            public Observable<ServiceResponse<ArmDisasterRecoveryInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DisasterRecoveryConfigsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ArmDisasterRecoveryInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ArmDisasterRecoveryInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void breakPairing(String resourceGroupName, String namespaceName, String alias) {
        ((ServiceResponse)this.breakPairingWithServiceResponseAsync(resourceGroupName, namespaceName, alias).toBlocking().single()).body();
    }

    public ServiceFuture<Void> breakPairingAsync(String resourceGroupName, String namespaceName, String alias, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.breakPairingWithServiceResponseAsync(resourceGroupName, namespaceName, alias), serviceCallback);
    }

    public Observable<Void> breakPairingAsync(String resourceGroupName, String namespaceName, String alias) {
        return this.breakPairingWithServiceResponseAsync(resourceGroupName, namespaceName, alias).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> breakPairingWithServiceResponseAsync(String resourceGroupName, String namespaceName, String alias) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (alias == null) {
            throw new IllegalArgumentException("Parameter alias is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.breakPairing(resourceGroupName, namespaceName, alias, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DisasterRecoveryConfigsInner.this.breakPairingDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> breakPairingDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void failOver(String resourceGroupName, String namespaceName, String alias) {
        ((ServiceResponse)this.failOverWithServiceResponseAsync(resourceGroupName, namespaceName, alias).toBlocking().single()).body();
    }

    public ServiceFuture<Void> failOverAsync(String resourceGroupName, String namespaceName, String alias, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.failOverWithServiceResponseAsync(resourceGroupName, namespaceName, alias), serviceCallback);
    }

    public Observable<Void> failOverAsync(String resourceGroupName, String namespaceName, String alias) {
        return this.failOverWithServiceResponseAsync(resourceGroupName, namespaceName, alias).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> failOverWithServiceResponseAsync(String resourceGroupName, String namespaceName, String alias) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (alias == null) {
            throw new IllegalArgumentException("Parameter alias is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.failOver(resourceGroupName, namespaceName, alias, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DisasterRecoveryConfigsInner.this.failOverDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> failOverDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<AuthorizationRuleInner> listAuthorizationRules(String resourceGroupName, String namespaceName, String alias) {
        ServiceResponse response = (ServiceResponse)this.listAuthorizationRulesSinglePageAsync(resourceGroupName, namespaceName, alias).toBlocking().single();
        return new PagedList<AuthorizationRuleInner>((Page)response.body()){

            public Page<AuthorizationRuleInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DisasterRecoveryConfigsInner.this.listAuthorizationRulesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AuthorizationRuleInner>> listAuthorizationRulesAsync(String resourceGroupName, String namespaceName, String alias, ListOperationCallback<AuthorizationRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAuthorizationRulesSinglePageAsync(resourceGroupName, namespaceName, alias), (Func1)new Func1<String, Observable<ServiceResponse<Page<AuthorizationRuleInner>>>>(){

            public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> call(String nextPageLink) {
                return DisasterRecoveryConfigsInner.this.listAuthorizationRulesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AuthorizationRuleInner>> listAuthorizationRulesAsync(String resourceGroupName, String namespaceName, String alias) {
        return this.listAuthorizationRulesWithServiceResponseAsync(resourceGroupName, namespaceName, alias).map((Func1)new Func1<ServiceResponse<Page<AuthorizationRuleInner>>, Page<AuthorizationRuleInner>>(){

            public Page<AuthorizationRuleInner> call(ServiceResponse<Page<AuthorizationRuleInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> listAuthorizationRulesWithServiceResponseAsync(String resourceGroupName, String namespaceName, String alias) {
        return this.listAuthorizationRulesSinglePageAsync(resourceGroupName, namespaceName, alias).concatMap((Func1)new Func1<ServiceResponse<Page<AuthorizationRuleInner>>, Observable<ServiceResponse<Page<AuthorizationRuleInner>>>>(){

            public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> call(ServiceResponse<Page<AuthorizationRuleInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DisasterRecoveryConfigsInner.this.listAuthorizationRulesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> listAuthorizationRulesSinglePageAsync(String resourceGroupName, String namespaceName, String alias) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (alias == null) {
            throw new IllegalArgumentException("Parameter alias is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listAuthorizationRules(resourceGroupName, namespaceName, alias, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AuthorizationRuleInner>>>>(){

            public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DisasterRecoveryConfigsInner.this.listAuthorizationRulesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AuthorizationRuleInner>> listAuthorizationRulesDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AuthorizationRuleInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public AuthorizationRuleInner getAuthorizationRule(String resourceGroupName, String namespaceName, String alias, String authorizationRuleName) {
        return (AuthorizationRuleInner)((Object)((ServiceResponse)this.getAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, alias, authorizationRuleName).toBlocking().single()).body());
    }

    public ServiceFuture<AuthorizationRuleInner> getAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String alias, String authorizationRuleName, ServiceCallback<AuthorizationRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, alias, authorizationRuleName), serviceCallback);
    }

    public Observable<AuthorizationRuleInner> getAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String alias, String authorizationRuleName) {
        return this.getAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, alias, authorizationRuleName).map((Func1)new Func1<ServiceResponse<AuthorizationRuleInner>, AuthorizationRuleInner>(){

            public AuthorizationRuleInner call(ServiceResponse<AuthorizationRuleInner> response) {
                return (AuthorizationRuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AuthorizationRuleInner>> getAuthorizationRuleWithServiceResponseAsync(String resourceGroupName, String namespaceName, String alias, String authorizationRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (alias == null) {
            throw new IllegalArgumentException("Parameter alias is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getAuthorizationRule(resourceGroupName, namespaceName, alias, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AuthorizationRuleInner>>>(){

            public Observable<ServiceResponse<AuthorizationRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DisasterRecoveryConfigsInner.this.getAuthorizationRuleDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AuthorizationRuleInner> getAuthorizationRuleDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AuthorizationRuleInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public AccessKeysInner listKeys(String resourceGroupName, String namespaceName, String alias, String authorizationRuleName) {
        return (AccessKeysInner)((ServiceResponse)this.listKeysWithServiceResponseAsync(resourceGroupName, namespaceName, alias, authorizationRuleName).toBlocking().single()).body();
    }

    public ServiceFuture<AccessKeysInner> listKeysAsync(String resourceGroupName, String namespaceName, String alias, String authorizationRuleName, ServiceCallback<AccessKeysInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listKeysWithServiceResponseAsync(resourceGroupName, namespaceName, alias, authorizationRuleName), serviceCallback);
    }

    public Observable<AccessKeysInner> listKeysAsync(String resourceGroupName, String namespaceName, String alias, String authorizationRuleName) {
        return this.listKeysWithServiceResponseAsync(resourceGroupName, namespaceName, alias, authorizationRuleName).map((Func1)new Func1<ServiceResponse<AccessKeysInner>, AccessKeysInner>(){

            public AccessKeysInner call(ServiceResponse<AccessKeysInner> response) {
                return (AccessKeysInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<AccessKeysInner>> listKeysWithServiceResponseAsync(String resourceGroupName, String namespaceName, String alias, String authorizationRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (alias == null) {
            throw new IllegalArgumentException("Parameter alias is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listKeys(resourceGroupName, namespaceName, alias, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AccessKeysInner>>>(){

            public Observable<ServiceResponse<AccessKeysInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DisasterRecoveryConfigsInner.this.listKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AccessKeysInner> listKeysDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AccessKeysInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<ArmDisasterRecoveryInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ArmDisasterRecoveryInner>((Page)response.body()){

            public Page<ArmDisasterRecoveryInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DisasterRecoveryConfigsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ArmDisasterRecoveryInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ArmDisasterRecoveryInner>> serviceFuture, ListOperationCallback<ArmDisasterRecoveryInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ArmDisasterRecoveryInner>>>>(){

            public Observable<ServiceResponse<Page<ArmDisasterRecoveryInner>>> call(String nextPageLink) {
                return DisasterRecoveryConfigsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ArmDisasterRecoveryInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ArmDisasterRecoveryInner>>, Page<ArmDisasterRecoveryInner>>(){

            public Page<ArmDisasterRecoveryInner> call(ServiceResponse<Page<ArmDisasterRecoveryInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ArmDisasterRecoveryInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ArmDisasterRecoveryInner>>, Observable<ServiceResponse<Page<ArmDisasterRecoveryInner>>>>(){

            public Observable<ServiceResponse<Page<ArmDisasterRecoveryInner>>> call(ServiceResponse<Page<ArmDisasterRecoveryInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DisasterRecoveryConfigsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ArmDisasterRecoveryInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ArmDisasterRecoveryInner>>>>(){

            public Observable<ServiceResponse<Page<ArmDisasterRecoveryInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DisasterRecoveryConfigsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ArmDisasterRecoveryInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ArmDisasterRecoveryInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<AuthorizationRuleInner> listAuthorizationRulesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listAuthorizationRulesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AuthorizationRuleInner>((Page)response.body()){

            public Page<AuthorizationRuleInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DisasterRecoveryConfigsInner.this.listAuthorizationRulesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AuthorizationRuleInner>> listAuthorizationRulesNextAsync(String nextPageLink, ServiceFuture<List<AuthorizationRuleInner>> serviceFuture, ListOperationCallback<AuthorizationRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAuthorizationRulesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<AuthorizationRuleInner>>>>(){

            public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> call(String nextPageLink) {
                return DisasterRecoveryConfigsInner.this.listAuthorizationRulesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AuthorizationRuleInner>> listAuthorizationRulesNextAsync(String nextPageLink) {
        return this.listAuthorizationRulesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<AuthorizationRuleInner>>, Page<AuthorizationRuleInner>>(){

            public Page<AuthorizationRuleInner> call(ServiceResponse<Page<AuthorizationRuleInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> listAuthorizationRulesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listAuthorizationRulesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<AuthorizationRuleInner>>, Observable<ServiceResponse<Page<AuthorizationRuleInner>>>>(){

            public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> call(ServiceResponse<Page<AuthorizationRuleInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DisasterRecoveryConfigsInner.this.listAuthorizationRulesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> listAuthorizationRulesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listAuthorizationRulesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AuthorizationRuleInner>>>>(){

            public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DisasterRecoveryConfigsInner.this.listAuthorizationRulesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AuthorizationRuleInner>> listAuthorizationRulesNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AuthorizationRuleInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface DisasterRecoveryConfigsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.DisasterRecoveryConfigs checkNameAvailability"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/disasterRecoveryConfigs/CheckNameAvailability")
        public Observable<Response<ResponseBody>> checkNameAvailability(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="namespaceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body CheckNameAvailabilityParameter var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.DisasterRecoveryConfigs list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/disasterRecoveryConfigs")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.DisasterRecoveryConfigs createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="alias") String var3, @Path(value="subscriptionId") String var4, @Body ArmDisasterRecoveryInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.DisasterRecoveryConfigs delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="alias") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.DisasterRecoveryConfigs get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="alias") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.DisasterRecoveryConfigs breakPairing"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}/breakPairing")
        public Observable<Response<ResponseBody>> breakPairing(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="alias") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.DisasterRecoveryConfigs failOver"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}/failover")
        public Observable<Response<ResponseBody>> failOver(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="alias") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.DisasterRecoveryConfigs listAuthorizationRules"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}/AuthorizationRules")
        public Observable<Response<ResponseBody>> listAuthorizationRules(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="alias") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.DisasterRecoveryConfigs getAuthorizationRule"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}/AuthorizationRules/{authorizationRuleName}")
        public Observable<Response<ResponseBody>> getAuthorizationRule(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="alias") String var3, @Path(value="authorizationRuleName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.DisasterRecoveryConfigs listKeys"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}/AuthorizationRules/{authorizationRuleName}/listKeys")
        public Observable<Response<ResponseBody>> listKeys(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="alias") String var3, @Path(value="authorizationRuleName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.DisasterRecoveryConfigs listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.DisasterRecoveryConfigs listAuthorizationRulesNext"})
        @GET
        public Observable<Response<ResponseBody>> listAuthorizationRulesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

