/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.eventhub.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.eventhub.ErrorResponseException;
import com.microsoft.azure.management.eventhub.implementation.ConsumerGroupInner;
import com.microsoft.azure.management.eventhub.implementation.EventHubManagementClientImpl;
import com.microsoft.azure.management.eventhub.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ConsumerGroupsInner {
    private ConsumerGroupsService service;
    private EventHubManagementClientImpl client;

    public ConsumerGroupsInner(Retrofit retrofit, EventHubManagementClientImpl client) {
        this.service = (ConsumerGroupsService)retrofit.create(ConsumerGroupsService.class);
        this.client = client;
    }

    public ConsumerGroupInner createOrUpdate(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        return (ConsumerGroupInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName).toBlocking().single()).body());
    }

    public ServiceFuture<ConsumerGroupInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName, ServiceCallback<ConsumerGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName), serviceCallback);
    }

    public Observable<ConsumerGroupInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName).map((Func1)new Func1<ServiceResponse<ConsumerGroupInner>, ConsumerGroupInner>(){

            public ConsumerGroupInner call(ServiceResponse<ConsumerGroupInner> response) {
                return (ConsumerGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ConsumerGroupInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (eventHubName == null) {
            throw new IllegalArgumentException("Parameter eventHubName is required and cannot be null.");
        }
        if (consumerGroupName == null) {
            throw new IllegalArgumentException("Parameter consumerGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object userMetadata = null;
        ConsumerGroupInner parameters = new ConsumerGroupInner();
        parameters.withUserMetadata(null);
        return this.service.createOrUpdate(resourceGroupName, namespaceName, eventHubName, consumerGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ConsumerGroupInner>>>(){

            public Observable<ServiceResponse<ConsumerGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ConsumerGroupsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ConsumerGroupInner createOrUpdate(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName, String userMetadata) {
        return (ConsumerGroupInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName, userMetadata).toBlocking().single()).body());
    }

    public ServiceFuture<ConsumerGroupInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName, String userMetadata, ServiceCallback<ConsumerGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName, userMetadata), serviceCallback);
    }

    public Observable<ConsumerGroupInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName, String userMetadata) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName, userMetadata).map((Func1)new Func1<ServiceResponse<ConsumerGroupInner>, ConsumerGroupInner>(){

            public ConsumerGroupInner call(ServiceResponse<ConsumerGroupInner> response) {
                return (ConsumerGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ConsumerGroupInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName, String userMetadata) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (eventHubName == null) {
            throw new IllegalArgumentException("Parameter eventHubName is required and cannot be null.");
        }
        if (consumerGroupName == null) {
            throw new IllegalArgumentException("Parameter consumerGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        ConsumerGroupInner parameters = new ConsumerGroupInner();
        parameters.withUserMetadata(userMetadata);
        return this.service.createOrUpdate(resourceGroupName, namespaceName, eventHubName, consumerGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ConsumerGroupInner>>>(){

            public Observable<ServiceResponse<ConsumerGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ConsumerGroupsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ConsumerGroupInner> createOrUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ConsumerGroupInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (eventHubName == null) {
            throw new IllegalArgumentException("Parameter eventHubName is required and cannot be null.");
        }
        if (consumerGroupName == null) {
            throw new IllegalArgumentException("Parameter consumerGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, namespaceName, eventHubName, consumerGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ConsumerGroupsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public ConsumerGroupInner get(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        return (ConsumerGroupInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName).toBlocking().single()).body());
    }

    public ServiceFuture<ConsumerGroupInner> getAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName, ServiceCallback<ConsumerGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName), serviceCallback);
    }

    public Observable<ConsumerGroupInner> getAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        return this.getWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName).map((Func1)new Func1<ServiceResponse<ConsumerGroupInner>, ConsumerGroupInner>(){

            public ConsumerGroupInner call(ServiceResponse<ConsumerGroupInner> response) {
                return (ConsumerGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ConsumerGroupInner>> getWithServiceResponseAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (eventHubName == null) {
            throw new IllegalArgumentException("Parameter eventHubName is required and cannot be null.");
        }
        if (consumerGroupName == null) {
            throw new IllegalArgumentException("Parameter consumerGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, namespaceName, eventHubName, consumerGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ConsumerGroupInner>>>(){

            public Observable<ServiceResponse<ConsumerGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ConsumerGroupsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ConsumerGroupInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ConsumerGroupInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<ConsumerGroupInner> listByEventHub(String resourceGroupName, String namespaceName, String eventHubName) {
        ServiceResponse response = (ServiceResponse)this.listByEventHubSinglePageAsync(resourceGroupName, namespaceName, eventHubName).toBlocking().single();
        return new PagedList<ConsumerGroupInner>((Page)response.body()){

            public Page<ConsumerGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ConsumerGroupsInner.this.listByEventHubNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ConsumerGroupInner>> listByEventHubAsync(String resourceGroupName, String namespaceName, String eventHubName, ListOperationCallback<ConsumerGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByEventHubSinglePageAsync(resourceGroupName, namespaceName, eventHubName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ConsumerGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ConsumerGroupInner>>> call(String nextPageLink) {
                return ConsumerGroupsInner.this.listByEventHubNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ConsumerGroupInner>> listByEventHubAsync(String resourceGroupName, String namespaceName, String eventHubName) {
        return this.listByEventHubWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName).map((Func1)new Func1<ServiceResponse<Page<ConsumerGroupInner>>, Page<ConsumerGroupInner>>(){

            public Page<ConsumerGroupInner> call(ServiceResponse<Page<ConsumerGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ConsumerGroupInner>>> listByEventHubWithServiceResponseAsync(String resourceGroupName, String namespaceName, String eventHubName) {
        return this.listByEventHubSinglePageAsync(resourceGroupName, namespaceName, eventHubName).concatMap((Func1)new Func1<ServiceResponse<Page<ConsumerGroupInner>>, Observable<ServiceResponse<Page<ConsumerGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ConsumerGroupInner>>> call(ServiceResponse<Page<ConsumerGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ConsumerGroupsInner.this.listByEventHubNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ConsumerGroupInner>>> listByEventHubSinglePageAsync(String resourceGroupName, String namespaceName, String eventHubName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (eventHubName == null) {
            throw new IllegalArgumentException("Parameter eventHubName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer skip = null;
        Integer top = null;
        return this.service.listByEventHub(resourceGroupName, namespaceName, eventHubName, this.client.subscriptionId(), this.client.apiVersion(), skip, top, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ConsumerGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ConsumerGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ConsumerGroupsInner.this.listByEventHubDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<ConsumerGroupInner> listByEventHub(String resourceGroupName, String namespaceName, String eventHubName, Integer skip, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listByEventHubSinglePageAsync(resourceGroupName, namespaceName, eventHubName, skip, top).toBlocking().single();
        return new PagedList<ConsumerGroupInner>((Page)response.body()){

            public Page<ConsumerGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ConsumerGroupsInner.this.listByEventHubNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ConsumerGroupInner>> listByEventHubAsync(String resourceGroupName, String namespaceName, String eventHubName, Integer skip, Integer top, ListOperationCallback<ConsumerGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByEventHubSinglePageAsync(resourceGroupName, namespaceName, eventHubName, skip, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<ConsumerGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ConsumerGroupInner>>> call(String nextPageLink) {
                return ConsumerGroupsInner.this.listByEventHubNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ConsumerGroupInner>> listByEventHubAsync(String resourceGroupName, String namespaceName, String eventHubName, Integer skip, Integer top) {
        return this.listByEventHubWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, skip, top).map((Func1)new Func1<ServiceResponse<Page<ConsumerGroupInner>>, Page<ConsumerGroupInner>>(){

            public Page<ConsumerGroupInner> call(ServiceResponse<Page<ConsumerGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ConsumerGroupInner>>> listByEventHubWithServiceResponseAsync(String resourceGroupName, String namespaceName, String eventHubName, Integer skip, Integer top) {
        return this.listByEventHubSinglePageAsync(resourceGroupName, namespaceName, eventHubName, skip, top).concatMap((Func1)new Func1<ServiceResponse<Page<ConsumerGroupInner>>, Observable<ServiceResponse<Page<ConsumerGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ConsumerGroupInner>>> call(ServiceResponse<Page<ConsumerGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ConsumerGroupsInner.this.listByEventHubNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ConsumerGroupInner>>> listByEventHubSinglePageAsync(String resourceGroupName, String namespaceName, String eventHubName, Integer skip, Integer top) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (eventHubName == null) {
            throw new IllegalArgumentException("Parameter eventHubName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByEventHub(resourceGroupName, namespaceName, eventHubName, this.client.subscriptionId(), this.client.apiVersion(), skip, top, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ConsumerGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ConsumerGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ConsumerGroupsInner.this.listByEventHubDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ConsumerGroupInner>> listByEventHubDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ConsumerGroupInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<ConsumerGroupInner> listByEventHubNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByEventHubNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ConsumerGroupInner>((Page)response.body()){

            public Page<ConsumerGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ConsumerGroupsInner.this.listByEventHubNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ConsumerGroupInner>> listByEventHubNextAsync(String nextPageLink, ServiceFuture<List<ConsumerGroupInner>> serviceFuture, ListOperationCallback<ConsumerGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByEventHubNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ConsumerGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ConsumerGroupInner>>> call(String nextPageLink) {
                return ConsumerGroupsInner.this.listByEventHubNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ConsumerGroupInner>> listByEventHubNextAsync(String nextPageLink) {
        return this.listByEventHubNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ConsumerGroupInner>>, Page<ConsumerGroupInner>>(){

            public Page<ConsumerGroupInner> call(ServiceResponse<Page<ConsumerGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ConsumerGroupInner>>> listByEventHubNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByEventHubNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ConsumerGroupInner>>, Observable<ServiceResponse<Page<ConsumerGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ConsumerGroupInner>>> call(ServiceResponse<Page<ConsumerGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ConsumerGroupsInner.this.listByEventHubNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ConsumerGroupInner>>> listByEventHubNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByEventHubNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ConsumerGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ConsumerGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ConsumerGroupsInner.this.listByEventHubNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ConsumerGroupInner>> listByEventHubNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ConsumerGroupInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface ConsumerGroupsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.ConsumerGroups createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/consumergroups/{consumerGroupName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="eventHubName") String var3, @Path(value="consumerGroupName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body ConsumerGroupInner var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.ConsumerGroups delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/consumergroups/{consumerGroupName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="eventHubName") String var3, @Path(value="consumerGroupName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.ConsumerGroups get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/consumergroups/{consumerGroupName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="eventHubName") String var3, @Path(value="consumerGroupName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.ConsumerGroups listByEventHub"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/consumergroups")
        public Observable<Response<ResponseBody>> listByEventHub(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="eventHubName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Query(value="$skip") Integer var6, @Query(value="$top") Integer var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.ConsumerGroups listByEventHubNext"})
        @GET
        public Observable<Response<ResponseBody>> listByEventHubNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

