/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.dns.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.dns.RecordType;
import com.microsoft.azure.management.dns.SrvRecordSet;
import com.microsoft.azure.management.dns.SrvRecordSets;
import com.microsoft.azure.management.dns.implementation.DnsManagementClientImpl;
import com.microsoft.azure.management.dns.implementation.DnsRecordSetsBaseImpl;
import com.microsoft.azure.management.dns.implementation.DnsZoneImpl;
import com.microsoft.azure.management.dns.implementation.DnsZoneManager;
import com.microsoft.azure.management.dns.implementation.RecordSetInner;
import com.microsoft.azure.management.dns.implementation.SrvRecordSetImpl;
import rx.Observable;

@LangDefinition
class SrvRecordSetsImpl
extends DnsRecordSetsBaseImpl<SrvRecordSet, SrvRecordSetImpl>
implements SrvRecordSets {
    SrvRecordSetsImpl(DnsZoneImpl dnsZone) {
        super(dnsZone, RecordType.SRV);
    }

    public SrvRecordSetImpl getByName(String name) {
        RecordSetInner inner = ((DnsManagementClientImpl)((Object)((DnsZoneManager)this.parent().manager()).inner())).recordSets().get(this.dnsZone.resourceGroupName(), this.dnsZone.name(), name, this.recordType);
        if (inner == null) {
            return null;
        }
        return new SrvRecordSetImpl(inner.name(), this.dnsZone, inner);
    }

    @Override
    protected PagedList<SrvRecordSet> listIntern(String recordSetNameSuffix, Integer pageSize) {
        return super.wrapList(((DnsManagementClientImpl)((Object)((DnsZoneManager)this.parent().manager()).inner())).recordSets().listByType(this.dnsZone.resourceGroupName(), this.dnsZone.name(), this.recordType, pageSize, recordSetNameSuffix));
    }

    @Override
    protected Observable<SrvRecordSet> listInternAsync(String recordSetNameSuffix, Integer pageSize) {
        return this.wrapPageAsync(((DnsManagementClientImpl)((Object)((DnsZoneManager)this.parent().manager()).inner())).recordSets().listByTypeAsync(this.dnsZone.resourceGroupName(), this.dnsZone.name(), this.recordType));
    }

    protected SrvRecordSetImpl wrapModel(RecordSetInner inner) {
        if (inner == null) {
            return null;
        }
        return new SrvRecordSetImpl(inner.name(), this.dnsZone, inner);
    }
}

