/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.dns.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.dns.ARecordSets;
import com.microsoft.azure.management.dns.AaaaRecordSets;
import com.microsoft.azure.management.dns.CNameRecordSets;
import com.microsoft.azure.management.dns.CaaRecordSets;
import com.microsoft.azure.management.dns.DnsRecordSet;
import com.microsoft.azure.management.dns.DnsZone;
import com.microsoft.azure.management.dns.MXRecordSets;
import com.microsoft.azure.management.dns.NSRecordSets;
import com.microsoft.azure.management.dns.PtrRecordSets;
import com.microsoft.azure.management.dns.RecordType;
import com.microsoft.azure.management.dns.SoaRecordSet;
import com.microsoft.azure.management.dns.SrvRecordSets;
import com.microsoft.azure.management.dns.SubResource;
import com.microsoft.azure.management.dns.TxtRecordSets;
import com.microsoft.azure.management.dns.ZoneType;
import com.microsoft.azure.management.dns.implementation.ARecordSetImpl;
import com.microsoft.azure.management.dns.implementation.ARecordSetsImpl;
import com.microsoft.azure.management.dns.implementation.AaaaRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.AaaaRecordSetsImpl;
import com.microsoft.azure.management.dns.implementation.CNameRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.CNameRecordSetsImpl;
import com.microsoft.azure.management.dns.implementation.CaaRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.CaaRecordSetsImpl;
import com.microsoft.azure.management.dns.implementation.DnsManagementClientImpl;
import com.microsoft.azure.management.dns.implementation.DnsRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.DnsRecordSetsImpl;
import com.microsoft.azure.management.dns.implementation.DnsZoneManager;
import com.microsoft.azure.management.dns.implementation.MXRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.MXRecordSetsImpl;
import com.microsoft.azure.management.dns.implementation.NSRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.NSRecordSetsImpl;
import com.microsoft.azure.management.dns.implementation.PtrRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.PtrRecordSetsImpl;
import com.microsoft.azure.management.dns.implementation.RecordSetInner;
import com.microsoft.azure.management.dns.implementation.SoaRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.SrvRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.SrvRecordSetsImpl;
import com.microsoft.azure.management.dns.implementation.TxtRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.TxtRecordSetsImpl;
import com.microsoft.azure.management.dns.implementation.ZoneInner;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import rx.Completable;
import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;

@LangDefinition
public class DnsZoneImpl
extends GroupableResourceImpl<DnsZone, ZoneInner, DnsZoneImpl, DnsZoneManager>
implements DnsZone,
DnsZone.Definition,
DnsZone.Update {
    private ARecordSets aRecordSets;
    private AaaaRecordSets aaaaRecordSets;
    private CaaRecordSets caaRecordSets;
    private CNameRecordSets cnameRecordSets;
    private MXRecordSets mxRecordSets;
    private NSRecordSets nsRecordSets;
    private PtrRecordSets ptrRecordSets;
    private SrvRecordSets srvRecordSets;
    private TxtRecordSets txtRecordSets;
    private DnsRecordSetsImpl recordSets = new DnsRecordSetsImpl(this);
    private String dnsZoneETag;

    DnsZoneImpl(String name, ZoneInner innerModel, DnsZoneManager manager) {
        super(name, (Resource)innerModel, (ManagerBase)manager);
        this.initRecordSets();
        if (this.isInCreateMode()) {
            ((ZoneInner)((Object)this.inner())).withZoneType(ZoneType.PUBLIC);
        }
    }

    @Override
    public long maxNumberOfRecordSets() {
        return Utils.toPrimitiveLong((Long)((ZoneInner)((Object)this.inner())).maxNumberOfRecordSets());
    }

    @Override
    public long numberOfRecordSets() {
        return Utils.toPrimitiveLong((Long)((ZoneInner)((Object)this.inner())).numberOfRecordSets());
    }

    @Override
    public String eTag() {
        return ((ZoneInner)((Object)this.inner())).etag();
    }

    @Override
    public ZoneType accessType() {
        return ((ZoneInner)((Object)this.inner())).zoneType();
    }

    @Override
    public List<String> registrationVirtualNetworkIds() {
        ArrayList<String> list = new ArrayList<String>();
        if (((ZoneInner)((Object)this.inner())).registrationVirtualNetworks() != null) {
            for (SubResource sb : ((ZoneInner)((Object)this.inner())).registrationVirtualNetworks()) {
                list.add(sb.id());
            }
        }
        return list;
    }

    @Override
    public List<String> resolutionVirtualNetworkIds() {
        ArrayList<String> list = new ArrayList<String>();
        if (((ZoneInner)((Object)this.inner())).resolutionVirtualNetworks() != null) {
            for (SubResource sb : ((ZoneInner)((Object)this.inner())).resolutionVirtualNetworks()) {
                list.add(sb.id());
            }
        }
        return list;
    }

    @Override
    public PagedList<DnsRecordSet> listRecordSets() {
        return this.listRecordSetsIntern(null, null);
    }

    @Override
    public PagedList<DnsRecordSet> listRecordSets(String recordSetNameSuffix) {
        return this.listRecordSetsIntern(recordSetNameSuffix, null);
    }

    @Override
    public PagedList<DnsRecordSet> listRecordSets(int pageSize) {
        return this.listRecordSetsIntern(null, pageSize);
    }

    @Override
    public PagedList<DnsRecordSet> listRecordSets(String recordSetNameSuffix, int pageSize) {
        return this.listRecordSetsIntern(recordSetNameSuffix, pageSize);
    }

    @Override
    public List<String> nameServers() {
        if (this.inner() == null) {
            return new ArrayList<String>();
        }
        return ((ZoneInner)((Object)this.inner())).nameServers();
    }

    @Override
    public ARecordSets aRecordSets() {
        return this.aRecordSets;
    }

    @Override
    public AaaaRecordSets aaaaRecordSets() {
        return this.aaaaRecordSets;
    }

    @Override
    public CaaRecordSets caaRecordSets() {
        return this.caaRecordSets;
    }

    @Override
    public CNameRecordSets cNameRecordSets() {
        return this.cnameRecordSets;
    }

    @Override
    public MXRecordSets mxRecordSets() {
        return this.mxRecordSets;
    }

    @Override
    public NSRecordSets nsRecordSets() {
        return this.nsRecordSets;
    }

    @Override
    public PtrRecordSets ptrRecordSets() {
        return this.ptrRecordSets;
    }

    @Override
    public SrvRecordSets srvRecordSets() {
        return this.srvRecordSets;
    }

    @Override
    public TxtRecordSets txtRecordSets() {
        return this.txtRecordSets;
    }

    @Override
    public SoaRecordSet getSoaRecordSet() {
        RecordSetInner inner = ((DnsManagementClientImpl)((Object)((DnsZoneManager)this.manager()).inner())).recordSets().get(this.resourceGroupName(), this.name(), "@", RecordType.SOA);
        if (inner == null) {
            return null;
        }
        return new SoaRecordSetImpl(inner.name(), this, inner);
    }

    public DnsRecordSetImpl defineARecordSet(String name) {
        return this.recordSets.defineARecordSet(name);
    }

    public DnsRecordSetImpl defineAaaaRecordSet(String name) {
        return this.recordSets.defineAaaaRecordSet(name);
    }

    public DnsRecordSetImpl defineCaaRecordSet(String name) {
        return this.recordSets.defineCaaRecordSet(name);
    }

    @Override
    public DnsZoneImpl withCNameRecordSet(String name, String alias) {
        this.recordSets.withCNameRecordSet(name, alias);
        return this;
    }

    public DnsRecordSetImpl defineCNameRecordSet(String name) {
        return this.recordSets.defineCNameRecordSet(name);
    }

    public DnsRecordSetImpl defineMXRecordSet(String name) {
        return this.recordSets.defineMXRecordSet(name);
    }

    public DnsRecordSetImpl defineNSRecordSet(String name) {
        return this.recordSets.defineNSRecordSet(name);
    }

    public DnsRecordSetImpl definePtrRecordSet(String name) {
        return this.recordSets.definePtrRecordSet(name);
    }

    public DnsRecordSetImpl defineSrvRecordSet(String name) {
        return this.recordSets.defineSrvRecordSet(name);
    }

    public DnsRecordSetImpl defineTxtRecordSet(String name) {
        return this.recordSets.defineTxtRecordSet(name);
    }

    @Override
    public DnsRecordSetImpl updateARecordSet(String name) {
        return this.recordSets.updateARecordSet(name);
    }

    @Override
    public DnsRecordSetImpl updateAaaaRecordSet(String name) {
        return this.recordSets.updateAaaaRecordSet(name);
    }

    @Override
    public DnsRecordSetImpl updateCaaRecordSet(String name) {
        return this.recordSets.updateCaaRecordSet(name);
    }

    @Override
    public DnsRecordSetImpl updateMXRecordSet(String name) {
        return this.recordSets.updateMXRecordSet(name);
    }

    @Override
    public DnsRecordSetImpl updateCNameRecordSet(String name) {
        return this.recordSets.updateCNameRecordSet(name);
    }

    @Override
    public DnsRecordSetImpl updateNSRecordSet(String name) {
        return this.recordSets.updateNSRecordSet(name);
    }

    @Override
    public DnsRecordSetImpl updatePtrRecordSet(String name) {
        return this.recordSets.updatePtrRecordSet(name);
    }

    @Override
    public DnsRecordSetImpl updateSrvRecordSet(String name) {
        return this.recordSets.updateSrvRecordSet(name);
    }

    @Override
    public DnsRecordSetImpl updateTxtRecordSet(String name) {
        return this.recordSets.updateTxtRecordSet(name);
    }

    @Override
    public DnsRecordSetImpl updateSoaRecord() {
        return this.recordSets.updateSoaRecordSet();
    }

    @Override
    public DnsZoneImpl withoutARecordSet(String name) {
        return this.withoutARecordSet(name, null);
    }

    @Override
    public DnsZoneImpl withoutARecordSet(String name, String eTag) {
        this.recordSets.withoutARecordSet(name, eTag);
        return this;
    }

    @Override
    public DnsZoneImpl withoutAaaaRecordSet(String name) {
        return this.withoutAaaaRecordSet(name, null);
    }

    @Override
    public DnsZoneImpl withoutAaaaRecordSet(String name, String eTag) {
        this.recordSets.withoutAaaaRecordSet(name, eTag);
        return this;
    }

    @Override
    public DnsZoneImpl withoutCaaRecordSet(String name) {
        return this.withoutCaaRecordSet(name, null);
    }

    @Override
    public DnsZoneImpl withoutCaaRecordSet(String name, String eTag) {
        this.recordSets.withoutCaaRecordSet(name, eTag);
        return this;
    }

    @Override
    public DnsZoneImpl withoutCNameRecordSet(String name) {
        return this.withoutCNameRecordSet(name, null);
    }

    @Override
    public DnsZoneImpl withoutCNameRecordSet(String name, String eTag) {
        this.recordSets.withoutCNameRecordSet(name, eTag);
        return this;
    }

    @Override
    public DnsZoneImpl withoutMXRecordSet(String name) {
        return this.withoutMXRecordSet(name, null);
    }

    @Override
    public DnsZoneImpl withoutMXRecordSet(String name, String eTag) {
        this.recordSets.withoutMXRecordSet(name, eTag);
        return this;
    }

    @Override
    public DnsZoneImpl withoutNSRecordSet(String name) {
        return this.withoutNSRecordSet(name, null);
    }

    @Override
    public DnsZoneImpl withoutNSRecordSet(String name, String eTag) {
        this.recordSets.withoutNSRecordSet(name, eTag);
        return this;
    }

    @Override
    public DnsZoneImpl withoutPtrRecordSet(String name) {
        return this.withoutPtrRecordSet(name, null);
    }

    @Override
    public DnsZoneImpl withoutPtrRecordSet(String name, String eTag) {
        this.recordSets.withoutPtrRecordSet(name, eTag);
        return this;
    }

    @Override
    public DnsZoneImpl withoutSrvRecordSet(String name) {
        return this.withoutSrvRecordSet(name, null);
    }

    @Override
    public DnsZoneImpl withoutSrvRecordSet(String name, String eTag) {
        this.recordSets.withoutSrvRecordSet(name, eTag);
        return this;
    }

    @Override
    public DnsZoneImpl withoutTxtRecordSet(String name) {
        return this.withoutTxtRecordSet(name, null);
    }

    @Override
    public DnsZoneImpl withoutTxtRecordSet(String name, String eTag) {
        this.recordSets.withoutTxtRecordSet(name, eTag);
        return this;
    }

    @Override
    public DnsZoneImpl withETagCheck() {
        if (this.isInCreateMode()) {
            this.dnsZoneETag = "*";
            return this;
        }
        return this.withETagCheck(((ZoneInner)((Object)this.inner())).etag());
    }

    @Override
    public DnsZoneImpl withETagCheck(String eTagValue) {
        this.dnsZoneETag = eTagValue;
        return this;
    }

    public Observable<DnsZone> createResourceAsync() {
        final DnsZoneImpl self = this;
        Func0<Observable<ZoneInner>> createOrUpdateAsync = new Func0<Observable<ZoneInner>>(){

            public Observable<ZoneInner> call() {
                if (self.isInCreateMode()) {
                    return ((DnsManagementClientImpl)((Object)((DnsZoneManager)self.manager()).inner())).zones().createOrUpdateAsync(self.resourceGroupName(), self.name(), (ZoneInner)((Object)self.inner()), null, self.dnsZoneETag);
                }
                return ((DnsManagementClientImpl)((Object)((DnsZoneManager)self.manager()).inner())).zones().createOrUpdateAsync(self.resourceGroupName(), self.name(), (ZoneInner)((Object)self.inner()), self.dnsZoneETag, null);
            }
        };
        return ((Observable)createOrUpdateAsync.call()).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).map((Func1)new Func1<DnsZone, DnsZone>(){

            public DnsZone call(DnsZone dnsZone) {
                self.dnsZoneETag = null;
                return dnsZone;
            }
        });
    }

    public Completable afterPostRunAsync(boolean isGroupFaulted) {
        this.recordSets.clear();
        return Completable.complete();
    }

    public Observable<DnsZone> refreshAsync() {
        return super.refreshAsync().map((Func1)new Func1<DnsZone, DnsZone>(){

            public DnsZone call(DnsZone dnsZone) {
                DnsZoneImpl impl = (DnsZoneImpl)dnsZone;
                impl.initRecordSets();
                return impl;
            }
        });
    }

    protected Observable<ZoneInner> getInnerAsync() {
        return ((DnsManagementClientImpl)((Object)((DnsZoneManager)this.manager()).inner())).zones().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    private void initRecordSets() {
        this.aRecordSets = new ARecordSetsImpl(this);
        this.aaaaRecordSets = new AaaaRecordSetsImpl(this);
        this.caaRecordSets = new CaaRecordSetsImpl(this);
        this.cnameRecordSets = new CNameRecordSetsImpl(this);
        this.mxRecordSets = new MXRecordSetsImpl(this);
        this.nsRecordSets = new NSRecordSetsImpl(this);
        this.ptrRecordSets = new PtrRecordSetsImpl(this);
        this.srvRecordSets = new SrvRecordSetsImpl(this);
        this.txtRecordSets = new TxtRecordSetsImpl(this);
        this.recordSets.clear();
    }

    private PagedList<DnsRecordSet> listRecordSetsIntern(String recordSetSuffix, Integer pageSize) {
        final DnsZoneImpl self = this;
        PagedListConverter<RecordSetInner, DnsRecordSet> converter = new PagedListConverter<RecordSetInner, DnsRecordSet>(){

            public Observable<DnsRecordSet> typeConvertAsync(RecordSetInner inner) {
                DnsRecordSetImpl recordSet = new DnsRecordSetImpl(inner.name(), inner.type(), self, inner);
                switch (recordSet.recordType()) {
                    case A: {
                        return Observable.just((Object)new ARecordSetImpl(inner.name(), self, inner));
                    }
                    case AAAA: {
                        return Observable.just((Object)new AaaaRecordSetImpl(inner.name(), self, inner));
                    }
                    case CAA: {
                        return Observable.just((Object)new CaaRecordSetImpl(inner.name(), self, inner));
                    }
                    case CNAME: {
                        return Observable.just((Object)new CNameRecordSetImpl(inner.name(), self, inner));
                    }
                    case MX: {
                        return Observable.just((Object)new MXRecordSetImpl(inner.name(), self, inner));
                    }
                    case NS: {
                        return Observable.just((Object)new NSRecordSetImpl(inner.name(), self, inner));
                    }
                    case PTR: {
                        return Observable.just((Object)new PtrRecordSetImpl(inner.name(), self, inner));
                    }
                    case SOA: {
                        return Observable.just((Object)new SoaRecordSetImpl(inner.name(), self, inner));
                    }
                    case SRV: {
                        return Observable.just((Object)new SrvRecordSetImpl(inner.name(), self, inner));
                    }
                    case TXT: {
                        return Observable.just((Object)new TxtRecordSetImpl(inner.name(), self, inner));
                    }
                }
                return Observable.just((Object)recordSet);
            }
        };
        return converter.convert(((DnsManagementClientImpl)((Object)((DnsZoneManager)this.manager()).inner())).recordSets().listByDnsZone(this.resourceGroupName(), this.name(), pageSize, recordSetSuffix));
    }

    @Override
    public DnsZoneImpl withPublicAccess() {
        ((ZoneInner)((Object)this.inner())).withZoneType(ZoneType.PUBLIC);
        ((ZoneInner)((Object)this.inner())).withRegistrationVirtualNetworks(null);
        ((ZoneInner)((Object)this.inner())).withResolutionVirtualNetworks(null);
        return this;
    }

    @Override
    public DnsZoneImpl withPrivateAccess() {
        ((ZoneInner)((Object)this.inner())).withZoneType(ZoneType.PRIVATE);
        ((ZoneInner)((Object)this.inner())).withRegistrationVirtualNetworks(null);
        ((ZoneInner)((Object)this.inner())).withResolutionVirtualNetworks(null);
        return this;
    }

    @Override
    public DnsZoneImpl withPrivateAccess(List<String> registrationVirtualNetworkIds, List<String> resolutionVirtualNetworkIds) {
        SubResource sb;
        this.withPrivateAccess();
        ((ZoneInner)((Object)this.inner())).withRegistrationVirtualNetworks(new ArrayList<SubResource>());
        ((ZoneInner)((Object)this.inner())).withResolutionVirtualNetworks(new ArrayList<SubResource>());
        for (String rvnId : registrationVirtualNetworkIds) {
            sb = new SubResource();
            sb.withId(rvnId);
            ((ZoneInner)((Object)this.inner())).registrationVirtualNetworks().add(sb);
        }
        for (String rvnId : resolutionVirtualNetworkIds) {
            sb = new SubResource();
            sb.withId(rvnId);
            ((ZoneInner)((Object)this.inner())).resolutionVirtualNetworks().add(sb);
        }
        return this;
    }
}

