/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cosmosdb.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.cosmosdb.TableCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.ThroughputSettingsUpdateParameters;
import com.microsoft.azure.management.cosmosdb.implementation.CosmosDBImpl;
import com.microsoft.azure.management.cosmosdb.implementation.PageImpl;
import com.microsoft.azure.management.cosmosdb.implementation.TableGetResultsInner;
import com.microsoft.azure.management.cosmosdb.implementation.ThroughputSettingsGetResultsInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class TableResourcesInner {
    private TableResourcesService service;
    private CosmosDBImpl client;

    public TableResourcesInner(Retrofit retrofit, CosmosDBImpl client) {
        this.service = (TableResourcesService)retrofit.create(TableResourcesService.class);
        this.client = client;
    }

    public List<TableGetResultsInner> listTables(String resourceGroupName, String accountName) {
        return (List)((ServiceResponse)this.listTablesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<List<TableGetResultsInner>> listTablesAsync(String resourceGroupName, String accountName, ServiceCallback<List<TableGetResultsInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listTablesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<List<TableGetResultsInner>> listTablesAsync(String resourceGroupName, String accountName) {
        return this.listTablesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<List<TableGetResultsInner>>, List<TableGetResultsInner>>(){

            public List<TableGetResultsInner> call(ServiceResponse<List<TableGetResultsInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<TableGetResultsInner>>> listTablesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.listTables(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<TableGetResultsInner>>>>(){

            public Observable<ServiceResponse<List<TableGetResultsInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = TableResourcesInner.this.listTablesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<TableGetResultsInner>> listTablesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<TableGetResultsInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public TableGetResultsInner getTable(String resourceGroupName, String accountName, String tableName) {
        return (TableGetResultsInner)((Object)((ServiceResponse)this.getTableWithServiceResponseAsync(resourceGroupName, accountName, tableName).toBlocking().single()).body());
    }

    public ServiceFuture<TableGetResultsInner> getTableAsync(String resourceGroupName, String accountName, String tableName, ServiceCallback<TableGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getTableWithServiceResponseAsync(resourceGroupName, accountName, tableName), serviceCallback);
    }

    public Observable<TableGetResultsInner> getTableAsync(String resourceGroupName, String accountName, String tableName) {
        return this.getTableWithServiceResponseAsync(resourceGroupName, accountName, tableName).map((Func1)new Func1<ServiceResponse<TableGetResultsInner>, TableGetResultsInner>(){

            public TableGetResultsInner call(ServiceResponse<TableGetResultsInner> response) {
                return (TableGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<TableGetResultsInner>> getTableWithServiceResponseAsync(String resourceGroupName, String accountName, String tableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.getTable(this.client.subscriptionId(), resourceGroupName, accountName, tableName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TableGetResultsInner>>>(){

            public Observable<ServiceResponse<TableGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TableResourcesInner.this.getTableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TableGetResultsInner> getTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TableGetResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public TableGetResultsInner createUpdateTable(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters) {
        return (TableGetResultsInner)((Object)((ServiceResponse)this.createUpdateTableWithServiceResponseAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters).toBlocking().last()).body());
    }

    public ServiceFuture<TableGetResultsInner> createUpdateTableAsync(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters, ServiceCallback<TableGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateTableWithServiceResponseAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters), serviceCallback);
    }

    public Observable<TableGetResultsInner> createUpdateTableAsync(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters) {
        return this.createUpdateTableWithServiceResponseAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters).map((Func1)new Func1<ServiceResponse<TableGetResultsInner>, TableGetResultsInner>(){

            public TableGetResultsInner call(ServiceResponse<TableGetResultsInner> response) {
                return (TableGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<TableGetResultsInner>> createUpdateTableWithServiceResponseAsync(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (createUpdateTableParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateTableParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateTableParameters));
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.createUpdateTable(this.client.subscriptionId(), resourceGroupName, accountName, tableName, "2019-08-01", createUpdateTableParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<TableGetResultsInner>(){}.getType());
    }

    public TableGetResultsInner beginCreateUpdateTable(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters) {
        return (TableGetResultsInner)((Object)((ServiceResponse)this.beginCreateUpdateTableWithServiceResponseAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters).toBlocking().single()).body());
    }

    public ServiceFuture<TableGetResultsInner> beginCreateUpdateTableAsync(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters, ServiceCallback<TableGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateTableWithServiceResponseAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters), serviceCallback);
    }

    public Observable<TableGetResultsInner> beginCreateUpdateTableAsync(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters) {
        return this.beginCreateUpdateTableWithServiceResponseAsync(resourceGroupName, accountName, tableName, createUpdateTableParameters).map((Func1)new Func1<ServiceResponse<TableGetResultsInner>, TableGetResultsInner>(){

            public TableGetResultsInner call(ServiceResponse<TableGetResultsInner> response) {
                return (TableGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<TableGetResultsInner>> beginCreateUpdateTableWithServiceResponseAsync(String resourceGroupName, String accountName, String tableName, TableCreateUpdateParameters createUpdateTableParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (createUpdateTableParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateTableParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateTableParameters));
        String apiVersion = "2019-08-01";
        return this.service.beginCreateUpdateTable(this.client.subscriptionId(), resourceGroupName, accountName, tableName, "2019-08-01", createUpdateTableParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TableGetResultsInner>>>(){

            public Observable<ServiceResponse<TableGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TableResourcesInner.this.beginCreateUpdateTableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TableGetResultsInner> beginCreateUpdateTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TableGetResultsInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteTable(String resourceGroupName, String accountName, String tableName) {
        ((ServiceResponse)this.deleteTableWithServiceResponseAsync(resourceGroupName, accountName, tableName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteTableAsync(String resourceGroupName, String accountName, String tableName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteTableWithServiceResponseAsync(resourceGroupName, accountName, tableName), serviceCallback);
    }

    public Observable<Void> deleteTableAsync(String resourceGroupName, String accountName, String tableName) {
        return this.deleteTableWithServiceResponseAsync(resourceGroupName, accountName, tableName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteTableWithServiceResponseAsync(String resourceGroupName, String accountName, String tableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.deleteTable(this.client.subscriptionId(), resourceGroupName, accountName, tableName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteTable(String resourceGroupName, String accountName, String tableName) {
        ((ServiceResponse)this.beginDeleteTableWithServiceResponseAsync(resourceGroupName, accountName, tableName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteTableAsync(String resourceGroupName, String accountName, String tableName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteTableWithServiceResponseAsync(resourceGroupName, accountName, tableName), serviceCallback);
    }

    public Observable<Void> beginDeleteTableAsync(String resourceGroupName, String accountName, String tableName) {
        return this.beginDeleteTableWithServiceResponseAsync(resourceGroupName, accountName, tableName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteTableWithServiceResponseAsync(String resourceGroupName, String accountName, String tableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.beginDeleteTable(this.client.subscriptionId(), resourceGroupName, accountName, tableName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TableResourcesInner.this.beginDeleteTableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputSettingsGetResultsInner getTableThroughput(String resourceGroupName, String accountName, String tableName) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.getTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> getTableThroughputAsync(String resourceGroupName, String accountName, String tableName, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> getTableThroughputAsync(String resourceGroupName, String accountName, String tableName) {
        return this.getTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> getTableThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String tableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.getTableThroughput(this.client.subscriptionId(), resourceGroupName, accountName, tableName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputSettingsGetResultsInner>>>(){

            public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TableResourcesInner.this.getTableThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputSettingsGetResultsInner> getTableThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputSettingsGetResultsInner updateTableThroughput(String resourceGroupName, String accountName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.updateTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName, updateThroughputParameters).toBlocking().last()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> updateTableThroughputAsync(String resourceGroupName, String accountName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName, updateThroughputParameters), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> updateTableThroughputAsync(String resourceGroupName, String accountName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.updateTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName, updateThroughputParameters).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> updateTableThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (updateThroughputParameters == null) {
            throw new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)updateThroughputParameters));
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.updateTableThroughput(this.client.subscriptionId(), resourceGroupName, accountName, tableName, "2019-08-01", updateThroughputParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType());
    }

    public ThroughputSettingsGetResultsInner beginUpdateTableThroughput(String resourceGroupName, String accountName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.beginUpdateTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName, updateThroughputParameters).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> beginUpdateTableThroughputAsync(String resourceGroupName, String accountName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName, updateThroughputParameters), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> beginUpdateTableThroughputAsync(String resourceGroupName, String accountName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.beginUpdateTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, tableName, updateThroughputParameters).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> beginUpdateTableThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (updateThroughputParameters == null) {
            throw new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)updateThroughputParameters));
        String apiVersion = "2019-08-01";
        return this.service.beginUpdateTableThroughput(this.client.subscriptionId(), resourceGroupName, accountName, tableName, "2019-08-01", updateThroughputParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputSettingsGetResultsInner>>>(){

            public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TableResourcesInner.this.beginUpdateTableThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputSettingsGetResultsInner> beginUpdateTableThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface TableResourcesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.TableResources listTables"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/tables")
        public Observable<Response<ResponseBody>> listTables(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.TableResources getTable"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/tables/{tableName}")
        public Observable<Response<ResponseBody>> getTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="tableName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.TableResources createUpdateTable"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/tables/{tableName}")
        public Observable<Response<ResponseBody>> createUpdateTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="tableName") String var4, @Query(value="api-version") String var5, @Body TableCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.TableResources beginCreateUpdateTable"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/tables/{tableName}")
        public Observable<Response<ResponseBody>> beginCreateUpdateTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="tableName") String var4, @Query(value="api-version") String var5, @Body TableCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.TableResources deleteTable"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/tables/{tableName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="tableName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.TableResources beginDeleteTable"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/tables/{tableName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="tableName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.TableResources getTableThroughput"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/tables/{tableName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> getTableThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="tableName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.TableResources updateTableThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/tables/{tableName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> updateTableThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="tableName") String var4, @Query(value="api-version") String var5, @Body ThroughputSettingsUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.TableResources beginUpdateTableThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/tables/{tableName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> beginUpdateTableThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="tableName") String var4, @Query(value="api-version") String var5, @Body ThroughputSettingsUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);
    }
}

