/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerservice.implementation;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.containerservice.ContainerServices;
import com.microsoft.azure.management.containerservice.KubernetesClusters;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceManagementClientImpl;
import com.microsoft.azure.management.containerservice.implementation.ContainerServicesImpl;
import com.microsoft.azure.management.containerservice.implementation.KubernetesClustersImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.Manager;
import com.microsoft.azure.management.resources.fluentcore.utils.ProviderRegistrationInterceptor;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceManagerThrottlingInterceptor;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.Environment;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import okhttp3.Interceptor;

@Beta(value=Beta.SinceVersion.V1_4_0)
public final class ContainerServiceManager
extends Manager<ContainerServiceManager, ContainerServiceManagementClientImpl> {
    private ContainerServicesImpl containerServices;
    private KubernetesClustersImpl kubernetesClusters;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static ContainerServiceManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
        return new ContainerServiceManager(new RestClient.Builder().withBaseUrl((Environment)credentials.environment(), (Environment.Endpoint)AzureEnvironment.Endpoint.RESOURCE_MANAGER).withCredentials((ServiceClientCredentials)credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).withInterceptor((Interceptor)new ProviderRegistrationInterceptor(credentials)).withInterceptor((Interceptor)new ResourceManagerThrottlingInterceptor()).build(), subscriptionId);
    }

    public static ContainerServiceManager authenticate(RestClient restClient, String subscriptionId) {
        return new ContainerServiceManager(restClient, subscriptionId);
    }

    private ContainerServiceManager(RestClient restClient, String subscriptionId) {
        super(restClient, subscriptionId, (Object)new ContainerServiceManagementClientImpl(restClient).withSubscriptionId(subscriptionId));
    }

    public ContainerServices containerServices() {
        if (this.containerServices == null) {
            this.containerServices = new ContainerServicesImpl(this);
        }
        return this.containerServices;
    }

    public KubernetesClusters kubernetesClusters() {
        if (this.kubernetesClusters == null) {
            this.kubernetesClusters = new KubernetesClustersImpl(this);
        }
        return this.kubernetesClusters;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public ContainerServiceManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
            return ContainerServiceManager.authenticate(this.buildRestClient(credentials), subscriptionId);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public ContainerServiceManager authenticate(AzureTokenCredentials var1, String var2);
    }
}

