/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.containerregistry.WebhookCreateParameters;
import com.microsoft.azure.management.containerregistry.WebhookUpdateParameters;
import com.microsoft.azure.management.containerregistry.implementation.CallbackConfigInner;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.microsoft.azure.management.containerregistry.implementation.EventInfoInner;
import com.microsoft.azure.management.containerregistry.implementation.EventInner;
import com.microsoft.azure.management.containerregistry.implementation.PageImpl;
import com.microsoft.azure.management.containerregistry.implementation.WebhookInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class WebhooksInner {
    private WebhooksService service;
    private ContainerRegistryManagementClientImpl client;

    public WebhooksInner(Retrofit retrofit, ContainerRegistryManagementClientImpl client) {
        this.service = (WebhooksService)retrofit.create(WebhooksService.class);
        this.client = client;
    }

    public WebhookInner get(String resourceGroupName, String registryName, String webhookName) {
        return (WebhookInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, registryName, webhookName).toBlocking().single()).body());
    }

    public ServiceFuture<WebhookInner> getAsync(String resourceGroupName, String registryName, String webhookName, ServiceCallback<WebhookInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, registryName, webhookName), serviceCallback);
    }

    public Observable<WebhookInner> getAsync(String resourceGroupName, String registryName, String webhookName) {
        return this.getWithServiceResponseAsync(resourceGroupName, registryName, webhookName).map((Func1)new Func1<ServiceResponse<WebhookInner>, WebhookInner>(){

            public WebhookInner call(ServiceResponse<WebhookInner> response) {
                return (WebhookInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<WebhookInner>> getWithServiceResponseAsync(String resourceGroupName, String registryName, String webhookName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (webhookName == null) {
            throw new IllegalArgumentException("Parameter webhookName is required and cannot be null.");
        }
        String apiVersion = "2017-10-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, registryName, webhookName, "2017-10-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<WebhookInner>>>(){

            public Observable<ServiceResponse<WebhookInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebhooksInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<WebhookInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<WebhookInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public WebhookInner create(String resourceGroupName, String registryName, String webhookName, WebhookCreateParameters webhookCreateParameters) {
        return (WebhookInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters).toBlocking().last()).body());
    }

    public ServiceFuture<WebhookInner> createAsync(String resourceGroupName, String registryName, String webhookName, WebhookCreateParameters webhookCreateParameters, ServiceCallback<WebhookInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters), serviceCallback);
    }

    public Observable<WebhookInner> createAsync(String resourceGroupName, String registryName, String webhookName, WebhookCreateParameters webhookCreateParameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters).map((Func1)new Func1<ServiceResponse<WebhookInner>, WebhookInner>(){

            public WebhookInner call(ServiceResponse<WebhookInner> response) {
                return (WebhookInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<WebhookInner>> createWithServiceResponseAsync(String resourceGroupName, String registryName, String webhookName, WebhookCreateParameters webhookCreateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (webhookName == null) {
            throw new IllegalArgumentException("Parameter webhookName is required and cannot be null.");
        }
        if (webhookCreateParameters == null) {
            throw new IllegalArgumentException("Parameter webhookCreateParameters is required and cannot be null.");
        }
        Validator.validate((Object)webhookCreateParameters);
        String apiVersion = "2017-10-01";
        Observable<Response<ResponseBody>> observable = this.service.create(this.client.subscriptionId(), resourceGroupName, registryName, webhookName, "2017-10-01", webhookCreateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<WebhookInner>(){}.getType());
    }

    public WebhookInner beginCreate(String resourceGroupName, String registryName, String webhookName, WebhookCreateParameters webhookCreateParameters) {
        return (WebhookInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters).toBlocking().single()).body());
    }

    public ServiceFuture<WebhookInner> beginCreateAsync(String resourceGroupName, String registryName, String webhookName, WebhookCreateParameters webhookCreateParameters, ServiceCallback<WebhookInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters), serviceCallback);
    }

    public Observable<WebhookInner> beginCreateAsync(String resourceGroupName, String registryName, String webhookName, WebhookCreateParameters webhookCreateParameters) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters).map((Func1)new Func1<ServiceResponse<WebhookInner>, WebhookInner>(){

            public WebhookInner call(ServiceResponse<WebhookInner> response) {
                return (WebhookInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<WebhookInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String registryName, String webhookName, WebhookCreateParameters webhookCreateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (webhookName == null) {
            throw new IllegalArgumentException("Parameter webhookName is required and cannot be null.");
        }
        if (webhookCreateParameters == null) {
            throw new IllegalArgumentException("Parameter webhookCreateParameters is required and cannot be null.");
        }
        Validator.validate((Object)webhookCreateParameters);
        String apiVersion = "2017-10-01";
        return this.service.beginCreate(this.client.subscriptionId(), resourceGroupName, registryName, webhookName, "2017-10-01", webhookCreateParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<WebhookInner>>>(){

            public Observable<ServiceResponse<WebhookInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebhooksInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<WebhookInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<WebhookInner>(){}.getType()).register(201, new TypeToken<WebhookInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String registryName, String webhookName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, registryName, webhookName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String registryName, String webhookName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, registryName, webhookName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String registryName, String webhookName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, registryName, webhookName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String registryName, String webhookName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (webhookName == null) {
            throw new IllegalArgumentException("Parameter webhookName is required and cannot be null.");
        }
        String apiVersion = "2017-10-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, registryName, webhookName, "2017-10-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String registryName, String webhookName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, webhookName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String registryName, String webhookName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, webhookName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String registryName, String webhookName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, webhookName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String registryName, String webhookName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (webhookName == null) {
            throw new IllegalArgumentException("Parameter webhookName is required and cannot be null.");
        }
        String apiVersion = "2017-10-01";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, registryName, webhookName, "2017-10-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebhooksInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public WebhookInner update(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParameters webhookUpdateParameters) {
        return (WebhookInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters).toBlocking().last()).body());
    }

    public ServiceFuture<WebhookInner> updateAsync(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParameters webhookUpdateParameters, ServiceCallback<WebhookInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters), serviceCallback);
    }

    public Observable<WebhookInner> updateAsync(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParameters webhookUpdateParameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters).map((Func1)new Func1<ServiceResponse<WebhookInner>, WebhookInner>(){

            public WebhookInner call(ServiceResponse<WebhookInner> response) {
                return (WebhookInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<WebhookInner>> updateWithServiceResponseAsync(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParameters webhookUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (webhookName == null) {
            throw new IllegalArgumentException("Parameter webhookName is required and cannot be null.");
        }
        if (webhookUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter webhookUpdateParameters is required and cannot be null.");
        }
        Validator.validate((Object)webhookUpdateParameters);
        String apiVersion = "2017-10-01";
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, registryName, webhookName, "2017-10-01", webhookUpdateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<WebhookInner>(){}.getType());
    }

    public WebhookInner beginUpdate(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParameters webhookUpdateParameters) {
        return (WebhookInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters).toBlocking().single()).body());
    }

    public ServiceFuture<WebhookInner> beginUpdateAsync(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParameters webhookUpdateParameters, ServiceCallback<WebhookInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters), serviceCallback);
    }

    public Observable<WebhookInner> beginUpdateAsync(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParameters webhookUpdateParameters) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters).map((Func1)new Func1<ServiceResponse<WebhookInner>, WebhookInner>(){

            public WebhookInner call(ServiceResponse<WebhookInner> response) {
                return (WebhookInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<WebhookInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParameters webhookUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (webhookName == null) {
            throw new IllegalArgumentException("Parameter webhookName is required and cannot be null.");
        }
        if (webhookUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter webhookUpdateParameters is required and cannot be null.");
        }
        Validator.validate((Object)webhookUpdateParameters);
        String apiVersion = "2017-10-01";
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, registryName, webhookName, "2017-10-01", webhookUpdateParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<WebhookInner>>>(){

            public Observable<ServiceResponse<WebhookInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebhooksInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<WebhookInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<WebhookInner>(){}.getType()).register(201, new TypeToken<WebhookInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<WebhookInner> list(String resourceGroupName, String registryName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, registryName).toBlocking().single();
        return new PagedList<WebhookInner>((Page)response.body()){

            public Page<WebhookInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebhooksInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<WebhookInner>> listAsync(String resourceGroupName, String registryName, ListOperationCallback<WebhookInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, registryName), (Func1)new Func1<String, Observable<ServiceResponse<Page<WebhookInner>>>>(){

            public Observable<ServiceResponse<Page<WebhookInner>>> call(String nextPageLink) {
                return WebhooksInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<WebhookInner>> listAsync(String resourceGroupName, String registryName) {
        return this.listWithServiceResponseAsync(resourceGroupName, registryName).map((Func1)new Func1<ServiceResponse<Page<WebhookInner>>, Page<WebhookInner>>(){

            public Page<WebhookInner> call(ServiceResponse<Page<WebhookInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<WebhookInner>>> listWithServiceResponseAsync(String resourceGroupName, String registryName) {
        return this.listSinglePageAsync(resourceGroupName, registryName).concatMap((Func1)new Func1<ServiceResponse<Page<WebhookInner>>, Observable<ServiceResponse<Page<WebhookInner>>>>(){

            public Observable<ServiceResponse<Page<WebhookInner>>> call(ServiceResponse<Page<WebhookInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebhooksInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<WebhookInner>>> listSinglePageAsync(String resourceGroupName, String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        String apiVersion = "2017-10-01";
        return this.service.list(this.client.subscriptionId(), resourceGroupName, registryName, "2017-10-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WebhookInner>>>>(){

            public Observable<ServiceResponse<Page<WebhookInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebhooksInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<WebhookInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<WebhookInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public EventInfoInner ping(String resourceGroupName, String registryName, String webhookName) {
        return (EventInfoInner)((ServiceResponse)this.pingWithServiceResponseAsync(resourceGroupName, registryName, webhookName).toBlocking().single()).body();
    }

    public ServiceFuture<EventInfoInner> pingAsync(String resourceGroupName, String registryName, String webhookName, ServiceCallback<EventInfoInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.pingWithServiceResponseAsync(resourceGroupName, registryName, webhookName), serviceCallback);
    }

    public Observable<EventInfoInner> pingAsync(String resourceGroupName, String registryName, String webhookName) {
        return this.pingWithServiceResponseAsync(resourceGroupName, registryName, webhookName).map((Func1)new Func1<ServiceResponse<EventInfoInner>, EventInfoInner>(){

            public EventInfoInner call(ServiceResponse<EventInfoInner> response) {
                return (EventInfoInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<EventInfoInner>> pingWithServiceResponseAsync(String resourceGroupName, String registryName, String webhookName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (webhookName == null) {
            throw new IllegalArgumentException("Parameter webhookName is required and cannot be null.");
        }
        String apiVersion = "2017-10-01";
        return this.service.ping(this.client.subscriptionId(), resourceGroupName, registryName, webhookName, "2017-10-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<EventInfoInner>>>(){

            public Observable<ServiceResponse<EventInfoInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebhooksInner.this.pingDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<EventInfoInner> pingDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<EventInfoInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public CallbackConfigInner getCallbackConfig(String resourceGroupName, String registryName, String webhookName) {
        return (CallbackConfigInner)((ServiceResponse)this.getCallbackConfigWithServiceResponseAsync(resourceGroupName, registryName, webhookName).toBlocking().single()).body();
    }

    public ServiceFuture<CallbackConfigInner> getCallbackConfigAsync(String resourceGroupName, String registryName, String webhookName, ServiceCallback<CallbackConfigInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getCallbackConfigWithServiceResponseAsync(resourceGroupName, registryName, webhookName), serviceCallback);
    }

    public Observable<CallbackConfigInner> getCallbackConfigAsync(String resourceGroupName, String registryName, String webhookName) {
        return this.getCallbackConfigWithServiceResponseAsync(resourceGroupName, registryName, webhookName).map((Func1)new Func1<ServiceResponse<CallbackConfigInner>, CallbackConfigInner>(){

            public CallbackConfigInner call(ServiceResponse<CallbackConfigInner> response) {
                return (CallbackConfigInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CallbackConfigInner>> getCallbackConfigWithServiceResponseAsync(String resourceGroupName, String registryName, String webhookName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (webhookName == null) {
            throw new IllegalArgumentException("Parameter webhookName is required and cannot be null.");
        }
        String apiVersion = "2017-10-01";
        return this.service.getCallbackConfig(this.client.subscriptionId(), resourceGroupName, registryName, webhookName, "2017-10-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CallbackConfigInner>>>(){

            public Observable<ServiceResponse<CallbackConfigInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebhooksInner.this.getCallbackConfigDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CallbackConfigInner> getCallbackConfigDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CallbackConfigInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<EventInner> listEvents(String resourceGroupName, String registryName, String webhookName) {
        ServiceResponse response = (ServiceResponse)this.listEventsSinglePageAsync(resourceGroupName, registryName, webhookName).toBlocking().single();
        return new PagedList<EventInner>((Page)response.body()){

            public Page<EventInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebhooksInner.this.listEventsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<EventInner>> listEventsAsync(String resourceGroupName, String registryName, String webhookName, ListOperationCallback<EventInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listEventsSinglePageAsync(resourceGroupName, registryName, webhookName), (Func1)new Func1<String, Observable<ServiceResponse<Page<EventInner>>>>(){

            public Observable<ServiceResponse<Page<EventInner>>> call(String nextPageLink) {
                return WebhooksInner.this.listEventsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<EventInner>> listEventsAsync(String resourceGroupName, String registryName, String webhookName) {
        return this.listEventsWithServiceResponseAsync(resourceGroupName, registryName, webhookName).map((Func1)new Func1<ServiceResponse<Page<EventInner>>, Page<EventInner>>(){

            public Page<EventInner> call(ServiceResponse<Page<EventInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<EventInner>>> listEventsWithServiceResponseAsync(String resourceGroupName, String registryName, String webhookName) {
        return this.listEventsSinglePageAsync(resourceGroupName, registryName, webhookName).concatMap((Func1)new Func1<ServiceResponse<Page<EventInner>>, Observable<ServiceResponse<Page<EventInner>>>>(){

            public Observable<ServiceResponse<Page<EventInner>>> call(ServiceResponse<Page<EventInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebhooksInner.this.listEventsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<EventInner>>> listEventsSinglePageAsync(String resourceGroupName, String registryName, String webhookName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (webhookName == null) {
            throw new IllegalArgumentException("Parameter webhookName is required and cannot be null.");
        }
        String apiVersion = "2017-10-01";
        return this.service.listEvents(this.client.subscriptionId(), resourceGroupName, registryName, webhookName, "2017-10-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<EventInner>>>>(){

            public Observable<ServiceResponse<Page<EventInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebhooksInner.this.listEventsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<EventInner>> listEventsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<EventInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<WebhookInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<WebhookInner>((Page)response.body()){

            public Page<WebhookInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebhooksInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<WebhookInner>> listNextAsync(String nextPageLink, ServiceFuture<List<WebhookInner>> serviceFuture, ListOperationCallback<WebhookInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<WebhookInner>>>>(){

            public Observable<ServiceResponse<Page<WebhookInner>>> call(String nextPageLink) {
                return WebhooksInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<WebhookInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<WebhookInner>>, Page<WebhookInner>>(){

            public Page<WebhookInner> call(ServiceResponse<Page<WebhookInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<WebhookInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<WebhookInner>>, Observable<ServiceResponse<Page<WebhookInner>>>>(){

            public Observable<ServiceResponse<Page<WebhookInner>>> call(ServiceResponse<Page<WebhookInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebhooksInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<WebhookInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WebhookInner>>>>(){

            public Observable<ServiceResponse<Page<WebhookInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebhooksInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<WebhookInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<WebhookInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<EventInner> listEventsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listEventsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<EventInner>((Page)response.body()){

            public Page<EventInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebhooksInner.this.listEventsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<EventInner>> listEventsNextAsync(String nextPageLink, ServiceFuture<List<EventInner>> serviceFuture, ListOperationCallback<EventInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listEventsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<EventInner>>>>(){

            public Observable<ServiceResponse<Page<EventInner>>> call(String nextPageLink) {
                return WebhooksInner.this.listEventsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<EventInner>> listEventsNextAsync(String nextPageLink) {
        return this.listEventsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<EventInner>>, Page<EventInner>>(){

            public Page<EventInner> call(ServiceResponse<Page<EventInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<EventInner>>> listEventsNextWithServiceResponseAsync(String nextPageLink) {
        return this.listEventsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<EventInner>>, Observable<ServiceResponse<Page<EventInner>>>>(){

            public Observable<ServiceResponse<Page<EventInner>>> call(ServiceResponse<Page<EventInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebhooksInner.this.listEventsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<EventInner>>> listEventsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listEventsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<EventInner>>>>(){

            public Observable<ServiceResponse<Page<EventInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebhooksInner.this.listEventsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<EventInner>> listEventsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<EventInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface WebhooksService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Webhooks get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="webhookName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Webhooks create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}")
        public Observable<Response<ResponseBody>> create(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="webhookName") String var4, @Query(value="api-version") String var5, @Body WebhookCreateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Webhooks beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="webhookName") String var4, @Query(value="api-version") String var5, @Body WebhookCreateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Webhooks delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="webhookName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Webhooks beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="webhookName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Webhooks update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="webhookName") String var4, @Query(value="api-version") String var5, @Body WebhookUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Webhooks beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="webhookName") String var4, @Query(value="api-version") String var5, @Body WebhookUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Webhooks list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Webhooks ping"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}/ping")
        public Observable<Response<ResponseBody>> ping(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="webhookName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Webhooks getCallbackConfig"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}/getCallbackConfig")
        public Observable<Response<ResponseBody>> getCallbackConfig(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="webhookName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Webhooks listEvents"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}/listEvents")
        public Observable<Response<ResponseBody>> listEvents(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="webhookName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Webhooks listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Webhooks listEventsNext"})
        @GET
        public Observable<Response<ResponseBody>> listEventsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

