/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerinstance.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.containerinstance.CachedImages;
import com.microsoft.azure.management.containerinstance.Capabilities;
import com.microsoft.azure.management.containerinstance.implementation.ContainerInstanceManagementClientImpl;
import com.microsoft.azure.management.containerinstance.implementation.PageImpl;
import com.microsoft.azure.management.containerinstance.implementation.PageImpl1;
import com.microsoft.azure.management.containerinstance.implementation.UsageInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class LocationsInner {
    private LocationsService service;
    private ContainerInstanceManagementClientImpl client;

    public LocationsInner(Retrofit retrofit, ContainerInstanceManagementClientImpl client) {
        this.service = (LocationsService)retrofit.create(LocationsService.class);
        this.client = client;
    }

    public List<UsageInner> listUsage(String location) {
        return (List)((ServiceResponse)this.listUsageWithServiceResponseAsync(location).toBlocking().single()).body();
    }

    public ServiceFuture<List<UsageInner>> listUsageAsync(String location, ServiceCallback<List<UsageInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listUsageWithServiceResponseAsync(location), serviceCallback);
    }

    public Observable<List<UsageInner>> listUsageAsync(String location) {
        return this.listUsageWithServiceResponseAsync(location).map((Func1)new Func1<ServiceResponse<List<UsageInner>>, List<UsageInner>>(){

            public List<UsageInner> call(ServiceResponse<List<UsageInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<UsageInner>>> listUsageWithServiceResponseAsync(String location) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listUsage(this.client.subscriptionId(), location, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<UsageInner>>>>(){

            public Observable<ServiceResponse<List<UsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LocationsInner.this.listUsageDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<UsageInner>> listUsageDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<UsageInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<CachedImages> listCachedImages(String location) {
        ServiceResponse response = (ServiceResponse)this.listCachedImagesSinglePageAsync(location).toBlocking().single();
        return new PagedList<CachedImages>((Page)response.body()){

            public Page<CachedImages> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LocationsInner.this.listCachedImagesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<CachedImages>> listCachedImagesAsync(String location, ListOperationCallback<CachedImages> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listCachedImagesSinglePageAsync(location), (Func1)new Func1<String, Observable<ServiceResponse<Page<CachedImages>>>>(){

            public Observable<ServiceResponse<Page<CachedImages>>> call(String nextPageLink) {
                return LocationsInner.this.listCachedImagesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<CachedImages>> listCachedImagesAsync(String location) {
        return this.listCachedImagesWithServiceResponseAsync(location).map((Func1)new Func1<ServiceResponse<Page<CachedImages>>, Page<CachedImages>>(){

            public Page<CachedImages> call(ServiceResponse<Page<CachedImages>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<CachedImages>>> listCachedImagesWithServiceResponseAsync(String location) {
        return this.listCachedImagesSinglePageAsync(location).concatMap((Func1)new Func1<ServiceResponse<Page<CachedImages>>, Observable<ServiceResponse<Page<CachedImages>>>>(){

            public Observable<ServiceResponse<Page<CachedImages>>> call(ServiceResponse<Page<CachedImages>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LocationsInner.this.listCachedImagesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CachedImages>>> listCachedImagesSinglePageAsync(String location) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listCachedImages(this.client.subscriptionId(), location, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CachedImages>>>>(){

            public Observable<ServiceResponse<Page<CachedImages>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LocationsInner.this.listCachedImagesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CachedImages>> listCachedImagesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CachedImages>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<Capabilities> listCapabilities(String location) {
        ServiceResponse response = (ServiceResponse)this.listCapabilitiesSinglePageAsync(location).toBlocking().single();
        return new PagedList<Capabilities>((Page)response.body()){

            public Page<Capabilities> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LocationsInner.this.listCapabilitiesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<Capabilities>> listCapabilitiesAsync(String location, ListOperationCallback<Capabilities> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listCapabilitiesSinglePageAsync(location), (Func1)new Func1<String, Observable<ServiceResponse<Page<Capabilities>>>>(){

            public Observable<ServiceResponse<Page<Capabilities>>> call(String nextPageLink) {
                return LocationsInner.this.listCapabilitiesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<Capabilities>> listCapabilitiesAsync(String location) {
        return this.listCapabilitiesWithServiceResponseAsync(location).map((Func1)new Func1<ServiceResponse<Page<Capabilities>>, Page<Capabilities>>(){

            public Page<Capabilities> call(ServiceResponse<Page<Capabilities>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<Capabilities>>> listCapabilitiesWithServiceResponseAsync(String location) {
        return this.listCapabilitiesSinglePageAsync(location).concatMap((Func1)new Func1<ServiceResponse<Page<Capabilities>>, Observable<ServiceResponse<Page<Capabilities>>>>(){

            public Observable<ServiceResponse<Page<Capabilities>>> call(ServiceResponse<Page<Capabilities>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LocationsInner.this.listCapabilitiesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<Capabilities>>> listCapabilitiesSinglePageAsync(String location) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listCapabilities(this.client.subscriptionId(), location, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<Capabilities>>>>(){

            public Observable<ServiceResponse<Page<Capabilities>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LocationsInner.this.listCapabilitiesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<Capabilities>> listCapabilitiesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<Capabilities>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<CachedImages> listCachedImagesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listCachedImagesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<CachedImages>((Page)response.body()){

            public Page<CachedImages> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LocationsInner.this.listCachedImagesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<CachedImages>> listCachedImagesNextAsync(String nextPageLink, ServiceFuture<List<CachedImages>> serviceFuture, ListOperationCallback<CachedImages> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listCachedImagesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<CachedImages>>>>(){

            public Observable<ServiceResponse<Page<CachedImages>>> call(String nextPageLink) {
                return LocationsInner.this.listCachedImagesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<CachedImages>> listCachedImagesNextAsync(String nextPageLink) {
        return this.listCachedImagesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<CachedImages>>, Page<CachedImages>>(){

            public Page<CachedImages> call(ServiceResponse<Page<CachedImages>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<CachedImages>>> listCachedImagesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listCachedImagesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<CachedImages>>, Observable<ServiceResponse<Page<CachedImages>>>>(){

            public Observable<ServiceResponse<Page<CachedImages>>> call(ServiceResponse<Page<CachedImages>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LocationsInner.this.listCachedImagesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CachedImages>>> listCachedImagesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listCachedImagesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CachedImages>>>>(){

            public Observable<ServiceResponse<Page<CachedImages>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LocationsInner.this.listCachedImagesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CachedImages>> listCachedImagesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CachedImages>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<Capabilities> listCapabilitiesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listCapabilitiesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<Capabilities>((Page)response.body()){

            public Page<Capabilities> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LocationsInner.this.listCapabilitiesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<Capabilities>> listCapabilitiesNextAsync(String nextPageLink, ServiceFuture<List<Capabilities>> serviceFuture, ListOperationCallback<Capabilities> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listCapabilitiesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<Capabilities>>>>(){

            public Observable<ServiceResponse<Page<Capabilities>>> call(String nextPageLink) {
                return LocationsInner.this.listCapabilitiesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<Capabilities>> listCapabilitiesNextAsync(String nextPageLink) {
        return this.listCapabilitiesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<Capabilities>>, Page<Capabilities>>(){

            public Page<Capabilities> call(ServiceResponse<Page<Capabilities>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<Capabilities>>> listCapabilitiesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listCapabilitiesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<Capabilities>>, Observable<ServiceResponse<Page<Capabilities>>>>(){

            public Observable<ServiceResponse<Page<Capabilities>>> call(ServiceResponse<Page<Capabilities>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LocationsInner.this.listCapabilitiesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<Capabilities>>> listCapabilitiesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listCapabilitiesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<Capabilities>>>>(){

            public Observable<ServiceResponse<Page<Capabilities>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LocationsInner.this.listCapabilitiesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<Capabilities>> listCapabilitiesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<Capabilities>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface LocationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerinstance.Locations listUsage"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.ContainerInstance/locations/{location}/usages")
        public Observable<Response<ResponseBody>> listUsage(@Path(value="subscriptionId") String var1, @Path(value="location") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerinstance.Locations listCachedImages"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.ContainerInstance/locations/{location}/cachedImages")
        public Observable<Response<ResponseBody>> listCachedImages(@Path(value="subscriptionId") String var1, @Path(value="location") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerinstance.Locations listCapabilities"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.ContainerInstance/locations/{location}/capabilities")
        public Observable<Response<ResponseBody>> listCapabilities(@Path(value="subscriptionId") String var1, @Path(value="location") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerinstance.Locations listCachedImagesNext"})
        @GET
        public Observable<Response<ResponseBody>> listCachedImagesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerinstance.Locations listCapabilitiesNext"})
        @GET
        public Observable<Response<ResponseBody>> listCapabilitiesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

