/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerinstance.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.containerinstance.implementation.ContainerInstanceManagementClientImpl;
import com.microsoft.azure.management.containerinstance.implementation.UsageListResultInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ContainerGroupUsagesInner {
    private ContainerGroupUsagesService service;
    private ContainerInstanceManagementClientImpl client;

    public ContainerGroupUsagesInner(Retrofit retrofit, ContainerInstanceManagementClientImpl client) {
        this.service = (ContainerGroupUsagesService)retrofit.create(ContainerGroupUsagesService.class);
        this.client = client;
    }

    public UsageListResultInner list(String location) {
        return (UsageListResultInner)((ServiceResponse)this.listWithServiceResponseAsync(location).toBlocking().single()).body();
    }

    public ServiceFuture<UsageListResultInner> listAsync(String location, ServiceCallback<UsageListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(location), serviceCallback);
    }

    public Observable<UsageListResultInner> listAsync(String location) {
        return this.listWithServiceResponseAsync(location).map((Func1)new Func1<ServiceResponse<UsageListResultInner>, UsageListResultInner>(){

            public UsageListResultInner call(ServiceResponse<UsageListResultInner> response) {
                return (UsageListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<UsageListResultInner>> listWithServiceResponseAsync(String location) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), location, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<UsageListResultInner>>>(){

            public Observable<ServiceResponse<UsageListResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ContainerGroupUsagesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<UsageListResultInner> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<UsageListResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ContainerGroupUsagesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerinstance.ContainerGroupUsages list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.ContainerInstance/locations/{location}/usages")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Path(value="location") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);
    }
}

