/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.RollingUpgradeStatusInfoInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class VirtualMachineScaleSetRollingUpgradesInner {
    private VirtualMachineScaleSetRollingUpgradesService service;
    private ComputeManagementClientImpl client;

    public VirtualMachineScaleSetRollingUpgradesInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (VirtualMachineScaleSetRollingUpgradesService)retrofit.create(VirtualMachineScaleSetRollingUpgradesService.class);
        this.client = client;
    }

    public void cancel(String resourceGroupName, String vmScaleSetName) {
        ((ServiceResponse)this.cancelWithServiceResponseAsync(resourceGroupName, vmScaleSetName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> cancelAsync(String resourceGroupName, String vmScaleSetName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.cancelWithServiceResponseAsync(resourceGroupName, vmScaleSetName), serviceCallback);
    }

    public Observable<Void> cancelAsync(String resourceGroupName, String vmScaleSetName) {
        return this.cancelWithServiceResponseAsync(resourceGroupName, vmScaleSetName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> cancelWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        Observable<Response<ResponseBody>> observable = this.service.cancel(resourceGroupName, vmScaleSetName, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginCancel(String resourceGroupName, String vmScaleSetName) {
        ((ServiceResponse)this.beginCancelWithServiceResponseAsync(resourceGroupName, vmScaleSetName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginCancelAsync(String resourceGroupName, String vmScaleSetName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCancelWithServiceResponseAsync(resourceGroupName, vmScaleSetName), serviceCallback);
    }

    public Observable<Void> beginCancelAsync(String resourceGroupName, String vmScaleSetName) {
        return this.beginCancelWithServiceResponseAsync(resourceGroupName, vmScaleSetName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginCancelWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.beginCancel(resourceGroupName, vmScaleSetName, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineScaleSetRollingUpgradesInner.this.beginCancelDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginCancelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void startOSUpgrade(String resourceGroupName, String vmScaleSetName) {
        ((ServiceResponse)this.startOSUpgradeWithServiceResponseAsync(resourceGroupName, vmScaleSetName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> startOSUpgradeAsync(String resourceGroupName, String vmScaleSetName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.startOSUpgradeWithServiceResponseAsync(resourceGroupName, vmScaleSetName), serviceCallback);
    }

    public Observable<Void> startOSUpgradeAsync(String resourceGroupName, String vmScaleSetName) {
        return this.startOSUpgradeWithServiceResponseAsync(resourceGroupName, vmScaleSetName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> startOSUpgradeWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        Observable<Response<ResponseBody>> observable = this.service.startOSUpgrade(resourceGroupName, vmScaleSetName, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginStartOSUpgrade(String resourceGroupName, String vmScaleSetName) {
        ((ServiceResponse)this.beginStartOSUpgradeWithServiceResponseAsync(resourceGroupName, vmScaleSetName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginStartOSUpgradeAsync(String resourceGroupName, String vmScaleSetName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginStartOSUpgradeWithServiceResponseAsync(resourceGroupName, vmScaleSetName), serviceCallback);
    }

    public Observable<Void> beginStartOSUpgradeAsync(String resourceGroupName, String vmScaleSetName) {
        return this.beginStartOSUpgradeWithServiceResponseAsync(resourceGroupName, vmScaleSetName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginStartOSUpgradeWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.beginStartOSUpgrade(resourceGroupName, vmScaleSetName, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineScaleSetRollingUpgradesInner.this.beginStartOSUpgradeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginStartOSUpgradeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void startExtensionUpgrade(String resourceGroupName, String vmScaleSetName) {
        ((ServiceResponse)this.startExtensionUpgradeWithServiceResponseAsync(resourceGroupName, vmScaleSetName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> startExtensionUpgradeAsync(String resourceGroupName, String vmScaleSetName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.startExtensionUpgradeWithServiceResponseAsync(resourceGroupName, vmScaleSetName), serviceCallback);
    }

    public Observable<Void> startExtensionUpgradeAsync(String resourceGroupName, String vmScaleSetName) {
        return this.startExtensionUpgradeWithServiceResponseAsync(resourceGroupName, vmScaleSetName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> startExtensionUpgradeWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        Observable<Response<ResponseBody>> observable = this.service.startExtensionUpgrade(resourceGroupName, vmScaleSetName, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginStartExtensionUpgrade(String resourceGroupName, String vmScaleSetName) {
        ((ServiceResponse)this.beginStartExtensionUpgradeWithServiceResponseAsync(resourceGroupName, vmScaleSetName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginStartExtensionUpgradeAsync(String resourceGroupName, String vmScaleSetName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginStartExtensionUpgradeWithServiceResponseAsync(resourceGroupName, vmScaleSetName), serviceCallback);
    }

    public Observable<Void> beginStartExtensionUpgradeAsync(String resourceGroupName, String vmScaleSetName) {
        return this.beginStartExtensionUpgradeWithServiceResponseAsync(resourceGroupName, vmScaleSetName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginStartExtensionUpgradeWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.beginStartExtensionUpgrade(resourceGroupName, vmScaleSetName, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineScaleSetRollingUpgradesInner.this.beginStartExtensionUpgradeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginStartExtensionUpgradeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RollingUpgradeStatusInfoInner getLatest(String resourceGroupName, String vmScaleSetName) {
        return (RollingUpgradeStatusInfoInner)((Object)((ServiceResponse)this.getLatestWithServiceResponseAsync(resourceGroupName, vmScaleSetName).toBlocking().single()).body());
    }

    public ServiceFuture<RollingUpgradeStatusInfoInner> getLatestAsync(String resourceGroupName, String vmScaleSetName, ServiceCallback<RollingUpgradeStatusInfoInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getLatestWithServiceResponseAsync(resourceGroupName, vmScaleSetName), serviceCallback);
    }

    public Observable<RollingUpgradeStatusInfoInner> getLatestAsync(String resourceGroupName, String vmScaleSetName) {
        return this.getLatestWithServiceResponseAsync(resourceGroupName, vmScaleSetName).map((Func1)new Func1<ServiceResponse<RollingUpgradeStatusInfoInner>, RollingUpgradeStatusInfoInner>(){

            public RollingUpgradeStatusInfoInner call(ServiceResponse<RollingUpgradeStatusInfoInner> response) {
                return (RollingUpgradeStatusInfoInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RollingUpgradeStatusInfoInner>> getLatestWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.getLatest(resourceGroupName, vmScaleSetName, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RollingUpgradeStatusInfoInner>>>(){

            public Observable<ServiceResponse<RollingUpgradeStatusInfoInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineScaleSetRollingUpgradesInner.this.getLatestDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RollingUpgradeStatusInfoInner> getLatestDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RollingUpgradeStatusInfoInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface VirtualMachineScaleSetRollingUpgradesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetRollingUpgrades cancel"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/rollingUpgrades/cancel")
        public Observable<Response<ResponseBody>> cancel(@Path(value="resourceGroupName") String var1, @Path(value="vmScaleSetName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetRollingUpgrades beginCancel"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/rollingUpgrades/cancel")
        public Observable<Response<ResponseBody>> beginCancel(@Path(value="resourceGroupName") String var1, @Path(value="vmScaleSetName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetRollingUpgrades startOSUpgrade"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/osRollingUpgrade")
        public Observable<Response<ResponseBody>> startOSUpgrade(@Path(value="resourceGroupName") String var1, @Path(value="vmScaleSetName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetRollingUpgrades beginStartOSUpgrade"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/osRollingUpgrade")
        public Observable<Response<ResponseBody>> beginStartOSUpgrade(@Path(value="resourceGroupName") String var1, @Path(value="vmScaleSetName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetRollingUpgrades startExtensionUpgrade"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/extensionRollingUpgrade")
        public Observable<Response<ResponseBody>> startExtensionUpgrade(@Path(value="resourceGroupName") String var1, @Path(value="vmScaleSetName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetRollingUpgrades beginStartExtensionUpgrade"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/extensionRollingUpgrade")
        public Observable<Response<ResponseBody>> beginStartExtensionUpgrade(@Path(value="resourceGroupName") String var1, @Path(value="vmScaleSetName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetRollingUpgrades getLatest"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/rollingUpgrades/latest")
        public Observable<Response<ResponseBody>> getLatest(@Path(value="resourceGroupName") String var1, @Path(value="vmScaleSetName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);
    }
}

