/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.compute.VirtualMachineRunCommandUpdate;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in VirtualMachineScaleSetVMRunCommands.
 */
public class VirtualMachineScaleSetVMRunCommandsInner {
    /** The Retrofit service to perform REST calls. */
    private VirtualMachineScaleSetVMRunCommandsService service;
    /** The service client containing this operation class. */
    private ComputeManagementClientImpl client;

    /**
     * Initializes an instance of VirtualMachineScaleSetVMRunCommandsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public VirtualMachineScaleSetVMRunCommandsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = retrofit.create(VirtualMachineScaleSetVMRunCommandsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for VirtualMachineScaleSetVMRunCommands to be
     * used by Retrofit to perform actually REST calls.
     */
    interface VirtualMachineScaleSetVMRunCommandsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMRunCommands createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/runCommands/{runCommandName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("vmScaleSetName") String vmScaleSetName, @Path("instanceId") String instanceId, @Path("runCommandName") String runCommandName, @Path("subscriptionId") String subscriptionId, @Body VirtualMachineRunCommandInner runCommand, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMRunCommands beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/runCommands/{runCommandName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("vmScaleSetName") String vmScaleSetName, @Path("instanceId") String instanceId, @Path("runCommandName") String runCommandName, @Path("subscriptionId") String subscriptionId, @Body VirtualMachineRunCommandInner runCommand, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMRunCommands update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/runCommands/{runCommandName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("vmScaleSetName") String vmScaleSetName, @Path("instanceId") String instanceId, @Path("runCommandName") String runCommandName, @Path("subscriptionId") String subscriptionId, @Body VirtualMachineRunCommandUpdate runCommand, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMRunCommands beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/runCommands/{runCommandName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("vmScaleSetName") String vmScaleSetName, @Path("instanceId") String instanceId, @Path("runCommandName") String runCommandName, @Path("subscriptionId") String subscriptionId, @Body VirtualMachineRunCommandUpdate runCommand, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMRunCommands delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/runCommands/{runCommandName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("vmScaleSetName") String vmScaleSetName, @Path("instanceId") String instanceId, @Path("runCommandName") String runCommandName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMRunCommands beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/runCommands/{runCommandName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("vmScaleSetName") String vmScaleSetName, @Path("instanceId") String instanceId, @Path("runCommandName") String runCommandName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMRunCommands get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/runCommands/{runCommandName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("vmScaleSetName") String vmScaleSetName, @Path("instanceId") String instanceId, @Path("runCommandName") String runCommandName, @Path("subscriptionId") String subscriptionId, @Query("$expand") String expand, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMRunCommands list" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/runCommands")
        Observable<Response<ResponseBody>> list(@Path("resourceGroupName") String resourceGroupName, @Path("vmScaleSetName") String vmScaleSetName, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Query("$expand") String expand, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMRunCommands listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * The operation to create or update the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualMachineRunCommandInner object if successful.
     */
    public VirtualMachineRunCommandInner createOrUpdate(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand).toBlocking().last().body();
    }

    /**
     * The operation to create or update the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualMachineRunCommandInner> createOrUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandInner runCommand, final ServiceCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand), serviceCallback);
    }

    /**
     * The operation to create or update the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<VirtualMachineRunCommandInner> createOrUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand).map(new Func1<ServiceResponse<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>() {
            @Override
            public VirtualMachineRunCommandInner call(ServiceResponse<VirtualMachineRunCommandInner> response) {
                return response.body();
            }
        });
    }

    /**
     * The operation to create or update the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<VirtualMachineRunCommandInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (runCommand == null) {
            throw new IllegalArgumentException("Parameter runCommand is required and cannot be null.");
        }
        Validator.validate(runCommand);
        final String apiVersion = "2020-12-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, vmScaleSetName, instanceId, runCommandName, this.client.subscriptionId(), runCommand, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualMachineRunCommandInner>() { }.getType());
    }

    /**
     * The operation to create or update the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualMachineRunCommandInner object if successful.
     */
    public VirtualMachineRunCommandInner beginCreateOrUpdate(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand).toBlocking().single().body();
    }

    /**
     * The operation to create or update the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualMachineRunCommandInner> beginCreateOrUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandInner runCommand, final ServiceCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand), serviceCallback);
    }

    /**
     * The operation to create or update the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualMachineRunCommandInner object
     */
    public Observable<VirtualMachineRunCommandInner> beginCreateOrUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand).map(new Func1<ServiceResponse<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>() {
            @Override
            public VirtualMachineRunCommandInner call(ServiceResponse<VirtualMachineRunCommandInner> response) {
                return response.body();
            }
        });
    }

    /**
     * The operation to create or update the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Create Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualMachineRunCommandInner object
     */
    public Observable<ServiceResponse<VirtualMachineRunCommandInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (runCommand == null) {
            throw new IllegalArgumentException("Parameter runCommand is required and cannot be null.");
        }
        Validator.validate(runCommand);
        final String apiVersion = "2020-12-01";
        return service.beginCreateOrUpdate(resourceGroupName, vmScaleSetName, instanceId, runCommandName, this.client.subscriptionId(), runCommand, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineRunCommandInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualMachineRunCommandInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualMachineRunCommandInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualMachineRunCommandInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VirtualMachineRunCommandInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VirtualMachineRunCommandInner>() { }.getType())
                .register(201, new TypeToken<VirtualMachineRunCommandInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * The operation to update the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualMachineRunCommandInner object if successful.
     */
    public VirtualMachineRunCommandInner update(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        return updateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand).toBlocking().last().body();
    }

    /**
     * The operation to update the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualMachineRunCommandInner> updateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandUpdate runCommand, final ServiceCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand), serviceCallback);
    }

    /**
     * The operation to update the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<VirtualMachineRunCommandInner> updateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        return updateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand).map(new Func1<ServiceResponse<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>() {
            @Override
            public VirtualMachineRunCommandInner call(ServiceResponse<VirtualMachineRunCommandInner> response) {
                return response.body();
            }
        });
    }

    /**
     * The operation to update the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<VirtualMachineRunCommandInner>> updateWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (runCommand == null) {
            throw new IllegalArgumentException("Parameter runCommand is required and cannot be null.");
        }
        Validator.validate(runCommand);
        final String apiVersion = "2020-12-01";
        Observable<Response<ResponseBody>> observable = service.update(resourceGroupName, vmScaleSetName, instanceId, runCommandName, this.client.subscriptionId(), runCommand, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualMachineRunCommandInner>() { }.getType());
    }

    /**
     * The operation to update the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualMachineRunCommandInner object if successful.
     */
    public VirtualMachineRunCommandInner beginUpdate(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand).toBlocking().single().body();
    }

    /**
     * The operation to update the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualMachineRunCommandInner> beginUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandUpdate runCommand, final ServiceCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand), serviceCallback);
    }

    /**
     * The operation to update the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualMachineRunCommandInner object
     */
    public Observable<VirtualMachineRunCommandInner> beginUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, runCommand).map(new Func1<ServiceResponse<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>() {
            @Override
            public VirtualMachineRunCommandInner call(ServiceResponse<VirtualMachineRunCommandInner> response) {
                return response.body();
            }
        });
    }

    /**
     * The operation to update the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @param runCommand Parameters supplied to the Update Virtual Machine RunCommand operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualMachineRunCommandInner object
     */
    public Observable<ServiceResponse<VirtualMachineRunCommandInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (runCommand == null) {
            throw new IllegalArgumentException("Parameter runCommand is required and cannot be null.");
        }
        Validator.validate(runCommand);
        final String apiVersion = "2020-12-01";
        return service.beginUpdate(resourceGroupName, vmScaleSetName, instanceId, runCommandName, this.client.subscriptionId(), runCommand, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineRunCommandInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualMachineRunCommandInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualMachineRunCommandInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualMachineRunCommandInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VirtualMachineRunCommandInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VirtualMachineRunCommandInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * The operation to delete the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName) {
        deleteWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName).toBlocking().last().body();
    }

    /**
     * The operation to delete the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName), serviceCallback);
    }

    /**
     * The operation to delete the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName) {
        return deleteWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * The operation to delete the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, vmScaleSetName, instanceId, runCommandName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * The operation to delete the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName).toBlocking().single().body();
    }

    /**
     * The operation to delete the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName), serviceCallback);
    }

    /**
     * The operation to delete the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * The operation to delete the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        return service.beginDelete(resourceGroupName, vmScaleSetName, instanceId, runCommandName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * The operation to get the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualMachineRunCommandInner object if successful.
     */
    public VirtualMachineRunCommandInner get(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName) {
        return getWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName).toBlocking().single().body();
    }

    /**
     * The operation to get the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualMachineRunCommandInner> getAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, final ServiceCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName), serviceCallback);
    }

    /**
     * The operation to get the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualMachineRunCommandInner object
     */
    public Observable<VirtualMachineRunCommandInner> getAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName) {
        return getWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName).map(new Func1<ServiceResponse<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>() {
            @Override
            public VirtualMachineRunCommandInner call(ServiceResponse<VirtualMachineRunCommandInner> response) {
                return response.body();
            }
        });
    }

    /**
     * The operation to get the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualMachineRunCommandInner object
     */
    public Observable<ServiceResponse<VirtualMachineRunCommandInner>> getWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        final String expand = null;
        return service.get(resourceGroupName, vmScaleSetName, instanceId, runCommandName, this.client.subscriptionId(), expand, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineRunCommandInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualMachineRunCommandInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualMachineRunCommandInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * The operation to get the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualMachineRunCommandInner object if successful.
     */
    public VirtualMachineRunCommandInner get(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, String expand) {
        return getWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, expand).toBlocking().single().body();
    }

    /**
     * The operation to get the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @param expand The expand expression to apply on the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualMachineRunCommandInner> getAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, String expand, final ServiceCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, expand), serviceCallback);
    }

    /**
     * The operation to get the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualMachineRunCommandInner object
     */
    public Observable<VirtualMachineRunCommandInner> getAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, String expand) {
        return getWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, runCommandName, expand).map(new Func1<ServiceResponse<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>() {
            @Override
            public VirtualMachineRunCommandInner call(ServiceResponse<VirtualMachineRunCommandInner> response) {
                return response.body();
            }
        });
    }

    /**
     * The operation to get the VMSS VM run command.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param runCommandName The name of the virtual machine run command.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualMachineRunCommandInner object
     */
    public Observable<ServiceResponse<VirtualMachineRunCommandInner>> getWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String runCommandName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        return service.get(resourceGroupName, vmScaleSetName, instanceId, runCommandName, this.client.subscriptionId(), expand, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineRunCommandInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualMachineRunCommandInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualMachineRunCommandInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualMachineRunCommandInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VirtualMachineRunCommandInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VirtualMachineRunCommandInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * The operation to get all run commands of an instance in Virtual Machine Scaleset.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualMachineRunCommandInner&gt; object if successful.
     */
    public PagedList<VirtualMachineRunCommandInner> list(final String resourceGroupName, final String vmScaleSetName, final String instanceId) {
        ServiceResponse<Page<VirtualMachineRunCommandInner>> response = listSinglePageAsync(resourceGroupName, vmScaleSetName, instanceId).toBlocking().single();
        return new PagedList<VirtualMachineRunCommandInner>(response.body()) {
            @Override
            public Page<VirtualMachineRunCommandInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * The operation to get all run commands of an instance in Virtual Machine Scaleset.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualMachineRunCommandInner>> listAsync(final String resourceGroupName, final String vmScaleSetName, final String instanceId, final ListOperationCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(resourceGroupName, vmScaleSetName, instanceId),
            new Func1<String, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * The operation to get all run commands of an instance in Virtual Machine Scaleset.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualMachineRunCommandInner&gt; object
     */
    public Observable<Page<VirtualMachineRunCommandInner>> listAsync(final String resourceGroupName, final String vmScaleSetName, final String instanceId) {
        return listWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId)
            .map(new Func1<ServiceResponse<Page<VirtualMachineRunCommandInner>>, Page<VirtualMachineRunCommandInner>>() {
                @Override
                public Page<VirtualMachineRunCommandInner> call(ServiceResponse<Page<VirtualMachineRunCommandInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * The operation to get all run commands of an instance in Virtual Machine Scaleset.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualMachineRunCommandInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> listWithServiceResponseAsync(final String resourceGroupName, final String vmScaleSetName, final String instanceId) {
        return listSinglePageAsync(resourceGroupName, vmScaleSetName, instanceId)
            .concatMap(new Func1<ServiceResponse<Page<VirtualMachineRunCommandInner>>, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(ServiceResponse<Page<VirtualMachineRunCommandInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * The operation to get all run commands of an instance in Virtual Machine Scaleset.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualMachineRunCommandInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> listSinglePageAsync(final String resourceGroupName, final String vmScaleSetName, final String instanceId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        final String expand = null;
        return service.list(resourceGroupName, vmScaleSetName, instanceId, this.client.subscriptionId(), expand, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<VirtualMachineRunCommandInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualMachineRunCommandInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * The operation to get all run commands of an instance in Virtual Machine Scaleset.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualMachineRunCommandInner&gt; object if successful.
     */
    public PagedList<VirtualMachineRunCommandInner> list(final String resourceGroupName, final String vmScaleSetName, final String instanceId, final String expand) {
        ServiceResponse<Page<VirtualMachineRunCommandInner>> response = listSinglePageAsync(resourceGroupName, vmScaleSetName, instanceId, expand).toBlocking().single();
        return new PagedList<VirtualMachineRunCommandInner>(response.body()) {
            @Override
            public Page<VirtualMachineRunCommandInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * The operation to get all run commands of an instance in Virtual Machine Scaleset.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param expand The expand expression to apply on the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualMachineRunCommandInner>> listAsync(final String resourceGroupName, final String vmScaleSetName, final String instanceId, final String expand, final ListOperationCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(resourceGroupName, vmScaleSetName, instanceId, expand),
            new Func1<String, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * The operation to get all run commands of an instance in Virtual Machine Scaleset.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualMachineRunCommandInner&gt; object
     */
    public Observable<Page<VirtualMachineRunCommandInner>> listAsync(final String resourceGroupName, final String vmScaleSetName, final String instanceId, final String expand) {
        return listWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, expand)
            .map(new Func1<ServiceResponse<Page<VirtualMachineRunCommandInner>>, Page<VirtualMachineRunCommandInner>>() {
                @Override
                public Page<VirtualMachineRunCommandInner> call(ServiceResponse<Page<VirtualMachineRunCommandInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * The operation to get all run commands of an instance in Virtual Machine Scaleset.
     *
     * @param resourceGroupName The name of the resource group.
     * @param vmScaleSetName The name of the VM scale set.
     * @param instanceId The instance ID of the virtual machine.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualMachineRunCommandInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> listWithServiceResponseAsync(final String resourceGroupName, final String vmScaleSetName, final String instanceId, final String expand) {
        return listSinglePageAsync(resourceGroupName, vmScaleSetName, instanceId, expand)
            .concatMap(new Func1<ServiceResponse<Page<VirtualMachineRunCommandInner>>, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(ServiceResponse<Page<VirtualMachineRunCommandInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * The operation to get all run commands of an instance in Virtual Machine Scaleset.
     *
    ServiceResponse<PageImpl1<VirtualMachineRunCommandInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl1<VirtualMachineRunCommandInner>> * @param vmScaleSetName The name of the VM scale set.
    ServiceResponse<PageImpl1<VirtualMachineRunCommandInner>> * @param instanceId The instance ID of the virtual machine.
    ServiceResponse<PageImpl1<VirtualMachineRunCommandInner>> * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualMachineRunCommandInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> listSinglePageAsync(final String resourceGroupName, final String vmScaleSetName, final String instanceId, final String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        return service.list(resourceGroupName, vmScaleSetName, instanceId, this.client.subscriptionId(), expand, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<VirtualMachineRunCommandInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualMachineRunCommandInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<VirtualMachineRunCommandInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<VirtualMachineRunCommandInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<VirtualMachineRunCommandInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * The operation to get all run commands of an instance in Virtual Machine Scaleset.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualMachineRunCommandInner&gt; object if successful.
     */
    public PagedList<VirtualMachineRunCommandInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<VirtualMachineRunCommandInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualMachineRunCommandInner>(response.body()) {
            @Override
            public Page<VirtualMachineRunCommandInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * The operation to get all run commands of an instance in Virtual Machine Scaleset.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualMachineRunCommandInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<VirtualMachineRunCommandInner>> serviceFuture, final ListOperationCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * The operation to get all run commands of an instance in Virtual Machine Scaleset.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualMachineRunCommandInner&gt; object
     */
    public Observable<Page<VirtualMachineRunCommandInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<VirtualMachineRunCommandInner>>, Page<VirtualMachineRunCommandInner>>() {
                @Override
                public Page<VirtualMachineRunCommandInner> call(ServiceResponse<Page<VirtualMachineRunCommandInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * The operation to get all run commands of an instance in Virtual Machine Scaleset.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualMachineRunCommandInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<VirtualMachineRunCommandInner>>, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(ServiceResponse<Page<VirtualMachineRunCommandInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * The operation to get all run commands of an instance in Virtual Machine Scaleset.
     *
    ServiceResponse<PageImpl1<VirtualMachineRunCommandInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualMachineRunCommandInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<VirtualMachineRunCommandInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualMachineRunCommandInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<VirtualMachineRunCommandInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<VirtualMachineRunCommandInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<VirtualMachineRunCommandInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
