/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.compute.SshPublicKeyUpdateResource;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in SshPublicKeys.
 */
public class SshPublicKeysInner implements InnerSupportsGet<SshPublicKeyResourceInner>, InnerSupportsDelete<Void>, InnerSupportsListing<SshPublicKeyResourceInner> {
    /** The Retrofit service to perform REST calls. */
    private SshPublicKeysService service;
    /** The service client containing this operation class. */
    private ComputeManagementClientImpl client;

    /**
     * Initializes an instance of SshPublicKeysInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public SshPublicKeysInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = retrofit.create(SshPublicKeysService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for SshPublicKeys to be
     * used by Retrofit to perform actually REST calls.
     */
    interface SshPublicKeysService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.SshPublicKeys list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Compute/sshPublicKeys")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.SshPublicKeys listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/sshPublicKeys")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.SshPublicKeys create" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/sshPublicKeys/{sshPublicKeyName}")
        Observable<Response<ResponseBody>> create(@Path("resourceGroupName") String resourceGroupName, @Path("sshPublicKeyName") String sshPublicKeyName, @Path("subscriptionId") String subscriptionId, @Body SshPublicKeyResourceInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.SshPublicKeys update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/sshPublicKeys/{sshPublicKeyName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("sshPublicKeyName") String sshPublicKeyName, @Path("subscriptionId") String subscriptionId, @Body SshPublicKeyUpdateResource parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.SshPublicKeys delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/sshPublicKeys/{sshPublicKeyName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("sshPublicKeyName") String sshPublicKeyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.SshPublicKeys getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/sshPublicKeys/{sshPublicKeyName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("sshPublicKeyName") String sshPublicKeyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.SshPublicKeys generateKeyPair" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/sshPublicKeys/{sshPublicKeyName}/generateKeyPair")
        Observable<Response<ResponseBody>> generateKeyPair(@Path("resourceGroupName") String resourceGroupName, @Path("sshPublicKeyName") String sshPublicKeyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.SshPublicKeys listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.SshPublicKeys listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists all of the SSH public keys in the subscription. Use the nextLink property in the response to get the next page of SSH public keys.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SshPublicKeyResourceInner&gt; object if successful.
     */
    public PagedList<SshPublicKeyResourceInner> list() {
        ServiceResponse<Page<SshPublicKeyResourceInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<SshPublicKeyResourceInner>(response.body()) {
            @Override
            public Page<SshPublicKeyResourceInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the SSH public keys in the subscription. Use the nextLink property in the response to get the next page of SSH public keys.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SshPublicKeyResourceInner>> listAsync(final ListOperationCallback<SshPublicKeyResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the SSH public keys in the subscription. Use the nextLink property in the response to get the next page of SSH public keys.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SshPublicKeyResourceInner&gt; object
     */
    public Observable<Page<SshPublicKeyResourceInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<SshPublicKeyResourceInner>>, Page<SshPublicKeyResourceInner>>() {
                @Override
                public Page<SshPublicKeyResourceInner> call(ServiceResponse<Page<SshPublicKeyResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the SSH public keys in the subscription. Use the nextLink property in the response to get the next page of SSH public keys.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SshPublicKeyResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<SshPublicKeyResourceInner>>, Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> call(ServiceResponse<Page<SshPublicKeyResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the SSH public keys in the subscription. Use the nextLink property in the response to get the next page of SSH public keys.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SshPublicKeyResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<SshPublicKeyResourceInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SshPublicKeyResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<SshPublicKeyResourceInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<SshPublicKeyResourceInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<SshPublicKeyResourceInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all of the SSH public keys in the specified resource group. Use the nextLink property in the response to get the next page of SSH public keys.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SshPublicKeyResourceInner&gt; object if successful.
     */
    public PagedList<SshPublicKeyResourceInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<SshPublicKeyResourceInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<SshPublicKeyResourceInner>(response.body()) {
            @Override
            public Page<SshPublicKeyResourceInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the SSH public keys in the specified resource group. Use the nextLink property in the response to get the next page of SSH public keys.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SshPublicKeyResourceInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<SshPublicKeyResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the SSH public keys in the specified resource group. Use the nextLink property in the response to get the next page of SSH public keys.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SshPublicKeyResourceInner&gt; object
     */
    public Observable<Page<SshPublicKeyResourceInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<SshPublicKeyResourceInner>>, Page<SshPublicKeyResourceInner>>() {
                @Override
                public Page<SshPublicKeyResourceInner> call(ServiceResponse<Page<SshPublicKeyResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the SSH public keys in the specified resource group. Use the nextLink property in the response to get the next page of SSH public keys.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SshPublicKeyResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<SshPublicKeyResourceInner>>, Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> call(ServiceResponse<Page<SshPublicKeyResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the SSH public keys in the specified resource group. Use the nextLink property in the response to get the next page of SSH public keys.
     *
    ServiceResponse<PageImpl1<SshPublicKeyResourceInner>> * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SshPublicKeyResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<SshPublicKeyResourceInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SshPublicKeyResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<SshPublicKeyResourceInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<SshPublicKeyResourceInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<SshPublicKeyResourceInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a new SSH public key resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param sshPublicKeyName The name of the SSH public key.
     * @param parameters Parameters supplied to create the SSH public key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SshPublicKeyResourceInner object if successful.
     */
    public SshPublicKeyResourceInner create(String resourceGroupName, String sshPublicKeyName, SshPublicKeyResourceInner parameters) {
        return createWithServiceResponseAsync(resourceGroupName, sshPublicKeyName, parameters).toBlocking().single().body();
    }

    /**
     * Creates a new SSH public key resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param sshPublicKeyName The name of the SSH public key.
     * @param parameters Parameters supplied to create the SSH public key.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SshPublicKeyResourceInner> createAsync(String resourceGroupName, String sshPublicKeyName, SshPublicKeyResourceInner parameters, final ServiceCallback<SshPublicKeyResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, sshPublicKeyName, parameters), serviceCallback);
    }

    /**
     * Creates a new SSH public key resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param sshPublicKeyName The name of the SSH public key.
     * @param parameters Parameters supplied to create the SSH public key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SshPublicKeyResourceInner object
     */
    public Observable<SshPublicKeyResourceInner> createAsync(String resourceGroupName, String sshPublicKeyName, SshPublicKeyResourceInner parameters) {
        return createWithServiceResponseAsync(resourceGroupName, sshPublicKeyName, parameters).map(new Func1<ServiceResponse<SshPublicKeyResourceInner>, SshPublicKeyResourceInner>() {
            @Override
            public SshPublicKeyResourceInner call(ServiceResponse<SshPublicKeyResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new SSH public key resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param sshPublicKeyName The name of the SSH public key.
     * @param parameters Parameters supplied to create the SSH public key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SshPublicKeyResourceInner object
     */
    public Observable<ServiceResponse<SshPublicKeyResourceInner>> createWithServiceResponseAsync(String resourceGroupName, String sshPublicKeyName, SshPublicKeyResourceInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (sshPublicKeyName == null) {
            throw new IllegalArgumentException("Parameter sshPublicKeyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2020-12-01";
        return service.create(resourceGroupName, sshPublicKeyName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SshPublicKeyResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<SshPublicKeyResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SshPublicKeyResourceInner> clientResponse = createDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SshPublicKeyResourceInner> createDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SshPublicKeyResourceInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SshPublicKeyResourceInner>() { }.getType())
                .register(201, new TypeToken<SshPublicKeyResourceInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates a new SSH public key resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param sshPublicKeyName The name of the SSH public key.
     * @param parameters Parameters supplied to update the SSH public key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SshPublicKeyResourceInner object if successful.
     */
    public SshPublicKeyResourceInner update(String resourceGroupName, String sshPublicKeyName, SshPublicKeyUpdateResource parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, sshPublicKeyName, parameters).toBlocking().single().body();
    }

    /**
     * Updates a new SSH public key resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param sshPublicKeyName The name of the SSH public key.
     * @param parameters Parameters supplied to update the SSH public key.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SshPublicKeyResourceInner> updateAsync(String resourceGroupName, String sshPublicKeyName, SshPublicKeyUpdateResource parameters, final ServiceCallback<SshPublicKeyResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, sshPublicKeyName, parameters), serviceCallback);
    }

    /**
     * Updates a new SSH public key resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param sshPublicKeyName The name of the SSH public key.
     * @param parameters Parameters supplied to update the SSH public key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SshPublicKeyResourceInner object
     */
    public Observable<SshPublicKeyResourceInner> updateAsync(String resourceGroupName, String sshPublicKeyName, SshPublicKeyUpdateResource parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, sshPublicKeyName, parameters).map(new Func1<ServiceResponse<SshPublicKeyResourceInner>, SshPublicKeyResourceInner>() {
            @Override
            public SshPublicKeyResourceInner call(ServiceResponse<SshPublicKeyResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a new SSH public key resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param sshPublicKeyName The name of the SSH public key.
     * @param parameters Parameters supplied to update the SSH public key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SshPublicKeyResourceInner object
     */
    public Observable<ServiceResponse<SshPublicKeyResourceInner>> updateWithServiceResponseAsync(String resourceGroupName, String sshPublicKeyName, SshPublicKeyUpdateResource parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (sshPublicKeyName == null) {
            throw new IllegalArgumentException("Parameter sshPublicKeyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2020-12-01";
        return service.update(resourceGroupName, sshPublicKeyName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SshPublicKeyResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<SshPublicKeyResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SshPublicKeyResourceInner> clientResponse = updateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SshPublicKeyResourceInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SshPublicKeyResourceInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SshPublicKeyResourceInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Delete an SSH public key.
     *
     * @param resourceGroupName The name of the resource group.
     * @param sshPublicKeyName The name of the SSH public key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String sshPublicKeyName) {
        deleteWithServiceResponseAsync(resourceGroupName, sshPublicKeyName).toBlocking().single().body();
    }

    /**
     * Delete an SSH public key.
     *
     * @param resourceGroupName The name of the resource group.
     * @param sshPublicKeyName The name of the SSH public key.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String sshPublicKeyName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, sshPublicKeyName), serviceCallback);
    }

    /**
     * Delete an SSH public key.
     *
     * @param resourceGroupName The name of the resource group.
     * @param sshPublicKeyName The name of the SSH public key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String sshPublicKeyName) {
        return deleteWithServiceResponseAsync(resourceGroupName, sshPublicKeyName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete an SSH public key.
     *
     * @param resourceGroupName The name of the resource group.
     * @param sshPublicKeyName The name of the SSH public key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String sshPublicKeyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (sshPublicKeyName == null) {
            throw new IllegalArgumentException("Parameter sshPublicKeyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        return service.delete(resourceGroupName, sshPublicKeyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves information about an SSH public key.
     *
     * @param resourceGroupName The name of the resource group.
     * @param sshPublicKeyName The name of the SSH public key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SshPublicKeyResourceInner object if successful.
     */
    public SshPublicKeyResourceInner getByResourceGroup(String resourceGroupName, String sshPublicKeyName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, sshPublicKeyName).toBlocking().single().body();
    }

    /**
     * Retrieves information about an SSH public key.
     *
     * @param resourceGroupName The name of the resource group.
     * @param sshPublicKeyName The name of the SSH public key.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SshPublicKeyResourceInner> getByResourceGroupAsync(String resourceGroupName, String sshPublicKeyName, final ServiceCallback<SshPublicKeyResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, sshPublicKeyName), serviceCallback);
    }

    /**
     * Retrieves information about an SSH public key.
     *
     * @param resourceGroupName The name of the resource group.
     * @param sshPublicKeyName The name of the SSH public key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SshPublicKeyResourceInner object
     */
    public Observable<SshPublicKeyResourceInner> getByResourceGroupAsync(String resourceGroupName, String sshPublicKeyName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, sshPublicKeyName).map(new Func1<ServiceResponse<SshPublicKeyResourceInner>, SshPublicKeyResourceInner>() {
            @Override
            public SshPublicKeyResourceInner call(ServiceResponse<SshPublicKeyResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves information about an SSH public key.
     *
     * @param resourceGroupName The name of the resource group.
     * @param sshPublicKeyName The name of the SSH public key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SshPublicKeyResourceInner object
     */
    public Observable<ServiceResponse<SshPublicKeyResourceInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String sshPublicKeyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (sshPublicKeyName == null) {
            throw new IllegalArgumentException("Parameter sshPublicKeyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        return service.getByResourceGroup(resourceGroupName, sshPublicKeyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SshPublicKeyResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<SshPublicKeyResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SshPublicKeyResourceInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SshPublicKeyResourceInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SshPublicKeyResourceInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SshPublicKeyResourceInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Generates and returns a public/private key pair and populates the SSH public key resource with the public key. The length of the key will be 3072 bits. This operation can only be performed once per SSH public key resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param sshPublicKeyName The name of the SSH public key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SshPublicKeyGenerateKeyPairResultInner object if successful.
     */
    public SshPublicKeyGenerateKeyPairResultInner generateKeyPair(String resourceGroupName, String sshPublicKeyName) {
        return generateKeyPairWithServiceResponseAsync(resourceGroupName, sshPublicKeyName).toBlocking().single().body();
    }

    /**
     * Generates and returns a public/private key pair and populates the SSH public key resource with the public key. The length of the key will be 3072 bits. This operation can only be performed once per SSH public key resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param sshPublicKeyName The name of the SSH public key.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SshPublicKeyGenerateKeyPairResultInner> generateKeyPairAsync(String resourceGroupName, String sshPublicKeyName, final ServiceCallback<SshPublicKeyGenerateKeyPairResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(generateKeyPairWithServiceResponseAsync(resourceGroupName, sshPublicKeyName), serviceCallback);
    }

    /**
     * Generates and returns a public/private key pair and populates the SSH public key resource with the public key. The length of the key will be 3072 bits. This operation can only be performed once per SSH public key resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param sshPublicKeyName The name of the SSH public key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SshPublicKeyGenerateKeyPairResultInner object
     */
    public Observable<SshPublicKeyGenerateKeyPairResultInner> generateKeyPairAsync(String resourceGroupName, String sshPublicKeyName) {
        return generateKeyPairWithServiceResponseAsync(resourceGroupName, sshPublicKeyName).map(new Func1<ServiceResponse<SshPublicKeyGenerateKeyPairResultInner>, SshPublicKeyGenerateKeyPairResultInner>() {
            @Override
            public SshPublicKeyGenerateKeyPairResultInner call(ServiceResponse<SshPublicKeyGenerateKeyPairResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Generates and returns a public/private key pair and populates the SSH public key resource with the public key. The length of the key will be 3072 bits. This operation can only be performed once per SSH public key resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param sshPublicKeyName The name of the SSH public key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SshPublicKeyGenerateKeyPairResultInner object
     */
    public Observable<ServiceResponse<SshPublicKeyGenerateKeyPairResultInner>> generateKeyPairWithServiceResponseAsync(String resourceGroupName, String sshPublicKeyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (sshPublicKeyName == null) {
            throw new IllegalArgumentException("Parameter sshPublicKeyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        return service.generateKeyPair(resourceGroupName, sshPublicKeyName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SshPublicKeyGenerateKeyPairResultInner>>>() {
                @Override
                public Observable<ServiceResponse<SshPublicKeyGenerateKeyPairResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SshPublicKeyGenerateKeyPairResultInner> clientResponse = generateKeyPairDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SshPublicKeyGenerateKeyPairResultInner> generateKeyPairDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SshPublicKeyGenerateKeyPairResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SshPublicKeyGenerateKeyPairResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all of the SSH public keys in the subscription. Use the nextLink property in the response to get the next page of SSH public keys.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SshPublicKeyResourceInner&gt; object if successful.
     */
    public PagedList<SshPublicKeyResourceInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<SshPublicKeyResourceInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SshPublicKeyResourceInner>(response.body()) {
            @Override
            public Page<SshPublicKeyResourceInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the SSH public keys in the subscription. Use the nextLink property in the response to get the next page of SSH public keys.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SshPublicKeyResourceInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<SshPublicKeyResourceInner>> serviceFuture, final ListOperationCallback<SshPublicKeyResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the SSH public keys in the subscription. Use the nextLink property in the response to get the next page of SSH public keys.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SshPublicKeyResourceInner&gt; object
     */
    public Observable<Page<SshPublicKeyResourceInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<SshPublicKeyResourceInner>>, Page<SshPublicKeyResourceInner>>() {
                @Override
                public Page<SshPublicKeyResourceInner> call(ServiceResponse<Page<SshPublicKeyResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the SSH public keys in the subscription. Use the nextLink property in the response to get the next page of SSH public keys.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SshPublicKeyResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<SshPublicKeyResourceInner>>, Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> call(ServiceResponse<Page<SshPublicKeyResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the SSH public keys in the subscription. Use the nextLink property in the response to get the next page of SSH public keys.
     *
    ServiceResponse<PageImpl1<SshPublicKeyResourceInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SshPublicKeyResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<SshPublicKeyResourceInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SshPublicKeyResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<SshPublicKeyResourceInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<SshPublicKeyResourceInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<SshPublicKeyResourceInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all of the SSH public keys in the specified resource group. Use the nextLink property in the response to get the next page of SSH public keys.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SshPublicKeyResourceInner&gt; object if successful.
     */
    public PagedList<SshPublicKeyResourceInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<SshPublicKeyResourceInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SshPublicKeyResourceInner>(response.body()) {
            @Override
            public Page<SshPublicKeyResourceInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the SSH public keys in the specified resource group. Use the nextLink property in the response to get the next page of SSH public keys.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SshPublicKeyResourceInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<SshPublicKeyResourceInner>> serviceFuture, final ListOperationCallback<SshPublicKeyResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the SSH public keys in the specified resource group. Use the nextLink property in the response to get the next page of SSH public keys.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SshPublicKeyResourceInner&gt; object
     */
    public Observable<Page<SshPublicKeyResourceInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<SshPublicKeyResourceInner>>, Page<SshPublicKeyResourceInner>>() {
                @Override
                public Page<SshPublicKeyResourceInner> call(ServiceResponse<Page<SshPublicKeyResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the SSH public keys in the specified resource group. Use the nextLink property in the response to get the next page of SSH public keys.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SshPublicKeyResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<SshPublicKeyResourceInner>>, Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> call(ServiceResponse<Page<SshPublicKeyResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the SSH public keys in the specified resource group. Use the nextLink property in the response to get the next page of SSH public keys.
     *
    ServiceResponse<PageImpl1<SshPublicKeyResourceInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SshPublicKeyResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SshPublicKeyResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<SshPublicKeyResourceInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SshPublicKeyResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<SshPublicKeyResourceInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<SshPublicKeyResourceInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<SshPublicKeyResourceInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
