/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.compute.GalleryApplicationVersionUpdate;
import com.microsoft.azure.management.compute.ReplicationStatusTypes;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in GalleryApplicationVersions.
 */
public class GalleryApplicationVersionsInner {
    /** The Retrofit service to perform REST calls. */
    private GalleryApplicationVersionsService service;
    /** The service client containing this operation class. */
    private ComputeManagementClientImpl client;

    /**
     * Initializes an instance of GalleryApplicationVersionsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public GalleryApplicationVersionsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = retrofit.create(GalleryApplicationVersionsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for GalleryApplicationVersions to be
     * used by Retrofit to perform actually REST calls.
     */
    interface GalleryApplicationVersionsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplicationVersions createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}/versions/{galleryApplicationVersionName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("galleryName") String galleryName, @Path("galleryApplicationName") String galleryApplicationName, @Path("galleryApplicationVersionName") String galleryApplicationVersionName, @Query("api-version") String apiVersion, @Body GalleryApplicationVersionInner galleryApplicationVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplicationVersions beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}/versions/{galleryApplicationVersionName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("galleryName") String galleryName, @Path("galleryApplicationName") String galleryApplicationName, @Path("galleryApplicationVersionName") String galleryApplicationVersionName, @Query("api-version") String apiVersion, @Body GalleryApplicationVersionInner galleryApplicationVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplicationVersions update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}/versions/{galleryApplicationVersionName}")
        Observable<Response<ResponseBody>> update(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("galleryName") String galleryName, @Path("galleryApplicationName") String galleryApplicationName, @Path("galleryApplicationVersionName") String galleryApplicationVersionName, @Query("api-version") String apiVersion, @Body GalleryApplicationVersionUpdate galleryApplicationVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplicationVersions beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}/versions/{galleryApplicationVersionName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("galleryName") String galleryName, @Path("galleryApplicationName") String galleryApplicationName, @Path("galleryApplicationVersionName") String galleryApplicationVersionName, @Query("api-version") String apiVersion, @Body GalleryApplicationVersionUpdate galleryApplicationVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplicationVersions get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}/versions/{galleryApplicationVersionName}")
        Observable<Response<ResponseBody>> get(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("galleryName") String galleryName, @Path("galleryApplicationName") String galleryApplicationName, @Path("galleryApplicationVersionName") String galleryApplicationVersionName, @Query("$expand") ReplicationStatusTypes expand, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplicationVersions delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}/versions/{galleryApplicationVersionName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("galleryName") String galleryName, @Path("galleryApplicationName") String galleryApplicationName, @Path("galleryApplicationVersionName") String galleryApplicationVersionName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplicationVersions beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}/versions/{galleryApplicationVersionName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("galleryName") String galleryName, @Path("galleryApplicationName") String galleryApplicationName, @Path("galleryApplicationVersionName") String galleryApplicationVersionName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplicationVersions listByGalleryApplication" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}/versions")
        Observable<Response<ResponseBody>> listByGalleryApplication(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("galleryName") String galleryName, @Path("galleryApplicationName") String galleryApplicationName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryApplicationVersions listByGalleryApplicationNext" })
        @GET
        Observable<Response<ResponseBody>> listByGalleryApplicationNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Create or update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is to be created.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be created. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;
     * @param galleryApplicationVersion Parameters supplied to the create or update gallery Application Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the GalleryApplicationVersionInner object if successful.
     */
    public GalleryApplicationVersionInner createOrUpdate(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion).toBlocking().last().body();
    }

    /**
     * Create or update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is to be created.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be created. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;
     * @param galleryApplicationVersion Parameters supplied to the create or update gallery Application Version operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<GalleryApplicationVersionInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion, final ServiceCallback<GalleryApplicationVersionInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion), serviceCallback);
    }

    /**
     * Create or update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is to be created.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be created. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;
     * @param galleryApplicationVersion Parameters supplied to the create or update gallery Application Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<GalleryApplicationVersionInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion).map(new Func1<ServiceResponse<GalleryApplicationVersionInner>, GalleryApplicationVersionInner>() {
            @Override
            public GalleryApplicationVersionInner call(ServiceResponse<GalleryApplicationVersionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is to be created.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be created. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;
     * @param galleryApplicationVersion Parameters supplied to the create or update gallery Application Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<GalleryApplicationVersionInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        if (galleryApplicationVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationVersionName is required and cannot be null.");
        }
        if (galleryApplicationVersion == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationVersion is required and cannot be null.");
        }
        Validator.validate(galleryApplicationVersion);
        final String apiVersion = "2019-12-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, apiVersion, galleryApplicationVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<GalleryApplicationVersionInner>() { }.getType());
    }

    /**
     * Create or update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is to be created.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be created. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;
     * @param galleryApplicationVersion Parameters supplied to the create or update gallery Application Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the GalleryApplicationVersionInner object if successful.
     */
    public GalleryApplicationVersionInner beginCreateOrUpdate(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion).toBlocking().single().body();
    }

    /**
     * Create or update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is to be created.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be created. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;
     * @param galleryApplicationVersion Parameters supplied to the create or update gallery Application Version operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<GalleryApplicationVersionInner> beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion, final ServiceCallback<GalleryApplicationVersionInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion), serviceCallback);
    }

    /**
     * Create or update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is to be created.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be created. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;
     * @param galleryApplicationVersion Parameters supplied to the create or update gallery Application Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GalleryApplicationVersionInner object
     */
    public Observable<GalleryApplicationVersionInner> beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion).map(new Func1<ServiceResponse<GalleryApplicationVersionInner>, GalleryApplicationVersionInner>() {
            @Override
            public GalleryApplicationVersionInner call(ServiceResponse<GalleryApplicationVersionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is to be created.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be created. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;
     * @param galleryApplicationVersion Parameters supplied to the create or update gallery Application Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GalleryApplicationVersionInner object
     */
    public Observable<ServiceResponse<GalleryApplicationVersionInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionInner galleryApplicationVersion) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        if (galleryApplicationVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationVersionName is required and cannot be null.");
        }
        if (galleryApplicationVersion == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationVersion is required and cannot be null.");
        }
        Validator.validate(galleryApplicationVersion);
        final String apiVersion = "2019-12-01";
        return service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, apiVersion, galleryApplicationVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<GalleryApplicationVersionInner>>>() {
                @Override
                public Observable<ServiceResponse<GalleryApplicationVersionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<GalleryApplicationVersionInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<GalleryApplicationVersionInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<GalleryApplicationVersionInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<GalleryApplicationVersionInner>() { }.getType())
                .register(201, new TypeToken<GalleryApplicationVersionInner>() { }.getType())
                .register(202, new TypeToken<GalleryApplicationVersionInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is to be updated.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be updated. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;
     * @param galleryApplicationVersion Parameters supplied to the update gallery Application Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the GalleryApplicationVersionInner object if successful.
     */
    public GalleryApplicationVersionInner update(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion) {
        return updateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion).toBlocking().last().body();
    }

    /**
     * Update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is to be updated.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be updated. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;
     * @param galleryApplicationVersion Parameters supplied to the update gallery Application Version operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<GalleryApplicationVersionInner> updateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion, final ServiceCallback<GalleryApplicationVersionInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion), serviceCallback);
    }

    /**
     * Update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is to be updated.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be updated. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;
     * @param galleryApplicationVersion Parameters supplied to the update gallery Application Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<GalleryApplicationVersionInner> updateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion) {
        return updateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion).map(new Func1<ServiceResponse<GalleryApplicationVersionInner>, GalleryApplicationVersionInner>() {
            @Override
            public GalleryApplicationVersionInner call(ServiceResponse<GalleryApplicationVersionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is to be updated.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be updated. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;
     * @param galleryApplicationVersion Parameters supplied to the update gallery Application Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<GalleryApplicationVersionInner>> updateWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        if (galleryApplicationVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationVersionName is required and cannot be null.");
        }
        if (galleryApplicationVersion == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationVersion is required and cannot be null.");
        }
        Validator.validate(galleryApplicationVersion);
        final String apiVersion = "2019-12-01";
        Observable<Response<ResponseBody>> observable = service.update(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, apiVersion, galleryApplicationVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<GalleryApplicationVersionInner>() { }.getType());
    }

    /**
     * Update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is to be updated.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be updated. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;
     * @param galleryApplicationVersion Parameters supplied to the update gallery Application Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the GalleryApplicationVersionInner object if successful.
     */
    public GalleryApplicationVersionInner beginUpdate(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion).toBlocking().single().body();
    }

    /**
     * Update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is to be updated.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be updated. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;
     * @param galleryApplicationVersion Parameters supplied to the update gallery Application Version operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<GalleryApplicationVersionInner> beginUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion, final ServiceCallback<GalleryApplicationVersionInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion), serviceCallback);
    }

    /**
     * Update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is to be updated.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be updated. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;
     * @param galleryApplicationVersion Parameters supplied to the update gallery Application Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GalleryApplicationVersionInner object
     */
    public Observable<GalleryApplicationVersionInner> beginUpdateAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, galleryApplicationVersion).map(new Func1<ServiceResponse<GalleryApplicationVersionInner>, GalleryApplicationVersionInner>() {
            @Override
            public GalleryApplicationVersionInner call(ServiceResponse<GalleryApplicationVersionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is to be updated.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be updated. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;
     * @param galleryApplicationVersion Parameters supplied to the update gallery Application Version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GalleryApplicationVersionInner object
     */
    public Observable<ServiceResponse<GalleryApplicationVersionInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, GalleryApplicationVersionUpdate galleryApplicationVersion) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        if (galleryApplicationVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationVersionName is required and cannot be null.");
        }
        if (galleryApplicationVersion == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationVersion is required and cannot be null.");
        }
        Validator.validate(galleryApplicationVersion);
        final String apiVersion = "2019-12-01";
        return service.beginUpdate(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, apiVersion, galleryApplicationVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<GalleryApplicationVersionInner>>>() {
                @Override
                public Observable<ServiceResponse<GalleryApplicationVersionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<GalleryApplicationVersionInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<GalleryApplicationVersionInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<GalleryApplicationVersionInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<GalleryApplicationVersionInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves information about a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the GalleryApplicationVersionInner object if successful.
     */
    public GalleryApplicationVersionInner get(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        return getWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName).toBlocking().single().body();
    }

    /**
     * Retrieves information about a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be retrieved.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<GalleryApplicationVersionInner> getAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, final ServiceCallback<GalleryApplicationVersionInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName), serviceCallback);
    }

    /**
     * Retrieves information about a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GalleryApplicationVersionInner object
     */
    public Observable<GalleryApplicationVersionInner> getAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        return getWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName).map(new Func1<ServiceResponse<GalleryApplicationVersionInner>, GalleryApplicationVersionInner>() {
            @Override
            public GalleryApplicationVersionInner call(ServiceResponse<GalleryApplicationVersionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves information about a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GalleryApplicationVersionInner object
     */
    public Observable<ServiceResponse<GalleryApplicationVersionInner>> getWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        if (galleryApplicationVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationVersionName is required and cannot be null.");
        }
        final String apiVersion = "2019-12-01";
        final ReplicationStatusTypes expand = null;
        return service.get(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, expand, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<GalleryApplicationVersionInner>>>() {
                @Override
                public Observable<ServiceResponse<GalleryApplicationVersionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<GalleryApplicationVersionInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves information about a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be retrieved.
     * @param expand The expand expression to apply on the operation. Possible values include: 'ReplicationStatus'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the GalleryApplicationVersionInner object if successful.
     */
    public GalleryApplicationVersionInner get(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, ReplicationStatusTypes expand) {
        return getWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, expand).toBlocking().single().body();
    }

    /**
     * Retrieves information about a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be retrieved.
     * @param expand The expand expression to apply on the operation. Possible values include: 'ReplicationStatus'
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<GalleryApplicationVersionInner> getAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, ReplicationStatusTypes expand, final ServiceCallback<GalleryApplicationVersionInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, expand), serviceCallback);
    }

    /**
     * Retrieves information about a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be retrieved.
     * @param expand The expand expression to apply on the operation. Possible values include: 'ReplicationStatus'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GalleryApplicationVersionInner object
     */
    public Observable<GalleryApplicationVersionInner> getAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, ReplicationStatusTypes expand) {
        return getWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, expand).map(new Func1<ServiceResponse<GalleryApplicationVersionInner>, GalleryApplicationVersionInner>() {
            @Override
            public GalleryApplicationVersionInner call(ServiceResponse<GalleryApplicationVersionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves information about a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be retrieved.
     * @param expand The expand expression to apply on the operation. Possible values include: 'ReplicationStatus'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the GalleryApplicationVersionInner object
     */
    public Observable<ServiceResponse<GalleryApplicationVersionInner>> getWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, ReplicationStatusTypes expand) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        if (galleryApplicationVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationVersionName is required and cannot be null.");
        }
        final String apiVersion = "2019-12-01";
        return service.get(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, expand, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<GalleryApplicationVersionInner>>>() {
                @Override
                public Observable<ServiceResponse<GalleryApplicationVersionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<GalleryApplicationVersionInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<GalleryApplicationVersionInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<GalleryApplicationVersionInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<GalleryApplicationVersionInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Delete a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        deleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName).toBlocking().last().body();
    }

    /**
     * Delete a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be deleted.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName), serviceCallback);
    }

    /**
     * Delete a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        return deleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        if (galleryApplicationVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationVersionName is required and cannot be null.");
        }
        final String apiVersion = "2019-12-01";
        Observable<Response<ResponseBody>> observable = service.delete(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Delete a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName).toBlocking().single().body();
    }

    /**
     * Delete a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be deleted.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName), serviceCallback);
    }

    /**
     * Delete a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryApplicationName, String galleryApplicationVersionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        if (galleryApplicationVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationVersionName is required and cannot be null.");
        }
        final String apiVersion = "2019-12-01";
        return service.beginDelete(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * List gallery Application Versions in a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the Shared Application Gallery Application Definition from which the Application Versions are to be listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;GalleryApplicationVersionInner&gt; object if successful.
     */
    public PagedList<GalleryApplicationVersionInner> listByGalleryApplication(final String resourceGroupName, final String galleryName, final String galleryApplicationName) {
        ServiceResponse<Page<GalleryApplicationVersionInner>> response = listByGalleryApplicationSinglePageAsync(resourceGroupName, galleryName, galleryApplicationName).toBlocking().single();
        return new PagedList<GalleryApplicationVersionInner>(response.body()) {
            @Override
            public Page<GalleryApplicationVersionInner> nextPage(String nextPageLink) {
                return listByGalleryApplicationNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List gallery Application Versions in a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the Shared Application Gallery Application Definition from which the Application Versions are to be listed.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<GalleryApplicationVersionInner>> listByGalleryApplicationAsync(final String resourceGroupName, final String galleryName, final String galleryApplicationName, final ListOperationCallback<GalleryApplicationVersionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByGalleryApplicationSinglePageAsync(resourceGroupName, galleryName, galleryApplicationName),
            new Func1<String, Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>> call(String nextPageLink) {
                    return listByGalleryApplicationNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List gallery Application Versions in a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the Shared Application Gallery Application Definition from which the Application Versions are to be listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;GalleryApplicationVersionInner&gt; object
     */
    public Observable<Page<GalleryApplicationVersionInner>> listByGalleryApplicationAsync(final String resourceGroupName, final String galleryName, final String galleryApplicationName) {
        return listByGalleryApplicationWithServiceResponseAsync(resourceGroupName, galleryName, galleryApplicationName)
            .map(new Func1<ServiceResponse<Page<GalleryApplicationVersionInner>>, Page<GalleryApplicationVersionInner>>() {
                @Override
                public Page<GalleryApplicationVersionInner> call(ServiceResponse<Page<GalleryApplicationVersionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List gallery Application Versions in a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the Shared Application Gallery Application Definition from which the Application Versions are to be listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;GalleryApplicationVersionInner&gt; object
     */
    public Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>> listByGalleryApplicationWithServiceResponseAsync(final String resourceGroupName, final String galleryName, final String galleryApplicationName) {
        return listByGalleryApplicationSinglePageAsync(resourceGroupName, galleryName, galleryApplicationName)
            .concatMap(new Func1<ServiceResponse<Page<GalleryApplicationVersionInner>>, Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>> call(ServiceResponse<Page<GalleryApplicationVersionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByGalleryApplicationNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List gallery Application Versions in a gallery Application Definition.
     *
    ServiceResponse<PageImpl1<GalleryApplicationVersionInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl1<GalleryApplicationVersionInner>> * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
    ServiceResponse<PageImpl1<GalleryApplicationVersionInner>> * @param galleryApplicationName The name of the Shared Application Gallery Application Definition from which the Application Versions are to be listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;GalleryApplicationVersionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>> listByGalleryApplicationSinglePageAsync(final String resourceGroupName, final String galleryName, final String galleryApplicationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryApplicationName == null) {
            throw new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null.");
        }
        final String apiVersion = "2019-12-01";
        return service.listByGalleryApplication(this.client.subscriptionId(), resourceGroupName, galleryName, galleryApplicationName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<GalleryApplicationVersionInner>> result = listByGalleryApplicationDelegate(response);
                        return Observable.just(new ServiceResponse<Page<GalleryApplicationVersionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<GalleryApplicationVersionInner>> listByGalleryApplicationDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<GalleryApplicationVersionInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<GalleryApplicationVersionInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * List gallery Application Versions in a gallery Application Definition.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;GalleryApplicationVersionInner&gt; object if successful.
     */
    public PagedList<GalleryApplicationVersionInner> listByGalleryApplicationNext(final String nextPageLink) {
        ServiceResponse<Page<GalleryApplicationVersionInner>> response = listByGalleryApplicationNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<GalleryApplicationVersionInner>(response.body()) {
            @Override
            public Page<GalleryApplicationVersionInner> nextPage(String nextPageLink) {
                return listByGalleryApplicationNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List gallery Application Versions in a gallery Application Definition.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<GalleryApplicationVersionInner>> listByGalleryApplicationNextAsync(final String nextPageLink, final ServiceFuture<List<GalleryApplicationVersionInner>> serviceFuture, final ListOperationCallback<GalleryApplicationVersionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByGalleryApplicationNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>> call(String nextPageLink) {
                    return listByGalleryApplicationNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List gallery Application Versions in a gallery Application Definition.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;GalleryApplicationVersionInner&gt; object
     */
    public Observable<Page<GalleryApplicationVersionInner>> listByGalleryApplicationNextAsync(final String nextPageLink) {
        return listByGalleryApplicationNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<GalleryApplicationVersionInner>>, Page<GalleryApplicationVersionInner>>() {
                @Override
                public Page<GalleryApplicationVersionInner> call(ServiceResponse<Page<GalleryApplicationVersionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List gallery Application Versions in a gallery Application Definition.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;GalleryApplicationVersionInner&gt; object
     */
    public Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>> listByGalleryApplicationNextWithServiceResponseAsync(final String nextPageLink) {
        return listByGalleryApplicationNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<GalleryApplicationVersionInner>>, Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>> call(ServiceResponse<Page<GalleryApplicationVersionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByGalleryApplicationNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List gallery Application Versions in a gallery Application Definition.
     *
    ServiceResponse<PageImpl1<GalleryApplicationVersionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;GalleryApplicationVersionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>> listByGalleryApplicationNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByGalleryApplicationNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GalleryApplicationVersionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<GalleryApplicationVersionInner>> result = listByGalleryApplicationNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<GalleryApplicationVersionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<GalleryApplicationVersionInner>> listByGalleryApplicationNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<GalleryApplicationVersionInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<GalleryApplicationVersionInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
