/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in DiskRestorePoints.
 */
public class DiskRestorePointsInner {
    /** The Retrofit service to perform REST calls. */
    private DiskRestorePointsService service;
    /** The service client containing this operation class. */
    private ComputeManagementClientImpl client;

    /**
     * Initializes an instance of DiskRestorePointsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public DiskRestorePointsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = retrofit.create(DiskRestorePointsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for DiskRestorePoints to be
     * used by Retrofit to perform actually REST calls.
     */
    interface DiskRestorePointsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskRestorePoints get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/restorePointCollections/{restorePointCollectionName}/restorePoints/{vmRestorePointName}/diskRestorePoints/{diskRestorePointName}")
        Observable<Response<ResponseBody>> get(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("restorePointCollectionName") String restorePointCollectionName, @Path("vmRestorePointName") String vmRestorePointName, @Path("diskRestorePointName") String diskRestorePointName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskRestorePoints listByRestorePoint" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/restorePointCollections/{restorePointCollectionName}/restorePoints/{vmRestorePointName}/diskRestorePoints")
        Observable<Response<ResponseBody>> listByRestorePoint(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("restorePointCollectionName") String restorePointCollectionName, @Path("vmRestorePointName") String vmRestorePointName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DiskRestorePoints listByRestorePointNext" })
        @GET
        Observable<Response<ResponseBody>> listByRestorePointNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Get disk restorePoint resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskRestorePointName The name of the disk restore point created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiskRestorePointInner object if successful.
     */
    public DiskRestorePointInner get(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName) {
        return getWithServiceResponseAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName).toBlocking().single().body();
    }

    /**
     * Get disk restorePoint resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskRestorePointName The name of the disk restore point created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiskRestorePointInner> getAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName, final ServiceCallback<DiskRestorePointInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName), serviceCallback);
    }

    /**
     * Get disk restorePoint resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskRestorePointName The name of the disk restore point created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiskRestorePointInner object
     */
    public Observable<DiskRestorePointInner> getAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName) {
        return getWithServiceResponseAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName).map(new Func1<ServiceResponse<DiskRestorePointInner>, DiskRestorePointInner>() {
            @Override
            public DiskRestorePointInner call(ServiceResponse<DiskRestorePointInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get disk restorePoint resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskRestorePointName The name of the disk restore point created. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiskRestorePointInner object
     */
    public Observable<ServiceResponse<DiskRestorePointInner>> getWithServiceResponseAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (restorePointCollectionName == null) {
            throw new IllegalArgumentException("Parameter restorePointCollectionName is required and cannot be null.");
        }
        if (vmRestorePointName == null) {
            throw new IllegalArgumentException("Parameter vmRestorePointName is required and cannot be null.");
        }
        if (diskRestorePointName == null) {
            throw new IllegalArgumentException("Parameter diskRestorePointName is required and cannot be null.");
        }
        final String apiVersion = "2020-09-30";
        return service.get(this.client.subscriptionId(), resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiskRestorePointInner>>>() {
                @Override
                public Observable<ServiceResponse<DiskRestorePointInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DiskRestorePointInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DiskRestorePointInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DiskRestorePointInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DiskRestorePointInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists diskRestorePoints under a vmRestorePoint.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DiskRestorePointInner&gt; object if successful.
     */
    public PagedList<DiskRestorePointInner> listByRestorePoint(final String resourceGroupName, final String restorePointCollectionName, final String vmRestorePointName) {
        ServiceResponse<Page<DiskRestorePointInner>> response = listByRestorePointSinglePageAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName).toBlocking().single();
        return new PagedList<DiskRestorePointInner>(response.body()) {
            @Override
            public Page<DiskRestorePointInner> nextPage(String nextPageLink) {
                return listByRestorePointNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists diskRestorePoints under a vmRestorePoint.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DiskRestorePointInner>> listByRestorePointAsync(final String resourceGroupName, final String restorePointCollectionName, final String vmRestorePointName, final ListOperationCallback<DiskRestorePointInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByRestorePointSinglePageAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName),
            new Func1<String, Observable<ServiceResponse<Page<DiskRestorePointInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskRestorePointInner>>> call(String nextPageLink) {
                    return listByRestorePointNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists diskRestorePoints under a vmRestorePoint.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskRestorePointInner&gt; object
     */
    public Observable<Page<DiskRestorePointInner>> listByRestorePointAsync(final String resourceGroupName, final String restorePointCollectionName, final String vmRestorePointName) {
        return listByRestorePointWithServiceResponseAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName)
            .map(new Func1<ServiceResponse<Page<DiskRestorePointInner>>, Page<DiskRestorePointInner>>() {
                @Override
                public Page<DiskRestorePointInner> call(ServiceResponse<Page<DiskRestorePointInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists diskRestorePoints under a vmRestorePoint.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskRestorePointInner&gt; object
     */
    public Observable<ServiceResponse<Page<DiskRestorePointInner>>> listByRestorePointWithServiceResponseAsync(final String resourceGroupName, final String restorePointCollectionName, final String vmRestorePointName) {
        return listByRestorePointSinglePageAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName)
            .concatMap(new Func1<ServiceResponse<Page<DiskRestorePointInner>>, Observable<ServiceResponse<Page<DiskRestorePointInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskRestorePointInner>>> call(ServiceResponse<Page<DiskRestorePointInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByRestorePointNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists diskRestorePoints under a vmRestorePoint.
     *
    ServiceResponse<PageImpl1<DiskRestorePointInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl1<DiskRestorePointInner>> * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
    ServiceResponse<PageImpl1<DiskRestorePointInner>> * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DiskRestorePointInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DiskRestorePointInner>>> listByRestorePointSinglePageAsync(final String resourceGroupName, final String restorePointCollectionName, final String vmRestorePointName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (restorePointCollectionName == null) {
            throw new IllegalArgumentException("Parameter restorePointCollectionName is required and cannot be null.");
        }
        if (vmRestorePointName == null) {
            throw new IllegalArgumentException("Parameter vmRestorePointName is required and cannot be null.");
        }
        final String apiVersion = "2020-09-30";
        return service.listByRestorePoint(this.client.subscriptionId(), resourceGroupName, restorePointCollectionName, vmRestorePointName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskRestorePointInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskRestorePointInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<DiskRestorePointInner>> result = listByRestorePointDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DiskRestorePointInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<DiskRestorePointInner>> listByRestorePointDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<DiskRestorePointInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<DiskRestorePointInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists diskRestorePoints under a vmRestorePoint.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DiskRestorePointInner&gt; object if successful.
     */
    public PagedList<DiskRestorePointInner> listByRestorePointNext(final String nextPageLink) {
        ServiceResponse<Page<DiskRestorePointInner>> response = listByRestorePointNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DiskRestorePointInner>(response.body()) {
            @Override
            public Page<DiskRestorePointInner> nextPage(String nextPageLink) {
                return listByRestorePointNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists diskRestorePoints under a vmRestorePoint.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DiskRestorePointInner>> listByRestorePointNextAsync(final String nextPageLink, final ServiceFuture<List<DiskRestorePointInner>> serviceFuture, final ListOperationCallback<DiskRestorePointInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByRestorePointNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<DiskRestorePointInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskRestorePointInner>>> call(String nextPageLink) {
                    return listByRestorePointNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists diskRestorePoints under a vmRestorePoint.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskRestorePointInner&gt; object
     */
    public Observable<Page<DiskRestorePointInner>> listByRestorePointNextAsync(final String nextPageLink) {
        return listByRestorePointNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<DiskRestorePointInner>>, Page<DiskRestorePointInner>>() {
                @Override
                public Page<DiskRestorePointInner> call(ServiceResponse<Page<DiskRestorePointInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists diskRestorePoints under a vmRestorePoint.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiskRestorePointInner&gt; object
     */
    public Observable<ServiceResponse<Page<DiskRestorePointInner>>> listByRestorePointNextWithServiceResponseAsync(final String nextPageLink) {
        return listByRestorePointNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<DiskRestorePointInner>>, Observable<ServiceResponse<Page<DiskRestorePointInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskRestorePointInner>>> call(ServiceResponse<Page<DiskRestorePointInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByRestorePointNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists diskRestorePoints under a vmRestorePoint.
     *
    ServiceResponse<PageImpl1<DiskRestorePointInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DiskRestorePointInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DiskRestorePointInner>>> listByRestorePointNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByRestorePointNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiskRestorePointInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiskRestorePointInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<DiskRestorePointInner>> result = listByRestorePointNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DiskRestorePointInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<DiskRestorePointInner>> listByRestorePointNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<DiskRestorePointInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<DiskRestorePointInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
