/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.compute.DedicatedHostUpdate;
import com.microsoft.azure.management.compute.InstanceViewTypes;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in DedicatedHosts.
 */
public class DedicatedHostsInner {
    /** The Retrofit service to perform REST calls. */
    private DedicatedHostsService service;
    /** The service client containing this operation class. */
    private ComputeManagementClientImpl client;

    /**
     * Initializes an instance of DedicatedHostsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public DedicatedHostsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = retrofit.create(DedicatedHostsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for DedicatedHosts to be
     * used by Retrofit to perform actually REST calls.
     */
    interface DedicatedHostsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHosts createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}/hosts/{hostName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("hostGroupName") String hostGroupName, @Path("hostName") String hostName, @Path("subscriptionId") String subscriptionId, @Body DedicatedHostInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHosts beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}/hosts/{hostName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("hostGroupName") String hostGroupName, @Path("hostName") String hostName, @Path("subscriptionId") String subscriptionId, @Body DedicatedHostInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHosts update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}/hosts/{hostName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("hostGroupName") String hostGroupName, @Path("hostName") String hostName, @Path("subscriptionId") String subscriptionId, @Body DedicatedHostUpdate parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHosts beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}/hosts/{hostName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("hostGroupName") String hostGroupName, @Path("hostName") String hostName, @Path("subscriptionId") String subscriptionId, @Body DedicatedHostUpdate parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHosts delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}/hosts/{hostName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("hostGroupName") String hostGroupName, @Path("hostName") String hostName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHosts beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}/hosts/{hostName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("hostGroupName") String hostGroupName, @Path("hostName") String hostName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHosts get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}/hosts/{hostName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("hostGroupName") String hostGroupName, @Path("hostName") String hostName, @Path("subscriptionId") String subscriptionId, @Query("$expand") InstanceViewTypes expand, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHosts listByHostGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}/hosts")
        Observable<Response<ResponseBody>> listByHostGroup(@Path("resourceGroupName") String resourceGroupName, @Path("hostGroupName") String hostGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHosts listByHostGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByHostGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Create or update a dedicated host .
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host .
     * @param parameters Parameters supplied to the Create Dedicated Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DedicatedHostInner object if successful.
     */
    public DedicatedHostInner createOrUpdate(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, parameters).toBlocking().last().body();
    }

    /**
     * Create or update a dedicated host .
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host .
     * @param parameters Parameters supplied to the Create Dedicated Host.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DedicatedHostInner> createOrUpdateAsync(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostInner parameters, final ServiceCallback<DedicatedHostInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, parameters), serviceCallback);
    }

    /**
     * Create or update a dedicated host .
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host .
     * @param parameters Parameters supplied to the Create Dedicated Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<DedicatedHostInner> createOrUpdateAsync(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, parameters).map(new Func1<ServiceResponse<DedicatedHostInner>, DedicatedHostInner>() {
            @Override
            public DedicatedHostInner call(ServiceResponse<DedicatedHostInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a dedicated host .
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host .
     * @param parameters Parameters supplied to the Create Dedicated Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<DedicatedHostInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2020-12-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, hostGroupName, hostName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DedicatedHostInner>() { }.getType());
    }

    /**
     * Create or update a dedicated host .
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host .
     * @param parameters Parameters supplied to the Create Dedicated Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DedicatedHostInner object if successful.
     */
    public DedicatedHostInner beginCreateOrUpdate(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, parameters).toBlocking().single().body();
    }

    /**
     * Create or update a dedicated host .
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host .
     * @param parameters Parameters supplied to the Create Dedicated Host.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DedicatedHostInner> beginCreateOrUpdateAsync(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostInner parameters, final ServiceCallback<DedicatedHostInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, parameters), serviceCallback);
    }

    /**
     * Create or update a dedicated host .
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host .
     * @param parameters Parameters supplied to the Create Dedicated Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DedicatedHostInner object
     */
    public Observable<DedicatedHostInner> beginCreateOrUpdateAsync(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, parameters).map(new Func1<ServiceResponse<DedicatedHostInner>, DedicatedHostInner>() {
            @Override
            public DedicatedHostInner call(ServiceResponse<DedicatedHostInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a dedicated host .
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host .
     * @param parameters Parameters supplied to the Create Dedicated Host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DedicatedHostInner object
     */
    public Observable<ServiceResponse<DedicatedHostInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2020-12-01";
        return service.beginCreateOrUpdate(resourceGroupName, hostGroupName, hostName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DedicatedHostInner>>>() {
                @Override
                public Observable<ServiceResponse<DedicatedHostInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DedicatedHostInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DedicatedHostInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DedicatedHostInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DedicatedHostInner>() { }.getType())
                .register(201, new TypeToken<DedicatedHostInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Update an dedicated host .
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host .
     * @param parameters Parameters supplied to the Update Dedicated Host operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DedicatedHostInner object if successful.
     */
    public DedicatedHostInner update(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostUpdate parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, parameters).toBlocking().last().body();
    }

    /**
     * Update an dedicated host .
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host .
     * @param parameters Parameters supplied to the Update Dedicated Host operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DedicatedHostInner> updateAsync(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostUpdate parameters, final ServiceCallback<DedicatedHostInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, parameters), serviceCallback);
    }

    /**
     * Update an dedicated host .
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host .
     * @param parameters Parameters supplied to the Update Dedicated Host operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<DedicatedHostInner> updateAsync(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostUpdate parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, parameters).map(new Func1<ServiceResponse<DedicatedHostInner>, DedicatedHostInner>() {
            @Override
            public DedicatedHostInner call(ServiceResponse<DedicatedHostInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update an dedicated host .
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host .
     * @param parameters Parameters supplied to the Update Dedicated Host operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<DedicatedHostInner>> updateWithServiceResponseAsync(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostUpdate parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2020-12-01";
        Observable<Response<ResponseBody>> observable = service.update(resourceGroupName, hostGroupName, hostName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DedicatedHostInner>() { }.getType());
    }

    /**
     * Update an dedicated host .
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host .
     * @param parameters Parameters supplied to the Update Dedicated Host operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DedicatedHostInner object if successful.
     */
    public DedicatedHostInner beginUpdate(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostUpdate parameters) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, parameters).toBlocking().single().body();
    }

    /**
     * Update an dedicated host .
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host .
     * @param parameters Parameters supplied to the Update Dedicated Host operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DedicatedHostInner> beginUpdateAsync(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostUpdate parameters, final ServiceCallback<DedicatedHostInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, parameters), serviceCallback);
    }

    /**
     * Update an dedicated host .
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host .
     * @param parameters Parameters supplied to the Update Dedicated Host operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DedicatedHostInner object
     */
    public Observable<DedicatedHostInner> beginUpdateAsync(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostUpdate parameters) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, parameters).map(new Func1<ServiceResponse<DedicatedHostInner>, DedicatedHostInner>() {
            @Override
            public DedicatedHostInner call(ServiceResponse<DedicatedHostInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update an dedicated host .
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host .
     * @param parameters Parameters supplied to the Update Dedicated Host operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DedicatedHostInner object
     */
    public Observable<ServiceResponse<DedicatedHostInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String hostGroupName, String hostName, DedicatedHostUpdate parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2020-12-01";
        return service.beginUpdate(resourceGroupName, hostGroupName, hostName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DedicatedHostInner>>>() {
                @Override
                public Observable<ServiceResponse<DedicatedHostInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DedicatedHostInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DedicatedHostInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DedicatedHostInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DedicatedHostInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Delete a dedicated host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String hostGroupName, String hostName) {
        deleteWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName).toBlocking().last().body();
    }

    /**
     * Delete a dedicated host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String hostGroupName, String hostName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName), serviceCallback);
    }

    /**
     * Delete a dedicated host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String hostGroupName, String hostName) {
        return deleteWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete a dedicated host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String hostGroupName, String hostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, hostGroupName, hostName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Delete a dedicated host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String hostGroupName, String hostName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName).toBlocking().single().body();
    }

    /**
     * Delete a dedicated host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String hostGroupName, String hostName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName), serviceCallback);
    }

    /**
     * Delete a dedicated host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String hostGroupName, String hostName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete a dedicated host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String hostGroupName, String hostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        return service.beginDelete(resourceGroupName, hostGroupName, hostName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves information about a dedicated host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DedicatedHostInner object if successful.
     */
    public DedicatedHostInner get(String resourceGroupName, String hostGroupName, String hostName) {
        return getWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName).toBlocking().single().body();
    }

    /**
     * Retrieves information about a dedicated host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DedicatedHostInner> getAsync(String resourceGroupName, String hostGroupName, String hostName, final ServiceCallback<DedicatedHostInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName), serviceCallback);
    }

    /**
     * Retrieves information about a dedicated host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DedicatedHostInner object
     */
    public Observable<DedicatedHostInner> getAsync(String resourceGroupName, String hostGroupName, String hostName) {
        return getWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName).map(new Func1<ServiceResponse<DedicatedHostInner>, DedicatedHostInner>() {
            @Override
            public DedicatedHostInner call(ServiceResponse<DedicatedHostInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves information about a dedicated host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DedicatedHostInner object
     */
    public Observable<ServiceResponse<DedicatedHostInner>> getWithServiceResponseAsync(String resourceGroupName, String hostGroupName, String hostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        final InstanceViewTypes expand = null;
        return service.get(resourceGroupName, hostGroupName, hostName, this.client.subscriptionId(), expand, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DedicatedHostInner>>>() {
                @Override
                public Observable<ServiceResponse<DedicatedHostInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DedicatedHostInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves information about a dedicated host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host.
     * @param expand The expand expression to apply on the operation. Possible values include: 'instanceView'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DedicatedHostInner object if successful.
     */
    public DedicatedHostInner get(String resourceGroupName, String hostGroupName, String hostName, InstanceViewTypes expand) {
        return getWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, expand).toBlocking().single().body();
    }

    /**
     * Retrieves information about a dedicated host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host.
     * @param expand The expand expression to apply on the operation. Possible values include: 'instanceView'
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DedicatedHostInner> getAsync(String resourceGroupName, String hostGroupName, String hostName, InstanceViewTypes expand, final ServiceCallback<DedicatedHostInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, expand), serviceCallback);
    }

    /**
     * Retrieves information about a dedicated host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host.
     * @param expand The expand expression to apply on the operation. Possible values include: 'instanceView'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DedicatedHostInner object
     */
    public Observable<DedicatedHostInner> getAsync(String resourceGroupName, String hostGroupName, String hostName, InstanceViewTypes expand) {
        return getWithServiceResponseAsync(resourceGroupName, hostGroupName, hostName, expand).map(new Func1<ServiceResponse<DedicatedHostInner>, DedicatedHostInner>() {
            @Override
            public DedicatedHostInner call(ServiceResponse<DedicatedHostInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves information about a dedicated host.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param hostName The name of the dedicated host.
     * @param expand The expand expression to apply on the operation. Possible values include: 'instanceView'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DedicatedHostInner object
     */
    public Observable<ServiceResponse<DedicatedHostInner>> getWithServiceResponseAsync(String resourceGroupName, String hostGroupName, String hostName, InstanceViewTypes expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        return service.get(resourceGroupName, hostGroupName, hostName, this.client.subscriptionId(), expand, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DedicatedHostInner>>>() {
                @Override
                public Observable<ServiceResponse<DedicatedHostInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DedicatedHostInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DedicatedHostInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DedicatedHostInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DedicatedHostInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all of the dedicated hosts in the specified dedicated host group. Use the nextLink property in the response to get the next page of dedicated hosts.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DedicatedHostInner&gt; object if successful.
     */
    public PagedList<DedicatedHostInner> listByHostGroup(final String resourceGroupName, final String hostGroupName) {
        ServiceResponse<Page<DedicatedHostInner>> response = listByHostGroupSinglePageAsync(resourceGroupName, hostGroupName).toBlocking().single();
        return new PagedList<DedicatedHostInner>(response.body()) {
            @Override
            public Page<DedicatedHostInner> nextPage(String nextPageLink) {
                return listByHostGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the dedicated hosts in the specified dedicated host group. Use the nextLink property in the response to get the next page of dedicated hosts.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DedicatedHostInner>> listByHostGroupAsync(final String resourceGroupName, final String hostGroupName, final ListOperationCallback<DedicatedHostInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByHostGroupSinglePageAsync(resourceGroupName, hostGroupName),
            new Func1<String, Observable<ServiceResponse<Page<DedicatedHostInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DedicatedHostInner>>> call(String nextPageLink) {
                    return listByHostGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the dedicated hosts in the specified dedicated host group. Use the nextLink property in the response to get the next page of dedicated hosts.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DedicatedHostInner&gt; object
     */
    public Observable<Page<DedicatedHostInner>> listByHostGroupAsync(final String resourceGroupName, final String hostGroupName) {
        return listByHostGroupWithServiceResponseAsync(resourceGroupName, hostGroupName)
            .map(new Func1<ServiceResponse<Page<DedicatedHostInner>>, Page<DedicatedHostInner>>() {
                @Override
                public Page<DedicatedHostInner> call(ServiceResponse<Page<DedicatedHostInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the dedicated hosts in the specified dedicated host group. Use the nextLink property in the response to get the next page of dedicated hosts.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DedicatedHostInner&gt; object
     */
    public Observable<ServiceResponse<Page<DedicatedHostInner>>> listByHostGroupWithServiceResponseAsync(final String resourceGroupName, final String hostGroupName) {
        return listByHostGroupSinglePageAsync(resourceGroupName, hostGroupName)
            .concatMap(new Func1<ServiceResponse<Page<DedicatedHostInner>>, Observable<ServiceResponse<Page<DedicatedHostInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DedicatedHostInner>>> call(ServiceResponse<Page<DedicatedHostInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByHostGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the dedicated hosts in the specified dedicated host group. Use the nextLink property in the response to get the next page of dedicated hosts.
     *
    ServiceResponse<PageImpl1<DedicatedHostInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl1<DedicatedHostInner>> * @param hostGroupName The name of the dedicated host group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DedicatedHostInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DedicatedHostInner>>> listByHostGroupSinglePageAsync(final String resourceGroupName, final String hostGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        return service.listByHostGroup(resourceGroupName, hostGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DedicatedHostInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DedicatedHostInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<DedicatedHostInner>> result = listByHostGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DedicatedHostInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<DedicatedHostInner>> listByHostGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<DedicatedHostInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<DedicatedHostInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all of the dedicated hosts in the specified dedicated host group. Use the nextLink property in the response to get the next page of dedicated hosts.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DedicatedHostInner&gt; object if successful.
     */
    public PagedList<DedicatedHostInner> listByHostGroupNext(final String nextPageLink) {
        ServiceResponse<Page<DedicatedHostInner>> response = listByHostGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DedicatedHostInner>(response.body()) {
            @Override
            public Page<DedicatedHostInner> nextPage(String nextPageLink) {
                return listByHostGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the dedicated hosts in the specified dedicated host group. Use the nextLink property in the response to get the next page of dedicated hosts.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DedicatedHostInner>> listByHostGroupNextAsync(final String nextPageLink, final ServiceFuture<List<DedicatedHostInner>> serviceFuture, final ListOperationCallback<DedicatedHostInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByHostGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<DedicatedHostInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DedicatedHostInner>>> call(String nextPageLink) {
                    return listByHostGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the dedicated hosts in the specified dedicated host group. Use the nextLink property in the response to get the next page of dedicated hosts.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DedicatedHostInner&gt; object
     */
    public Observable<Page<DedicatedHostInner>> listByHostGroupNextAsync(final String nextPageLink) {
        return listByHostGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<DedicatedHostInner>>, Page<DedicatedHostInner>>() {
                @Override
                public Page<DedicatedHostInner> call(ServiceResponse<Page<DedicatedHostInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the dedicated hosts in the specified dedicated host group. Use the nextLink property in the response to get the next page of dedicated hosts.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DedicatedHostInner&gt; object
     */
    public Observable<ServiceResponse<Page<DedicatedHostInner>>> listByHostGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByHostGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<DedicatedHostInner>>, Observable<ServiceResponse<Page<DedicatedHostInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DedicatedHostInner>>> call(ServiceResponse<Page<DedicatedHostInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByHostGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the dedicated hosts in the specified dedicated host group. Use the nextLink property in the response to get the next page of dedicated hosts.
     *
    ServiceResponse<PageImpl1<DedicatedHostInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DedicatedHostInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DedicatedHostInner>>> listByHostGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByHostGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DedicatedHostInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DedicatedHostInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<DedicatedHostInner>> result = listByHostGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DedicatedHostInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<DedicatedHostInner>> listByHostGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<DedicatedHostInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<DedicatedHostInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
