/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.compute.DedicatedHostGroupUpdate;
import com.microsoft.azure.management.compute.InstanceViewTypes;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in DedicatedHostGroups.
 */
public class DedicatedHostGroupsInner implements InnerSupportsGet<DedicatedHostGroupInner>, InnerSupportsDelete<Void>, InnerSupportsListing<DedicatedHostGroupInner> {
    /** The Retrofit service to perform REST calls. */
    private DedicatedHostGroupsService service;
    /** The service client containing this operation class. */
    private ComputeManagementClientImpl client;

    /**
     * Initializes an instance of DedicatedHostGroupsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public DedicatedHostGroupsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = retrofit.create(DedicatedHostGroupsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for DedicatedHostGroups to be
     * used by Retrofit to perform actually REST calls.
     */
    interface DedicatedHostGroupsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHostGroups createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("hostGroupName") String hostGroupName, @Path("subscriptionId") String subscriptionId, @Body DedicatedHostGroupInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHostGroups update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("hostGroupName") String hostGroupName, @Path("subscriptionId") String subscriptionId, @Body DedicatedHostGroupUpdate parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHostGroups delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("hostGroupName") String hostGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHostGroups getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("hostGroupName") String hostGroupName, @Path("subscriptionId") String subscriptionId, @Query("$expand") InstanceViewTypes expand, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHostGroups listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHostGroups list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Compute/hostGroups")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHostGroups listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.DedicatedHostGroups listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Create or update a dedicated host group. For details of Dedicated Host and Dedicated Host Groups please see [Dedicated Host Documentation] (https://go.microsoft.com/fwlink/?linkid=2082596).
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param parameters Parameters supplied to the Create Dedicated Host Group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DedicatedHostGroupInner object if successful.
     */
    public DedicatedHostGroupInner createOrUpdate(String resourceGroupName, String hostGroupName, DedicatedHostGroupInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, hostGroupName, parameters).toBlocking().single().body();
    }

    /**
     * Create or update a dedicated host group. For details of Dedicated Host and Dedicated Host Groups please see [Dedicated Host Documentation] (https://go.microsoft.com/fwlink/?linkid=2082596).
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param parameters Parameters supplied to the Create Dedicated Host Group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DedicatedHostGroupInner> createOrUpdateAsync(String resourceGroupName, String hostGroupName, DedicatedHostGroupInner parameters, final ServiceCallback<DedicatedHostGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, hostGroupName, parameters), serviceCallback);
    }

    /**
     * Create or update a dedicated host group. For details of Dedicated Host and Dedicated Host Groups please see [Dedicated Host Documentation] (https://go.microsoft.com/fwlink/?linkid=2082596).
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param parameters Parameters supplied to the Create Dedicated Host Group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DedicatedHostGroupInner object
     */
    public Observable<DedicatedHostGroupInner> createOrUpdateAsync(String resourceGroupName, String hostGroupName, DedicatedHostGroupInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, hostGroupName, parameters).map(new Func1<ServiceResponse<DedicatedHostGroupInner>, DedicatedHostGroupInner>() {
            @Override
            public DedicatedHostGroupInner call(ServiceResponse<DedicatedHostGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a dedicated host group. For details of Dedicated Host and Dedicated Host Groups please see [Dedicated Host Documentation] (https://go.microsoft.com/fwlink/?linkid=2082596).
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param parameters Parameters supplied to the Create Dedicated Host Group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DedicatedHostGroupInner object
     */
    public Observable<ServiceResponse<DedicatedHostGroupInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String hostGroupName, DedicatedHostGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2020-12-01";
        return service.createOrUpdate(resourceGroupName, hostGroupName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DedicatedHostGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<DedicatedHostGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DedicatedHostGroupInner> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DedicatedHostGroupInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DedicatedHostGroupInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DedicatedHostGroupInner>() { }.getType())
                .register(201, new TypeToken<DedicatedHostGroupInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Update an dedicated host group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param parameters Parameters supplied to the Update Dedicated Host Group operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DedicatedHostGroupInner object if successful.
     */
    public DedicatedHostGroupInner update(String resourceGroupName, String hostGroupName, DedicatedHostGroupUpdate parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, hostGroupName, parameters).toBlocking().single().body();
    }

    /**
     * Update an dedicated host group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param parameters Parameters supplied to the Update Dedicated Host Group operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DedicatedHostGroupInner> updateAsync(String resourceGroupName, String hostGroupName, DedicatedHostGroupUpdate parameters, final ServiceCallback<DedicatedHostGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, hostGroupName, parameters), serviceCallback);
    }

    /**
     * Update an dedicated host group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param parameters Parameters supplied to the Update Dedicated Host Group operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DedicatedHostGroupInner object
     */
    public Observable<DedicatedHostGroupInner> updateAsync(String resourceGroupName, String hostGroupName, DedicatedHostGroupUpdate parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, hostGroupName, parameters).map(new Func1<ServiceResponse<DedicatedHostGroupInner>, DedicatedHostGroupInner>() {
            @Override
            public DedicatedHostGroupInner call(ServiceResponse<DedicatedHostGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update an dedicated host group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param parameters Parameters supplied to the Update Dedicated Host Group operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DedicatedHostGroupInner object
     */
    public Observable<ServiceResponse<DedicatedHostGroupInner>> updateWithServiceResponseAsync(String resourceGroupName, String hostGroupName, DedicatedHostGroupUpdate parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2020-12-01";
        return service.update(resourceGroupName, hostGroupName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DedicatedHostGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<DedicatedHostGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DedicatedHostGroupInner> clientResponse = updateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DedicatedHostGroupInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DedicatedHostGroupInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DedicatedHostGroupInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Delete a dedicated host group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String hostGroupName) {
        deleteWithServiceResponseAsync(resourceGroupName, hostGroupName).toBlocking().single().body();
    }

    /**
     * Delete a dedicated host group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String hostGroupName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, hostGroupName), serviceCallback);
    }

    /**
     * Delete a dedicated host group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String hostGroupName) {
        return deleteWithServiceResponseAsync(resourceGroupName, hostGroupName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete a dedicated host group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String hostGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        return service.delete(resourceGroupName, hostGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves information about a dedicated host group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DedicatedHostGroupInner object if successful.
     */
    public DedicatedHostGroupInner getByResourceGroup(String resourceGroupName, String hostGroupName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, hostGroupName).toBlocking().single().body();
    }

    /**
     * Retrieves information about a dedicated host group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DedicatedHostGroupInner> getByResourceGroupAsync(String resourceGroupName, String hostGroupName, final ServiceCallback<DedicatedHostGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, hostGroupName), serviceCallback);
    }

    /**
     * Retrieves information about a dedicated host group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DedicatedHostGroupInner object
     */
    public Observable<DedicatedHostGroupInner> getByResourceGroupAsync(String resourceGroupName, String hostGroupName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, hostGroupName).map(new Func1<ServiceResponse<DedicatedHostGroupInner>, DedicatedHostGroupInner>() {
            @Override
            public DedicatedHostGroupInner call(ServiceResponse<DedicatedHostGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves information about a dedicated host group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DedicatedHostGroupInner object
     */
    public Observable<ServiceResponse<DedicatedHostGroupInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String hostGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        final InstanceViewTypes expand = null;
        return service.getByResourceGroup(resourceGroupName, hostGroupName, this.client.subscriptionId(), expand, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DedicatedHostGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<DedicatedHostGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DedicatedHostGroupInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Retrieves information about a dedicated host group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param expand The expand expression to apply on the operation. The response shows the list of instance view of the dedicated hosts under the dedicated host group. Possible values include: 'instanceView'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DedicatedHostGroupInner object if successful.
     */
    public DedicatedHostGroupInner getByResourceGroup(String resourceGroupName, String hostGroupName, InstanceViewTypes expand) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, hostGroupName, expand).toBlocking().single().body();
    }

    /**
     * Retrieves information about a dedicated host group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param expand The expand expression to apply on the operation. The response shows the list of instance view of the dedicated hosts under the dedicated host group. Possible values include: 'instanceView'
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DedicatedHostGroupInner> getByResourceGroupAsync(String resourceGroupName, String hostGroupName, InstanceViewTypes expand, final ServiceCallback<DedicatedHostGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, hostGroupName, expand), serviceCallback);
    }

    /**
     * Retrieves information about a dedicated host group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param expand The expand expression to apply on the operation. The response shows the list of instance view of the dedicated hosts under the dedicated host group. Possible values include: 'instanceView'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DedicatedHostGroupInner object
     */
    public Observable<DedicatedHostGroupInner> getByResourceGroupAsync(String resourceGroupName, String hostGroupName, InstanceViewTypes expand) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, hostGroupName, expand).map(new Func1<ServiceResponse<DedicatedHostGroupInner>, DedicatedHostGroupInner>() {
            @Override
            public DedicatedHostGroupInner call(ServiceResponse<DedicatedHostGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves information about a dedicated host group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param hostGroupName The name of the dedicated host group.
     * @param expand The expand expression to apply on the operation. The response shows the list of instance view of the dedicated hosts under the dedicated host group. Possible values include: 'instanceView'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DedicatedHostGroupInner object
     */
    public Observable<ServiceResponse<DedicatedHostGroupInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String hostGroupName, InstanceViewTypes expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (hostGroupName == null) {
            throw new IllegalArgumentException("Parameter hostGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        return service.getByResourceGroup(resourceGroupName, hostGroupName, this.client.subscriptionId(), expand, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DedicatedHostGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<DedicatedHostGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DedicatedHostGroupInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DedicatedHostGroupInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DedicatedHostGroupInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DedicatedHostGroupInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all of the dedicated host groups in the specified resource group. Use the nextLink property in the response to get the next page of dedicated host groups.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DedicatedHostGroupInner&gt; object if successful.
     */
    public PagedList<DedicatedHostGroupInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<DedicatedHostGroupInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<DedicatedHostGroupInner>(response.body()) {
            @Override
            public Page<DedicatedHostGroupInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the dedicated host groups in the specified resource group. Use the nextLink property in the response to get the next page of dedicated host groups.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DedicatedHostGroupInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<DedicatedHostGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<DedicatedHostGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the dedicated host groups in the specified resource group. Use the nextLink property in the response to get the next page of dedicated host groups.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DedicatedHostGroupInner&gt; object
     */
    public Observable<Page<DedicatedHostGroupInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<DedicatedHostGroupInner>>, Page<DedicatedHostGroupInner>>() {
                @Override
                public Page<DedicatedHostGroupInner> call(ServiceResponse<Page<DedicatedHostGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the dedicated host groups in the specified resource group. Use the nextLink property in the response to get the next page of dedicated host groups.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DedicatedHostGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<DedicatedHostGroupInner>>, Observable<ServiceResponse<Page<DedicatedHostGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> call(ServiceResponse<Page<DedicatedHostGroupInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the dedicated host groups in the specified resource group. Use the nextLink property in the response to get the next page of dedicated host groups.
     *
    ServiceResponse<PageImpl1<DedicatedHostGroupInner>> * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DedicatedHostGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DedicatedHostGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<DedicatedHostGroupInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DedicatedHostGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<DedicatedHostGroupInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<DedicatedHostGroupInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<DedicatedHostGroupInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all of the dedicated host groups in the subscription. Use the nextLink property in the response to get the next page of dedicated host groups.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DedicatedHostGroupInner&gt; object if successful.
     */
    public PagedList<DedicatedHostGroupInner> list() {
        ServiceResponse<Page<DedicatedHostGroupInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<DedicatedHostGroupInner>(response.body()) {
            @Override
            public Page<DedicatedHostGroupInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the dedicated host groups in the subscription. Use the nextLink property in the response to get the next page of dedicated host groups.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DedicatedHostGroupInner>> listAsync(final ListOperationCallback<DedicatedHostGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<DedicatedHostGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the dedicated host groups in the subscription. Use the nextLink property in the response to get the next page of dedicated host groups.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DedicatedHostGroupInner&gt; object
     */
    public Observable<Page<DedicatedHostGroupInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<DedicatedHostGroupInner>>, Page<DedicatedHostGroupInner>>() {
                @Override
                public Page<DedicatedHostGroupInner> call(ServiceResponse<Page<DedicatedHostGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the dedicated host groups in the subscription. Use the nextLink property in the response to get the next page of dedicated host groups.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DedicatedHostGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<DedicatedHostGroupInner>>, Observable<ServiceResponse<Page<DedicatedHostGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> call(ServiceResponse<Page<DedicatedHostGroupInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the dedicated host groups in the subscription. Use the nextLink property in the response to get the next page of dedicated host groups.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DedicatedHostGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2020-12-01";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DedicatedHostGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<DedicatedHostGroupInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DedicatedHostGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<DedicatedHostGroupInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<DedicatedHostGroupInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<DedicatedHostGroupInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all of the dedicated host groups in the specified resource group. Use the nextLink property in the response to get the next page of dedicated host groups.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DedicatedHostGroupInner&gt; object if successful.
     */
    public PagedList<DedicatedHostGroupInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<DedicatedHostGroupInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DedicatedHostGroupInner>(response.body()) {
            @Override
            public Page<DedicatedHostGroupInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the dedicated host groups in the specified resource group. Use the nextLink property in the response to get the next page of dedicated host groups.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DedicatedHostGroupInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<DedicatedHostGroupInner>> serviceFuture, final ListOperationCallback<DedicatedHostGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<DedicatedHostGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the dedicated host groups in the specified resource group. Use the nextLink property in the response to get the next page of dedicated host groups.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DedicatedHostGroupInner&gt; object
     */
    public Observable<Page<DedicatedHostGroupInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<DedicatedHostGroupInner>>, Page<DedicatedHostGroupInner>>() {
                @Override
                public Page<DedicatedHostGroupInner> call(ServiceResponse<Page<DedicatedHostGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the dedicated host groups in the specified resource group. Use the nextLink property in the response to get the next page of dedicated host groups.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DedicatedHostGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<DedicatedHostGroupInner>>, Observable<ServiceResponse<Page<DedicatedHostGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> call(ServiceResponse<Page<DedicatedHostGroupInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the dedicated host groups in the specified resource group. Use the nextLink property in the response to get the next page of dedicated host groups.
     *
    ServiceResponse<PageImpl1<DedicatedHostGroupInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DedicatedHostGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DedicatedHostGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<DedicatedHostGroupInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DedicatedHostGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<DedicatedHostGroupInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<DedicatedHostGroupInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<DedicatedHostGroupInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all of the dedicated host groups in the subscription. Use the nextLink property in the response to get the next page of dedicated host groups.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DedicatedHostGroupInner&gt; object if successful.
     */
    public PagedList<DedicatedHostGroupInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<DedicatedHostGroupInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DedicatedHostGroupInner>(response.body()) {
            @Override
            public Page<DedicatedHostGroupInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the dedicated host groups in the subscription. Use the nextLink property in the response to get the next page of dedicated host groups.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DedicatedHostGroupInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<DedicatedHostGroupInner>> serviceFuture, final ListOperationCallback<DedicatedHostGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<DedicatedHostGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the dedicated host groups in the subscription. Use the nextLink property in the response to get the next page of dedicated host groups.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DedicatedHostGroupInner&gt; object
     */
    public Observable<Page<DedicatedHostGroupInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<DedicatedHostGroupInner>>, Page<DedicatedHostGroupInner>>() {
                @Override
                public Page<DedicatedHostGroupInner> call(ServiceResponse<Page<DedicatedHostGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the dedicated host groups in the subscription. Use the nextLink property in the response to get the next page of dedicated host groups.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DedicatedHostGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<DedicatedHostGroupInner>>, Observable<ServiceResponse<Page<DedicatedHostGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> call(ServiceResponse<Page<DedicatedHostGroupInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the dedicated host groups in the subscription. Use the nextLink property in the response to get the next page of dedicated host groups.
     *
    ServiceResponse<PageImpl1<DedicatedHostGroupInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DedicatedHostGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DedicatedHostGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DedicatedHostGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<DedicatedHostGroupInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DedicatedHostGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<DedicatedHostGroupInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<DedicatedHostGroupInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<DedicatedHostGroupInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
