/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute;

import java.util.List;
import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Input for InstallPatches on a Windows VM, as directly received by the API.
 */
public class WindowsParameters {
    /**
     * The update classifications to select when installing patches for
     * Windows.
     */
    @JsonProperty(value = "classificationsToInclude")
    private List<VMGuestPatchClassificationWindows> classificationsToInclude;

    /**
     * Kbs to include in the patch operation.
     */
    @JsonProperty(value = "kbNumbersToInclude")
    private List<String> kbNumbersToInclude;

    /**
     * Kbs to exclude in the patch operation.
     */
    @JsonProperty(value = "kbNumbersToExclude")
    private List<String> kbNumbersToExclude;

    /**
     * Filters out Kbs that don't have an InstallationRebootBehavior of
     * 'NeverReboots' when this is set to true.
     */
    @JsonProperty(value = "excludeKbsRequiringReboot")
    private Boolean excludeKbsRequiringReboot;

    /**
     * This is used to install patches that were published on or before this
     * given max published date.
     */
    @JsonProperty(value = "maxPatchPublishDate")
    private DateTime maxPatchPublishDate;

    /**
     * Get the update classifications to select when installing patches for Windows.
     *
     * @return the classificationsToInclude value
     */
    public List<VMGuestPatchClassificationWindows> classificationsToInclude() {
        return this.classificationsToInclude;
    }

    /**
     * Set the update classifications to select when installing patches for Windows.
     *
     * @param classificationsToInclude the classificationsToInclude value to set
     * @return the WindowsParameters object itself.
     */
    public WindowsParameters withClassificationsToInclude(List<VMGuestPatchClassificationWindows> classificationsToInclude) {
        this.classificationsToInclude = classificationsToInclude;
        return this;
    }

    /**
     * Get kbs to include in the patch operation.
     *
     * @return the kbNumbersToInclude value
     */
    public List<String> kbNumbersToInclude() {
        return this.kbNumbersToInclude;
    }

    /**
     * Set kbs to include in the patch operation.
     *
     * @param kbNumbersToInclude the kbNumbersToInclude value to set
     * @return the WindowsParameters object itself.
     */
    public WindowsParameters withKbNumbersToInclude(List<String> kbNumbersToInclude) {
        this.kbNumbersToInclude = kbNumbersToInclude;
        return this;
    }

    /**
     * Get kbs to exclude in the patch operation.
     *
     * @return the kbNumbersToExclude value
     */
    public List<String> kbNumbersToExclude() {
        return this.kbNumbersToExclude;
    }

    /**
     * Set kbs to exclude in the patch operation.
     *
     * @param kbNumbersToExclude the kbNumbersToExclude value to set
     * @return the WindowsParameters object itself.
     */
    public WindowsParameters withKbNumbersToExclude(List<String> kbNumbersToExclude) {
        this.kbNumbersToExclude = kbNumbersToExclude;
        return this;
    }

    /**
     * Get filters out Kbs that don't have an InstallationRebootBehavior of 'NeverReboots' when this is set to true.
     *
     * @return the excludeKbsRequiringReboot value
     */
    public Boolean excludeKbsRequiringReboot() {
        return this.excludeKbsRequiringReboot;
    }

    /**
     * Set filters out Kbs that don't have an InstallationRebootBehavior of 'NeverReboots' when this is set to true.
     *
     * @param excludeKbsRequiringReboot the excludeKbsRequiringReboot value to set
     * @return the WindowsParameters object itself.
     */
    public WindowsParameters withExcludeKbsRequiringReboot(Boolean excludeKbsRequiringReboot) {
        this.excludeKbsRequiringReboot = excludeKbsRequiringReboot;
        return this;
    }

    /**
     * Get this is used to install patches that were published on or before this given max published date.
     *
     * @return the maxPatchPublishDate value
     */
    public DateTime maxPatchPublishDate() {
        return this.maxPatchPublishDate;
    }

    /**
     * Set this is used to install patches that were published on or before this given max published date.
     *
     * @param maxPatchPublishDate the maxPatchPublishDate value to set
     * @return the WindowsParameters object itself.
     */
    public WindowsParameters withMaxPatchPublishDate(DateTime maxPatchPublishDate) {
        this.maxPatchPublishDate = maxPatchPublishDate;
        return this;
    }

}
