/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Input for InstallPatches as directly received by the API.
 */
public class VirtualMachineInstallPatchesParameters {
    /**
     * Specifies the maximum amount of time that the operation will run. It
     * must be an ISO 8601-compliant duration string such as PT4H (4 hours).
     */
    @JsonProperty(value = "maximumDuration", required = true)
    private String maximumDuration;

    /**
     * Defines when it is acceptable to reboot a VM during a software update
     * operation. Possible values include: 'IfRequired', 'Never', 'Always'.
     */
    @JsonProperty(value = "rebootSetting", required = true)
    private VMGuestPatchRebootSetting rebootSetting;

    /**
     * Input for InstallPatches on a Windows VM, as directly received by the
     * API.
     */
    @JsonProperty(value = "windowsParameters")
    private WindowsParameters windowsParameters;

    /**
     * Input for InstallPatches on a Linux VM, as directly received by the API.
     */
    @JsonProperty(value = "linuxParameters")
    private LinuxParameters linuxParameters;

    /**
     * Get specifies the maximum amount of time that the operation will run. It must be an ISO 8601-compliant duration string such as PT4H (4 hours).
     *
     * @return the maximumDuration value
     */
    public String maximumDuration() {
        return this.maximumDuration;
    }

    /**
     * Set specifies the maximum amount of time that the operation will run. It must be an ISO 8601-compliant duration string such as PT4H (4 hours).
     *
     * @param maximumDuration the maximumDuration value to set
     * @return the VirtualMachineInstallPatchesParameters object itself.
     */
    public VirtualMachineInstallPatchesParameters withMaximumDuration(String maximumDuration) {
        this.maximumDuration = maximumDuration;
        return this;
    }

    /**
     * Get defines when it is acceptable to reboot a VM during a software update operation. Possible values include: 'IfRequired', 'Never', 'Always'.
     *
     * @return the rebootSetting value
     */
    public VMGuestPatchRebootSetting rebootSetting() {
        return this.rebootSetting;
    }

    /**
     * Set defines when it is acceptable to reboot a VM during a software update operation. Possible values include: 'IfRequired', 'Never', 'Always'.
     *
     * @param rebootSetting the rebootSetting value to set
     * @return the VirtualMachineInstallPatchesParameters object itself.
     */
    public VirtualMachineInstallPatchesParameters withRebootSetting(VMGuestPatchRebootSetting rebootSetting) {
        this.rebootSetting = rebootSetting;
        return this;
    }

    /**
     * Get input for InstallPatches on a Windows VM, as directly received by the API.
     *
     * @return the windowsParameters value
     */
    public WindowsParameters windowsParameters() {
        return this.windowsParameters;
    }

    /**
     * Set input for InstallPatches on a Windows VM, as directly received by the API.
     *
     * @param windowsParameters the windowsParameters value to set
     * @return the VirtualMachineInstallPatchesParameters object itself.
     */
    public VirtualMachineInstallPatchesParameters withWindowsParameters(WindowsParameters windowsParameters) {
        this.windowsParameters = windowsParameters;
        return this;
    }

    /**
     * Get input for InstallPatches on a Linux VM, as directly received by the API.
     *
     * @return the linuxParameters value
     */
    public LinuxParameters linuxParameters() {
        return this.linuxParameters;
    }

    /**
     * Set input for InstallPatches on a Linux VM, as directly received by the API.
     *
     * @param linuxParameters the linuxParameters value to set
     * @return the VirtualMachineInstallPatchesParameters object itself.
     */
    public VirtualMachineInstallPatchesParameters withLinuxParameters(LinuxParameters linuxParameters) {
        this.linuxParameters = linuxParameters;
        return this;
    }

}
