/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Specifies additional capabilities supported by the image.
 */
public class VirtualMachineImageFeature {
    /**
     * The name of the feature.
     */
    @JsonProperty(value = "name")
    private String name;

    /**
     * The corresponding value for the feature.
     */
    @JsonProperty(value = "value")
    private String value;

    /**
     * Get the name of the feature.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name of the feature.
     *
     * @param name the name value to set
     * @return the VirtualMachineImageFeature object itself.
     */
    public VirtualMachineImageFeature withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the corresponding value for the feature.
     *
     * @return the value value
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the corresponding value for the feature.
     *
     * @param value the value value to set
     * @return the VirtualMachineImageFeature object itself.
     */
    public VirtualMachineImageFeature withValue(String value) {
        this.value = value;
        return this;
    }

}
