/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Describes The zonal capabilities of a SKU.
 */
public class ResourceSkuZoneDetails {
    /**
     * The set of zones that the SKU is available in with the specified
     * capabilities.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> name;

    /**
     * A list of capabilities that are available for the SKU in the specified
     * list of zones.
     */
    @JsonProperty(value = "capabilities", access = JsonProperty.Access.WRITE_ONLY)
    private List<ResourceSkuCapabilities> capabilities;

    /**
     * Get the set of zones that the SKU is available in with the specified capabilities.
     *
     * @return the name value
     */
    public List<String> name() {
        return this.name;
    }

    /**
     * Get a list of capabilities that are available for the SKU in the specified list of zones.
     *
     * @return the capabilities value
     */
    public List<ResourceSkuCapabilities> capabilities() {
        return this.capabilities;
    }

}
