/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Information about a specific patch that was encountered during an
 * installation action.
 */
public class PatchInstallationDetail {
    /**
     * A unique identifier for the patch.
     */
    @JsonProperty(value = "patchId", access = JsonProperty.Access.WRITE_ONLY)
    private String patchId;

    /**
     * The friendly name of the patch.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /**
     * The version string of the package. It may conform to Semantic
     * Versioning. Only applies to Linux.
     */
    @JsonProperty(value = "version", access = JsonProperty.Access.WRITE_ONLY)
    private String version;

    /**
     * The KBID of the patch. Only applies to Windows patches.
     */
    @JsonProperty(value = "kbId", access = JsonProperty.Access.WRITE_ONLY)
    private String kbId;

    /**
     * The classification(s) of the patch as provided by the patch publisher.
     */
    @JsonProperty(value = "classifications", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> classifications;

    /**
     * The state of the patch after the installation operation completed.
     * Possible values include: 'Unknown', 'Installed', 'Failed', 'Excluded',
     * 'NotSelected', 'Pending'.
     */
    @JsonProperty(value = "installationState", access = JsonProperty.Access.WRITE_ONLY)
    private PatchInstallationState installationState;

    /**
     * Get a unique identifier for the patch.
     *
     * @return the patchId value
     */
    public String patchId() {
        return this.patchId;
    }

    /**
     * Get the friendly name of the patch.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the version string of the package. It may conform to Semantic Versioning. Only applies to Linux.
     *
     * @return the version value
     */
    public String version() {
        return this.version;
    }

    /**
     * Get the KBID of the patch. Only applies to Windows patches.
     *
     * @return the kbId value
     */
    public String kbId() {
        return this.kbId;
    }

    /**
     * Get the classification(s) of the patch as provided by the patch publisher.
     *
     * @return the classifications value
     */
    public List<String> classifications() {
        return this.classifications;
    }

    /**
     * Get the state of the patch after the installation operation completed. Possible values include: 'Unknown', 'Installed', 'Failed', 'Excluded', 'NotSelected', 'Pending'.
     *
     * @return the installationState value
     */
    public PatchInstallationState installationState() {
        return this.installationState;
    }

}
