/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for PatchAssessmentState.
 */
public final class PatchAssessmentState extends ExpandableStringEnum<PatchAssessmentState> {
    /** Static value Unknown for PatchAssessmentState. */
    public static final PatchAssessmentState UNKNOWN = fromString("Unknown");

    /** Static value Available for PatchAssessmentState. */
    public static final PatchAssessmentState AVAILABLE = fromString("Available");

    /**
     * Creates or finds a PatchAssessmentState from its string representation.
     * @param name a name to look for
     * @return the corresponding PatchAssessmentState
     */
    @JsonCreator
    public static PatchAssessmentState fromString(String name) {
        return fromString(name, PatchAssessmentState.class);
    }

    /**
     * @return known PatchAssessmentState values
     */
    public static Collection<PatchAssessmentState> values() {
        return values(PatchAssessmentState.class);
    }
}
